package com.spotify.github.v3.repos;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import com.spotify.github.v3.git.Author;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link PushCommit}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePushCommit.builder()}.
 */
@Generated(from = "PushCommit", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutablePushCommit implements PushCommit {
  private final @Nullable String id;
  private final @Nullable String treeId;
  private final @Nullable Boolean distinct;
  private final @Nullable String message;
  private final @Nullable ZonedDateTime timestamp;
  private final @Nullable URI url;
  private final @Nullable Author author;
  private final @Nullable Author committer;
  private final @Nullable List<String> added;
  private final @Nullable List<String> removed;
  private final @Nullable List<String> modified;

  private ImmutablePushCommit(
      @Nullable String id,
      @Nullable String treeId,
      @Nullable Boolean distinct,
      @Nullable String message,
      @Nullable ZonedDateTime timestamp,
      @Nullable URI url,
      @Nullable Author author,
      @Nullable Author committer,
      @Nullable List<String> added,
      @Nullable List<String> removed,
      @Nullable List<String> modified) {
    this.id = id;
    this.treeId = treeId;
    this.distinct = distinct;
    this.message = message;
    this.timestamp = timestamp;
    this.url = url;
    this.author = author;
    this.committer = committer;
    this.added = added;
    this.removed = removed;
    this.modified = modified;
  }

  /**
   *Commit id. 
   */
  @JsonProperty
  @Override
  public @Nullable String id() {
    return id;
  }

  /**
   *Tree id. 
   */
  @JsonProperty
  @Override
  public @Nullable String treeId() {
    return treeId;
  }

  /**
   *Whether this commit is distinct from any that have been pushed before.. 
   */
  @JsonProperty
  @Override
  public @Nullable Boolean distinct() {
    return distinct;
  }

  /**
   *Commit message. 
   */
  @JsonProperty
  @Override
  public @Nullable String message() {
    return message;
  }

  /**
   *Timestamp. 
   */
  @JsonProperty
  @Override
  public @Nullable ZonedDateTime timestamp() {
    return timestamp;
  }

  /**
   *Points to the commit API resource.. 
   */
  @JsonProperty
  @Override
  public @Nullable URI url() {
    return url;
  }

  /**
   *Commit author. 
   */
  @JsonProperty
  @Override
  public @Nullable Author author() {
    return author;
  }

  /**
   *Commit committer. 
   */
  @JsonProperty
  @Override
  public @Nullable Author committer() {
    return committer;
  }

  /**
   *Files that were added. 
   */
  @JsonProperty
  @Override
  public @Nullable List<String> added() {
    return added;
  }

  /**
   *Files that were removed. 
   */
  @JsonProperty
  @Override
  public @Nullable List<String> removed() {
    return removed;
  }

  /**
   *Files that were modified. 
   */
  @JsonProperty
  @Override
  public @Nullable List<String> modified() {
    return modified;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PushCommit#id() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePushCommit withId(@Nullable String value) {
    if (Objects.equals(this.id, value)) return this;
    return new ImmutablePushCommit(
        value,
        this.treeId,
        this.distinct,
        this.message,
        this.timestamp,
        this.url,
        this.author,
        this.committer,
        this.added,
        this.removed,
        this.modified);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PushCommit#treeId() treeId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for treeId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePushCommit withTreeId(@Nullable String value) {
    if (Objects.equals(this.treeId, value)) return this;
    return new ImmutablePushCommit(
        this.id,
        value,
        this.distinct,
        this.message,
        this.timestamp,
        this.url,
        this.author,
        this.committer,
        this.added,
        this.removed,
        this.modified);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PushCommit#distinct() distinct} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for distinct (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePushCommit withDistinct(@Nullable Boolean value) {
    if (Objects.equals(this.distinct, value)) return this;
    return new ImmutablePushCommit(
        this.id,
        this.treeId,
        value,
        this.message,
        this.timestamp,
        this.url,
        this.author,
        this.committer,
        this.added,
        this.removed,
        this.modified);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PushCommit#message() message} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for message (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePushCommit withMessage(@Nullable String value) {
    if (Objects.equals(this.message, value)) return this;
    return new ImmutablePushCommit(
        this.id,
        this.treeId,
        this.distinct,
        value,
        this.timestamp,
        this.url,
        this.author,
        this.committer,
        this.added,
        this.removed,
        this.modified);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PushCommit#timestamp() timestamp} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for timestamp (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePushCommit withTimestamp(@Nullable ZonedDateTime value) {
    if (this.timestamp == value) return this;
    return new ImmutablePushCommit(
        this.id,
        this.treeId,
        this.distinct,
        this.message,
        value,
        this.url,
        this.author,
        this.committer,
        this.added,
        this.removed,
        this.modified);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PushCommit#url() url} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for url (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePushCommit withUrl(@Nullable URI value) {
    if (this.url == value) return this;
    return new ImmutablePushCommit(
        this.id,
        this.treeId,
        this.distinct,
        this.message,
        this.timestamp,
        value,
        this.author,
        this.committer,
        this.added,
        this.removed,
        this.modified);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PushCommit#author() author} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for author (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePushCommit withAuthor(@Nullable Author value) {
    if (this.author == value) return this;
    return new ImmutablePushCommit(
        this.id,
        this.treeId,
        this.distinct,
        this.message,
        this.timestamp,
        this.url,
        value,
        this.committer,
        this.added,
        this.removed,
        this.modified);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PushCommit#committer() committer} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for committer (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePushCommit withCommitter(@Nullable Author value) {
    if (this.committer == value) return this;
    return new ImmutablePushCommit(
        this.id,
        this.treeId,
        this.distinct,
        this.message,
        this.timestamp,
        this.url,
        this.author,
        value,
        this.added,
        this.removed,
        this.modified);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PushCommit#added() added}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePushCommit withAdded(@Nullable String... elements) {
    if (elements == null) {
      return new ImmutablePushCommit(
          this.id,
          this.treeId,
          this.distinct,
          this.message,
          this.timestamp,
          this.url,
          this.author,
          this.committer,
          null,
          this.removed,
          this.modified);
    }
    @Nullable List<String> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutablePushCommit(
        this.id,
        this.treeId,
        this.distinct,
        this.message,
        this.timestamp,
        this.url,
        this.author,
        this.committer,
        newValue,
        this.removed,
        this.modified);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PushCommit#added() added}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of added elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePushCommit withAdded(@Nullable Iterable<String> elements) {
    if (this.added == elements) return this;
    @Nullable List<String> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutablePushCommit(
        this.id,
        this.treeId,
        this.distinct,
        this.message,
        this.timestamp,
        this.url,
        this.author,
        this.committer,
        newValue,
        this.removed,
        this.modified);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PushCommit#removed() removed}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePushCommit withRemoved(@Nullable String... elements) {
    if (elements == null) {
      return new ImmutablePushCommit(
          this.id,
          this.treeId,
          this.distinct,
          this.message,
          this.timestamp,
          this.url,
          this.author,
          this.committer,
          this.added,
          null,
          this.modified);
    }
    @Nullable List<String> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutablePushCommit(
        this.id,
        this.treeId,
        this.distinct,
        this.message,
        this.timestamp,
        this.url,
        this.author,
        this.committer,
        this.added,
        newValue,
        this.modified);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PushCommit#removed() removed}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of removed elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePushCommit withRemoved(@Nullable Iterable<String> elements) {
    if (this.removed == elements) return this;
    @Nullable List<String> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutablePushCommit(
        this.id,
        this.treeId,
        this.distinct,
        this.message,
        this.timestamp,
        this.url,
        this.author,
        this.committer,
        this.added,
        newValue,
        this.modified);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PushCommit#modified() modified}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePushCommit withModified(@Nullable String... elements) {
    if (elements == null) {
      return new ImmutablePushCommit(
          this.id,
          this.treeId,
          this.distinct,
          this.message,
          this.timestamp,
          this.url,
          this.author,
          this.committer,
          this.added,
          this.removed,
          null);
    }
    @Nullable List<String> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutablePushCommit(
        this.id,
        this.treeId,
        this.distinct,
        this.message,
        this.timestamp,
        this.url,
        this.author,
        this.committer,
        this.added,
        this.removed,
        newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PushCommit#modified() modified}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of modified elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePushCommit withModified(@Nullable Iterable<String> elements) {
    if (this.modified == elements) return this;
    @Nullable List<String> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutablePushCommit(
        this.id,
        this.treeId,
        this.distinct,
        this.message,
        this.timestamp,
        this.url,
        this.author,
        this.committer,
        this.added,
        this.removed,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePushCommit} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePushCommit
        && equalTo((ImmutablePushCommit) another);
  }

  private boolean equalTo(ImmutablePushCommit another) {
    return Objects.equals(id, another.id)
        && Objects.equals(treeId, another.treeId)
        && Objects.equals(distinct, another.distinct)
        && Objects.equals(message, another.message)
        && Objects.equals(timestamp, another.timestamp)
        && Objects.equals(url, another.url)
        && Objects.equals(author, another.author)
        && Objects.equals(committer, another.committer)
        && Objects.equals(added, another.added)
        && Objects.equals(removed, another.removed)
        && Objects.equals(modified, another.modified);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code treeId}, {@code distinct}, {@code message}, {@code timestamp}, {@code url}, {@code author}, {@code committer}, {@code added}, {@code removed}, {@code modified}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(treeId);
    h += (h << 5) + Objects.hashCode(distinct);
    h += (h << 5) + Objects.hashCode(message);
    h += (h << 5) + Objects.hashCode(timestamp);
    h += (h << 5) + Objects.hashCode(url);
    h += (h << 5) + Objects.hashCode(author);
    h += (h << 5) + Objects.hashCode(committer);
    h += (h << 5) + Objects.hashCode(added);
    h += (h << 5) + Objects.hashCode(removed);
    h += (h << 5) + Objects.hashCode(modified);
    return h;
  }

  /**
   * Prints the immutable value {@code PushCommit} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "PushCommit{"
        + "id=" + id
        + ", treeId=" + treeId
        + ", distinct=" + distinct
        + ", message=" + message
        + ", timestamp=" + timestamp
        + ", url=" + url
        + ", author=" + author
        + ", committer=" + committer
        + ", added=" + added
        + ", removed=" + removed
        + ", modified=" + modified
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "PushCommit", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements PushCommit {
    @Nullable String id;
    @Nullable String treeId;
    @Nullable Boolean distinct;
    @Nullable String message;
    @Nullable ZonedDateTime timestamp;
    @Nullable URI url;
    @Nullable Author author;
    @Nullable Author committer;
    @Nullable List<String> added = null;
    @Nullable List<String> removed = null;
    @Nullable List<String> modified = null;
    @JsonProperty
    public void setId(@Nullable String id) {
      this.id = id;
    }
    @JsonProperty
    public void setTreeId(@Nullable String treeId) {
      this.treeId = treeId;
    }
    @JsonProperty
    public void setDistinct(@Nullable Boolean distinct) {
      this.distinct = distinct;
    }
    @JsonProperty
    public void setMessage(@Nullable String message) {
      this.message = message;
    }
    @JsonProperty
    public void setTimestamp(@Nullable ZonedDateTime timestamp) {
      this.timestamp = timestamp;
    }
    @JsonProperty
    public void setUrl(@Nullable URI url) {
      this.url = url;
    }
    @JsonProperty
    public void setAuthor(@Nullable Author author) {
      this.author = author;
    }
    @JsonProperty
    public void setCommitter(@Nullable Author committer) {
      this.committer = committer;
    }
    @JsonProperty
    public void setAdded(@Nullable List<String> added) {
      this.added = added;
    }
    @JsonProperty
    public void setRemoved(@Nullable List<String> removed) {
      this.removed = removed;
    }
    @JsonProperty
    public void setModified(@Nullable List<String> modified) {
      this.modified = modified;
    }
    @Override
    public String id() { throw new UnsupportedOperationException(); }
    @Override
    public String treeId() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean distinct() { throw new UnsupportedOperationException(); }
    @Override
    public String message() { throw new UnsupportedOperationException(); }
    @Override
    public ZonedDateTime timestamp() { throw new UnsupportedOperationException(); }
    @Override
    public URI url() { throw new UnsupportedOperationException(); }
    @Override
    public Author author() { throw new UnsupportedOperationException(); }
    @Override
    public Author committer() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> added() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> removed() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> modified() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutablePushCommit fromJson(Json json) {
    ImmutablePushCommit.Builder builder = ImmutablePushCommit.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.treeId != null) {
      builder.treeId(json.treeId);
    }
    if (json.distinct != null) {
      builder.distinct(json.distinct);
    }
    if (json.message != null) {
      builder.message(json.message);
    }
    if (json.timestamp != null) {
      builder.timestamp(json.timestamp);
    }
    if (json.url != null) {
      builder.url(json.url);
    }
    if (json.author != null) {
      builder.author(json.author);
    }
    if (json.committer != null) {
      builder.committer(json.committer);
    }
    if (json.added != null) {
      builder.addAllAdded(json.added);
    }
    if (json.removed != null) {
      builder.addAllRemoved(json.removed);
    }
    if (json.modified != null) {
      builder.addAllModified(json.modified);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link PushCommit} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PushCommit instance
   */
  public static ImmutablePushCommit copyOf(PushCommit instance) {
    if (instance instanceof ImmutablePushCommit) {
      return (ImmutablePushCommit) instance;
    }
    return ImmutablePushCommit.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePushCommit ImmutablePushCommit}.
   * <pre>
   * ImmutablePushCommit.builder()
   *    .id(String | null) // nullable {@link PushCommit#id() id}
   *    .treeId(String | null) // nullable {@link PushCommit#treeId() treeId}
   *    .distinct(Boolean | null) // nullable {@link PushCommit#distinct() distinct}
   *    .message(String | null) // nullable {@link PushCommit#message() message}
   *    .timestamp(java.time.ZonedDateTime | null) // nullable {@link PushCommit#timestamp() timestamp}
   *    .url(java.net.URI | null) // nullable {@link PushCommit#url() url}
   *    .author(com.spotify.github.v3.git.Author | null) // nullable {@link PushCommit#author() author}
   *    .committer(com.spotify.github.v3.git.Author | null) // nullable {@link PushCommit#committer() committer}
   *    .added(List&amp;lt;String&amp;gt; | null) // nullable {@link PushCommit#added() added}
   *    .removed(List&amp;lt;String&amp;gt; | null) // nullable {@link PushCommit#removed() removed}
   *    .modified(List&amp;lt;String&amp;gt; | null) // nullable {@link PushCommit#modified() modified}
   *    .build();
   * </pre>
   * @return A new ImmutablePushCommit builder
   */
  public static ImmutablePushCommit.Builder builder() {
    return new ImmutablePushCommit.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePushCommit ImmutablePushCommit}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PushCommit", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable String id;
    private @Nullable String treeId;
    private @Nullable Boolean distinct;
    private @Nullable String message;
    private @Nullable ZonedDateTime timestamp;
    private @Nullable URI url;
    private @Nullable Author author;
    private @Nullable Author committer;
    private List<String> added = null;
    private List<String> removed = null;
    private List<String> modified = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code PushCommit} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(PushCommit instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String idValue = instance.id();
      if (idValue != null) {
        id(idValue);
      }
      @Nullable String treeIdValue = instance.treeId();
      if (treeIdValue != null) {
        treeId(treeIdValue);
      }
      @Nullable Boolean distinctValue = instance.distinct();
      if (distinctValue != null) {
        distinct(distinctValue);
      }
      @Nullable String messageValue = instance.message();
      if (messageValue != null) {
        message(messageValue);
      }
      @Nullable ZonedDateTime timestampValue = instance.timestamp();
      if (timestampValue != null) {
        timestamp(timestampValue);
      }
      @Nullable URI urlValue = instance.url();
      if (urlValue != null) {
        url(urlValue);
      }
      @Nullable Author authorValue = instance.author();
      if (authorValue != null) {
        author(authorValue);
      }
      @Nullable Author committerValue = instance.committer();
      if (committerValue != null) {
        committer(committerValue);
      }
      @Nullable List<String> addedValue = instance.added();
      if (addedValue != null) {
        addAllAdded(addedValue);
      }
      @Nullable List<String> removedValue = instance.removed();
      if (removedValue != null) {
        addAllRemoved(removedValue);
      }
      @Nullable List<String> modifiedValue = instance.modified();
      if (modifiedValue != null) {
        addAllModified(modifiedValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link PushCommit#id() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder id(@Nullable String id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link PushCommit#treeId() treeId} attribute.
     * @param treeId The value for treeId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder treeId(@Nullable String treeId) {
      this.treeId = treeId;
      return this;
    }

    /**
     * Initializes the value for the {@link PushCommit#distinct() distinct} attribute.
     * @param distinct The value for distinct (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder distinct(@Nullable Boolean distinct) {
      this.distinct = distinct;
      return this;
    }

    /**
     * Initializes the value for the {@link PushCommit#message() message} attribute.
     * @param message The value for message (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder message(@Nullable String message) {
      this.message = message;
      return this;
    }

    /**
     * Initializes the value for the {@link PushCommit#timestamp() timestamp} attribute.
     * @param timestamp The value for timestamp (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder timestamp(@Nullable ZonedDateTime timestamp) {
      this.timestamp = timestamp;
      return this;
    }

    /**
     * Initializes the value for the {@link PushCommit#url() url} attribute.
     * @param url The value for url (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder url(@Nullable URI url) {
      this.url = url;
      return this;
    }

    /**
     * Initializes the value for the {@link PushCommit#author() author} attribute.
     * @param author The value for author (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder author(@Nullable Author author) {
      this.author = author;
      return this;
    }

    /**
     * Initializes the value for the {@link PushCommit#committer() committer} attribute.
     * @param committer The value for committer (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder committer(@Nullable Author committer) {
      this.committer = committer;
      return this;
    }

    /**
     * Adds one element to {@link PushCommit#added() added} list.
     * @param element A added element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAdded(String element) {
      if (this.added == null) {
        this.added = new ArrayList<String>();
      }
      this.added.add(Objects.requireNonNull(element, "added element"));
      return this;
    }

    /**
     * Adds elements to {@link PushCommit#added() added} list.
     * @param elements An array of added elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAdded(String... elements) {
      if (this.added == null) {
        this.added = new ArrayList<String>();
      }
      for (String element : elements) {
        this.added.add(Objects.requireNonNull(element, "added element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link PushCommit#added() added} list.
     * @param elements An iterable of added elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder added(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.added = null;
        return this;
      }
      this.added = new ArrayList<String>();
      return addAllAdded(elements);
    }

    /**
     * Adds elements to {@link PushCommit#added() added} list.
     * @param elements An iterable of added elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllAdded(Iterable<String> elements) {
      Objects.requireNonNull(elements, "added element");
      if (this.added == null) {
        this.added = new ArrayList<String>();
      }
      for (String element : elements) {
        this.added.add(Objects.requireNonNull(element, "added element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link PushCommit#removed() removed} list.
     * @param element A removed element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addRemoved(String element) {
      if (this.removed == null) {
        this.removed = new ArrayList<String>();
      }
      this.removed.add(Objects.requireNonNull(element, "removed element"));
      return this;
    }

    /**
     * Adds elements to {@link PushCommit#removed() removed} list.
     * @param elements An array of removed elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addRemoved(String... elements) {
      if (this.removed == null) {
        this.removed = new ArrayList<String>();
      }
      for (String element : elements) {
        this.removed.add(Objects.requireNonNull(element, "removed element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link PushCommit#removed() removed} list.
     * @param elements An iterable of removed elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder removed(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.removed = null;
        return this;
      }
      this.removed = new ArrayList<String>();
      return addAllRemoved(elements);
    }

    /**
     * Adds elements to {@link PushCommit#removed() removed} list.
     * @param elements An iterable of removed elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllRemoved(Iterable<String> elements) {
      Objects.requireNonNull(elements, "removed element");
      if (this.removed == null) {
        this.removed = new ArrayList<String>();
      }
      for (String element : elements) {
        this.removed.add(Objects.requireNonNull(element, "removed element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link PushCommit#modified() modified} list.
     * @param element A modified element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addModified(String element) {
      if (this.modified == null) {
        this.modified = new ArrayList<String>();
      }
      this.modified.add(Objects.requireNonNull(element, "modified element"));
      return this;
    }

    /**
     * Adds elements to {@link PushCommit#modified() modified} list.
     * @param elements An array of modified elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addModified(String... elements) {
      if (this.modified == null) {
        this.modified = new ArrayList<String>();
      }
      for (String element : elements) {
        this.modified.add(Objects.requireNonNull(element, "modified element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link PushCommit#modified() modified} list.
     * @param elements An iterable of modified elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder modified(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.modified = null;
        return this;
      }
      this.modified = new ArrayList<String>();
      return addAllModified(elements);
    }

    /**
     * Adds elements to {@link PushCommit#modified() modified} list.
     * @param elements An iterable of modified elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllModified(Iterable<String> elements) {
      Objects.requireNonNull(elements, "modified element");
      if (this.modified == null) {
        this.modified = new ArrayList<String>();
      }
      for (String element : elements) {
        this.modified.add(Objects.requireNonNull(element, "modified element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutablePushCommit ImmutablePushCommit}.
     * @return An immutable instance of PushCommit
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePushCommit build() {
      return new ImmutablePushCommit(
          id,
          treeId,
          distinct,
          message,
          timestamp,
          url,
          author,
          committer,
          added == null ? null : createUnmodifiableList(true, added),
          removed == null ? null : createUnmodifiableList(true, removed),
          modified == null ? null : createUnmodifiableList(true, modified));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
