package com.spotify.github.v3.repos;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import com.spotify.github.GitHubInstant;
import com.spotify.github.UpdateTracking;
import com.spotify.github.v3.User;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Status}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableStatus.builder()}.
 */
@Generated(from = "Status", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableStatus implements Status {
  private final @Nullable GitHubInstant createdAt;
  private final @Nullable GitHubInstant updatedAt;
  private final @Nullable String state;
  private final @Nullable URI targetUrl;
  private final @Nullable String description;
  private final @Nullable Long id;
  private final @Nullable URI url;
  private final @Nullable String context;
  private final @Nullable User creator;
  private final @Nullable URI deploymentUrl;
  private final @Nullable URI repositoryUrl;

  private ImmutableStatus(
      @Nullable GitHubInstant createdAt,
      @Nullable GitHubInstant updatedAt,
      @Nullable String state,
      @Nullable URI targetUrl,
      @Nullable String description,
      @Nullable Long id,
      @Nullable URI url,
      @Nullable String context,
      @Nullable User creator,
      @Nullable URI deploymentUrl,
      @Nullable URI repositoryUrl) {
    this.createdAt = createdAt;
    this.updatedAt = updatedAt;
    this.state = state;
    this.targetUrl = targetUrl;
    this.description = description;
    this.id = id;
    this.url = url;
    this.context = context;
    this.creator = creator;
    this.deploymentUrl = deploymentUrl;
    this.repositoryUrl = repositoryUrl;
  }

  /**
   * Created date
   * @return The date when the issue was created
   */
  @JsonProperty
  @Override
  public @Nullable GitHubInstant createdAt() {
    return createdAt;
  }

  /**
   * Updated date
   * @return The date when the issue was updated
   */
  @JsonProperty
  @Override
  public @Nullable GitHubInstant updatedAt() {
    return updatedAt;
  }

  /**
   *The state of the status. Can be one of pending, success, error, or failure. 
   */
  @JsonProperty
  @Override
  public @Nullable String state() {
    return state;
  }

  /**
   * The target URL to associate with this status. This URL will be linked from the GitHub UI to
   * allow users to easily see the 'source' of the Status.
   */
  @JsonProperty
  @Override
  public Optional<URI> targetUrl() {
    return Optional.ofNullable(targetUrl);
  }

  /**
   *A short description of the status. 
   */
  @JsonProperty
  @Override
  public Optional<String> description() {
    return Optional.ofNullable(description);
  }

  /**
   *Status id 
   */
  @JsonProperty
  @Override
  public @Nullable Long id() {
    return id;
  }

  /**
   *Status URL 
   */
  @JsonProperty
  @Override
  public @Nullable URI url() {
    return url;
  }

  /**
   * A string label to differentiate this status from the status of other systems. Default:
   * "default"
   */
  @JsonProperty
  @Override
  public Optional<String> context() {
    return Optional.ofNullable(context);
  }

  /**
   *Status creator user entity 
   */
  @JsonProperty
  @Override
  public Optional<User> creator() {
    return Optional.ofNullable(creator);
  }

  /**
   *Deployment URL 
   */
  @JsonProperty
  @Override
  public Optional<URI> deploymentUrl() {
    return Optional.ofNullable(deploymentUrl);
  }

  /**
   *Repository URL 
   */
  @JsonProperty
  @Override
  public Optional<URI> repositoryUrl() {
    return Optional.ofNullable(repositoryUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Status#createdAt() createdAt} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for createdAt (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStatus withCreatedAt(@Nullable GitHubInstant value) {
    if (this.createdAt == value) return this;
    return new ImmutableStatus(
        value,
        this.updatedAt,
        this.state,
        this.targetUrl,
        this.description,
        this.id,
        this.url,
        this.context,
        this.creator,
        this.deploymentUrl,
        this.repositoryUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Status#updatedAt() updatedAt} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for updatedAt (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStatus withUpdatedAt(@Nullable GitHubInstant value) {
    if (this.updatedAt == value) return this;
    return new ImmutableStatus(
        this.createdAt,
        value,
        this.state,
        this.targetUrl,
        this.description,
        this.id,
        this.url,
        this.context,
        this.creator,
        this.deploymentUrl,
        this.repositoryUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Status#state() state} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for state (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStatus withState(@Nullable String value) {
    if (Objects.equals(this.state, value)) return this;
    return new ImmutableStatus(
        this.createdAt,
        this.updatedAt,
        value,
        this.targetUrl,
        this.description,
        this.id,
        this.url,
        this.context,
        this.creator,
        this.deploymentUrl,
        this.repositoryUrl);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Status#targetUrl() targetUrl} attribute.
   * @param value The value for targetUrl
   * @return A modified copy of {@code this} object
   */
  public final ImmutableStatus withTargetUrl(URI value) {
    @Nullable URI newValue = Objects.requireNonNull(value, "targetUrl");
    if (this.targetUrl == newValue) return this;
    return new ImmutableStatus(
        this.createdAt,
        this.updatedAt,
        this.state,
        newValue,
        this.description,
        this.id,
        this.url,
        this.context,
        this.creator,
        this.deploymentUrl,
        this.repositoryUrl);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Status#targetUrl() targetUrl} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for targetUrl
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableStatus withTargetUrl(Optional<? extends URI> optional) {
    @Nullable URI value = optional.orElse(null);
    if (this.targetUrl == value) return this;
    return new ImmutableStatus(
        this.createdAt,
        this.updatedAt,
        this.state,
        value,
        this.description,
        this.id,
        this.url,
        this.context,
        this.creator,
        this.deploymentUrl,
        this.repositoryUrl);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Status#description() description} attribute.
   * @param value The value for description
   * @return A modified copy of {@code this} object
   */
  public final ImmutableStatus withDescription(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "description");
    if (Objects.equals(this.description, newValue)) return this;
    return new ImmutableStatus(
        this.createdAt,
        this.updatedAt,
        this.state,
        this.targetUrl,
        newValue,
        this.id,
        this.url,
        this.context,
        this.creator,
        this.deploymentUrl,
        this.repositoryUrl);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Status#description() description} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for description
   * @return A modified copy of {@code this} object
   */
  public final ImmutableStatus withDescription(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.description, value)) return this;
    return new ImmutableStatus(
        this.createdAt,
        this.updatedAt,
        this.state,
        this.targetUrl,
        value,
        this.id,
        this.url,
        this.context,
        this.creator,
        this.deploymentUrl,
        this.repositoryUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Status#id() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStatus withId(@Nullable Long value) {
    if (Objects.equals(this.id, value)) return this;
    return new ImmutableStatus(
        this.createdAt,
        this.updatedAt,
        this.state,
        this.targetUrl,
        this.description,
        value,
        this.url,
        this.context,
        this.creator,
        this.deploymentUrl,
        this.repositoryUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Status#url() url} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for url (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStatus withUrl(@Nullable URI value) {
    if (this.url == value) return this;
    return new ImmutableStatus(
        this.createdAt,
        this.updatedAt,
        this.state,
        this.targetUrl,
        this.description,
        this.id,
        value,
        this.context,
        this.creator,
        this.deploymentUrl,
        this.repositoryUrl);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Status#context() context} attribute.
   * @param value The value for context
   * @return A modified copy of {@code this} object
   */
  public final ImmutableStatus withContext(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "context");
    if (Objects.equals(this.context, newValue)) return this;
    return new ImmutableStatus(
        this.createdAt,
        this.updatedAt,
        this.state,
        this.targetUrl,
        this.description,
        this.id,
        this.url,
        newValue,
        this.creator,
        this.deploymentUrl,
        this.repositoryUrl);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Status#context() context} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for context
   * @return A modified copy of {@code this} object
   */
  public final ImmutableStatus withContext(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.context, value)) return this;
    return new ImmutableStatus(
        this.createdAt,
        this.updatedAt,
        this.state,
        this.targetUrl,
        this.description,
        this.id,
        this.url,
        value,
        this.creator,
        this.deploymentUrl,
        this.repositoryUrl);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Status#creator() creator} attribute.
   * @param value The value for creator
   * @return A modified copy of {@code this} object
   */
  public final ImmutableStatus withCreator(User value) {
    @Nullable User newValue = Objects.requireNonNull(value, "creator");
    if (this.creator == newValue) return this;
    return new ImmutableStatus(
        this.createdAt,
        this.updatedAt,
        this.state,
        this.targetUrl,
        this.description,
        this.id,
        this.url,
        this.context,
        newValue,
        this.deploymentUrl,
        this.repositoryUrl);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Status#creator() creator} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for creator
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableStatus withCreator(Optional<? extends User> optional) {
    @Nullable User value = optional.orElse(null);
    if (this.creator == value) return this;
    return new ImmutableStatus(
        this.createdAt,
        this.updatedAt,
        this.state,
        this.targetUrl,
        this.description,
        this.id,
        this.url,
        this.context,
        value,
        this.deploymentUrl,
        this.repositoryUrl);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Status#deploymentUrl() deploymentUrl} attribute.
   * @param value The value for deploymentUrl
   * @return A modified copy of {@code this} object
   */
  public final ImmutableStatus withDeploymentUrl(URI value) {
    @Nullable URI newValue = Objects.requireNonNull(value, "deploymentUrl");
    if (this.deploymentUrl == newValue) return this;
    return new ImmutableStatus(
        this.createdAt,
        this.updatedAt,
        this.state,
        this.targetUrl,
        this.description,
        this.id,
        this.url,
        this.context,
        this.creator,
        newValue,
        this.repositoryUrl);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Status#deploymentUrl() deploymentUrl} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for deploymentUrl
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableStatus withDeploymentUrl(Optional<? extends URI> optional) {
    @Nullable URI value = optional.orElse(null);
    if (this.deploymentUrl == value) return this;
    return new ImmutableStatus(
        this.createdAt,
        this.updatedAt,
        this.state,
        this.targetUrl,
        this.description,
        this.id,
        this.url,
        this.context,
        this.creator,
        value,
        this.repositoryUrl);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Status#repositoryUrl() repositoryUrl} attribute.
   * @param value The value for repositoryUrl
   * @return A modified copy of {@code this} object
   */
  public final ImmutableStatus withRepositoryUrl(URI value) {
    @Nullable URI newValue = Objects.requireNonNull(value, "repositoryUrl");
    if (this.repositoryUrl == newValue) return this;
    return new ImmutableStatus(
        this.createdAt,
        this.updatedAt,
        this.state,
        this.targetUrl,
        this.description,
        this.id,
        this.url,
        this.context,
        this.creator,
        this.deploymentUrl,
        newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Status#repositoryUrl() repositoryUrl} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for repositoryUrl
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableStatus withRepositoryUrl(Optional<? extends URI> optional) {
    @Nullable URI value = optional.orElse(null);
    if (this.repositoryUrl == value) return this;
    return new ImmutableStatus(
        this.createdAt,
        this.updatedAt,
        this.state,
        this.targetUrl,
        this.description,
        this.id,
        this.url,
        this.context,
        this.creator,
        this.deploymentUrl,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableStatus} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableStatus
        && equalTo((ImmutableStatus) another);
  }

  private boolean equalTo(ImmutableStatus another) {
    return Objects.equals(createdAt, another.createdAt)
        && Objects.equals(updatedAt, another.updatedAt)
        && Objects.equals(state, another.state)
        && Objects.equals(targetUrl, another.targetUrl)
        && Objects.equals(description, another.description)
        && Objects.equals(id, another.id)
        && Objects.equals(url, another.url)
        && Objects.equals(context, another.context)
        && Objects.equals(creator, another.creator)
        && Objects.equals(deploymentUrl, another.deploymentUrl)
        && Objects.equals(repositoryUrl, another.repositoryUrl);
  }

  /**
   * Computes a hash code from attributes: {@code createdAt}, {@code updatedAt}, {@code state}, {@code targetUrl}, {@code description}, {@code id}, {@code url}, {@code context}, {@code creator}, {@code deploymentUrl}, {@code repositoryUrl}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(createdAt);
    h += (h << 5) + Objects.hashCode(updatedAt);
    h += (h << 5) + Objects.hashCode(state);
    h += (h << 5) + Objects.hashCode(targetUrl);
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(url);
    h += (h << 5) + Objects.hashCode(context);
    h += (h << 5) + Objects.hashCode(creator);
    h += (h << 5) + Objects.hashCode(deploymentUrl);
    h += (h << 5) + Objects.hashCode(repositoryUrl);
    return h;
  }

  /**
   * Prints the immutable value {@code Status} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("Status{");
    if (createdAt != null) {
      builder.append("createdAt=").append(createdAt);
    }
    if (updatedAt != null) {
      if (builder.length() > 7) builder.append(", ");
      builder.append("updatedAt=").append(updatedAt);
    }
    if (state != null) {
      if (builder.length() > 7) builder.append(", ");
      builder.append("state=").append(state);
    }
    if (targetUrl != null) {
      if (builder.length() > 7) builder.append(", ");
      builder.append("targetUrl=").append(targetUrl);
    }
    if (description != null) {
      if (builder.length() > 7) builder.append(", ");
      builder.append("description=").append(description);
    }
    if (id != null) {
      if (builder.length() > 7) builder.append(", ");
      builder.append("id=").append(id);
    }
    if (url != null) {
      if (builder.length() > 7) builder.append(", ");
      builder.append("url=").append(url);
    }
    if (context != null) {
      if (builder.length() > 7) builder.append(", ");
      builder.append("context=").append(context);
    }
    if (creator != null) {
      if (builder.length() > 7) builder.append(", ");
      builder.append("creator=").append(creator);
    }
    if (deploymentUrl != null) {
      if (builder.length() > 7) builder.append(", ");
      builder.append("deploymentUrl=").append(deploymentUrl);
    }
    if (repositoryUrl != null) {
      if (builder.length() > 7) builder.append(", ");
      builder.append("repositoryUrl=").append(repositoryUrl);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Status", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Status {
    @Nullable GitHubInstant createdAt;
    @Nullable GitHubInstant updatedAt;
    @Nullable String state;
    @Nullable Optional<URI> targetUrl = Optional.empty();
    @Nullable Optional<String> description = Optional.empty();
    @Nullable Long id;
    @Nullable URI url;
    @Nullable Optional<String> context = Optional.empty();
    @Nullable Optional<User> creator = Optional.empty();
    @Nullable Optional<URI> deploymentUrl = Optional.empty();
    @Nullable Optional<URI> repositoryUrl = Optional.empty();
    @JsonProperty
    public void setCreatedAt(@Nullable GitHubInstant createdAt) {
      this.createdAt = createdAt;
    }
    @JsonProperty
    public void setUpdatedAt(@Nullable GitHubInstant updatedAt) {
      this.updatedAt = updatedAt;
    }
    @JsonProperty
    public void setState(@Nullable String state) {
      this.state = state;
    }
    @JsonProperty
    public void setTargetUrl(Optional<URI> targetUrl) {
      this.targetUrl = targetUrl;
    }
    @JsonProperty
    public void setDescription(Optional<String> description) {
      this.description = description;
    }
    @JsonProperty
    public void setId(@Nullable Long id) {
      this.id = id;
    }
    @JsonProperty
    public void setUrl(@Nullable URI url) {
      this.url = url;
    }
    @JsonProperty
    public void setContext(Optional<String> context) {
      this.context = context;
    }
    @JsonProperty
    public void setCreator(Optional<User> creator) {
      this.creator = creator;
    }
    @JsonProperty
    public void setDeploymentUrl(Optional<URI> deploymentUrl) {
      this.deploymentUrl = deploymentUrl;
    }
    @JsonProperty
    public void setRepositoryUrl(Optional<URI> repositoryUrl) {
      this.repositoryUrl = repositoryUrl;
    }
    @Override
    public GitHubInstant createdAt() { throw new UnsupportedOperationException(); }
    @Override
    public GitHubInstant updatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public String state() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<URI> targetUrl() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> description() { throw new UnsupportedOperationException(); }
    @Override
    public Long id() { throw new UnsupportedOperationException(); }
    @Override
    public URI url() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> context() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<User> creator() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<URI> deploymentUrl() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<URI> repositoryUrl() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableStatus fromJson(Json json) {
    ImmutableStatus.Builder builder = ImmutableStatus.builder();
    if (json.createdAt != null) {
      builder.createdAt(json.createdAt);
    }
    if (json.updatedAt != null) {
      builder.updatedAt(json.updatedAt);
    }
    if (json.state != null) {
      builder.state(json.state);
    }
    if (json.targetUrl != null) {
      builder.targetUrl(json.targetUrl);
    }
    if (json.description != null) {
      builder.description(json.description);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.url != null) {
      builder.url(json.url);
    }
    if (json.context != null) {
      builder.context(json.context);
    }
    if (json.creator != null) {
      builder.creator(json.creator);
    }
    if (json.deploymentUrl != null) {
      builder.deploymentUrl(json.deploymentUrl);
    }
    if (json.repositoryUrl != null) {
      builder.repositoryUrl(json.repositoryUrl);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Status} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Status instance
   */
  public static ImmutableStatus copyOf(Status instance) {
    if (instance instanceof ImmutableStatus) {
      return (ImmutableStatus) instance;
    }
    return ImmutableStatus.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableStatus ImmutableStatus}.
   * <pre>
   * ImmutableStatus.builder()
   *    .createdAt(com.spotify.github.GitHubInstant | null) // nullable {@link Status#createdAt() createdAt}
   *    .updatedAt(com.spotify.github.GitHubInstant | null) // nullable {@link Status#updatedAt() updatedAt}
   *    .state(String | null) // nullable {@link Status#state() state}
   *    .targetUrl(java.net.URI) // optional {@link Status#targetUrl() targetUrl}
   *    .description(String) // optional {@link Status#description() description}
   *    .id(Long | null) // nullable {@link Status#id() id}
   *    .url(java.net.URI | null) // nullable {@link Status#url() url}
   *    .context(String) // optional {@link Status#context() context}
   *    .creator(com.spotify.github.v3.User) // optional {@link Status#creator() creator}
   *    .deploymentUrl(java.net.URI) // optional {@link Status#deploymentUrl() deploymentUrl}
   *    .repositoryUrl(java.net.URI) // optional {@link Status#repositoryUrl() repositoryUrl}
   *    .build();
   * </pre>
   * @return A new ImmutableStatus builder
   */
  public static ImmutableStatus.Builder builder() {
    return new ImmutableStatus.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableStatus ImmutableStatus}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Status", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable GitHubInstant createdAt;
    private @Nullable GitHubInstant updatedAt;
    private @Nullable String state;
    private @Nullable URI targetUrl;
    private @Nullable String description;
    private @Nullable Long id;
    private @Nullable URI url;
    private @Nullable String context;
    private @Nullable User creator;
    private @Nullable URI deploymentUrl;
    private @Nullable URI repositoryUrl;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.v3.repos.Status} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Status instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.UpdateTracking} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(UpdateTracking instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof Status) {
        Status instance = (Status) object;
        Optional<User> creatorOptional = instance.creator();
        if (creatorOptional.isPresent()) {
          creator(creatorOptional);
        }
        Optional<URI> deploymentUrlOptional = instance.deploymentUrl();
        if (deploymentUrlOptional.isPresent()) {
          deploymentUrl(deploymentUrlOptional);
        }
        Optional<String> contextOptional = instance.context();
        if (contextOptional.isPresent()) {
          context(contextOptional);
        }
        Optional<String> descriptionOptional = instance.description();
        if (descriptionOptional.isPresent()) {
          description(descriptionOptional);
        }
        @Nullable String stateValue = instance.state();
        if (stateValue != null) {
          state(stateValue);
        }
        @Nullable Long idValue = instance.id();
        if (idValue != null) {
          id(idValue);
        }
        Optional<URI> targetUrlOptional = instance.targetUrl();
        if (targetUrlOptional.isPresent()) {
          targetUrl(targetUrlOptional);
        }
        @Nullable URI urlValue = instance.url();
        if (urlValue != null) {
          url(urlValue);
        }
        Optional<URI> repositoryUrlOptional = instance.repositoryUrl();
        if (repositoryUrlOptional.isPresent()) {
          repositoryUrl(repositoryUrlOptional);
        }
      }
      if (object instanceof UpdateTracking) {
        UpdateTracking instance = (UpdateTracking) object;
        @Nullable GitHubInstant createdAtValue = instance.createdAt();
        if (createdAtValue != null) {
          createdAt(createdAtValue);
        }
        @Nullable GitHubInstant updatedAtValue = instance.updatedAt();
        if (updatedAtValue != null) {
          updatedAt(updatedAtValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link Status#createdAt() createdAt} attribute.
     * @param createdAt The value for createdAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder createdAt(@Nullable GitHubInstant createdAt) {
      this.createdAt = createdAt;
      return this;
    }

    /**
     * Initializes the value for the {@link Status#updatedAt() updatedAt} attribute.
     * @param updatedAt The value for updatedAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder updatedAt(@Nullable GitHubInstant updatedAt) {
      this.updatedAt = updatedAt;
      return this;
    }

    /**
     * Initializes the value for the {@link Status#state() state} attribute.
     * @param state The value for state (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder state(@Nullable String state) {
      this.state = state;
      return this;
    }

    /**
     * Initializes the optional value {@link Status#targetUrl() targetUrl} to targetUrl.
     * @param targetUrl The value for targetUrl
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder targetUrl(URI targetUrl) {
      this.targetUrl = Objects.requireNonNull(targetUrl, "targetUrl");
      return this;
    }

    /**
     * Initializes the optional value {@link Status#targetUrl() targetUrl} to targetUrl.
     * @param targetUrl The value for targetUrl
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder targetUrl(Optional<? extends URI> targetUrl) {
      this.targetUrl = targetUrl.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Status#description() description} to description.
     * @param description The value for description
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder description(String description) {
      this.description = Objects.requireNonNull(description, "description");
      return this;
    }

    /**
     * Initializes the optional value {@link Status#description() description} to description.
     * @param description The value for description
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder description(Optional<String> description) {
      this.description = description.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link Status#id() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder id(@Nullable Long id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link Status#url() url} attribute.
     * @param url The value for url (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder url(@Nullable URI url) {
      this.url = url;
      return this;
    }

    /**
     * Initializes the optional value {@link Status#context() context} to context.
     * @param context The value for context
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder context(String context) {
      this.context = Objects.requireNonNull(context, "context");
      return this;
    }

    /**
     * Initializes the optional value {@link Status#context() context} to context.
     * @param context The value for context
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder context(Optional<String> context) {
      this.context = context.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Status#creator() creator} to creator.
     * @param creator The value for creator
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder creator(User creator) {
      this.creator = Objects.requireNonNull(creator, "creator");
      return this;
    }

    /**
     * Initializes the optional value {@link Status#creator() creator} to creator.
     * @param creator The value for creator
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder creator(Optional<? extends User> creator) {
      this.creator = creator.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Status#deploymentUrl() deploymentUrl} to deploymentUrl.
     * @param deploymentUrl The value for deploymentUrl
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder deploymentUrl(URI deploymentUrl) {
      this.deploymentUrl = Objects.requireNonNull(deploymentUrl, "deploymentUrl");
      return this;
    }

    /**
     * Initializes the optional value {@link Status#deploymentUrl() deploymentUrl} to deploymentUrl.
     * @param deploymentUrl The value for deploymentUrl
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder deploymentUrl(Optional<? extends URI> deploymentUrl) {
      this.deploymentUrl = deploymentUrl.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Status#repositoryUrl() repositoryUrl} to repositoryUrl.
     * @param repositoryUrl The value for repositoryUrl
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder repositoryUrl(URI repositoryUrl) {
      this.repositoryUrl = Objects.requireNonNull(repositoryUrl, "repositoryUrl");
      return this;
    }

    /**
     * Initializes the optional value {@link Status#repositoryUrl() repositoryUrl} to repositoryUrl.
     * @param repositoryUrl The value for repositoryUrl
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder repositoryUrl(Optional<? extends URI> repositoryUrl) {
      this.repositoryUrl = repositoryUrl.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableStatus ImmutableStatus}.
     * @return An immutable instance of Status
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableStatus build() {
      return new ImmutableStatus(
          createdAt,
          updatedAt,
          state,
          targetUrl,
          description,
          id,
          url,
          context,
          creator,
          deploymentUrl,
          repositoryUrl);
    }
  }
}
