package com.spotify.github.v3.search;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import com.spotify.github.CloseTracking;
import com.spotify.github.GitHubInstant;
import com.spotify.github.UpdateTracking;
import com.spotify.github.v3.Milestone;
import com.spotify.github.v3.User;
import com.spotify.github.v3.issues.Issue;
import com.spotify.github.v3.issues.Label;
import com.spotify.github.v3.issues.PullRequest;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link SearchIssue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSearchIssue.builder()}.
 */
@Generated(from = "SearchIssue", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableSearchIssue implements SearchIssue {
  private final @Nullable GitHubInstant createdAt;
  private final @Nullable GitHubInstant updatedAt;
  private final @Nullable GitHubInstant closedAt;
  private final @Nullable Integer id;
  private final @Nullable URI url;
  private final @Nullable Optional<URI> eventsUrl;
  private final @Nullable Optional<URI> repositoryUrl;
  private final @Nullable String labelsUrl;
  private final @Nullable URI commentsUrl;
  private final @Nullable URI htmlUrl;
  private final @Nullable Integer number;
  private final @Nullable String state;
  private final @Nullable String title;
  private final @Nullable Optional<String> body;
  private final @Nullable User user;
  private final @Nullable List<Label> labels;
  private final @Nullable User assignee;
  private final @Nullable Milestone milestone;
  private final @Nullable Boolean locked;
  private final @Nullable Integer comments;
  private final @Nullable PullRequest pullRequest;
  private final @Nullable Float score;

  private ImmutableSearchIssue(
      @Nullable GitHubInstant createdAt,
      @Nullable GitHubInstant updatedAt,
      @Nullable GitHubInstant closedAt,
      @Nullable Integer id,
      @Nullable URI url,
      @Nullable Optional<URI> eventsUrl,
      @Nullable Optional<URI> repositoryUrl,
      @Nullable String labelsUrl,
      @Nullable URI commentsUrl,
      @Nullable URI htmlUrl,
      @Nullable Integer number,
      @Nullable String state,
      @Nullable String title,
      @Nullable Optional<String> body,
      @Nullable User user,
      @Nullable List<Label> labels,
      @Nullable User assignee,
      @Nullable Milestone milestone,
      @Nullable Boolean locked,
      @Nullable Integer comments,
      @Nullable PullRequest pullRequest,
      @Nullable Float score) {
    this.createdAt = createdAt;
    this.updatedAt = updatedAt;
    this.closedAt = closedAt;
    this.id = id;
    this.url = url;
    this.eventsUrl = eventsUrl;
    this.repositoryUrl = repositoryUrl;
    this.labelsUrl = labelsUrl;
    this.commentsUrl = commentsUrl;
    this.htmlUrl = htmlUrl;
    this.number = number;
    this.state = state;
    this.title = title;
    this.body = body;
    this.user = user;
    this.labels = labels;
    this.assignee = assignee;
    this.milestone = milestone;
    this.locked = locked;
    this.comments = comments;
    this.pullRequest = pullRequest;
    this.score = score;
  }

  /**
   * Created date
   * @return The date when the issue was created
   */
  @JsonProperty
  @Override
  public @Nullable GitHubInstant createdAt() {
    return createdAt;
  }

  /**
   * Updated date
   * @return The date when the issue was updated
   */
  @JsonProperty
  @Override
  public @Nullable GitHubInstant updatedAt() {
    return updatedAt;
  }

  /**
   * Closed date.
   * @return The date when the issue was closed
   */
  @JsonProperty
  @Override
  public Optional<GitHubInstant> closedAt() {
    return Optional.ofNullable(closedAt);
  }

  /**
   *ID. 
   */
  @JsonProperty
  @Override
  public @Nullable Integer id() {
    return id;
  }

  /**
   *URL. 
   */
  @JsonProperty
  @Override
  public @Nullable URI url() {
    return url;
  }

  /**
   *Events URL. 
   */
  @JsonProperty
  @Override
  public @Nullable Optional<URI> eventsUrl() {
    return eventsUrl;
  }

  /**
   *Repository URL. 
   */
  @JsonProperty
  @Override
  public @Nullable Optional<URI> repositoryUrl() {
    return repositoryUrl;
  }

  /**
   *Labels URL template. 
   */
  @JsonProperty
  @Override
  public @Nullable String labelsUrl() {
    return labelsUrl;
  }

  /**
   *Comments URL. 
   */
  @JsonProperty
  @Override
  public @Nullable URI commentsUrl() {
    return commentsUrl;
  }

  /**
   *HTML URL. 
   */
  @JsonProperty
  @Override
  public @Nullable URI htmlUrl() {
    return htmlUrl;
  }

  /**
   *Number. 
   */
  @JsonProperty
  @Override
  public @Nullable Integer number() {
    return number;
  }

  /**
   *Indicates the state of the issues to return. Can be either open, closed, or all. 
   */
  @JsonProperty
  @Override
  public @Nullable String state() {
    return state;
  }

  /**
   *The title of the issue. 
   */
  @JsonProperty
  @Override
  public @Nullable String title() {
    return title;
  }

  /**
   *The contents of the issue. 
   */
  @JsonProperty
  @Override
  public @Nullable Optional<String> body() {
    return body;
  }

  /**
   *User. 
   */
  @JsonProperty
  @Override
  public @Nullable User user() {
    return user;
  }

  /**
   *A list of comma separated label names. Example: bug,ui,@highl. 
   */
  @JsonProperty
  @Override
  public @Nullable List<Label> labels() {
    return labels;
  }

  /**
   *Login for the user that this issue should be assigned to. 
   */
  @JsonProperty
  @Override
  public Optional<User> assignee() {
    return Optional.ofNullable(assignee);
  }

  /**
   *The milestone associated this issue with. 
   */
  @JsonProperty
  @Override
  public Optional<Milestone> milestone() {
    return Optional.ofNullable(milestone);
  }

  /**
   *Is locked. 
   */
  @JsonProperty
  @Override
  public @Nullable Boolean locked() {
    return locked;
  }

  /**
   *Number of comments. 
   */
  @JsonProperty
  @Override
  public @Nullable Integer comments() {
    return comments;
  }

  /**
   *Pull request. 
   */
  @JsonProperty
  @Override
  public Optional<PullRequest> pullRequest() {
    return Optional.ofNullable(pullRequest);
  }

  /**
   * Score of item
   * @return float
   */
  @JsonProperty
  @Override
  public @Nullable Float score() {
    return score;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SearchIssue#createdAt() createdAt} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for createdAt (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSearchIssue withCreatedAt(@Nullable GitHubInstant value) {
    if (this.createdAt == value) return this;
    return new ImmutableSearchIssue(
        value,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.eventsUrl,
        this.repositoryUrl,
        this.labelsUrl,
        this.commentsUrl,
        this.htmlUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.user,
        this.labels,
        this.assignee,
        this.milestone,
        this.locked,
        this.comments,
        this.pullRequest,
        this.score);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SearchIssue#updatedAt() updatedAt} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for updatedAt (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSearchIssue withUpdatedAt(@Nullable GitHubInstant value) {
    if (this.updatedAt == value) return this;
    return new ImmutableSearchIssue(
        this.createdAt,
        value,
        this.closedAt,
        this.id,
        this.url,
        this.eventsUrl,
        this.repositoryUrl,
        this.labelsUrl,
        this.commentsUrl,
        this.htmlUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.user,
        this.labels,
        this.assignee,
        this.milestone,
        this.locked,
        this.comments,
        this.pullRequest,
        this.score);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SearchIssue#closedAt() closedAt} attribute.
   * @param value The value for closedAt
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSearchIssue withClosedAt(GitHubInstant value) {
    @Nullable GitHubInstant newValue = Objects.requireNonNull(value, "closedAt");
    if (this.closedAt == newValue) return this;
    return new ImmutableSearchIssue(
        this.createdAt,
        this.updatedAt,
        newValue,
        this.id,
        this.url,
        this.eventsUrl,
        this.repositoryUrl,
        this.labelsUrl,
        this.commentsUrl,
        this.htmlUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.user,
        this.labels,
        this.assignee,
        this.milestone,
        this.locked,
        this.comments,
        this.pullRequest,
        this.score);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SearchIssue#closedAt() closedAt} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for closedAt
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableSearchIssue withClosedAt(Optional<? extends GitHubInstant> optional) {
    @Nullable GitHubInstant value = optional.orElse(null);
    if (this.closedAt == value) return this;
    return new ImmutableSearchIssue(
        this.createdAt,
        this.updatedAt,
        value,
        this.id,
        this.url,
        this.eventsUrl,
        this.repositoryUrl,
        this.labelsUrl,
        this.commentsUrl,
        this.htmlUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.user,
        this.labels,
        this.assignee,
        this.milestone,
        this.locked,
        this.comments,
        this.pullRequest,
        this.score);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SearchIssue#id() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSearchIssue withId(@Nullable Integer value) {
    if (Objects.equals(this.id, value)) return this;
    return new ImmutableSearchIssue(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        value,
        this.url,
        this.eventsUrl,
        this.repositoryUrl,
        this.labelsUrl,
        this.commentsUrl,
        this.htmlUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.user,
        this.labels,
        this.assignee,
        this.milestone,
        this.locked,
        this.comments,
        this.pullRequest,
        this.score);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SearchIssue#url() url} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for url (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSearchIssue withUrl(@Nullable URI value) {
    if (this.url == value) return this;
    return new ImmutableSearchIssue(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        value,
        this.eventsUrl,
        this.repositoryUrl,
        this.labelsUrl,
        this.commentsUrl,
        this.htmlUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.user,
        this.labels,
        this.assignee,
        this.milestone,
        this.locked,
        this.comments,
        this.pullRequest,
        this.score);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SearchIssue#eventsUrl() eventsUrl} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for eventsUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSearchIssue withEventsUrl(@Nullable Optional<URI> value) {
    if (Objects.equals(this.eventsUrl, value)) return this;
    return new ImmutableSearchIssue(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        value,
        this.repositoryUrl,
        this.labelsUrl,
        this.commentsUrl,
        this.htmlUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.user,
        this.labels,
        this.assignee,
        this.milestone,
        this.locked,
        this.comments,
        this.pullRequest,
        this.score);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SearchIssue#repositoryUrl() repositoryUrl} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for repositoryUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSearchIssue withRepositoryUrl(@Nullable Optional<URI> value) {
    if (Objects.equals(this.repositoryUrl, value)) return this;
    return new ImmutableSearchIssue(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.eventsUrl,
        value,
        this.labelsUrl,
        this.commentsUrl,
        this.htmlUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.user,
        this.labels,
        this.assignee,
        this.milestone,
        this.locked,
        this.comments,
        this.pullRequest,
        this.score);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SearchIssue#labelsUrl() labelsUrl} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for labelsUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSearchIssue withLabelsUrl(@Nullable String value) {
    if (Objects.equals(this.labelsUrl, value)) return this;
    return new ImmutableSearchIssue(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.eventsUrl,
        this.repositoryUrl,
        value,
        this.commentsUrl,
        this.htmlUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.user,
        this.labels,
        this.assignee,
        this.milestone,
        this.locked,
        this.comments,
        this.pullRequest,
        this.score);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SearchIssue#commentsUrl() commentsUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for commentsUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSearchIssue withCommentsUrl(@Nullable URI value) {
    if (this.commentsUrl == value) return this;
    return new ImmutableSearchIssue(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.eventsUrl,
        this.repositoryUrl,
        this.labelsUrl,
        value,
        this.htmlUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.user,
        this.labels,
        this.assignee,
        this.milestone,
        this.locked,
        this.comments,
        this.pullRequest,
        this.score);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SearchIssue#htmlUrl() htmlUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for htmlUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSearchIssue withHtmlUrl(@Nullable URI value) {
    if (this.htmlUrl == value) return this;
    return new ImmutableSearchIssue(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.eventsUrl,
        this.repositoryUrl,
        this.labelsUrl,
        this.commentsUrl,
        value,
        this.number,
        this.state,
        this.title,
        this.body,
        this.user,
        this.labels,
        this.assignee,
        this.milestone,
        this.locked,
        this.comments,
        this.pullRequest,
        this.score);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SearchIssue#number() number} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for number (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSearchIssue withNumber(@Nullable Integer value) {
    if (Objects.equals(this.number, value)) return this;
    return new ImmutableSearchIssue(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.eventsUrl,
        this.repositoryUrl,
        this.labelsUrl,
        this.commentsUrl,
        this.htmlUrl,
        value,
        this.state,
        this.title,
        this.body,
        this.user,
        this.labels,
        this.assignee,
        this.milestone,
        this.locked,
        this.comments,
        this.pullRequest,
        this.score);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SearchIssue#state() state} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for state (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSearchIssue withState(@Nullable String value) {
    if (Objects.equals(this.state, value)) return this;
    return new ImmutableSearchIssue(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.eventsUrl,
        this.repositoryUrl,
        this.labelsUrl,
        this.commentsUrl,
        this.htmlUrl,
        this.number,
        value,
        this.title,
        this.body,
        this.user,
        this.labels,
        this.assignee,
        this.milestone,
        this.locked,
        this.comments,
        this.pullRequest,
        this.score);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SearchIssue#title() title} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for title (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSearchIssue withTitle(@Nullable String value) {
    if (Objects.equals(this.title, value)) return this;
    return new ImmutableSearchIssue(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.eventsUrl,
        this.repositoryUrl,
        this.labelsUrl,
        this.commentsUrl,
        this.htmlUrl,
        this.number,
        this.state,
        value,
        this.body,
        this.user,
        this.labels,
        this.assignee,
        this.milestone,
        this.locked,
        this.comments,
        this.pullRequest,
        this.score);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SearchIssue#body() body} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for body (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSearchIssue withBody(@Nullable Optional<String> value) {
    if (Objects.equals(this.body, value)) return this;
    return new ImmutableSearchIssue(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.eventsUrl,
        this.repositoryUrl,
        this.labelsUrl,
        this.commentsUrl,
        this.htmlUrl,
        this.number,
        this.state,
        this.title,
        value,
        this.user,
        this.labels,
        this.assignee,
        this.milestone,
        this.locked,
        this.comments,
        this.pullRequest,
        this.score);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SearchIssue#user() user} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for user (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSearchIssue withUser(@Nullable User value) {
    if (this.user == value) return this;
    return new ImmutableSearchIssue(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.eventsUrl,
        this.repositoryUrl,
        this.labelsUrl,
        this.commentsUrl,
        this.htmlUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        value,
        this.labels,
        this.assignee,
        this.milestone,
        this.locked,
        this.comments,
        this.pullRequest,
        this.score);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SearchIssue#labels() labels}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSearchIssue withLabels(@Nullable Label... elements) {
    if (elements == null) {
      return new ImmutableSearchIssue(
          this.createdAt,
          this.updatedAt,
          this.closedAt,
          this.id,
          this.url,
          this.eventsUrl,
          this.repositoryUrl,
          this.labelsUrl,
          this.commentsUrl,
          this.htmlUrl,
          this.number,
          this.state,
          this.title,
          this.body,
          this.user,
          null,
          this.assignee,
          this.milestone,
          this.locked,
          this.comments,
          this.pullRequest,
          this.score);
    }
    @Nullable List<Label> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableSearchIssue(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.eventsUrl,
        this.repositoryUrl,
        this.labelsUrl,
        this.commentsUrl,
        this.htmlUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.user,
        newValue,
        this.assignee,
        this.milestone,
        this.locked,
        this.comments,
        this.pullRequest,
        this.score);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SearchIssue#labels() labels}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of labels elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSearchIssue withLabels(@Nullable Iterable<? extends Label> elements) {
    if (this.labels == elements) return this;
    @Nullable List<Label> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableSearchIssue(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.eventsUrl,
        this.repositoryUrl,
        this.labelsUrl,
        this.commentsUrl,
        this.htmlUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.user,
        newValue,
        this.assignee,
        this.milestone,
        this.locked,
        this.comments,
        this.pullRequest,
        this.score);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SearchIssue#assignee() assignee} attribute.
   * @param value The value for assignee
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSearchIssue withAssignee(User value) {
    @Nullable User newValue = Objects.requireNonNull(value, "assignee");
    if (this.assignee == newValue) return this;
    return new ImmutableSearchIssue(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.eventsUrl,
        this.repositoryUrl,
        this.labelsUrl,
        this.commentsUrl,
        this.htmlUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.user,
        this.labels,
        newValue,
        this.milestone,
        this.locked,
        this.comments,
        this.pullRequest,
        this.score);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SearchIssue#assignee() assignee} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for assignee
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableSearchIssue withAssignee(Optional<? extends User> optional) {
    @Nullable User value = optional.orElse(null);
    if (this.assignee == value) return this;
    return new ImmutableSearchIssue(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.eventsUrl,
        this.repositoryUrl,
        this.labelsUrl,
        this.commentsUrl,
        this.htmlUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.user,
        this.labels,
        value,
        this.milestone,
        this.locked,
        this.comments,
        this.pullRequest,
        this.score);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SearchIssue#milestone() milestone} attribute.
   * @param value The value for milestone
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSearchIssue withMilestone(Milestone value) {
    @Nullable Milestone newValue = Objects.requireNonNull(value, "milestone");
    if (this.milestone == newValue) return this;
    return new ImmutableSearchIssue(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.eventsUrl,
        this.repositoryUrl,
        this.labelsUrl,
        this.commentsUrl,
        this.htmlUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.user,
        this.labels,
        this.assignee,
        newValue,
        this.locked,
        this.comments,
        this.pullRequest,
        this.score);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SearchIssue#milestone() milestone} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for milestone
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableSearchIssue withMilestone(Optional<? extends Milestone> optional) {
    @Nullable Milestone value = optional.orElse(null);
    if (this.milestone == value) return this;
    return new ImmutableSearchIssue(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.eventsUrl,
        this.repositoryUrl,
        this.labelsUrl,
        this.commentsUrl,
        this.htmlUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.user,
        this.labels,
        this.assignee,
        value,
        this.locked,
        this.comments,
        this.pullRequest,
        this.score);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SearchIssue#locked() locked} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for locked (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSearchIssue withLocked(@Nullable Boolean value) {
    if (Objects.equals(this.locked, value)) return this;
    return new ImmutableSearchIssue(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.eventsUrl,
        this.repositoryUrl,
        this.labelsUrl,
        this.commentsUrl,
        this.htmlUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.user,
        this.labels,
        this.assignee,
        this.milestone,
        value,
        this.comments,
        this.pullRequest,
        this.score);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SearchIssue#comments() comments} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for comments (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSearchIssue withComments(@Nullable Integer value) {
    if (Objects.equals(this.comments, value)) return this;
    return new ImmutableSearchIssue(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.eventsUrl,
        this.repositoryUrl,
        this.labelsUrl,
        this.commentsUrl,
        this.htmlUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.user,
        this.labels,
        this.assignee,
        this.milestone,
        this.locked,
        value,
        this.pullRequest,
        this.score);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SearchIssue#pullRequest() pullRequest} attribute.
   * @param value The value for pullRequest
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSearchIssue withPullRequest(PullRequest value) {
    @Nullable PullRequest newValue = Objects.requireNonNull(value, "pullRequest");
    if (this.pullRequest == newValue) return this;
    return new ImmutableSearchIssue(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.eventsUrl,
        this.repositoryUrl,
        this.labelsUrl,
        this.commentsUrl,
        this.htmlUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.user,
        this.labels,
        this.assignee,
        this.milestone,
        this.locked,
        this.comments,
        newValue,
        this.score);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SearchIssue#pullRequest() pullRequest} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for pullRequest
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableSearchIssue withPullRequest(Optional<? extends PullRequest> optional) {
    @Nullable PullRequest value = optional.orElse(null);
    if (this.pullRequest == value) return this;
    return new ImmutableSearchIssue(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.eventsUrl,
        this.repositoryUrl,
        this.labelsUrl,
        this.commentsUrl,
        this.htmlUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.user,
        this.labels,
        this.assignee,
        this.milestone,
        this.locked,
        this.comments,
        value,
        this.score);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SearchIssue#score() score} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for score (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSearchIssue withScore(@Nullable Float value) {
    if (Objects.equals(this.score, value)) return this;
    return new ImmutableSearchIssue(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.eventsUrl,
        this.repositoryUrl,
        this.labelsUrl,
        this.commentsUrl,
        this.htmlUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.user,
        this.labels,
        this.assignee,
        this.milestone,
        this.locked,
        this.comments,
        this.pullRequest,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSearchIssue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSearchIssue
        && equalTo((ImmutableSearchIssue) another);
  }

  private boolean equalTo(ImmutableSearchIssue another) {
    return Objects.equals(createdAt, another.createdAt)
        && Objects.equals(updatedAt, another.updatedAt)
        && Objects.equals(closedAt, another.closedAt)
        && Objects.equals(id, another.id)
        && Objects.equals(url, another.url)
        && Objects.equals(eventsUrl, another.eventsUrl)
        && Objects.equals(repositoryUrl, another.repositoryUrl)
        && Objects.equals(labelsUrl, another.labelsUrl)
        && Objects.equals(commentsUrl, another.commentsUrl)
        && Objects.equals(htmlUrl, another.htmlUrl)
        && Objects.equals(number, another.number)
        && Objects.equals(state, another.state)
        && Objects.equals(title, another.title)
        && Objects.equals(body, another.body)
        && Objects.equals(user, another.user)
        && Objects.equals(labels, another.labels)
        && Objects.equals(assignee, another.assignee)
        && Objects.equals(milestone, another.milestone)
        && Objects.equals(locked, another.locked)
        && Objects.equals(comments, another.comments)
        && Objects.equals(pullRequest, another.pullRequest)
        && Objects.equals(score, another.score);
  }

  /**
   * Computes a hash code from attributes: {@code createdAt}, {@code updatedAt}, {@code closedAt}, {@code id}, {@code url}, {@code eventsUrl}, {@code repositoryUrl}, {@code labelsUrl}, {@code commentsUrl}, {@code htmlUrl}, {@code number}, {@code state}, {@code title}, {@code body}, {@code user}, {@code labels}, {@code assignee}, {@code milestone}, {@code locked}, {@code comments}, {@code pullRequest}, {@code score}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(createdAt);
    h += (h << 5) + Objects.hashCode(updatedAt);
    h += (h << 5) + Objects.hashCode(closedAt);
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(url);
    h += (h << 5) + Objects.hashCode(eventsUrl);
    h += (h << 5) + Objects.hashCode(repositoryUrl);
    h += (h << 5) + Objects.hashCode(labelsUrl);
    h += (h << 5) + Objects.hashCode(commentsUrl);
    h += (h << 5) + Objects.hashCode(htmlUrl);
    h += (h << 5) + Objects.hashCode(number);
    h += (h << 5) + Objects.hashCode(state);
    h += (h << 5) + Objects.hashCode(title);
    h += (h << 5) + Objects.hashCode(body);
    h += (h << 5) + Objects.hashCode(user);
    h += (h << 5) + Objects.hashCode(labels);
    h += (h << 5) + Objects.hashCode(assignee);
    h += (h << 5) + Objects.hashCode(milestone);
    h += (h << 5) + Objects.hashCode(locked);
    h += (h << 5) + Objects.hashCode(comments);
    h += (h << 5) + Objects.hashCode(pullRequest);
    h += (h << 5) + Objects.hashCode(score);
    return h;
  }

  /**
   * Prints the immutable value {@code SearchIssue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("SearchIssue{");
    if (createdAt != null) {
      builder.append("createdAt=").append(createdAt);
    }
    if (updatedAt != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("updatedAt=").append(updatedAt);
    }
    if (closedAt != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("closedAt=").append(closedAt);
    }
    if (id != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("id=").append(id);
    }
    if (url != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("url=").append(url);
    }
    if (eventsUrl != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("eventsUrl=").append(eventsUrl);
    }
    if (repositoryUrl != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("repositoryUrl=").append(repositoryUrl);
    }
    if (labelsUrl != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("labelsUrl=").append(labelsUrl);
    }
    if (commentsUrl != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("commentsUrl=").append(commentsUrl);
    }
    if (htmlUrl != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("htmlUrl=").append(htmlUrl);
    }
    if (number != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("number=").append(number);
    }
    if (state != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("state=").append(state);
    }
    if (title != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("title=").append(title);
    }
    if (body != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("body=").append(body);
    }
    if (user != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("user=").append(user);
    }
    if (labels != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("labels=").append(labels);
    }
    if (assignee != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("assignee=").append(assignee);
    }
    if (milestone != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("milestone=").append(milestone);
    }
    if (locked != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("locked=").append(locked);
    }
    if (comments != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("comments=").append(comments);
    }
    if (pullRequest != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("pullRequest=").append(pullRequest);
    }
    if (score != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("score=").append(score);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "SearchIssue", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements SearchIssue {
    @Nullable GitHubInstant createdAt;
    @Nullable GitHubInstant updatedAt;
    @Nullable Optional<GitHubInstant> closedAt = Optional.empty();
    @Nullable Integer id;
    @Nullable URI url;
    @Nullable Optional<URI> eventsUrl;
    @Nullable Optional<URI> repositoryUrl;
    @Nullable String labelsUrl;
    @Nullable URI commentsUrl;
    @Nullable URI htmlUrl;
    @Nullable Integer number;
    @Nullable String state;
    @Nullable String title;
    @Nullable Optional<String> body;
    @Nullable User user;
    @Nullable List<Label> labels = null;
    @Nullable Optional<User> assignee = Optional.empty();
    @Nullable Optional<Milestone> milestone = Optional.empty();
    @Nullable Boolean locked;
    @Nullable Integer comments;
    @Nullable Optional<PullRequest> pullRequest = Optional.empty();
    @Nullable Float score;
    @JsonProperty
    public void setCreatedAt(@Nullable GitHubInstant createdAt) {
      this.createdAt = createdAt;
    }
    @JsonProperty
    public void setUpdatedAt(@Nullable GitHubInstant updatedAt) {
      this.updatedAt = updatedAt;
    }
    @JsonProperty
    public void setClosedAt(Optional<GitHubInstant> closedAt) {
      this.closedAt = closedAt;
    }
    @JsonProperty
    public void setId(@Nullable Integer id) {
      this.id = id;
    }
    @JsonProperty
    public void setUrl(@Nullable URI url) {
      this.url = url;
    }
    @JsonProperty
    public void setEventsUrl(@Nullable Optional<URI> eventsUrl) {
      this.eventsUrl = eventsUrl;
    }
    @JsonProperty
    public void setRepositoryUrl(@Nullable Optional<URI> repositoryUrl) {
      this.repositoryUrl = repositoryUrl;
    }
    @JsonProperty
    public void setLabelsUrl(@Nullable String labelsUrl) {
      this.labelsUrl = labelsUrl;
    }
    @JsonProperty
    public void setCommentsUrl(@Nullable URI commentsUrl) {
      this.commentsUrl = commentsUrl;
    }
    @JsonProperty
    public void setHtmlUrl(@Nullable URI htmlUrl) {
      this.htmlUrl = htmlUrl;
    }
    @JsonProperty
    public void setNumber(@Nullable Integer number) {
      this.number = number;
    }
    @JsonProperty
    public void setState(@Nullable String state) {
      this.state = state;
    }
    @JsonProperty
    public void setTitle(@Nullable String title) {
      this.title = title;
    }
    @JsonProperty
    public void setBody(@Nullable Optional<String> body) {
      this.body = body;
    }
    @JsonProperty
    public void setUser(@Nullable User user) {
      this.user = user;
    }
    @JsonProperty
    public void setLabels(@Nullable List<Label> labels) {
      this.labels = labels;
    }
    @JsonProperty
    public void setAssignee(Optional<User> assignee) {
      this.assignee = assignee;
    }
    @JsonProperty
    public void setMilestone(Optional<Milestone> milestone) {
      this.milestone = milestone;
    }
    @JsonProperty
    public void setLocked(@Nullable Boolean locked) {
      this.locked = locked;
    }
    @JsonProperty
    public void setComments(@Nullable Integer comments) {
      this.comments = comments;
    }
    @JsonProperty
    public void setPullRequest(Optional<PullRequest> pullRequest) {
      this.pullRequest = pullRequest;
    }
    @JsonProperty
    public void setScore(@Nullable Float score) {
      this.score = score;
    }
    @Override
    public GitHubInstant createdAt() { throw new UnsupportedOperationException(); }
    @Override
    public GitHubInstant updatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<GitHubInstant> closedAt() { throw new UnsupportedOperationException(); }
    @Override
    public Integer id() { throw new UnsupportedOperationException(); }
    @Override
    public URI url() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<URI> eventsUrl() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<URI> repositoryUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String labelsUrl() { throw new UnsupportedOperationException(); }
    @Override
    public URI commentsUrl() { throw new UnsupportedOperationException(); }
    @Override
    public URI htmlUrl() { throw new UnsupportedOperationException(); }
    @Override
    public Integer number() { throw new UnsupportedOperationException(); }
    @Override
    public String state() { throw new UnsupportedOperationException(); }
    @Override
    public String title() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> body() { throw new UnsupportedOperationException(); }
    @Override
    public User user() { throw new UnsupportedOperationException(); }
    @Override
    public List<Label> labels() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<User> assignee() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Milestone> milestone() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean locked() { throw new UnsupportedOperationException(); }
    @Override
    public Integer comments() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<PullRequest> pullRequest() { throw new UnsupportedOperationException(); }
    @Override
    public Float score() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableSearchIssue fromJson(Json json) {
    ImmutableSearchIssue.Builder builder = ImmutableSearchIssue.builder();
    if (json.createdAt != null) {
      builder.createdAt(json.createdAt);
    }
    if (json.updatedAt != null) {
      builder.updatedAt(json.updatedAt);
    }
    if (json.closedAt != null) {
      builder.closedAt(json.closedAt);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.url != null) {
      builder.url(json.url);
    }
    if (json.eventsUrl != null) {
      builder.eventsUrl(json.eventsUrl);
    }
    if (json.repositoryUrl != null) {
      builder.repositoryUrl(json.repositoryUrl);
    }
    if (json.labelsUrl != null) {
      builder.labelsUrl(json.labelsUrl);
    }
    if (json.commentsUrl != null) {
      builder.commentsUrl(json.commentsUrl);
    }
    if (json.htmlUrl != null) {
      builder.htmlUrl(json.htmlUrl);
    }
    if (json.number != null) {
      builder.number(json.number);
    }
    if (json.state != null) {
      builder.state(json.state);
    }
    if (json.title != null) {
      builder.title(json.title);
    }
    if (json.body != null) {
      builder.body(json.body);
    }
    if (json.user != null) {
      builder.user(json.user);
    }
    if (json.labels != null) {
      builder.addAllLabels(json.labels);
    }
    if (json.assignee != null) {
      builder.assignee(json.assignee);
    }
    if (json.milestone != null) {
      builder.milestone(json.milestone);
    }
    if (json.locked != null) {
      builder.locked(json.locked);
    }
    if (json.comments != null) {
      builder.comments(json.comments);
    }
    if (json.pullRequest != null) {
      builder.pullRequest(json.pullRequest);
    }
    if (json.score != null) {
      builder.score(json.score);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link SearchIssue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SearchIssue instance
   */
  public static ImmutableSearchIssue copyOf(SearchIssue instance) {
    if (instance instanceof ImmutableSearchIssue) {
      return (ImmutableSearchIssue) instance;
    }
    return ImmutableSearchIssue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSearchIssue ImmutableSearchIssue}.
   * <pre>
   * ImmutableSearchIssue.builder()
   *    .createdAt(com.spotify.github.GitHubInstant | null) // nullable {@link SearchIssue#createdAt() createdAt}
   *    .updatedAt(com.spotify.github.GitHubInstant | null) // nullable {@link SearchIssue#updatedAt() updatedAt}
   *    .closedAt(com.spotify.github.GitHubInstant) // optional {@link SearchIssue#closedAt() closedAt}
   *    .id(Integer | null) // nullable {@link SearchIssue#id() id}
   *    .url(java.net.URI | null) // nullable {@link SearchIssue#url() url}
   *    .eventsUrl(Optional&amp;lt;java.net.URI&amp;gt; | null) // nullable {@link SearchIssue#eventsUrl() eventsUrl}
   *    .repositoryUrl(Optional&amp;lt;java.net.URI&amp;gt; | null) // nullable {@link SearchIssue#repositoryUrl() repositoryUrl}
   *    .labelsUrl(String | null) // nullable {@link SearchIssue#labelsUrl() labelsUrl}
   *    .commentsUrl(java.net.URI | null) // nullable {@link SearchIssue#commentsUrl() commentsUrl}
   *    .htmlUrl(java.net.URI | null) // nullable {@link SearchIssue#htmlUrl() htmlUrl}
   *    .number(Integer | null) // nullable {@link SearchIssue#number() number}
   *    .state(String | null) // nullable {@link SearchIssue#state() state}
   *    .title(String | null) // nullable {@link SearchIssue#title() title}
   *    .body(Optional&amp;lt;String&amp;gt; | null) // nullable {@link SearchIssue#body() body}
   *    .user(com.spotify.github.v3.User | null) // nullable {@link SearchIssue#user() user}
   *    .labels(List&amp;lt;com.spotify.github.v3.issues.Label&amp;gt; | null) // nullable {@link SearchIssue#labels() labels}
   *    .assignee(com.spotify.github.v3.User) // optional {@link SearchIssue#assignee() assignee}
   *    .milestone(com.spotify.github.v3.Milestone) // optional {@link SearchIssue#milestone() milestone}
   *    .locked(Boolean | null) // nullable {@link SearchIssue#locked() locked}
   *    .comments(Integer | null) // nullable {@link SearchIssue#comments() comments}
   *    .pullRequest(com.spotify.github.v3.issues.PullRequest) // optional {@link SearchIssue#pullRequest() pullRequest}
   *    .score(Float | null) // nullable {@link SearchIssue#score() score}
   *    .build();
   * </pre>
   * @return A new ImmutableSearchIssue builder
   */
  public static ImmutableSearchIssue.Builder builder() {
    return new ImmutableSearchIssue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSearchIssue ImmutableSearchIssue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "SearchIssue", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable GitHubInstant createdAt;
    private @Nullable GitHubInstant updatedAt;
    private @Nullable GitHubInstant closedAt;
    private @Nullable Integer id;
    private @Nullable URI url;
    private @Nullable Optional<URI> eventsUrl;
    private @Nullable Optional<URI> repositoryUrl;
    private @Nullable String labelsUrl;
    private @Nullable URI commentsUrl;
    private @Nullable URI htmlUrl;
    private @Nullable Integer number;
    private @Nullable String state;
    private @Nullable String title;
    private @Nullable Optional<String> body;
    private @Nullable User user;
    private List<Label> labels = null;
    private @Nullable User assignee;
    private @Nullable Milestone milestone;
    private @Nullable Boolean locked;
    private @Nullable Integer comments;
    private @Nullable PullRequest pullRequest;
    private @Nullable Float score;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.v3.search.SearchIssue} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(SearchIssue instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.CloseTracking} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CloseTracking instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.v3.issues.Issue} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Issue instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.UpdateTracking} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(UpdateTracking instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof SearchIssue) {
        SearchIssue instance = (SearchIssue) object;
        @Nullable Float scoreValue = instance.score();
        if (scoreValue != null) {
          score(scoreValue);
        }
      }
      if (object instanceof CloseTracking) {
        CloseTracking instance = (CloseTracking) object;
        Optional<GitHubInstant> closedAtOptional = instance.closedAt();
        if (closedAtOptional.isPresent()) {
          closedAt(closedAtOptional);
        }
      }
      if (object instanceof Issue) {
        Issue instance = (Issue) object;
        @Nullable Integer commentsValue = instance.comments();
        if (commentsValue != null) {
          comments(commentsValue);
        }
        @Nullable String labelsUrlValue = instance.labelsUrl();
        if (labelsUrlValue != null) {
          labelsUrl(labelsUrlValue);
        }
        @Nullable URI htmlUrlValue = instance.htmlUrl();
        if (htmlUrlValue != null) {
          htmlUrl(htmlUrlValue);
        }
        @Nullable String titleValue = instance.title();
        if (titleValue != null) {
          title(titleValue);
        }
        @Nullable Optional<String> bodyValue = instance.body();
        if (bodyValue != null) {
          body(bodyValue);
        }
        @Nullable URI urlValue = instance.url();
        if (urlValue != null) {
          url(urlValue);
        }
        Optional<PullRequest> pullRequestOptional = instance.pullRequest();
        if (pullRequestOptional.isPresent()) {
          pullRequest(pullRequestOptional);
        }
        @Nullable Optional<URI> repositoryUrlValue = instance.repositoryUrl();
        if (repositoryUrlValue != null) {
          repositoryUrl(repositoryUrlValue);
        }
        @Nullable List<Label> labelsValue = instance.labels();
        if (labelsValue != null) {
          addAllLabels(labelsValue);
        }
        @Nullable Integer numberValue = instance.number();
        if (numberValue != null) {
          number(numberValue);
        }
        @Nullable URI commentsUrlValue = instance.commentsUrl();
        if (commentsUrlValue != null) {
          commentsUrl(commentsUrlValue);
        }
        Optional<Milestone> milestoneOptional = instance.milestone();
        if (milestoneOptional.isPresent()) {
          milestone(milestoneOptional);
        }
        @Nullable Integer idValue = instance.id();
        if (idValue != null) {
          id(idValue);
        }
        @Nullable Optional<URI> eventsUrlValue = instance.eventsUrl();
        if (eventsUrlValue != null) {
          eventsUrl(eventsUrlValue);
        }
        @Nullable String stateValue = instance.state();
        if (stateValue != null) {
          state(stateValue);
        }
        Optional<User> assigneeOptional = instance.assignee();
        if (assigneeOptional.isPresent()) {
          assignee(assigneeOptional);
        }
        @Nullable Boolean lockedValue = instance.locked();
        if (lockedValue != null) {
          locked(lockedValue);
        }
        @Nullable User userValue = instance.user();
        if (userValue != null) {
          user(userValue);
        }
      }
      if (object instanceof UpdateTracking) {
        UpdateTracking instance = (UpdateTracking) object;
        @Nullable GitHubInstant createdAtValue = instance.createdAt();
        if (createdAtValue != null) {
          createdAt(createdAtValue);
        }
        @Nullable GitHubInstant updatedAtValue = instance.updatedAt();
        if (updatedAtValue != null) {
          updatedAt(updatedAtValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link SearchIssue#createdAt() createdAt} attribute.
     * @param createdAt The value for createdAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder createdAt(@Nullable GitHubInstant createdAt) {
      this.createdAt = createdAt;
      return this;
    }

    /**
     * Initializes the value for the {@link SearchIssue#updatedAt() updatedAt} attribute.
     * @param updatedAt The value for updatedAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder updatedAt(@Nullable GitHubInstant updatedAt) {
      this.updatedAt = updatedAt;
      return this;
    }

    /**
     * Initializes the optional value {@link SearchIssue#closedAt() closedAt} to closedAt.
     * @param closedAt The value for closedAt
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder closedAt(GitHubInstant closedAt) {
      this.closedAt = Objects.requireNonNull(closedAt, "closedAt");
      return this;
    }

    /**
     * Initializes the optional value {@link SearchIssue#closedAt() closedAt} to closedAt.
     * @param closedAt The value for closedAt
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder closedAt(Optional<? extends GitHubInstant> closedAt) {
      this.closedAt = closedAt.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link SearchIssue#id() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder id(@Nullable Integer id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link SearchIssue#url() url} attribute.
     * @param url The value for url (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder url(@Nullable URI url) {
      this.url = url;
      return this;
    }

    /**
     * Initializes the value for the {@link SearchIssue#eventsUrl() eventsUrl} attribute.
     * @param eventsUrl The value for eventsUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder eventsUrl(@Nullable Optional<URI> eventsUrl) {
      this.eventsUrl = eventsUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link SearchIssue#repositoryUrl() repositoryUrl} attribute.
     * @param repositoryUrl The value for repositoryUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder repositoryUrl(@Nullable Optional<URI> repositoryUrl) {
      this.repositoryUrl = repositoryUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link SearchIssue#labelsUrl() labelsUrl} attribute.
     * @param labelsUrl The value for labelsUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder labelsUrl(@Nullable String labelsUrl) {
      this.labelsUrl = labelsUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link SearchIssue#commentsUrl() commentsUrl} attribute.
     * @param commentsUrl The value for commentsUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder commentsUrl(@Nullable URI commentsUrl) {
      this.commentsUrl = commentsUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link SearchIssue#htmlUrl() htmlUrl} attribute.
     * @param htmlUrl The value for htmlUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder htmlUrl(@Nullable URI htmlUrl) {
      this.htmlUrl = htmlUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link SearchIssue#number() number} attribute.
     * @param number The value for number (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder number(@Nullable Integer number) {
      this.number = number;
      return this;
    }

    /**
     * Initializes the value for the {@link SearchIssue#state() state} attribute.
     * @param state The value for state (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder state(@Nullable String state) {
      this.state = state;
      return this;
    }

    /**
     * Initializes the value for the {@link SearchIssue#title() title} attribute.
     * @param title The value for title (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder title(@Nullable String title) {
      this.title = title;
      return this;
    }

    /**
     * Initializes the value for the {@link SearchIssue#body() body} attribute.
     * @param body The value for body (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder body(@Nullable Optional<String> body) {
      this.body = body;
      return this;
    }

    /**
     * Initializes the value for the {@link SearchIssue#user() user} attribute.
     * @param user The value for user (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder user(@Nullable User user) {
      this.user = user;
      return this;
    }

    /**
     * Adds one element to {@link SearchIssue#labels() labels} list.
     * @param element A labels element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addLabels(Label element) {
      if (this.labels == null) {
        this.labels = new ArrayList<Label>();
      }
      this.labels.add(Objects.requireNonNull(element, "labels element"));
      return this;
    }

    /**
     * Adds elements to {@link SearchIssue#labels() labels} list.
     * @param elements An array of labels elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addLabels(Label... elements) {
      if (this.labels == null) {
        this.labels = new ArrayList<Label>();
      }
      for (Label element : elements) {
        this.labels.add(Objects.requireNonNull(element, "labels element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link SearchIssue#labels() labels} list.
     * @param elements An iterable of labels elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder labels(@Nullable Iterable<? extends Label> elements) {
      if (elements == null) {
        this.labels = null;
        return this;
      }
      this.labels = new ArrayList<Label>();
      return addAllLabels(elements);
    }

    /**
     * Adds elements to {@link SearchIssue#labels() labels} list.
     * @param elements An iterable of labels elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllLabels(Iterable<? extends Label> elements) {
      Objects.requireNonNull(elements, "labels element");
      if (this.labels == null) {
        this.labels = new ArrayList<Label>();
      }
      for (Label element : elements) {
        this.labels.add(Objects.requireNonNull(element, "labels element"));
      }
      return this;
    }

    /**
     * Initializes the optional value {@link SearchIssue#assignee() assignee} to assignee.
     * @param assignee The value for assignee
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder assignee(User assignee) {
      this.assignee = Objects.requireNonNull(assignee, "assignee");
      return this;
    }

    /**
     * Initializes the optional value {@link SearchIssue#assignee() assignee} to assignee.
     * @param assignee The value for assignee
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder assignee(Optional<? extends User> assignee) {
      this.assignee = assignee.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link SearchIssue#milestone() milestone} to milestone.
     * @param milestone The value for milestone
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder milestone(Milestone milestone) {
      this.milestone = Objects.requireNonNull(milestone, "milestone");
      return this;
    }

    /**
     * Initializes the optional value {@link SearchIssue#milestone() milestone} to milestone.
     * @param milestone The value for milestone
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder milestone(Optional<? extends Milestone> milestone) {
      this.milestone = milestone.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link SearchIssue#locked() locked} attribute.
     * @param locked The value for locked (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder locked(@Nullable Boolean locked) {
      this.locked = locked;
      return this;
    }

    /**
     * Initializes the value for the {@link SearchIssue#comments() comments} attribute.
     * @param comments The value for comments (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder comments(@Nullable Integer comments) {
      this.comments = comments;
      return this;
    }

    /**
     * Initializes the optional value {@link SearchIssue#pullRequest() pullRequest} to pullRequest.
     * @param pullRequest The value for pullRequest
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder pullRequest(PullRequest pullRequest) {
      this.pullRequest = Objects.requireNonNull(pullRequest, "pullRequest");
      return this;
    }

    /**
     * Initializes the optional value {@link SearchIssue#pullRequest() pullRequest} to pullRequest.
     * @param pullRequest The value for pullRequest
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder pullRequest(Optional<? extends PullRequest> pullRequest) {
      this.pullRequest = pullRequest.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link SearchIssue#score() score} attribute.
     * @param score The value for score (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder score(@Nullable Float score) {
      this.score = score;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSearchIssue ImmutableSearchIssue}.
     * @return An immutable instance of SearchIssue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSearchIssue build() {
      return new ImmutableSearchIssue(
          createdAt,
          updatedAt,
          closedAt,
          id,
          url,
          eventsUrl,
          repositoryUrl,
          labelsUrl,
          commentsUrl,
          htmlUrl,
          number,
          state,
          title,
          body,
          user,
          labels == null ? null : createUnmodifiableList(true, labels),
          assignee,
          milestone,
          locked,
          comments,
          pullRequest,
          score);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
