package com.spotify.github.v3.search;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link SearchIssues}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSearchIssues.builder()}.
 */
@Generated(from = "SearchIssues", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableSearchIssues implements SearchIssues {
  private final @Nullable Integer totalCount;
  private final @Nullable Boolean incompleteResults;
  private final @Nullable List<SearchIssue> items;

  private ImmutableSearchIssues(
      @Nullable Integer totalCount,
      @Nullable Boolean incompleteResults,
      @Nullable List<SearchIssue> items) {
    this.totalCount = totalCount;
    this.incompleteResults = incompleteResults;
    this.items = items;
  }

  /**
   *Total count of search hits 
   */
  @JsonProperty
  @Override
  public @Nullable Integer totalCount() {
    return totalCount;
  }

  /**
   *Are returned results incomplete 
   */
  @JsonProperty
  @Override
  public @Nullable Boolean incompleteResults() {
    return incompleteResults;
  }

  /**
   *Issues search results 
   */
  @JsonProperty
  @Override
  public @Nullable List<SearchIssue> items() {
    return items;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SearchIssues#totalCount() totalCount} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for totalCount (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSearchIssues withTotalCount(@Nullable Integer value) {
    if (Objects.equals(this.totalCount, value)) return this;
    return new ImmutableSearchIssues(value, this.incompleteResults, this.items);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SearchIssues#incompleteResults() incompleteResults} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for incompleteResults (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSearchIssues withIncompleteResults(@Nullable Boolean value) {
    if (Objects.equals(this.incompleteResults, value)) return this;
    return new ImmutableSearchIssues(this.totalCount, value, this.items);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SearchIssues#items() items}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSearchIssues withItems(@Nullable SearchIssue... elements) {
    if (elements == null) {
      return new ImmutableSearchIssues(this.totalCount, this.incompleteResults, null);
    }
    @Nullable List<SearchIssue> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableSearchIssues(this.totalCount, this.incompleteResults, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SearchIssues#items() items}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of items elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSearchIssues withItems(@Nullable Iterable<? extends SearchIssue> elements) {
    if (this.items == elements) return this;
    @Nullable List<SearchIssue> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableSearchIssues(this.totalCount, this.incompleteResults, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSearchIssues} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSearchIssues
        && equalTo((ImmutableSearchIssues) another);
  }

  private boolean equalTo(ImmutableSearchIssues another) {
    return Objects.equals(totalCount, another.totalCount)
        && Objects.equals(incompleteResults, another.incompleteResults)
        && Objects.equals(items, another.items);
  }

  /**
   * Computes a hash code from attributes: {@code totalCount}, {@code incompleteResults}, {@code items}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(totalCount);
    h += (h << 5) + Objects.hashCode(incompleteResults);
    h += (h << 5) + Objects.hashCode(items);
    return h;
  }

  /**
   * Prints the immutable value {@code SearchIssues} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SearchIssues{"
        + "totalCount=" + totalCount
        + ", incompleteResults=" + incompleteResults
        + ", items=" + items
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "SearchIssues", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements SearchIssues {
    @Nullable Integer totalCount;
    @Nullable Boolean incompleteResults;
    @Nullable List<SearchIssue> items = null;
    @JsonProperty
    public void setTotalCount(@Nullable Integer totalCount) {
      this.totalCount = totalCount;
    }
    @JsonProperty
    public void setIncompleteResults(@Nullable Boolean incompleteResults) {
      this.incompleteResults = incompleteResults;
    }
    @JsonProperty
    public void setItems(@Nullable List<SearchIssue> items) {
      this.items = items;
    }
    @Override
    public Integer totalCount() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean incompleteResults() { throw new UnsupportedOperationException(); }
    @Override
    public List<SearchIssue> items() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableSearchIssues fromJson(Json json) {
    ImmutableSearchIssues.Builder builder = ImmutableSearchIssues.builder();
    if (json.totalCount != null) {
      builder.totalCount(json.totalCount);
    }
    if (json.incompleteResults != null) {
      builder.incompleteResults(json.incompleteResults);
    }
    if (json.items != null) {
      builder.addAllItems(json.items);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link SearchIssues} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SearchIssues instance
   */
  public static ImmutableSearchIssues copyOf(SearchIssues instance) {
    if (instance instanceof ImmutableSearchIssues) {
      return (ImmutableSearchIssues) instance;
    }
    return ImmutableSearchIssues.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSearchIssues ImmutableSearchIssues}.
   * <pre>
   * ImmutableSearchIssues.builder()
   *    .totalCount(Integer | null) // nullable {@link SearchIssues#totalCount() totalCount}
   *    .incompleteResults(Boolean | null) // nullable {@link SearchIssues#incompleteResults() incompleteResults}
   *    .items(List&amp;lt;com.spotify.github.v3.search.SearchIssue&amp;gt; | null) // nullable {@link SearchIssues#items() items}
   *    .build();
   * </pre>
   * @return A new ImmutableSearchIssues builder
   */
  public static ImmutableSearchIssues.Builder builder() {
    return new ImmutableSearchIssues.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSearchIssues ImmutableSearchIssues}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "SearchIssues", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable Integer totalCount;
    private @Nullable Boolean incompleteResults;
    private List<SearchIssue> items = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.v3.search.Search} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Search instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.v3.search.SearchIssues} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(SearchIssues instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof Search) {
        Search instance = (Search) object;
        @Nullable Integer totalCountValue = instance.totalCount();
        if (totalCountValue != null) {
          totalCount(totalCountValue);
        }
        @Nullable Boolean incompleteResultsValue = instance.incompleteResults();
        if (incompleteResultsValue != null) {
          incompleteResults(incompleteResultsValue);
        }
      }
      if (object instanceof SearchIssues) {
        SearchIssues instance = (SearchIssues) object;
        @Nullable List<SearchIssue> itemsValue = instance.items();
        if (itemsValue != null) {
          addAllItems(itemsValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link SearchIssues#totalCount() totalCount} attribute.
     * @param totalCount The value for totalCount (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder totalCount(@Nullable Integer totalCount) {
      this.totalCount = totalCount;
      return this;
    }

    /**
     * Initializes the value for the {@link SearchIssues#incompleteResults() incompleteResults} attribute.
     * @param incompleteResults The value for incompleteResults (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder incompleteResults(@Nullable Boolean incompleteResults) {
      this.incompleteResults = incompleteResults;
      return this;
    }

    /**
     * Adds one element to {@link SearchIssues#items() items} list.
     * @param element A items element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addItems(SearchIssue element) {
      if (this.items == null) {
        this.items = new ArrayList<SearchIssue>();
      }
      this.items.add(Objects.requireNonNull(element, "items element"));
      return this;
    }

    /**
     * Adds elements to {@link SearchIssues#items() items} list.
     * @param elements An array of items elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addItems(SearchIssue... elements) {
      if (this.items == null) {
        this.items = new ArrayList<SearchIssue>();
      }
      for (SearchIssue element : elements) {
        this.items.add(Objects.requireNonNull(element, "items element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link SearchIssues#items() items} list.
     * @param elements An iterable of items elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder items(@Nullable Iterable<? extends SearchIssue> elements) {
      if (elements == null) {
        this.items = null;
        return this;
      }
      this.items = new ArrayList<SearchIssue>();
      return addAllItems(elements);
    }

    /**
     * Adds elements to {@link SearchIssues#items() items} list.
     * @param elements An iterable of items elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllItems(Iterable<? extends SearchIssue> elements) {
      Objects.requireNonNull(elements, "items element");
      if (this.items == null) {
        this.items = new ArrayList<SearchIssue>();
      }
      for (SearchIssue element : elements) {
        this.items.add(Objects.requireNonNull(element, "items element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableSearchIssues ImmutableSearchIssues}.
     * @return An immutable instance of SearchIssues
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSearchIssues build() {
      return new ImmutableSearchIssues(totalCount, incompleteResults, items == null ? null : createUnmodifiableList(true, items));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
