/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.activity.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.User;
import com.spotify.github.v3.activity.events.BaseEvent;
import com.spotify.github.v3.activity.events.DeploymentStatusEvent;
import com.spotify.github.v3.activity.events.EventInstallation;
import com.spotify.github.v3.repos.Deployment;
import com.spotify.github.v3.repos.Repository;
import com.spotify.github.v3.repos.Status;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DeploymentStatusEvent", generator="Immutables")
@Immutable
public final class ImmutableDeploymentStatusEvent
implements DeploymentStatusEvent {
    @Nullable
    private final Repository repository;
    @Nullable
    private final User sender;
    @Nullable
    private final EventInstallation eventInstallation;
    @Nullable
    private final Status deploymentStatus;
    @Nullable
    private final Deployment deployment;

    private ImmutableDeploymentStatusEvent(@Nullable Repository repository, @Nullable User sender, @Nullable EventInstallation eventInstallation, @Nullable Status deploymentStatus, @Nullable Deployment deployment) {
        this.repository = repository;
        this.sender = sender;
        this.eventInstallation = eventInstallation;
        this.deploymentStatus = deploymentStatus;
        this.deployment = deployment;
    }

    @Override
    @JsonProperty
    @Nullable
    public Repository repository() {
        return this.repository;
    }

    @Override
    @JsonProperty
    @Nullable
    public User sender() {
        return this.sender;
    }

    @Override
    @JsonProperty(value="installation")
    @Nullable
    public EventInstallation eventInstallation() {
        return this.eventInstallation;
    }

    @Override
    @JsonProperty
    @Nullable
    public Status deploymentStatus() {
        return this.deploymentStatus;
    }

    @Override
    @JsonProperty
    @Nullable
    public Deployment deployment() {
        return this.deployment;
    }

    public final ImmutableDeploymentStatusEvent withRepository(@Nullable Repository value) {
        if (this.repository == value) {
            return this;
        }
        return new ImmutableDeploymentStatusEvent(value, this.sender, this.eventInstallation, this.deploymentStatus, this.deployment);
    }

    public final ImmutableDeploymentStatusEvent withSender(@Nullable User value) {
        if (this.sender == value) {
            return this;
        }
        return new ImmutableDeploymentStatusEvent(this.repository, value, this.eventInstallation, this.deploymentStatus, this.deployment);
    }

    public final ImmutableDeploymentStatusEvent withEventInstallation(@Nullable EventInstallation value) {
        if (this.eventInstallation == value) {
            return this;
        }
        return new ImmutableDeploymentStatusEvent(this.repository, this.sender, value, this.deploymentStatus, this.deployment);
    }

    public final ImmutableDeploymentStatusEvent withDeploymentStatus(@Nullable Status value) {
        if (this.deploymentStatus == value) {
            return this;
        }
        return new ImmutableDeploymentStatusEvent(this.repository, this.sender, this.eventInstallation, value, this.deployment);
    }

    public final ImmutableDeploymentStatusEvent withDeployment(@Nullable Deployment value) {
        if (this.deployment == value) {
            return this;
        }
        return new ImmutableDeploymentStatusEvent(this.repository, this.sender, this.eventInstallation, this.deploymentStatus, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDeploymentStatusEvent && this.equalTo((ImmutableDeploymentStatusEvent)another);
    }

    private boolean equalTo(ImmutableDeploymentStatusEvent another) {
        return Objects.equals(this.repository, another.repository) && Objects.equals(this.sender, another.sender) && Objects.equals(this.eventInstallation, another.eventInstallation) && Objects.equals(this.deploymentStatus, another.deploymentStatus) && Objects.equals(this.deployment, another.deployment);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.repository);
        h += (h << 5) + Objects.hashCode(this.sender);
        h += (h << 5) + Objects.hashCode(this.eventInstallation);
        h += (h << 5) + Objects.hashCode(this.deploymentStatus);
        h += (h << 5) + Objects.hashCode(this.deployment);
        return h;
    }

    public String toString() {
        return "DeploymentStatusEvent{repository=" + this.repository + ", sender=" + this.sender + ", eventInstallation=" + this.eventInstallation + ", deploymentStatus=" + this.deploymentStatus + ", deployment=" + this.deployment + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableDeploymentStatusEvent fromJson(Json json) {
        Builder builder = ImmutableDeploymentStatusEvent.builder();
        if (json.repository != null) {
            builder.repository(json.repository);
        }
        if (json.sender != null) {
            builder.sender(json.sender);
        }
        if (json.eventInstallation != null) {
            builder.eventInstallation(json.eventInstallation);
        }
        if (json.deploymentStatus != null) {
            builder.deploymentStatus(json.deploymentStatus);
        }
        if (json.deployment != null) {
            builder.deployment(json.deployment);
        }
        return builder.build();
    }

    public static ImmutableDeploymentStatusEvent copyOf(DeploymentStatusEvent instance) {
        if (instance instanceof ImmutableDeploymentStatusEvent) {
            return (ImmutableDeploymentStatusEvent)instance;
        }
        return ImmutableDeploymentStatusEvent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DeploymentStatusEvent", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Repository repository;
        @Nullable
        private User sender;
        @Nullable
        private EventInstallation eventInstallation;
        @Nullable
        private Status deploymentStatus;
        @Nullable
        private Deployment deployment;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DeploymentStatusEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(BaseEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            BaseEvent instance;
            if (object instanceof DeploymentStatusEvent) {
                Deployment deploymentValue;
                instance = (DeploymentStatusEvent)object;
                Status deploymentStatusValue = instance.deploymentStatus();
                if (deploymentStatusValue != null) {
                    this.deploymentStatus(deploymentStatusValue);
                }
                if ((deploymentValue = instance.deployment()) != null) {
                    this.deployment(deploymentValue);
                }
            }
            if (object instanceof BaseEvent) {
                EventInstallation eventInstallationValue;
                User senderValue;
                instance = (BaseEvent)object;
                Repository repositoryValue = instance.repository();
                if (repositoryValue != null) {
                    this.repository(repositoryValue);
                }
                if ((senderValue = instance.sender()) != null) {
                    this.sender(senderValue);
                }
                if ((eventInstallationValue = instance.eventInstallation()) != null) {
                    this.eventInstallation(eventInstallationValue);
                }
            }
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder repository(@Nullable Repository repository) {
            this.repository = repository;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder sender(@Nullable User sender) {
            this.sender = sender;
            return this;
        }

        @JsonProperty(value="installation")
        @CanIgnoreReturnValue
        public final Builder eventInstallation(@Nullable EventInstallation eventInstallation) {
            this.eventInstallation = eventInstallation;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder deploymentStatus(@Nullable Status deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder deployment(@Nullable Deployment deployment) {
            this.deployment = deployment;
            return this;
        }

        public ImmutableDeploymentStatusEvent build() {
            return new ImmutableDeploymentStatusEvent(this.repository, this.sender, this.eventInstallation, this.deploymentStatus, this.deployment);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="DeploymentStatusEvent", generator="Immutables")
    static final class Json
    implements DeploymentStatusEvent {
        @Nullable
        Repository repository;
        @Nullable
        User sender;
        @Nullable
        EventInstallation eventInstallation;
        @Nullable
        Status deploymentStatus;
        @Nullable
        Deployment deployment;

        Json() {
        }

        @JsonProperty
        public void setRepository(@Nullable Repository repository) {
            this.repository = repository;
        }

        @JsonProperty
        public void setSender(@Nullable User sender) {
            this.sender = sender;
        }

        @JsonProperty(value="installation")
        public void setEventInstallation(@Nullable EventInstallation eventInstallation) {
            this.eventInstallation = eventInstallation;
        }

        @JsonProperty
        public void setDeploymentStatus(@Nullable Status deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
        }

        @JsonProperty
        public void setDeployment(@Nullable Deployment deployment) {
            this.deployment = deployment;
        }

        @Override
        public Repository repository() {
            throw new UnsupportedOperationException();
        }

        @Override
        public User sender() {
            throw new UnsupportedOperationException();
        }

        @Override
        public EventInstallation eventInstallation() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Status deploymentStatus() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Deployment deployment() {
            throw new UnsupportedOperationException();
        }
    }
}

