/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.activity.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.User;
import com.spotify.github.v3.activity.events.BaseEvent;
import com.spotify.github.v3.activity.events.EventInstallation;
import com.spotify.github.v3.activity.events.PullRequestReviewCommentEvent;
import com.spotify.github.v3.prs.Comment;
import com.spotify.github.v3.prs.PullRequestItem;
import com.spotify.github.v3.repos.Repository;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="PullRequestReviewCommentEvent", generator="Immutables")
@Immutable
public final class ImmutablePullRequestReviewCommentEvent
implements PullRequestReviewCommentEvent {
    @Nullable
    private final Repository repository;
    @Nullable
    private final User sender;
    @Nullable
    private final EventInstallation eventInstallation;
    @Nullable
    private final String action;
    @Nullable
    private final Comment comment;
    @Nullable
    private final PullRequestItem pullRequest;

    private ImmutablePullRequestReviewCommentEvent(@Nullable Repository repository, @Nullable User sender, @Nullable EventInstallation eventInstallation, @Nullable String action, @Nullable Comment comment, @Nullable PullRequestItem pullRequest) {
        this.repository = repository;
        this.sender = sender;
        this.eventInstallation = eventInstallation;
        this.action = action;
        this.comment = comment;
        this.pullRequest = pullRequest;
    }

    @Override
    @JsonProperty
    @Nullable
    public Repository repository() {
        return this.repository;
    }

    @Override
    @JsonProperty
    @Nullable
    public User sender() {
        return this.sender;
    }

    @Override
    @JsonProperty(value="installation")
    @Nullable
    public EventInstallation eventInstallation() {
        return this.eventInstallation;
    }

    @Override
    @JsonProperty
    @Nullable
    public String action() {
        return this.action;
    }

    @Override
    @JsonProperty
    @Nullable
    public Comment comment() {
        return this.comment;
    }

    @Override
    @JsonProperty
    @Nullable
    public PullRequestItem pullRequest() {
        return this.pullRequest;
    }

    public final ImmutablePullRequestReviewCommentEvent withRepository(@Nullable Repository value) {
        if (this.repository == value) {
            return this;
        }
        return new ImmutablePullRequestReviewCommentEvent(value, this.sender, this.eventInstallation, this.action, this.comment, this.pullRequest);
    }

    public final ImmutablePullRequestReviewCommentEvent withSender(@Nullable User value) {
        if (this.sender == value) {
            return this;
        }
        return new ImmutablePullRequestReviewCommentEvent(this.repository, value, this.eventInstallation, this.action, this.comment, this.pullRequest);
    }

    public final ImmutablePullRequestReviewCommentEvent withEventInstallation(@Nullable EventInstallation value) {
        if (this.eventInstallation == value) {
            return this;
        }
        return new ImmutablePullRequestReviewCommentEvent(this.repository, this.sender, value, this.action, this.comment, this.pullRequest);
    }

    public final ImmutablePullRequestReviewCommentEvent withAction(@Nullable String value) {
        if (Objects.equals(this.action, value)) {
            return this;
        }
        return new ImmutablePullRequestReviewCommentEvent(this.repository, this.sender, this.eventInstallation, value, this.comment, this.pullRequest);
    }

    public final ImmutablePullRequestReviewCommentEvent withComment(@Nullable Comment value) {
        if (this.comment == value) {
            return this;
        }
        return new ImmutablePullRequestReviewCommentEvent(this.repository, this.sender, this.eventInstallation, this.action, value, this.pullRequest);
    }

    public final ImmutablePullRequestReviewCommentEvent withPullRequest(@Nullable PullRequestItem value) {
        if (this.pullRequest == value) {
            return this;
        }
        return new ImmutablePullRequestReviewCommentEvent(this.repository, this.sender, this.eventInstallation, this.action, this.comment, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePullRequestReviewCommentEvent && this.equalTo((ImmutablePullRequestReviewCommentEvent)another);
    }

    private boolean equalTo(ImmutablePullRequestReviewCommentEvent another) {
        return Objects.equals(this.repository, another.repository) && Objects.equals(this.sender, another.sender) && Objects.equals(this.eventInstallation, another.eventInstallation) && Objects.equals(this.action, another.action) && Objects.equals(this.comment, another.comment) && Objects.equals(this.pullRequest, another.pullRequest);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.repository);
        h += (h << 5) + Objects.hashCode(this.sender);
        h += (h << 5) + Objects.hashCode(this.eventInstallation);
        h += (h << 5) + Objects.hashCode(this.action);
        h += (h << 5) + Objects.hashCode(this.comment);
        h += (h << 5) + Objects.hashCode(this.pullRequest);
        return h;
    }

    public String toString() {
        return "PullRequestReviewCommentEvent{repository=" + this.repository + ", sender=" + this.sender + ", eventInstallation=" + this.eventInstallation + ", action=" + this.action + ", comment=" + this.comment + ", pullRequest=" + this.pullRequest + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePullRequestReviewCommentEvent fromJson(Json json) {
        Builder builder = ImmutablePullRequestReviewCommentEvent.builder();
        if (json.repository != null) {
            builder.repository(json.repository);
        }
        if (json.sender != null) {
            builder.sender(json.sender);
        }
        if (json.eventInstallation != null) {
            builder.eventInstallation(json.eventInstallation);
        }
        if (json.action != null) {
            builder.action(json.action);
        }
        if (json.comment != null) {
            builder.comment(json.comment);
        }
        if (json.pullRequest != null) {
            builder.pullRequest(json.pullRequest);
        }
        return builder.build();
    }

    public static ImmutablePullRequestReviewCommentEvent copyOf(PullRequestReviewCommentEvent instance) {
        if (instance instanceof ImmutablePullRequestReviewCommentEvent) {
            return (ImmutablePullRequestReviewCommentEvent)instance;
        }
        return ImmutablePullRequestReviewCommentEvent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="PullRequestReviewCommentEvent", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Repository repository;
        @Nullable
        private User sender;
        @Nullable
        private EventInstallation eventInstallation;
        @Nullable
        private String action;
        @Nullable
        private Comment comment;
        @Nullable
        private PullRequestItem pullRequest;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(BaseEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(PullRequestReviewCommentEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            BaseEvent instance;
            if (object instanceof BaseEvent) {
                EventInstallation eventInstallationValue;
                User senderValue;
                instance = (BaseEvent)object;
                Repository repositoryValue = instance.repository();
                if (repositoryValue != null) {
                    this.repository(repositoryValue);
                }
                if ((senderValue = instance.sender()) != null) {
                    this.sender(senderValue);
                }
                if ((eventInstallationValue = instance.eventInstallation()) != null) {
                    this.eventInstallation(eventInstallationValue);
                }
            }
            if (object instanceof PullRequestReviewCommentEvent) {
                PullRequestItem pullRequestValue;
                Comment commentValue;
                instance = (PullRequestReviewCommentEvent)object;
                String actionValue = instance.action();
                if (actionValue != null) {
                    this.action(actionValue);
                }
                if ((commentValue = instance.comment()) != null) {
                    this.comment(commentValue);
                }
                if ((pullRequestValue = instance.pullRequest()) != null) {
                    this.pullRequest(pullRequestValue);
                }
            }
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder repository(@Nullable Repository repository) {
            this.repository = repository;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder sender(@Nullable User sender) {
            this.sender = sender;
            return this;
        }

        @JsonProperty(value="installation")
        @CanIgnoreReturnValue
        public final Builder eventInstallation(@Nullable EventInstallation eventInstallation) {
            this.eventInstallation = eventInstallation;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder action(@Nullable String action) {
            this.action = action;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder comment(@Nullable Comment comment) {
            this.comment = comment;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder pullRequest(@Nullable PullRequestItem pullRequest) {
            this.pullRequest = pullRequest;
            return this;
        }

        public ImmutablePullRequestReviewCommentEvent build() {
            return new ImmutablePullRequestReviewCommentEvent(this.repository, this.sender, this.eventInstallation, this.action, this.comment, this.pullRequest);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="PullRequestReviewCommentEvent", generator="Immutables")
    static final class Json
    implements PullRequestReviewCommentEvent {
        @Nullable
        Repository repository;
        @Nullable
        User sender;
        @Nullable
        EventInstallation eventInstallation;
        @Nullable
        String action;
        @Nullable
        Comment comment;
        @Nullable
        PullRequestItem pullRequest;

        Json() {
        }

        @JsonProperty
        public void setRepository(@Nullable Repository repository) {
            this.repository = repository;
        }

        @JsonProperty
        public void setSender(@Nullable User sender) {
            this.sender = sender;
        }

        @JsonProperty(value="installation")
        public void setEventInstallation(@Nullable EventInstallation eventInstallation) {
            this.eventInstallation = eventInstallation;
        }

        @JsonProperty
        public void setAction(@Nullable String action) {
            this.action = action;
        }

        @JsonProperty
        public void setComment(@Nullable Comment comment) {
            this.comment = comment;
        }

        @JsonProperty
        public void setPullRequest(@Nullable PullRequestItem pullRequest) {
            this.pullRequest = pullRequest;
        }

        @Override
        public Repository repository() {
            throw new UnsupportedOperationException();
        }

        @Override
        public User sender() {
            throw new UnsupportedOperationException();
        }

        @Override
        public EventInstallation eventInstallation() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String action() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Comment comment() {
            throw new UnsupportedOperationException();
        }

        @Override
        public PullRequestItem pullRequest() {
            throw new UnsupportedOperationException();
        }
    }
}

