/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.activity.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.User;
import com.spotify.github.v3.activity.events.BaseEvent;
import com.spotify.github.v3.activity.events.EventInstallation;
import com.spotify.github.v3.activity.events.RepositoryEvent;
import com.spotify.github.v3.repos.Organization;
import com.spotify.github.v3.repos.Repository;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="RepositoryEvent", generator="Immutables")
@Immutable
public final class ImmutableRepositoryEvent
implements RepositoryEvent {
    @Nullable
    private final Repository repository;
    @Nullable
    private final User sender;
    @Nullable
    private final EventInstallation eventInstallation;
    @Nullable
    private final String action;
    @Nullable
    private final Organization organization;

    private ImmutableRepositoryEvent(@Nullable Repository repository, @Nullable User sender, @Nullable EventInstallation eventInstallation, @Nullable String action, @Nullable Organization organization) {
        this.repository = repository;
        this.sender = sender;
        this.eventInstallation = eventInstallation;
        this.action = action;
        this.organization = organization;
    }

    @Override
    @JsonProperty
    @Nullable
    public Repository repository() {
        return this.repository;
    }

    @Override
    @JsonProperty
    @Nullable
    public User sender() {
        return this.sender;
    }

    @Override
    @JsonProperty(value="installation")
    @Nullable
    public EventInstallation eventInstallation() {
        return this.eventInstallation;
    }

    @Override
    @JsonProperty
    @Nullable
    public String action() {
        return this.action;
    }

    @Override
    @JsonProperty
    @Nullable
    public Organization organization() {
        return this.organization;
    }

    public final ImmutableRepositoryEvent withRepository(@Nullable Repository value) {
        if (this.repository == value) {
            return this;
        }
        return new ImmutableRepositoryEvent(value, this.sender, this.eventInstallation, this.action, this.organization);
    }

    public final ImmutableRepositoryEvent withSender(@Nullable User value) {
        if (this.sender == value) {
            return this;
        }
        return new ImmutableRepositoryEvent(this.repository, value, this.eventInstallation, this.action, this.organization);
    }

    public final ImmutableRepositoryEvent withEventInstallation(@Nullable EventInstallation value) {
        if (this.eventInstallation == value) {
            return this;
        }
        return new ImmutableRepositoryEvent(this.repository, this.sender, value, this.action, this.organization);
    }

    public final ImmutableRepositoryEvent withAction(@Nullable String value) {
        if (Objects.equals(this.action, value)) {
            return this;
        }
        return new ImmutableRepositoryEvent(this.repository, this.sender, this.eventInstallation, value, this.organization);
    }

    public final ImmutableRepositoryEvent withOrganization(@Nullable Organization value) {
        if (this.organization == value) {
            return this;
        }
        return new ImmutableRepositoryEvent(this.repository, this.sender, this.eventInstallation, this.action, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRepositoryEvent && this.equalTo((ImmutableRepositoryEvent)another);
    }

    private boolean equalTo(ImmutableRepositoryEvent another) {
        return Objects.equals(this.repository, another.repository) && Objects.equals(this.sender, another.sender) && Objects.equals(this.eventInstallation, another.eventInstallation) && Objects.equals(this.action, another.action) && Objects.equals(this.organization, another.organization);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.repository);
        h += (h << 5) + Objects.hashCode(this.sender);
        h += (h << 5) + Objects.hashCode(this.eventInstallation);
        h += (h << 5) + Objects.hashCode(this.action);
        h += (h << 5) + Objects.hashCode(this.organization);
        return h;
    }

    public String toString() {
        return "RepositoryEvent{repository=" + this.repository + ", sender=" + this.sender + ", eventInstallation=" + this.eventInstallation + ", action=" + this.action + ", organization=" + this.organization + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableRepositoryEvent fromJson(Json json) {
        Builder builder = ImmutableRepositoryEvent.builder();
        if (json.repository != null) {
            builder.repository(json.repository);
        }
        if (json.sender != null) {
            builder.sender(json.sender);
        }
        if (json.eventInstallation != null) {
            builder.eventInstallation(json.eventInstallation);
        }
        if (json.action != null) {
            builder.action(json.action);
        }
        if (json.organization != null) {
            builder.organization(json.organization);
        }
        return builder.build();
    }

    public static ImmutableRepositoryEvent copyOf(RepositoryEvent instance) {
        if (instance instanceof ImmutableRepositoryEvent) {
            return (ImmutableRepositoryEvent)instance;
        }
        return ImmutableRepositoryEvent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="RepositoryEvent", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Repository repository;
        @Nullable
        private User sender;
        @Nullable
        private EventInstallation eventInstallation;
        @Nullable
        private String action;
        @Nullable
        private Organization organization;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(RepositoryEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(BaseEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            BaseEvent instance;
            if (object instanceof RepositoryEvent) {
                Organization organizationValue;
                instance = (RepositoryEvent)object;
                String actionValue = instance.action();
                if (actionValue != null) {
                    this.action(actionValue);
                }
                if ((organizationValue = instance.organization()) != null) {
                    this.organization(organizationValue);
                }
            }
            if (object instanceof BaseEvent) {
                EventInstallation eventInstallationValue;
                User senderValue;
                instance = (BaseEvent)object;
                Repository repositoryValue = instance.repository();
                if (repositoryValue != null) {
                    this.repository(repositoryValue);
                }
                if ((senderValue = instance.sender()) != null) {
                    this.sender(senderValue);
                }
                if ((eventInstallationValue = instance.eventInstallation()) != null) {
                    this.eventInstallation(eventInstallationValue);
                }
            }
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder repository(@Nullable Repository repository) {
            this.repository = repository;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder sender(@Nullable User sender) {
            this.sender = sender;
            return this;
        }

        @JsonProperty(value="installation")
        @CanIgnoreReturnValue
        public final Builder eventInstallation(@Nullable EventInstallation eventInstallation) {
            this.eventInstallation = eventInstallation;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder action(@Nullable String action) {
            this.action = action;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder organization(@Nullable Organization organization) {
            this.organization = organization;
            return this;
        }

        public ImmutableRepositoryEvent build() {
            return new ImmutableRepositoryEvent(this.repository, this.sender, this.eventInstallation, this.action, this.organization);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="RepositoryEvent", generator="Immutables")
    static final class Json
    implements RepositoryEvent {
        @Nullable
        Repository repository;
        @Nullable
        User sender;
        @Nullable
        EventInstallation eventInstallation;
        @Nullable
        String action;
        @Nullable
        Organization organization;

        Json() {
        }

        @JsonProperty
        public void setRepository(@Nullable Repository repository) {
            this.repository = repository;
        }

        @JsonProperty
        public void setSender(@Nullable User sender) {
            this.sender = sender;
        }

        @JsonProperty(value="installation")
        public void setEventInstallation(@Nullable EventInstallation eventInstallation) {
            this.eventInstallation = eventInstallation;
        }

        @JsonProperty
        public void setAction(@Nullable String action) {
            this.action = action;
        }

        @JsonProperty
        public void setOrganization(@Nullable Organization organization) {
            this.organization = organization;
        }

        @Override
        public Repository repository() {
            throw new UnsupportedOperationException();
        }

        @Override
        public User sender() {
            throw new UnsupportedOperationException();
        }

        @Override
        public EventInstallation eventInstallation() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String action() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Organization organization() {
            throw new UnsupportedOperationException();
        }
    }
}

