/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.checks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.checks.CheckRunAction;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CheckRunAction", generator="Immutables")
@Immutable
public final class ImmutableCheckRunAction
implements CheckRunAction {
    private final String label;
    private final String identifier;
    private final String description;

    private ImmutableCheckRunAction(String label, String identifier, String description) {
        this.label = label;
        this.identifier = identifier;
        this.description = description;
    }

    @Override
    @JsonProperty
    public String label() {
        return this.label;
    }

    @Override
    @JsonProperty
    public String identifier() {
        return this.identifier;
    }

    @Override
    @JsonProperty
    public String description() {
        return this.description;
    }

    public final ImmutableCheckRunAction withLabel(String value) {
        String newValue = Objects.requireNonNull(value, "label");
        if (this.label.equals(newValue)) {
            return this;
        }
        return ImmutableCheckRunAction.validate(new ImmutableCheckRunAction(newValue, this.identifier, this.description));
    }

    public final ImmutableCheckRunAction withIdentifier(String value) {
        String newValue = Objects.requireNonNull(value, "identifier");
        if (this.identifier.equals(newValue)) {
            return this;
        }
        return ImmutableCheckRunAction.validate(new ImmutableCheckRunAction(this.label, newValue, this.description));
    }

    public final ImmutableCheckRunAction withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (this.description.equals(newValue)) {
            return this;
        }
        return ImmutableCheckRunAction.validate(new ImmutableCheckRunAction(this.label, this.identifier, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCheckRunAction && this.equalTo((ImmutableCheckRunAction)another);
    }

    private boolean equalTo(ImmutableCheckRunAction another) {
        return this.label.equals(another.label) && this.identifier.equals(another.identifier) && this.description.equals(another.description);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.label.hashCode();
        h += (h << 5) + this.identifier.hashCode();
        h += (h << 5) + this.description.hashCode();
        return h;
    }

    public String toString() {
        return "CheckRunAction{label=" + this.label + ", identifier=" + this.identifier + ", description=" + this.description + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableCheckRunAction fromJson(Json json) {
        Builder builder = ImmutableCheckRunAction.builder();
        if (json.label != null) {
            builder.label(json.label);
        }
        if (json.identifier != null) {
            builder.identifier(json.identifier);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        return builder.build();
    }

    private static ImmutableCheckRunAction validate(ImmutableCheckRunAction instance) {
        instance.check();
        return instance;
    }

    public static ImmutableCheckRunAction copyOf(CheckRunAction instance) {
        if (instance instanceof ImmutableCheckRunAction) {
            return (ImmutableCheckRunAction)instance;
        }
        return ImmutableCheckRunAction.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CheckRunAction", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_LABEL = 1L;
        private static final long INIT_BIT_IDENTIFIER = 2L;
        private static final long INIT_BIT_DESCRIPTION = 4L;
        private long initBits = 7L;
        @Nullable
        private String label;
        @Nullable
        private String identifier;
        @Nullable
        private String description;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CheckRunAction instance) {
            Objects.requireNonNull(instance, "instance");
            this.label(instance.label());
            this.identifier(instance.identifier());
            this.description(instance.description());
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder label(String label) {
            this.label = Objects.requireNonNull(label, "label");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder identifier(String identifier) {
            this.identifier = Objects.requireNonNull(identifier, "identifier");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableCheckRunAction build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableCheckRunAction.validate(new ImmutableCheckRunAction(this.label, this.identifier, this.description));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("label");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("identifier");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("description");
            }
            return "Cannot build CheckRunAction, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="CheckRunAction", generator="Immutables")
    static final class Json
    implements CheckRunAction {
        @Nullable
        String label;
        @Nullable
        String identifier;
        @Nullable
        String description;

        Json() {
        }

        @JsonProperty
        public void setLabel(String label) {
            this.label = label;
        }

        @JsonProperty
        public void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @JsonProperty
        public void setDescription(String description) {
            this.description = description;
        }

        @Override
        public String label() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String identifier() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String description() {
            throw new UnsupportedOperationException();
        }
    }
}

