/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.clients;

import com.spotify.github.async.AsyncPage;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class GithubPageIterator<T>
implements Iterator<AsyncPage<T>> {
    private final Object lock = new Object();
    private AsyncPage<T> current;

    public GithubPageIterator(AsyncPage<T> initialPage) {
        this.current = initialPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasNext() {
        Object object = this.lock;
        synchronized (object) {
            return Objects.nonNull(this.current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AsyncPage<T> next() {
        Object object = this.lock;
        synchronized (object) {
            if (Objects.isNull(this.current)) {
                throw new NoSuchElementException("Iteration exhausted");
            }
            AsyncPage<T> currentPage = this.current.clone();
            this.current = (AsyncPage)((CompletableFuture)this.current.hasNextPage().thenCompose(hasNext -> Optional.of(hasNext).filter(Boolean::booleanValue).map(ignore -> this.current.nextPage()).orElseGet(() -> CompletableFuture.completedFuture(null)))).join();
            return currentPage;
        }
    }
}

