/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.git;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.git.StatItem;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="StatItem", generator="Immutables")
@Immutable
public final class ImmutableStatItem
implements StatItem {
    @Nullable
    private final Integer total;
    @Nullable
    private final Integer additions;
    @Nullable
    private final Integer deletions;

    private ImmutableStatItem(@Nullable Integer total, @Nullable Integer additions, @Nullable Integer deletions) {
        this.total = total;
        this.additions = additions;
        this.deletions = deletions;
    }

    @Override
    @JsonProperty
    @Nullable
    public Integer total() {
        return this.total;
    }

    @Override
    @JsonProperty
    @Nullable
    public Integer additions() {
        return this.additions;
    }

    @Override
    @JsonProperty
    @Nullable
    public Integer deletions() {
        return this.deletions;
    }

    public final ImmutableStatItem withTotal(@Nullable Integer value) {
        if (Objects.equals(this.total, value)) {
            return this;
        }
        return new ImmutableStatItem(value, this.additions, this.deletions);
    }

    public final ImmutableStatItem withAdditions(@Nullable Integer value) {
        if (Objects.equals(this.additions, value)) {
            return this;
        }
        return new ImmutableStatItem(this.total, value, this.deletions);
    }

    public final ImmutableStatItem withDeletions(@Nullable Integer value) {
        if (Objects.equals(this.deletions, value)) {
            return this;
        }
        return new ImmutableStatItem(this.total, this.additions, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStatItem && this.equalTo((ImmutableStatItem)another);
    }

    private boolean equalTo(ImmutableStatItem another) {
        return Objects.equals(this.total, another.total) && Objects.equals(this.additions, another.additions) && Objects.equals(this.deletions, another.deletions);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.total);
        h += (h << 5) + Objects.hashCode(this.additions);
        h += (h << 5) + Objects.hashCode(this.deletions);
        return h;
    }

    public String toString() {
        return "StatItem{total=" + this.total + ", additions=" + this.additions + ", deletions=" + this.deletions + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableStatItem fromJson(Json json) {
        Builder builder = ImmutableStatItem.builder();
        if (json.total != null) {
            builder.total(json.total);
        }
        if (json.additions != null) {
            builder.additions(json.additions);
        }
        if (json.deletions != null) {
            builder.deletions(json.deletions);
        }
        return builder.build();
    }

    public static ImmutableStatItem copyOf(StatItem instance) {
        if (instance instanceof ImmutableStatItem) {
            return (ImmutableStatItem)instance;
        }
        return ImmutableStatItem.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="StatItem", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Integer total;
        @Nullable
        private Integer additions;
        @Nullable
        private Integer deletions;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(StatItem instance) {
            Integer deletionsValue;
            Integer additionsValue;
            Objects.requireNonNull(instance, "instance");
            Integer totalValue = instance.total();
            if (totalValue != null) {
                this.total(totalValue);
            }
            if ((additionsValue = instance.additions()) != null) {
                this.additions(additionsValue);
            }
            if ((deletionsValue = instance.deletions()) != null) {
                this.deletions(deletionsValue);
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder total(@Nullable Integer total) {
            this.total = total;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder additions(@Nullable Integer additions) {
            this.additions = additions;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder deletions(@Nullable Integer deletions) {
            this.deletions = deletions;
            return this;
        }

        public ImmutableStatItem build() {
            return new ImmutableStatItem(this.total, this.additions, this.deletions);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="StatItem", generator="Immutables")
    static final class Json
    implements StatItem {
        @Nullable
        Integer total;
        @Nullable
        Integer additions;
        @Nullable
        Integer deletions;

        Json() {
        }

        @JsonProperty
        public void setTotal(@Nullable Integer total) {
            this.total = total;
        }

        @JsonProperty
        public void setAdditions(@Nullable Integer additions) {
            this.additions = additions;
        }

        @JsonProperty
        public void setDeletions(@Nullable Integer deletions) {
            this.deletions = deletions;
        }

        @Override
        public Integer total() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer additions() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer deletions() {
            throw new UnsupportedOperationException();
        }
    }
}

