/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.git;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.git.Verification;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Verification", generator="Immutables")
@Immutable
public final class ImmutableVerification
implements Verification {
    @Nullable
    private final Boolean verified;
    @Nullable
    private final String reason;
    @Nullable
    private final String signature;
    @Nullable
    private final String payload;

    private ImmutableVerification(@Nullable Boolean verified, @Nullable String reason, @Nullable String signature, @Nullable String payload) {
        this.verified = verified;
        this.reason = reason;
        this.signature = signature;
        this.payload = payload;
    }

    @Override
    @JsonProperty
    @Nullable
    public Boolean verified() {
        return this.verified;
    }

    @Override
    @JsonProperty
    @Nullable
    public String reason() {
        return this.reason;
    }

    @Override
    @JsonProperty
    @Nullable
    public String signature() {
        return this.signature;
    }

    @Override
    @JsonProperty
    @Nullable
    public String payload() {
        return this.payload;
    }

    public final ImmutableVerification withVerified(@Nullable Boolean value) {
        if (Objects.equals(this.verified, value)) {
            return this;
        }
        return new ImmutableVerification(value, this.reason, this.signature, this.payload);
    }

    public final ImmutableVerification withReason(@Nullable String value) {
        if (Objects.equals(this.reason, value)) {
            return this;
        }
        return new ImmutableVerification(this.verified, value, this.signature, this.payload);
    }

    public final ImmutableVerification withSignature(@Nullable String value) {
        if (Objects.equals(this.signature, value)) {
            return this;
        }
        return new ImmutableVerification(this.verified, this.reason, value, this.payload);
    }

    public final ImmutableVerification withPayload(@Nullable String value) {
        if (Objects.equals(this.payload, value)) {
            return this;
        }
        return new ImmutableVerification(this.verified, this.reason, this.signature, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableVerification && this.equalTo((ImmutableVerification)another);
    }

    private boolean equalTo(ImmutableVerification another) {
        return Objects.equals(this.verified, another.verified) && Objects.equals(this.reason, another.reason) && Objects.equals(this.signature, another.signature) && Objects.equals(this.payload, another.payload);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.verified);
        h += (h << 5) + Objects.hashCode(this.reason);
        h += (h << 5) + Objects.hashCode(this.signature);
        h += (h << 5) + Objects.hashCode(this.payload);
        return h;
    }

    public String toString() {
        return "Verification{verified=" + this.verified + ", reason=" + this.reason + ", signature=" + this.signature + ", payload=" + this.payload + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableVerification fromJson(Json json) {
        Builder builder = ImmutableVerification.builder();
        if (json.verified != null) {
            builder.verified(json.verified);
        }
        if (json.reason != null) {
            builder.reason(json.reason);
        }
        if (json.signature != null) {
            builder.signature(json.signature);
        }
        if (json.payload != null) {
            builder.payload(json.payload);
        }
        return builder.build();
    }

    public static ImmutableVerification copyOf(Verification instance) {
        if (instance instanceof ImmutableVerification) {
            return (ImmutableVerification)instance;
        }
        return ImmutableVerification.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Verification", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Boolean verified;
        @Nullable
        private String reason;
        @Nullable
        private String signature;
        @Nullable
        private String payload;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Verification instance) {
            String payloadValue;
            String signatureValue;
            String reasonValue;
            Objects.requireNonNull(instance, "instance");
            Boolean verifiedValue = instance.verified();
            if (verifiedValue != null) {
                this.verified(verifiedValue);
            }
            if ((reasonValue = instance.reason()) != null) {
                this.reason(reasonValue);
            }
            if ((signatureValue = instance.signature()) != null) {
                this.signature(signatureValue);
            }
            if ((payloadValue = instance.payload()) != null) {
                this.payload(payloadValue);
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder verified(@Nullable Boolean verified) {
            this.verified = verified;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder reason(@Nullable String reason) {
            this.reason = reason;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder signature(@Nullable String signature) {
            this.signature = signature;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder payload(@Nullable String payload) {
            this.payload = payload;
            return this;
        }

        public ImmutableVerification build() {
            return new ImmutableVerification(this.verified, this.reason, this.signature, this.payload);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Verification", generator="Immutables")
    static final class Json
    implements Verification {
        @Nullable
        Boolean verified;
        @Nullable
        String reason;
        @Nullable
        String signature;
        @Nullable
        String payload;

        Json() {
        }

        @JsonProperty
        public void setVerified(@Nullable Boolean verified) {
            this.verified = verified;
        }

        @JsonProperty
        public void setReason(@Nullable String reason) {
            this.reason = reason;
        }

        @JsonProperty
        public void setSignature(@Nullable String signature) {
            this.signature = signature;
        }

        @JsonProperty
        public void setPayload(@Nullable String payload) {
            this.payload = payload;
        }

        @Override
        public Boolean verified() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String reason() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String signature() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String payload() {
            throw new UnsupportedOperationException();
        }
    }
}

