/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.issues;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.GitHubInstant;
import com.spotify.github.v3.User;
import com.spotify.github.v3.issues.Event;
import com.spotify.github.v3.issues.Issue;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Event", generator="Immutables")
@Immutable
public final class ImmutableEvent
implements Event {
    @Nullable
    private final Integer id;
    @Nullable
    private final URI url;
    @Nullable
    private final User actor;
    @Nullable
    private final String event;
    @Nullable
    private final String commitId;
    @Nullable
    private final URI commitUrl;
    @Nullable
    private final GitHubInstant createdAt;
    @Nullable
    private final Issue issue;

    private ImmutableEvent(@Nullable Integer id, @Nullable URI url, @Nullable User actor, @Nullable String event, @Nullable String commitId, @Nullable URI commitUrl, @Nullable GitHubInstant createdAt, @Nullable Issue issue) {
        this.id = id;
        this.url = url;
        this.actor = actor;
        this.event = event;
        this.commitId = commitId;
        this.commitUrl = commitUrl;
        this.createdAt = createdAt;
        this.issue = issue;
    }

    @Override
    @JsonProperty
    @Nullable
    public Integer id() {
        return this.id;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI url() {
        return this.url;
    }

    @Override
    @JsonProperty
    @Nullable
    public User actor() {
        return this.actor;
    }

    @Override
    @JsonProperty
    @Nullable
    public String event() {
        return this.event;
    }

    @Override
    @JsonProperty
    @Nullable
    public String commitId() {
        return this.commitId;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI commitUrl() {
        return this.commitUrl;
    }

    @Override
    @JsonProperty
    @Nullable
    public GitHubInstant createdAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty
    public Optional<Issue> issue() {
        return Optional.ofNullable(this.issue);
    }

    public final ImmutableEvent withId(@Nullable Integer value) {
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return new ImmutableEvent(value, this.url, this.actor, this.event, this.commitId, this.commitUrl, this.createdAt, this.issue);
    }

    public final ImmutableEvent withUrl(@Nullable URI value) {
        if (this.url == value) {
            return this;
        }
        return new ImmutableEvent(this.id, value, this.actor, this.event, this.commitId, this.commitUrl, this.createdAt, this.issue);
    }

    public final ImmutableEvent withActor(@Nullable User value) {
        if (this.actor == value) {
            return this;
        }
        return new ImmutableEvent(this.id, this.url, value, this.event, this.commitId, this.commitUrl, this.createdAt, this.issue);
    }

    public final ImmutableEvent withEvent(@Nullable String value) {
        if (Objects.equals(this.event, value)) {
            return this;
        }
        return new ImmutableEvent(this.id, this.url, this.actor, value, this.commitId, this.commitUrl, this.createdAt, this.issue);
    }

    public final ImmutableEvent withCommitId(@Nullable String value) {
        if (Objects.equals(this.commitId, value)) {
            return this;
        }
        return new ImmutableEvent(this.id, this.url, this.actor, this.event, value, this.commitUrl, this.createdAt, this.issue);
    }

    public final ImmutableEvent withCommitUrl(@Nullable URI value) {
        if (this.commitUrl == value) {
            return this;
        }
        return new ImmutableEvent(this.id, this.url, this.actor, this.event, this.commitId, value, this.createdAt, this.issue);
    }

    public final ImmutableEvent withCreatedAt(@Nullable GitHubInstant value) {
        if (this.createdAt == value) {
            return this;
        }
        return new ImmutableEvent(this.id, this.url, this.actor, this.event, this.commitId, this.commitUrl, value, this.issue);
    }

    public final ImmutableEvent withIssue(Issue value) {
        Issue newValue = Objects.requireNonNull(value, "issue");
        if (this.issue == newValue) {
            return this;
        }
        return new ImmutableEvent(this.id, this.url, this.actor, this.event, this.commitId, this.commitUrl, this.createdAt, newValue);
    }

    public final ImmutableEvent withIssue(Optional<? extends Issue> optional) {
        Issue value = optional.orElse(null);
        if (this.issue == value) {
            return this;
        }
        return new ImmutableEvent(this.id, this.url, this.actor, this.event, this.commitId, this.commitUrl, this.createdAt, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEvent && this.equalTo((ImmutableEvent)another);
    }

    private boolean equalTo(ImmutableEvent another) {
        return Objects.equals(this.id, another.id) && Objects.equals(this.url, another.url) && Objects.equals(this.actor, another.actor) && Objects.equals(this.event, another.event) && Objects.equals(this.commitId, another.commitId) && Objects.equals(this.commitUrl, another.commitUrl) && Objects.equals(this.createdAt, another.createdAt) && Objects.equals(this.issue, another.issue);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + Objects.hashCode(this.url);
        h += (h << 5) + Objects.hashCode(this.actor);
        h += (h << 5) + Objects.hashCode(this.event);
        h += (h << 5) + Objects.hashCode(this.commitId);
        h += (h << 5) + Objects.hashCode(this.commitUrl);
        h += (h << 5) + Objects.hashCode(this.createdAt);
        h += (h << 5) + Objects.hashCode(this.issue);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Event{");
        if (this.id != null) {
            builder.append("id=").append(this.id);
        }
        if (this.url != null) {
            if (builder.length() > 6) {
                builder.append(", ");
            }
            builder.append("url=").append(this.url);
        }
        if (this.actor != null) {
            if (builder.length() > 6) {
                builder.append(", ");
            }
            builder.append("actor=").append(this.actor);
        }
        if (this.event != null) {
            if (builder.length() > 6) {
                builder.append(", ");
            }
            builder.append("event=").append(this.event);
        }
        if (this.commitId != null) {
            if (builder.length() > 6) {
                builder.append(", ");
            }
            builder.append("commitId=").append(this.commitId);
        }
        if (this.commitUrl != null) {
            if (builder.length() > 6) {
                builder.append(", ");
            }
            builder.append("commitUrl=").append(this.commitUrl);
        }
        if (this.createdAt != null) {
            if (builder.length() > 6) {
                builder.append(", ");
            }
            builder.append("createdAt=").append(this.createdAt);
        }
        if (this.issue != null) {
            if (builder.length() > 6) {
                builder.append(", ");
            }
            builder.append("issue=").append(this.issue);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableEvent fromJson(Json json) {
        Builder builder = ImmutableEvent.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.url != null) {
            builder.url(json.url);
        }
        if (json.actor != null) {
            builder.actor(json.actor);
        }
        if (json.event != null) {
            builder.event(json.event);
        }
        if (json.commitId != null) {
            builder.commitId(json.commitId);
        }
        if (json.commitUrl != null) {
            builder.commitUrl(json.commitUrl);
        }
        if (json.createdAt != null) {
            builder.createdAt(json.createdAt);
        }
        if (json.issue != null) {
            builder.issue(json.issue);
        }
        return builder.build();
    }

    public static ImmutableEvent copyOf(Event instance) {
        if (instance instanceof ImmutableEvent) {
            return (ImmutableEvent)instance;
        }
        return ImmutableEvent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Event", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Integer id;
        @Nullable
        private URI url;
        @Nullable
        private User actor;
        @Nullable
        private String event;
        @Nullable
        private String commitId;
        @Nullable
        private URI commitUrl;
        @Nullable
        private GitHubInstant createdAt;
        @Nullable
        private Issue issue;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Event instance) {
            Optional<Issue> issueOptional;
            GitHubInstant createdAtValue;
            URI commitUrlValue;
            String commitIdValue;
            String eventValue;
            User actorValue;
            URI urlValue;
            Objects.requireNonNull(instance, "instance");
            Integer idValue = instance.id();
            if (idValue != null) {
                this.id(idValue);
            }
            if ((urlValue = instance.url()) != null) {
                this.url(urlValue);
            }
            if ((actorValue = instance.actor()) != null) {
                this.actor(actorValue);
            }
            if ((eventValue = instance.event()) != null) {
                this.event(eventValue);
            }
            if ((commitIdValue = instance.commitId()) != null) {
                this.commitId(commitIdValue);
            }
            if ((commitUrlValue = instance.commitUrl()) != null) {
                this.commitUrl(commitUrlValue);
            }
            if ((createdAtValue = instance.createdAt()) != null) {
                this.createdAt(createdAtValue);
            }
            if ((issueOptional = instance.issue()).isPresent()) {
                this.issue(issueOptional);
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder id(@Nullable Integer id) {
            this.id = id;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder url(@Nullable URI url) {
            this.url = url;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder actor(@Nullable User actor) {
            this.actor = actor;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder event(@Nullable String event) {
            this.event = event;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder commitId(@Nullable String commitId) {
            this.commitId = commitId;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder commitUrl(@Nullable URI commitUrl) {
            this.commitUrl = commitUrl;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder createdAt(@Nullable GitHubInstant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder issue(Issue issue) {
            this.issue = Objects.requireNonNull(issue, "issue");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder issue(Optional<? extends Issue> issue) {
            this.issue = issue.orElse(null);
            return this;
        }

        public ImmutableEvent build() {
            return new ImmutableEvent(this.id, this.url, this.actor, this.event, this.commitId, this.commitUrl, this.createdAt, this.issue);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Event", generator="Immutables")
    static final class Json
    implements Event {
        @Nullable
        Integer id;
        @Nullable
        URI url;
        @Nullable
        User actor;
        @Nullable
        String event;
        @Nullable
        String commitId;
        @Nullable
        URI commitUrl;
        @Nullable
        GitHubInstant createdAt;
        @Nullable
        Optional<Issue> issue = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setId(@Nullable Integer id) {
            this.id = id;
        }

        @JsonProperty
        public void setUrl(@Nullable URI url) {
            this.url = url;
        }

        @JsonProperty
        public void setActor(@Nullable User actor) {
            this.actor = actor;
        }

        @JsonProperty
        public void setEvent(@Nullable String event) {
            this.event = event;
        }

        @JsonProperty
        public void setCommitId(@Nullable String commitId) {
            this.commitId = commitId;
        }

        @JsonProperty
        public void setCommitUrl(@Nullable URI commitUrl) {
            this.commitUrl = commitUrl;
        }

        @JsonProperty
        public void setCreatedAt(@Nullable GitHubInstant createdAt) {
            this.createdAt = createdAt;
        }

        @JsonProperty
        public void setIssue(Optional<Issue> issue) {
            this.issue = issue;
        }

        @Override
        public Integer id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI url() {
            throw new UnsupportedOperationException();
        }

        @Override
        public User actor() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String event() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String commitId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI commitUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public GitHubInstant createdAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Issue> issue() {
            throw new UnsupportedOperationException();
        }
    }
}

