/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.prs;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.GitHubInstant;
import com.spotify.github.UpdateTracking;
import com.spotify.github.v3.User;
import com.spotify.github.v3.prs.Comment;
import com.spotify.github.v3.prs.CommentLinks;
import java.net.URI;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Comment", generator="Immutables")
@Immutable
public final class ImmutableComment
implements Comment {
    @Nullable
    private final GitHubInstant createdAt;
    @Nullable
    private final GitHubInstant updatedAt;
    @Nullable
    private final URI url;
    @Nullable
    private final Long id;
    @Nullable
    private final String diffHunk;
    @Nullable
    private final String path;
    @Nullable
    private final Integer position;
    @Nullable
    private final Integer originalPosition;
    @Nullable
    private final String commitId;
    @Nullable
    private final String originalCommitId;
    @Nullable
    private final User user;
    @Nullable
    private final String body;
    @Nullable
    private final URI htmlUrl;
    @Nullable
    private final URI pullRequestUrl;
    @Nullable
    private final CommentLinks links;

    private ImmutableComment(@Nullable GitHubInstant createdAt, @Nullable GitHubInstant updatedAt, @Nullable URI url, @Nullable Long id, @Nullable String diffHunk, @Nullable String path, @Nullable Integer position, @Nullable Integer originalPosition, @Nullable String commitId, @Nullable String originalCommitId, @Nullable User user, @Nullable String body, @Nullable URI htmlUrl, @Nullable URI pullRequestUrl, @Nullable CommentLinks links) {
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.url = url;
        this.id = id;
        this.diffHunk = diffHunk;
        this.path = path;
        this.position = position;
        this.originalPosition = originalPosition;
        this.commitId = commitId;
        this.originalCommitId = originalCommitId;
        this.user = user;
        this.body = body;
        this.htmlUrl = htmlUrl;
        this.pullRequestUrl = pullRequestUrl;
        this.links = links;
    }

    @Override
    @JsonProperty
    @Nullable
    public GitHubInstant createdAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty
    @Nullable
    public GitHubInstant updatedAt() {
        return this.updatedAt;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI url() {
        return this.url;
    }

    @Override
    @JsonProperty
    @Nullable
    public Long id() {
        return this.id;
    }

    @Override
    @JsonProperty
    @Nullable
    public String diffHunk() {
        return this.diffHunk;
    }

    @Override
    @JsonProperty
    @Nullable
    public String path() {
        return this.path;
    }

    @Override
    @JsonProperty
    @Nullable
    public Integer position() {
        return this.position;
    }

    @Override
    @JsonProperty
    @Nullable
    public Integer originalPosition() {
        return this.originalPosition;
    }

    @Override
    @JsonProperty
    @Nullable
    public String commitId() {
        return this.commitId;
    }

    @Override
    @JsonProperty
    @Nullable
    public String originalCommitId() {
        return this.originalCommitId;
    }

    @Override
    @JsonProperty
    @Nullable
    public User user() {
        return this.user;
    }

    @Override
    @JsonProperty
    @Nullable
    public String body() {
        return this.body;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI htmlUrl() {
        return this.htmlUrl;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI pullRequestUrl() {
        return this.pullRequestUrl;
    }

    @Override
    @JsonProperty(value="_links")
    @Nullable
    public CommentLinks links() {
        return this.links;
    }

    public final ImmutableComment withCreatedAt(@Nullable GitHubInstant value) {
        if (this.createdAt == value) {
            return this;
        }
        return new ImmutableComment(value, this.updatedAt, this.url, this.id, this.diffHunk, this.path, this.position, this.originalPosition, this.commitId, this.originalCommitId, this.user, this.body, this.htmlUrl, this.pullRequestUrl, this.links);
    }

    public final ImmutableComment withUpdatedAt(@Nullable GitHubInstant value) {
        if (this.updatedAt == value) {
            return this;
        }
        return new ImmutableComment(this.createdAt, value, this.url, this.id, this.diffHunk, this.path, this.position, this.originalPosition, this.commitId, this.originalCommitId, this.user, this.body, this.htmlUrl, this.pullRequestUrl, this.links);
    }

    public final ImmutableComment withUrl(@Nullable URI value) {
        if (this.url == value) {
            return this;
        }
        return new ImmutableComment(this.createdAt, this.updatedAt, value, this.id, this.diffHunk, this.path, this.position, this.originalPosition, this.commitId, this.originalCommitId, this.user, this.body, this.htmlUrl, this.pullRequestUrl, this.links);
    }

    public final ImmutableComment withId(@Nullable Long value) {
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return new ImmutableComment(this.createdAt, this.updatedAt, this.url, value, this.diffHunk, this.path, this.position, this.originalPosition, this.commitId, this.originalCommitId, this.user, this.body, this.htmlUrl, this.pullRequestUrl, this.links);
    }

    public final ImmutableComment withDiffHunk(@Nullable String value) {
        if (Objects.equals(this.diffHunk, value)) {
            return this;
        }
        return new ImmutableComment(this.createdAt, this.updatedAt, this.url, this.id, value, this.path, this.position, this.originalPosition, this.commitId, this.originalCommitId, this.user, this.body, this.htmlUrl, this.pullRequestUrl, this.links);
    }

    public final ImmutableComment withPath(@Nullable String value) {
        if (Objects.equals(this.path, value)) {
            return this;
        }
        return new ImmutableComment(this.createdAt, this.updatedAt, this.url, this.id, this.diffHunk, value, this.position, this.originalPosition, this.commitId, this.originalCommitId, this.user, this.body, this.htmlUrl, this.pullRequestUrl, this.links);
    }

    public final ImmutableComment withPosition(@Nullable Integer value) {
        if (Objects.equals(this.position, value)) {
            return this;
        }
        return new ImmutableComment(this.createdAt, this.updatedAt, this.url, this.id, this.diffHunk, this.path, value, this.originalPosition, this.commitId, this.originalCommitId, this.user, this.body, this.htmlUrl, this.pullRequestUrl, this.links);
    }

    public final ImmutableComment withOriginalPosition(@Nullable Integer value) {
        if (Objects.equals(this.originalPosition, value)) {
            return this;
        }
        return new ImmutableComment(this.createdAt, this.updatedAt, this.url, this.id, this.diffHunk, this.path, this.position, value, this.commitId, this.originalCommitId, this.user, this.body, this.htmlUrl, this.pullRequestUrl, this.links);
    }

    public final ImmutableComment withCommitId(@Nullable String value) {
        if (Objects.equals(this.commitId, value)) {
            return this;
        }
        return new ImmutableComment(this.createdAt, this.updatedAt, this.url, this.id, this.diffHunk, this.path, this.position, this.originalPosition, value, this.originalCommitId, this.user, this.body, this.htmlUrl, this.pullRequestUrl, this.links);
    }

    public final ImmutableComment withOriginalCommitId(@Nullable String value) {
        if (Objects.equals(this.originalCommitId, value)) {
            return this;
        }
        return new ImmutableComment(this.createdAt, this.updatedAt, this.url, this.id, this.diffHunk, this.path, this.position, this.originalPosition, this.commitId, value, this.user, this.body, this.htmlUrl, this.pullRequestUrl, this.links);
    }

    public final ImmutableComment withUser(@Nullable User value) {
        if (this.user == value) {
            return this;
        }
        return new ImmutableComment(this.createdAt, this.updatedAt, this.url, this.id, this.diffHunk, this.path, this.position, this.originalPosition, this.commitId, this.originalCommitId, value, this.body, this.htmlUrl, this.pullRequestUrl, this.links);
    }

    public final ImmutableComment withBody(@Nullable String value) {
        if (Objects.equals(this.body, value)) {
            return this;
        }
        return new ImmutableComment(this.createdAt, this.updatedAt, this.url, this.id, this.diffHunk, this.path, this.position, this.originalPosition, this.commitId, this.originalCommitId, this.user, value, this.htmlUrl, this.pullRequestUrl, this.links);
    }

    public final ImmutableComment withHtmlUrl(@Nullable URI value) {
        if (this.htmlUrl == value) {
            return this;
        }
        return new ImmutableComment(this.createdAt, this.updatedAt, this.url, this.id, this.diffHunk, this.path, this.position, this.originalPosition, this.commitId, this.originalCommitId, this.user, this.body, value, this.pullRequestUrl, this.links);
    }

    public final ImmutableComment withPullRequestUrl(@Nullable URI value) {
        if (this.pullRequestUrl == value) {
            return this;
        }
        return new ImmutableComment(this.createdAt, this.updatedAt, this.url, this.id, this.diffHunk, this.path, this.position, this.originalPosition, this.commitId, this.originalCommitId, this.user, this.body, this.htmlUrl, value, this.links);
    }

    public final ImmutableComment withLinks(@Nullable CommentLinks value) {
        if (this.links == value) {
            return this;
        }
        return new ImmutableComment(this.createdAt, this.updatedAt, this.url, this.id, this.diffHunk, this.path, this.position, this.originalPosition, this.commitId, this.originalCommitId, this.user, this.body, this.htmlUrl, this.pullRequestUrl, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableComment && this.equalTo((ImmutableComment)another);
    }

    private boolean equalTo(ImmutableComment another) {
        return Objects.equals(this.createdAt, another.createdAt) && Objects.equals(this.updatedAt, another.updatedAt) && Objects.equals(this.url, another.url) && Objects.equals(this.id, another.id) && Objects.equals(this.diffHunk, another.diffHunk) && Objects.equals(this.path, another.path) && Objects.equals(this.position, another.position) && Objects.equals(this.originalPosition, another.originalPosition) && Objects.equals(this.commitId, another.commitId) && Objects.equals(this.originalCommitId, another.originalCommitId) && Objects.equals(this.user, another.user) && Objects.equals(this.body, another.body) && Objects.equals(this.htmlUrl, another.htmlUrl) && Objects.equals(this.pullRequestUrl, another.pullRequestUrl) && Objects.equals(this.links, another.links);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.createdAt);
        h += (h << 5) + Objects.hashCode(this.updatedAt);
        h += (h << 5) + Objects.hashCode(this.url);
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + Objects.hashCode(this.diffHunk);
        h += (h << 5) + Objects.hashCode(this.path);
        h += (h << 5) + Objects.hashCode(this.position);
        h += (h << 5) + Objects.hashCode(this.originalPosition);
        h += (h << 5) + Objects.hashCode(this.commitId);
        h += (h << 5) + Objects.hashCode(this.originalCommitId);
        h += (h << 5) + Objects.hashCode(this.user);
        h += (h << 5) + Objects.hashCode(this.body);
        h += (h << 5) + Objects.hashCode(this.htmlUrl);
        h += (h << 5) + Objects.hashCode(this.pullRequestUrl);
        h += (h << 5) + Objects.hashCode(this.links);
        return h;
    }

    public String toString() {
        return "Comment{createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", url=" + this.url + ", id=" + this.id + ", diffHunk=" + this.diffHunk + ", path=" + this.path + ", position=" + this.position + ", originalPosition=" + this.originalPosition + ", commitId=" + this.commitId + ", originalCommitId=" + this.originalCommitId + ", user=" + this.user + ", body=" + this.body + ", htmlUrl=" + this.htmlUrl + ", pullRequestUrl=" + this.pullRequestUrl + ", links=" + this.links + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableComment fromJson(Json json) {
        Builder builder = ImmutableComment.builder();
        if (json.createdAt != null) {
            builder.createdAt(json.createdAt);
        }
        if (json.updatedAt != null) {
            builder.updatedAt(json.updatedAt);
        }
        if (json.url != null) {
            builder.url(json.url);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.diffHunk != null) {
            builder.diffHunk(json.diffHunk);
        }
        if (json.path != null) {
            builder.path(json.path);
        }
        if (json.position != null) {
            builder.position(json.position);
        }
        if (json.originalPosition != null) {
            builder.originalPosition(json.originalPosition);
        }
        if (json.commitId != null) {
            builder.commitId(json.commitId);
        }
        if (json.originalCommitId != null) {
            builder.originalCommitId(json.originalCommitId);
        }
        if (json.user != null) {
            builder.user(json.user);
        }
        if (json.body != null) {
            builder.body(json.body);
        }
        if (json.htmlUrl != null) {
            builder.htmlUrl(json.htmlUrl);
        }
        if (json.pullRequestUrl != null) {
            builder.pullRequestUrl(json.pullRequestUrl);
        }
        if (json.links != null) {
            builder.links(json.links);
        }
        return builder.build();
    }

    public static ImmutableComment copyOf(Comment instance) {
        if (instance instanceof ImmutableComment) {
            return (ImmutableComment)instance;
        }
        return ImmutableComment.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Comment", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private GitHubInstant createdAt;
        @Nullable
        private GitHubInstant updatedAt;
        @Nullable
        private URI url;
        @Nullable
        private Long id;
        @Nullable
        private String diffHunk;
        @Nullable
        private String path;
        @Nullable
        private Integer position;
        @Nullable
        private Integer originalPosition;
        @Nullable
        private String commitId;
        @Nullable
        private String originalCommitId;
        @Nullable
        private User user;
        @Nullable
        private String body;
        @Nullable
        private URI htmlUrl;
        @Nullable
        private URI pullRequestUrl;
        @Nullable
        private CommentLinks links;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Comment instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(UpdateTracking instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            UpdateTracking instance;
            if (object instanceof Comment) {
                Integer originalPositionValue;
                User userValue;
                String diffHunkValue;
                Integer positionValue;
                Long idValue;
                CommentLinks linksValue;
                URI pullRequestUrlValue;
                String pathValue;
                String originalCommitIdValue;
                URI urlValue;
                String bodyValue;
                String commitIdValue;
                instance = (Comment)object;
                URI htmlUrlValue = instance.htmlUrl();
                if (htmlUrlValue != null) {
                    this.htmlUrl(htmlUrlValue);
                }
                if ((commitIdValue = instance.commitId()) != null) {
                    this.commitId(commitIdValue);
                }
                if ((bodyValue = instance.body()) != null) {
                    this.body(bodyValue);
                }
                if ((urlValue = instance.url()) != null) {
                    this.url(urlValue);
                }
                if ((originalCommitIdValue = instance.originalCommitId()) != null) {
                    this.originalCommitId(originalCommitIdValue);
                }
                if ((pathValue = instance.path()) != null) {
                    this.path(pathValue);
                }
                if ((pullRequestUrlValue = instance.pullRequestUrl()) != null) {
                    this.pullRequestUrl(pullRequestUrlValue);
                }
                if ((linksValue = instance.links()) != null) {
                    this.links(linksValue);
                }
                if ((idValue = instance.id()) != null) {
                    this.id(idValue);
                }
                if ((positionValue = instance.position()) != null) {
                    this.position(positionValue);
                }
                if ((diffHunkValue = instance.diffHunk()) != null) {
                    this.diffHunk(diffHunkValue);
                }
                if ((userValue = instance.user()) != null) {
                    this.user(userValue);
                }
                if ((originalPositionValue = instance.originalPosition()) != null) {
                    this.originalPosition(originalPositionValue);
                }
            }
            if (object instanceof UpdateTracking) {
                GitHubInstant updatedAtValue;
                instance = (UpdateTracking)object;
                GitHubInstant createdAtValue = instance.createdAt();
                if (createdAtValue != null) {
                    this.createdAt(createdAtValue);
                }
                if ((updatedAtValue = instance.updatedAt()) != null) {
                    this.updatedAt(updatedAtValue);
                }
            }
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder createdAt(@Nullable GitHubInstant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder updatedAt(@Nullable GitHubInstant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder url(@Nullable URI url) {
            this.url = url;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder id(@Nullable Long id) {
            this.id = id;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder diffHunk(@Nullable String diffHunk) {
            this.diffHunk = diffHunk;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder path(@Nullable String path) {
            this.path = path;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder position(@Nullable Integer position) {
            this.position = position;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder originalPosition(@Nullable Integer originalPosition) {
            this.originalPosition = originalPosition;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder commitId(@Nullable String commitId) {
            this.commitId = commitId;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder originalCommitId(@Nullable String originalCommitId) {
            this.originalCommitId = originalCommitId;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder user(@Nullable User user) {
            this.user = user;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder body(@Nullable String body) {
            this.body = body;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder htmlUrl(@Nullable URI htmlUrl) {
            this.htmlUrl = htmlUrl;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder pullRequestUrl(@Nullable URI pullRequestUrl) {
            this.pullRequestUrl = pullRequestUrl;
            return this;
        }

        @JsonProperty(value="_links")
        @CanIgnoreReturnValue
        public final Builder links(@Nullable CommentLinks links) {
            this.links = links;
            return this;
        }

        public ImmutableComment build() {
            return new ImmutableComment(this.createdAt, this.updatedAt, this.url, this.id, this.diffHunk, this.path, this.position, this.originalPosition, this.commitId, this.originalCommitId, this.user, this.body, this.htmlUrl, this.pullRequestUrl, this.links);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Comment", generator="Immutables")
    static final class Json
    implements Comment {
        @Nullable
        GitHubInstant createdAt;
        @Nullable
        GitHubInstant updatedAt;
        @Nullable
        URI url;
        @Nullable
        Long id;
        @Nullable
        String diffHunk;
        @Nullable
        String path;
        @Nullable
        Integer position;
        @Nullable
        Integer originalPosition;
        @Nullable
        String commitId;
        @Nullable
        String originalCommitId;
        @Nullable
        User user;
        @Nullable
        String body;
        @Nullable
        URI htmlUrl;
        @Nullable
        URI pullRequestUrl;
        @Nullable
        CommentLinks links;

        Json() {
        }

        @JsonProperty
        public void setCreatedAt(@Nullable GitHubInstant createdAt) {
            this.createdAt = createdAt;
        }

        @JsonProperty
        public void setUpdatedAt(@Nullable GitHubInstant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @JsonProperty
        public void setUrl(@Nullable URI url) {
            this.url = url;
        }

        @JsonProperty
        public void setId(@Nullable Long id) {
            this.id = id;
        }

        @JsonProperty
        public void setDiffHunk(@Nullable String diffHunk) {
            this.diffHunk = diffHunk;
        }

        @JsonProperty
        public void setPath(@Nullable String path) {
            this.path = path;
        }

        @JsonProperty
        public void setPosition(@Nullable Integer position) {
            this.position = position;
        }

        @JsonProperty
        public void setOriginalPosition(@Nullable Integer originalPosition) {
            this.originalPosition = originalPosition;
        }

        @JsonProperty
        public void setCommitId(@Nullable String commitId) {
            this.commitId = commitId;
        }

        @JsonProperty
        public void setOriginalCommitId(@Nullable String originalCommitId) {
            this.originalCommitId = originalCommitId;
        }

        @JsonProperty
        public void setUser(@Nullable User user) {
            this.user = user;
        }

        @JsonProperty
        public void setBody(@Nullable String body) {
            this.body = body;
        }

        @JsonProperty
        public void setHtmlUrl(@Nullable URI htmlUrl) {
            this.htmlUrl = htmlUrl;
        }

        @JsonProperty
        public void setPullRequestUrl(@Nullable URI pullRequestUrl) {
            this.pullRequestUrl = pullRequestUrl;
        }

        @JsonProperty(value="_links")
        public void setLinks(@Nullable CommentLinks links) {
            this.links = links;
        }

        @Override
        public GitHubInstant createdAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public GitHubInstant updatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI url() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String diffHunk() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String path() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer position() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer originalPosition() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String commitId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String originalCommitId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public User user() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String body() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI htmlUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI pullRequestUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public CommentLinks links() {
            throw new UnsupportedOperationException();
        }
    }
}

