/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.prs;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.GitHubInstant;
import com.spotify.github.v3.User;
import com.spotify.github.v3.activity.events.ReviewLinks;
import com.spotify.github.v3.prs.Review;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Review", generator="Immutables")
@Immutable
public final class ImmutableReview
implements Review {
    @Nullable
    private final Integer id;
    @Nullable
    private final User user;
    @Nullable
    private final Optional<String> body;
    @Nullable
    private final GitHubInstant submittedAt;
    @Nullable
    private final String state;
    @Nullable
    private final URI htmlUrl;
    @Nullable
    private final URI pullRequestUrl;
    @Nullable
    private final ReviewLinks links;
    @Nullable
    private final String commitId;

    private ImmutableReview(@Nullable Integer id, @Nullable User user, @Nullable Optional<String> body, @Nullable GitHubInstant submittedAt, @Nullable String state, @Nullable URI htmlUrl, @Nullable URI pullRequestUrl, @Nullable ReviewLinks links, @Nullable String commitId) {
        this.id = id;
        this.user = user;
        this.body = body;
        this.submittedAt = submittedAt;
        this.state = state;
        this.htmlUrl = htmlUrl;
        this.pullRequestUrl = pullRequestUrl;
        this.links = links;
        this.commitId = commitId;
    }

    @Override
    @JsonProperty
    @Nullable
    public Integer id() {
        return this.id;
    }

    @Override
    @JsonProperty
    @Nullable
    public User user() {
        return this.user;
    }

    @Override
    @JsonProperty
    @Nullable
    public Optional<String> body() {
        return this.body;
    }

    @Override
    @JsonProperty
    public Optional<GitHubInstant> submittedAt() {
        return Optional.ofNullable(this.submittedAt);
    }

    @Override
    @JsonProperty
    @Nullable
    public String state() {
        return this.state;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI htmlUrl() {
        return this.htmlUrl;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI pullRequestUrl() {
        return this.pullRequestUrl;
    }

    @Override
    @JsonProperty(value="_links")
    @Nullable
    public ReviewLinks links() {
        return this.links;
    }

    @Override
    @JsonProperty
    @Nullable
    public String commitId() {
        return this.commitId;
    }

    public final ImmutableReview withId(@Nullable Integer value) {
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return new ImmutableReview(value, this.user, this.body, this.submittedAt, this.state, this.htmlUrl, this.pullRequestUrl, this.links, this.commitId);
    }

    public final ImmutableReview withUser(@Nullable User value) {
        if (this.user == value) {
            return this;
        }
        return new ImmutableReview(this.id, value, this.body, this.submittedAt, this.state, this.htmlUrl, this.pullRequestUrl, this.links, this.commitId);
    }

    public final ImmutableReview withBody(@Nullable Optional<String> value) {
        if (Objects.equals(this.body, value)) {
            return this;
        }
        return new ImmutableReview(this.id, this.user, value, this.submittedAt, this.state, this.htmlUrl, this.pullRequestUrl, this.links, this.commitId);
    }

    public final ImmutableReview withSubmittedAt(GitHubInstant value) {
        GitHubInstant newValue = Objects.requireNonNull(value, "submittedAt");
        if (this.submittedAt == newValue) {
            return this;
        }
        return new ImmutableReview(this.id, this.user, this.body, newValue, this.state, this.htmlUrl, this.pullRequestUrl, this.links, this.commitId);
    }

    public final ImmutableReview withSubmittedAt(Optional<? extends GitHubInstant> optional) {
        GitHubInstant value = optional.orElse(null);
        if (this.submittedAt == value) {
            return this;
        }
        return new ImmutableReview(this.id, this.user, this.body, value, this.state, this.htmlUrl, this.pullRequestUrl, this.links, this.commitId);
    }

    public final ImmutableReview withState(@Nullable String value) {
        if (Objects.equals(this.state, value)) {
            return this;
        }
        return new ImmutableReview(this.id, this.user, this.body, this.submittedAt, value, this.htmlUrl, this.pullRequestUrl, this.links, this.commitId);
    }

    public final ImmutableReview withHtmlUrl(@Nullable URI value) {
        if (this.htmlUrl == value) {
            return this;
        }
        return new ImmutableReview(this.id, this.user, this.body, this.submittedAt, this.state, value, this.pullRequestUrl, this.links, this.commitId);
    }

    public final ImmutableReview withPullRequestUrl(@Nullable URI value) {
        if (this.pullRequestUrl == value) {
            return this;
        }
        return new ImmutableReview(this.id, this.user, this.body, this.submittedAt, this.state, this.htmlUrl, value, this.links, this.commitId);
    }

    public final ImmutableReview withLinks(@Nullable ReviewLinks value) {
        if (this.links == value) {
            return this;
        }
        return new ImmutableReview(this.id, this.user, this.body, this.submittedAt, this.state, this.htmlUrl, this.pullRequestUrl, value, this.commitId);
    }

    public final ImmutableReview withCommitId(@Nullable String value) {
        if (Objects.equals(this.commitId, value)) {
            return this;
        }
        return new ImmutableReview(this.id, this.user, this.body, this.submittedAt, this.state, this.htmlUrl, this.pullRequestUrl, this.links, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableReview && this.equalTo((ImmutableReview)another);
    }

    private boolean equalTo(ImmutableReview another) {
        return Objects.equals(this.id, another.id) && Objects.equals(this.user, another.user) && Objects.equals(this.body, another.body) && Objects.equals(this.submittedAt, another.submittedAt) && Objects.equals(this.state, another.state) && Objects.equals(this.htmlUrl, another.htmlUrl) && Objects.equals(this.pullRequestUrl, another.pullRequestUrl) && Objects.equals(this.links, another.links) && Objects.equals(this.commitId, another.commitId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + Objects.hashCode(this.user);
        h += (h << 5) + Objects.hashCode(this.body);
        h += (h << 5) + Objects.hashCode(this.submittedAt);
        h += (h << 5) + Objects.hashCode(this.state);
        h += (h << 5) + Objects.hashCode(this.htmlUrl);
        h += (h << 5) + Objects.hashCode(this.pullRequestUrl);
        h += (h << 5) + Objects.hashCode(this.links);
        h += (h << 5) + Objects.hashCode(this.commitId);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Review{");
        if (this.id != null) {
            builder.append("id=").append(this.id);
        }
        if (this.user != null) {
            if (builder.length() > 7) {
                builder.append(", ");
            }
            builder.append("user=").append(this.user);
        }
        if (this.body != null) {
            if (builder.length() > 7) {
                builder.append(", ");
            }
            builder.append("body=").append(this.body);
        }
        if (this.submittedAt != null) {
            if (builder.length() > 7) {
                builder.append(", ");
            }
            builder.append("submittedAt=").append(this.submittedAt);
        }
        if (this.state != null) {
            if (builder.length() > 7) {
                builder.append(", ");
            }
            builder.append("state=").append(this.state);
        }
        if (this.htmlUrl != null) {
            if (builder.length() > 7) {
                builder.append(", ");
            }
            builder.append("htmlUrl=").append(this.htmlUrl);
        }
        if (this.pullRequestUrl != null) {
            if (builder.length() > 7) {
                builder.append(", ");
            }
            builder.append("pullRequestUrl=").append(this.pullRequestUrl);
        }
        if (this.links != null) {
            if (builder.length() > 7) {
                builder.append(", ");
            }
            builder.append("links=").append(this.links);
        }
        if (this.commitId != null) {
            if (builder.length() > 7) {
                builder.append(", ");
            }
            builder.append("commitId=").append(this.commitId);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableReview fromJson(Json json) {
        Builder builder = ImmutableReview.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.user != null) {
            builder.user(json.user);
        }
        if (json.body != null) {
            builder.body(json.body);
        }
        if (json.submittedAt != null) {
            builder.submittedAt(json.submittedAt);
        }
        if (json.state != null) {
            builder.state(json.state);
        }
        if (json.htmlUrl != null) {
            builder.htmlUrl(json.htmlUrl);
        }
        if (json.pullRequestUrl != null) {
            builder.pullRequestUrl(json.pullRequestUrl);
        }
        if (json.links != null) {
            builder.links(json.links);
        }
        if (json.commitId != null) {
            builder.commitId(json.commitId);
        }
        return builder.build();
    }

    public static ImmutableReview copyOf(Review instance) {
        if (instance instanceof ImmutableReview) {
            return (ImmutableReview)instance;
        }
        return ImmutableReview.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Review", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Integer id;
        @Nullable
        private User user;
        @Nullable
        private Optional<String> body;
        @Nullable
        private GitHubInstant submittedAt;
        @Nullable
        private String state;
        @Nullable
        private URI htmlUrl;
        @Nullable
        private URI pullRequestUrl;
        @Nullable
        private ReviewLinks links;
        @Nullable
        private String commitId;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Review instance) {
            String commitIdValue;
            ReviewLinks linksValue;
            URI pullRequestUrlValue;
            URI htmlUrlValue;
            String stateValue;
            Optional<GitHubInstant> submittedAtOptional;
            Optional<String> bodyValue;
            User userValue;
            Objects.requireNonNull(instance, "instance");
            Integer idValue = instance.id();
            if (idValue != null) {
                this.id(idValue);
            }
            if ((userValue = instance.user()) != null) {
                this.user(userValue);
            }
            if ((bodyValue = instance.body()) != null) {
                this.body(bodyValue);
            }
            if ((submittedAtOptional = instance.submittedAt()).isPresent()) {
                this.submittedAt(submittedAtOptional);
            }
            if ((stateValue = instance.state()) != null) {
                this.state(stateValue);
            }
            if ((htmlUrlValue = instance.htmlUrl()) != null) {
                this.htmlUrl(htmlUrlValue);
            }
            if ((pullRequestUrlValue = instance.pullRequestUrl()) != null) {
                this.pullRequestUrl(pullRequestUrlValue);
            }
            if ((linksValue = instance.links()) != null) {
                this.links(linksValue);
            }
            if ((commitIdValue = instance.commitId()) != null) {
                this.commitId(commitIdValue);
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder id(@Nullable Integer id) {
            this.id = id;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder user(@Nullable User user) {
            this.user = user;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder body(@Nullable Optional<String> body) {
            this.body = body;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder submittedAt(GitHubInstant submittedAt) {
            this.submittedAt = Objects.requireNonNull(submittedAt, "submittedAt");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder submittedAt(Optional<? extends GitHubInstant> submittedAt) {
            this.submittedAt = submittedAt.orElse(null);
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder state(@Nullable String state) {
            this.state = state;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder htmlUrl(@Nullable URI htmlUrl) {
            this.htmlUrl = htmlUrl;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder pullRequestUrl(@Nullable URI pullRequestUrl) {
            this.pullRequestUrl = pullRequestUrl;
            return this;
        }

        @JsonProperty(value="_links")
        @CanIgnoreReturnValue
        public final Builder links(@Nullable ReviewLinks links) {
            this.links = links;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder commitId(@Nullable String commitId) {
            this.commitId = commitId;
            return this;
        }

        public ImmutableReview build() {
            return new ImmutableReview(this.id, this.user, this.body, this.submittedAt, this.state, this.htmlUrl, this.pullRequestUrl, this.links, this.commitId);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Review", generator="Immutables")
    static final class Json
    implements Review {
        @Nullable
        Integer id;
        @Nullable
        User user;
        @Nullable
        Optional<String> body;
        @Nullable
        Optional<GitHubInstant> submittedAt = Optional.empty();
        @Nullable
        String state;
        @Nullable
        URI htmlUrl;
        @Nullable
        URI pullRequestUrl;
        @Nullable
        ReviewLinks links;
        @Nullable
        String commitId;

        Json() {
        }

        @JsonProperty
        public void setId(@Nullable Integer id) {
            this.id = id;
        }

        @JsonProperty
        public void setUser(@Nullable User user) {
            this.user = user;
        }

        @JsonProperty
        public void setBody(@Nullable Optional<String> body) {
            this.body = body;
        }

        @JsonProperty
        public void setSubmittedAt(Optional<GitHubInstant> submittedAt) {
            this.submittedAt = submittedAt;
        }

        @JsonProperty
        public void setState(@Nullable String state) {
            this.state = state;
        }

        @JsonProperty
        public void setHtmlUrl(@Nullable URI htmlUrl) {
            this.htmlUrl = htmlUrl;
        }

        @JsonProperty
        public void setPullRequestUrl(@Nullable URI pullRequestUrl) {
            this.pullRequestUrl = pullRequestUrl;
        }

        @JsonProperty(value="_links")
        public void setLinks(@Nullable ReviewLinks links) {
            this.links = links;
        }

        @JsonProperty
        public void setCommitId(@Nullable String commitId) {
            this.commitId = commitId;
        }

        @Override
        public Integer id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public User user() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> body() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<GitHubInstant> submittedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String state() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI htmlUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI pullRequestUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReviewLinks links() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String commitId() {
            throw new UnsupportedOperationException();
        }
    }
}

