/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.repos;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.repos.Commit;
import com.spotify.github.v3.repos.CommitComparison;
import com.spotify.github.v3.repos.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CommitComparison", generator="Immutables")
@Immutable
public final class ImmutableCommitComparison
implements CommitComparison {
    @Nullable
    private final Commit baseCommit;
    @Nullable
    private final Commit mergeBaseCommit;
    @Nullable
    private final String status;
    private final int aheadBy;
    private final int behindBy;
    @Nullable
    private final List<Commit> commits;
    @Nullable
    private final List<File> files;

    private ImmutableCommitComparison(@Nullable Commit baseCommit, @Nullable Commit mergeBaseCommit, @Nullable String status, int aheadBy, int behindBy, @Nullable List<Commit> commits, @Nullable List<File> files) {
        this.baseCommit = baseCommit;
        this.mergeBaseCommit = mergeBaseCommit;
        this.status = status;
        this.aheadBy = aheadBy;
        this.behindBy = behindBy;
        this.commits = commits;
        this.files = files;
    }

    @Override
    @JsonProperty
    @Nullable
    public Commit baseCommit() {
        return this.baseCommit;
    }

    @Override
    @JsonProperty
    @Nullable
    public Commit mergeBaseCommit() {
        return this.mergeBaseCommit;
    }

    @Override
    @JsonProperty
    @Nullable
    public String status() {
        return this.status;
    }

    @Override
    @JsonProperty
    public int aheadBy() {
        return this.aheadBy;
    }

    @Override
    @JsonProperty
    public int behindBy() {
        return this.behindBy;
    }

    @Override
    @JsonProperty
    @Nullable
    public List<Commit> commits() {
        return this.commits;
    }

    @Override
    @JsonProperty
    @Nullable
    public List<File> files() {
        return this.files;
    }

    public final ImmutableCommitComparison withBaseCommit(@Nullable Commit value) {
        if (this.baseCommit == value) {
            return this;
        }
        return new ImmutableCommitComparison(value, this.mergeBaseCommit, this.status, this.aheadBy, this.behindBy, this.commits, this.files);
    }

    public final ImmutableCommitComparison withMergeBaseCommit(@Nullable Commit value) {
        if (this.mergeBaseCommit == value) {
            return this;
        }
        return new ImmutableCommitComparison(this.baseCommit, value, this.status, this.aheadBy, this.behindBy, this.commits, this.files);
    }

    public final ImmutableCommitComparison withStatus(@Nullable String value) {
        if (Objects.equals(this.status, value)) {
            return this;
        }
        return new ImmutableCommitComparison(this.baseCommit, this.mergeBaseCommit, value, this.aheadBy, this.behindBy, this.commits, this.files);
    }

    public final ImmutableCommitComparison withAheadBy(int value) {
        if (this.aheadBy == value) {
            return this;
        }
        return new ImmutableCommitComparison(this.baseCommit, this.mergeBaseCommit, this.status, value, this.behindBy, this.commits, this.files);
    }

    public final ImmutableCommitComparison withBehindBy(int value) {
        if (this.behindBy == value) {
            return this;
        }
        return new ImmutableCommitComparison(this.baseCommit, this.mergeBaseCommit, this.status, this.aheadBy, value, this.commits, this.files);
    }

    public final ImmutableCommitComparison withCommits(Commit ... elements) {
        if (elements == null) {
            return new ImmutableCommitComparison(this.baseCommit, this.mergeBaseCommit, this.status, this.aheadBy, this.behindBy, null, this.files);
        }
        List<Commit> newValue = Arrays.asList(elements) == null ? null : ImmutableCommitComparison.createUnmodifiableList(false, ImmutableCommitComparison.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableCommitComparison(this.baseCommit, this.mergeBaseCommit, this.status, this.aheadBy, this.behindBy, newValue, this.files);
    }

    public final ImmutableCommitComparison withCommits(@Nullable Iterable<? extends Commit> elements) {
        if (this.commits == elements) {
            return this;
        }
        List<Commit> newValue = elements == null ? null : ImmutableCommitComparison.createUnmodifiableList(false, ImmutableCommitComparison.createSafeList(elements, true, false));
        return new ImmutableCommitComparison(this.baseCommit, this.mergeBaseCommit, this.status, this.aheadBy, this.behindBy, newValue, this.files);
    }

    public final ImmutableCommitComparison withFiles(File ... elements) {
        if (elements == null) {
            return new ImmutableCommitComparison(this.baseCommit, this.mergeBaseCommit, this.status, this.aheadBy, this.behindBy, this.commits, null);
        }
        List<File> newValue = Arrays.asList(elements) == null ? null : ImmutableCommitComparison.createUnmodifiableList(false, ImmutableCommitComparison.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableCommitComparison(this.baseCommit, this.mergeBaseCommit, this.status, this.aheadBy, this.behindBy, this.commits, newValue);
    }

    public final ImmutableCommitComparison withFiles(@Nullable Iterable<? extends File> elements) {
        if (this.files == elements) {
            return this;
        }
        List<File> newValue = elements == null ? null : ImmutableCommitComparison.createUnmodifiableList(false, ImmutableCommitComparison.createSafeList(elements, true, false));
        return new ImmutableCommitComparison(this.baseCommit, this.mergeBaseCommit, this.status, this.aheadBy, this.behindBy, this.commits, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCommitComparison && this.equalTo((ImmutableCommitComparison)another);
    }

    private boolean equalTo(ImmutableCommitComparison another) {
        return Objects.equals(this.baseCommit, another.baseCommit) && Objects.equals(this.mergeBaseCommit, another.mergeBaseCommit) && Objects.equals(this.status, another.status) && this.aheadBy == another.aheadBy && this.behindBy == another.behindBy && Objects.equals(this.commits, another.commits) && Objects.equals(this.files, another.files);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.baseCommit);
        h += (h << 5) + Objects.hashCode(this.mergeBaseCommit);
        h += (h << 5) + Objects.hashCode(this.status);
        h += (h << 5) + this.aheadBy;
        h += (h << 5) + this.behindBy;
        h += (h << 5) + Objects.hashCode(this.commits);
        h += (h << 5) + Objects.hashCode(this.files);
        return h;
    }

    public String toString() {
        return "CommitComparison{baseCommit=" + this.baseCommit + ", mergeBaseCommit=" + this.mergeBaseCommit + ", status=" + this.status + ", aheadBy=" + this.aheadBy + ", behindBy=" + this.behindBy + ", commits=" + this.commits + ", files=" + this.files + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableCommitComparison fromJson(Json json) {
        Builder builder = ImmutableCommitComparison.builder();
        if (json.baseCommit != null) {
            builder.baseCommit(json.baseCommit);
        }
        if (json.mergeBaseCommit != null) {
            builder.mergeBaseCommit(json.mergeBaseCommit);
        }
        if (json.status != null) {
            builder.status(json.status);
        }
        if (json.aheadByIsSet) {
            builder.aheadBy(json.aheadBy);
        }
        if (json.behindByIsSet) {
            builder.behindBy(json.behindBy);
        }
        if (json.commits != null) {
            builder.addAllCommits(json.commits);
        }
        if (json.files != null) {
            builder.addAllFiles(json.files);
        }
        return builder.build();
    }

    public static ImmutableCommitComparison copyOf(CommitComparison instance) {
        if (instance instanceof ImmutableCommitComparison) {
            return (ImmutableCommitComparison)instance;
        }
        return ImmutableCommitComparison.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="CommitComparison", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_AHEAD_BY = 1L;
        private static final long INIT_BIT_BEHIND_BY = 2L;
        private long initBits = 3L;
        @Nullable
        private Commit baseCommit;
        @Nullable
        private Commit mergeBaseCommit;
        @Nullable
        private String status;
        private int aheadBy;
        private int behindBy;
        private List<Commit> commits = null;
        private List<File> files = null;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CommitComparison instance) {
            List<File> filesValue;
            String statusValue;
            Commit mergeBaseCommitValue;
            Objects.requireNonNull(instance, "instance");
            Commit baseCommitValue = instance.baseCommit();
            if (baseCommitValue != null) {
                this.baseCommit(baseCommitValue);
            }
            if ((mergeBaseCommitValue = instance.mergeBaseCommit()) != null) {
                this.mergeBaseCommit(mergeBaseCommitValue);
            }
            if ((statusValue = instance.status()) != null) {
                this.status(statusValue);
            }
            this.aheadBy(instance.aheadBy());
            this.behindBy(instance.behindBy());
            List<Commit> commitsValue = instance.commits();
            if (commitsValue != null) {
                this.addAllCommits(commitsValue);
            }
            if ((filesValue = instance.files()) != null) {
                this.addAllFiles(filesValue);
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder baseCommit(@Nullable Commit baseCommit) {
            this.baseCommit = baseCommit;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder mergeBaseCommit(@Nullable Commit mergeBaseCommit) {
            this.mergeBaseCommit = mergeBaseCommit;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder status(@Nullable String status) {
            this.status = status;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder aheadBy(int aheadBy) {
            this.aheadBy = aheadBy;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder behindBy(int behindBy) {
            this.behindBy = behindBy;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addCommits(Commit element) {
            if (this.commits == null) {
                this.commits = new ArrayList<Commit>();
            }
            this.commits.add(Objects.requireNonNull(element, "commits element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addCommits(Commit ... elements) {
            if (this.commits == null) {
                this.commits = new ArrayList<Commit>();
            }
            for (Commit element : elements) {
                this.commits.add(Objects.requireNonNull(element, "commits element"));
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder commits(@Nullable Iterable<? extends Commit> elements) {
            if (elements == null) {
                this.commits = null;
                return this;
            }
            this.commits = new ArrayList<Commit>();
            return this.addAllCommits(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllCommits(Iterable<? extends Commit> elements) {
            Objects.requireNonNull(elements, "commits element");
            if (this.commits == null) {
                this.commits = new ArrayList<Commit>();
            }
            for (Commit commit : elements) {
                this.commits.add(Objects.requireNonNull(commit, "commits element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addFiles(File element) {
            if (this.files == null) {
                this.files = new ArrayList<File>();
            }
            this.files.add(Objects.requireNonNull(element, "files element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addFiles(File ... elements) {
            if (this.files == null) {
                this.files = new ArrayList<File>();
            }
            for (File element : elements) {
                this.files.add(Objects.requireNonNull(element, "files element"));
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder files(@Nullable Iterable<? extends File> elements) {
            if (elements == null) {
                this.files = null;
                return this;
            }
            this.files = new ArrayList<File>();
            return this.addAllFiles(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllFiles(Iterable<? extends File> elements) {
            Objects.requireNonNull(elements, "files element");
            if (this.files == null) {
                this.files = new ArrayList<File>();
            }
            for (File file : elements) {
                this.files.add(Objects.requireNonNull(file, "files element"));
            }
            return this;
        }

        public ImmutableCommitComparison build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCommitComparison(this.baseCommit, this.mergeBaseCommit, this.status, this.aheadBy, this.behindBy, this.commits == null ? null : ImmutableCommitComparison.createUnmodifiableList(true, this.commits), this.files == null ? null : ImmutableCommitComparison.createUnmodifiableList(true, this.files));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("aheadBy");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("behindBy");
            }
            return "Cannot build CommitComparison, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="CommitComparison", generator="Immutables")
    static final class Json
    implements CommitComparison {
        @Nullable
        Commit baseCommit;
        @Nullable
        Commit mergeBaseCommit;
        @Nullable
        String status;
        int aheadBy;
        boolean aheadByIsSet;
        int behindBy;
        boolean behindByIsSet;
        @Nullable
        List<Commit> commits = null;
        @Nullable
        List<File> files = null;

        Json() {
        }

        @JsonProperty
        public void setBaseCommit(@Nullable Commit baseCommit) {
            this.baseCommit = baseCommit;
        }

        @JsonProperty
        public void setMergeBaseCommit(@Nullable Commit mergeBaseCommit) {
            this.mergeBaseCommit = mergeBaseCommit;
        }

        @JsonProperty
        public void setStatus(@Nullable String status) {
            this.status = status;
        }

        @JsonProperty
        public void setAheadBy(int aheadBy) {
            this.aheadBy = aheadBy;
            this.aheadByIsSet = true;
        }

        @JsonProperty
        public void setBehindBy(int behindBy) {
            this.behindBy = behindBy;
            this.behindByIsSet = true;
        }

        @JsonProperty
        public void setCommits(@Nullable List<Commit> commits) {
            this.commits = commits;
        }

        @JsonProperty
        public void setFiles(@Nullable List<File> files) {
            this.files = files;
        }

        @Override
        public Commit baseCommit() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Commit mergeBaseCommit() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String status() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int aheadBy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int behindBy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Commit> commits() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<File> files() {
            throw new UnsupportedOperationException();
        }
    }
}

