/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.repos;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.GitHubInstant;
import com.spotify.github.UpdateTracking;
import com.spotify.github.v3.User;
import com.spotify.github.v3.repos.Status;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Status", generator="Immutables")
@Immutable
public final class ImmutableStatus
implements Status {
    @Nullable
    private final GitHubInstant createdAt;
    @Nullable
    private final GitHubInstant updatedAt;
    @Nullable
    private final String state;
    @Nullable
    private final URI targetUrl;
    @Nullable
    private final String description;
    @Nullable
    private final Long id;
    @Nullable
    private final URI url;
    @Nullable
    private final String context;
    @Nullable
    private final User creator;
    @Nullable
    private final URI deploymentUrl;
    @Nullable
    private final URI repositoryUrl;

    private ImmutableStatus(@Nullable GitHubInstant createdAt, @Nullable GitHubInstant updatedAt, @Nullable String state, @Nullable URI targetUrl, @Nullable String description, @Nullable Long id, @Nullable URI url, @Nullable String context, @Nullable User creator, @Nullable URI deploymentUrl, @Nullable URI repositoryUrl) {
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.state = state;
        this.targetUrl = targetUrl;
        this.description = description;
        this.id = id;
        this.url = url;
        this.context = context;
        this.creator = creator;
        this.deploymentUrl = deploymentUrl;
        this.repositoryUrl = repositoryUrl;
    }

    @Override
    @JsonProperty
    @Nullable
    public GitHubInstant createdAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty
    @Nullable
    public GitHubInstant updatedAt() {
        return this.updatedAt;
    }

    @Override
    @JsonProperty
    @Nullable
    public String state() {
        return this.state;
    }

    @Override
    @JsonProperty
    public Optional<URI> targetUrl() {
        return Optional.ofNullable(this.targetUrl);
    }

    @Override
    @JsonProperty
    public Optional<String> description() {
        return Optional.ofNullable(this.description);
    }

    @Override
    @JsonProperty
    @Nullable
    public Long id() {
        return this.id;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI url() {
        return this.url;
    }

    @Override
    @JsonProperty
    public Optional<String> context() {
        return Optional.ofNullable(this.context);
    }

    @Override
    @JsonProperty
    public Optional<User> creator() {
        return Optional.ofNullable(this.creator);
    }

    @Override
    @JsonProperty
    public Optional<URI> deploymentUrl() {
        return Optional.ofNullable(this.deploymentUrl);
    }

    @Override
    @JsonProperty
    public Optional<URI> repositoryUrl() {
        return Optional.ofNullable(this.repositoryUrl);
    }

    public final ImmutableStatus withCreatedAt(@Nullable GitHubInstant value) {
        if (this.createdAt == value) {
            return this;
        }
        return new ImmutableStatus(value, this.updatedAt, this.state, this.targetUrl, this.description, this.id, this.url, this.context, this.creator, this.deploymentUrl, this.repositoryUrl);
    }

    public final ImmutableStatus withUpdatedAt(@Nullable GitHubInstant value) {
        if (this.updatedAt == value) {
            return this;
        }
        return new ImmutableStatus(this.createdAt, value, this.state, this.targetUrl, this.description, this.id, this.url, this.context, this.creator, this.deploymentUrl, this.repositoryUrl);
    }

    public final ImmutableStatus withState(@Nullable String value) {
        if (Objects.equals(this.state, value)) {
            return this;
        }
        return new ImmutableStatus(this.createdAt, this.updatedAt, value, this.targetUrl, this.description, this.id, this.url, this.context, this.creator, this.deploymentUrl, this.repositoryUrl);
    }

    public final ImmutableStatus withTargetUrl(URI value) {
        URI newValue = Objects.requireNonNull(value, "targetUrl");
        if (this.targetUrl == newValue) {
            return this;
        }
        return new ImmutableStatus(this.createdAt, this.updatedAt, this.state, newValue, this.description, this.id, this.url, this.context, this.creator, this.deploymentUrl, this.repositoryUrl);
    }

    public final ImmutableStatus withTargetUrl(Optional<? extends URI> optional) {
        URI value = optional.orElse(null);
        if (this.targetUrl == value) {
            return this;
        }
        return new ImmutableStatus(this.createdAt, this.updatedAt, this.state, value, this.description, this.id, this.url, this.context, this.creator, this.deploymentUrl, this.repositoryUrl);
    }

    public final ImmutableStatus withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (Objects.equals(this.description, newValue)) {
            return this;
        }
        return new ImmutableStatus(this.createdAt, this.updatedAt, this.state, this.targetUrl, newValue, this.id, this.url, this.context, this.creator, this.deploymentUrl, this.repositoryUrl);
    }

    public final ImmutableStatus withDescription(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new ImmutableStatus(this.createdAt, this.updatedAt, this.state, this.targetUrl, value, this.id, this.url, this.context, this.creator, this.deploymentUrl, this.repositoryUrl);
    }

    public final ImmutableStatus withId(@Nullable Long value) {
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return new ImmutableStatus(this.createdAt, this.updatedAt, this.state, this.targetUrl, this.description, value, this.url, this.context, this.creator, this.deploymentUrl, this.repositoryUrl);
    }

    public final ImmutableStatus withUrl(@Nullable URI value) {
        if (this.url == value) {
            return this;
        }
        return new ImmutableStatus(this.createdAt, this.updatedAt, this.state, this.targetUrl, this.description, this.id, value, this.context, this.creator, this.deploymentUrl, this.repositoryUrl);
    }

    public final ImmutableStatus withContext(String value) {
        String newValue = Objects.requireNonNull(value, "context");
        if (Objects.equals(this.context, newValue)) {
            return this;
        }
        return new ImmutableStatus(this.createdAt, this.updatedAt, this.state, this.targetUrl, this.description, this.id, this.url, newValue, this.creator, this.deploymentUrl, this.repositoryUrl);
    }

    public final ImmutableStatus withContext(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.context, value)) {
            return this;
        }
        return new ImmutableStatus(this.createdAt, this.updatedAt, this.state, this.targetUrl, this.description, this.id, this.url, value, this.creator, this.deploymentUrl, this.repositoryUrl);
    }

    public final ImmutableStatus withCreator(User value) {
        User newValue = Objects.requireNonNull(value, "creator");
        if (this.creator == newValue) {
            return this;
        }
        return new ImmutableStatus(this.createdAt, this.updatedAt, this.state, this.targetUrl, this.description, this.id, this.url, this.context, newValue, this.deploymentUrl, this.repositoryUrl);
    }

    public final ImmutableStatus withCreator(Optional<? extends User> optional) {
        User value = optional.orElse(null);
        if (this.creator == value) {
            return this;
        }
        return new ImmutableStatus(this.createdAt, this.updatedAt, this.state, this.targetUrl, this.description, this.id, this.url, this.context, value, this.deploymentUrl, this.repositoryUrl);
    }

    public final ImmutableStatus withDeploymentUrl(URI value) {
        URI newValue = Objects.requireNonNull(value, "deploymentUrl");
        if (this.deploymentUrl == newValue) {
            return this;
        }
        return new ImmutableStatus(this.createdAt, this.updatedAt, this.state, this.targetUrl, this.description, this.id, this.url, this.context, this.creator, newValue, this.repositoryUrl);
    }

    public final ImmutableStatus withDeploymentUrl(Optional<? extends URI> optional) {
        URI value = optional.orElse(null);
        if (this.deploymentUrl == value) {
            return this;
        }
        return new ImmutableStatus(this.createdAt, this.updatedAt, this.state, this.targetUrl, this.description, this.id, this.url, this.context, this.creator, value, this.repositoryUrl);
    }

    public final ImmutableStatus withRepositoryUrl(URI value) {
        URI newValue = Objects.requireNonNull(value, "repositoryUrl");
        if (this.repositoryUrl == newValue) {
            return this;
        }
        return new ImmutableStatus(this.createdAt, this.updatedAt, this.state, this.targetUrl, this.description, this.id, this.url, this.context, this.creator, this.deploymentUrl, newValue);
    }

    public final ImmutableStatus withRepositoryUrl(Optional<? extends URI> optional) {
        URI value = optional.orElse(null);
        if (this.repositoryUrl == value) {
            return this;
        }
        return new ImmutableStatus(this.createdAt, this.updatedAt, this.state, this.targetUrl, this.description, this.id, this.url, this.context, this.creator, this.deploymentUrl, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStatus && this.equalTo((ImmutableStatus)another);
    }

    private boolean equalTo(ImmutableStatus another) {
        return Objects.equals(this.createdAt, another.createdAt) && Objects.equals(this.updatedAt, another.updatedAt) && Objects.equals(this.state, another.state) && Objects.equals(this.targetUrl, another.targetUrl) && Objects.equals(this.description, another.description) && Objects.equals(this.id, another.id) && Objects.equals(this.url, another.url) && Objects.equals(this.context, another.context) && Objects.equals(this.creator, another.creator) && Objects.equals(this.deploymentUrl, another.deploymentUrl) && Objects.equals(this.repositoryUrl, another.repositoryUrl);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.createdAt);
        h += (h << 5) + Objects.hashCode(this.updatedAt);
        h += (h << 5) + Objects.hashCode(this.state);
        h += (h << 5) + Objects.hashCode(this.targetUrl);
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + Objects.hashCode(this.url);
        h += (h << 5) + Objects.hashCode(this.context);
        h += (h << 5) + Objects.hashCode(this.creator);
        h += (h << 5) + Objects.hashCode(this.deploymentUrl);
        h += (h << 5) + Objects.hashCode(this.repositoryUrl);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Status{");
        if (this.createdAt != null) {
            builder.append("createdAt=").append(this.createdAt);
        }
        if (this.updatedAt != null) {
            if (builder.length() > 7) {
                builder.append(", ");
            }
            builder.append("updatedAt=").append(this.updatedAt);
        }
        if (this.state != null) {
            if (builder.length() > 7) {
                builder.append(", ");
            }
            builder.append("state=").append(this.state);
        }
        if (this.targetUrl != null) {
            if (builder.length() > 7) {
                builder.append(", ");
            }
            builder.append("targetUrl=").append(this.targetUrl);
        }
        if (this.description != null) {
            if (builder.length() > 7) {
                builder.append(", ");
            }
            builder.append("description=").append(this.description);
        }
        if (this.id != null) {
            if (builder.length() > 7) {
                builder.append(", ");
            }
            builder.append("id=").append(this.id);
        }
        if (this.url != null) {
            if (builder.length() > 7) {
                builder.append(", ");
            }
            builder.append("url=").append(this.url);
        }
        if (this.context != null) {
            if (builder.length() > 7) {
                builder.append(", ");
            }
            builder.append("context=").append(this.context);
        }
        if (this.creator != null) {
            if (builder.length() > 7) {
                builder.append(", ");
            }
            builder.append("creator=").append(this.creator);
        }
        if (this.deploymentUrl != null) {
            if (builder.length() > 7) {
                builder.append(", ");
            }
            builder.append("deploymentUrl=").append(this.deploymentUrl);
        }
        if (this.repositoryUrl != null) {
            if (builder.length() > 7) {
                builder.append(", ");
            }
            builder.append("repositoryUrl=").append(this.repositoryUrl);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableStatus fromJson(Json json) {
        Builder builder = ImmutableStatus.builder();
        if (json.createdAt != null) {
            builder.createdAt(json.createdAt);
        }
        if (json.updatedAt != null) {
            builder.updatedAt(json.updatedAt);
        }
        if (json.state != null) {
            builder.state(json.state);
        }
        if (json.targetUrl != null) {
            builder.targetUrl(json.targetUrl);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.url != null) {
            builder.url(json.url);
        }
        if (json.context != null) {
            builder.context(json.context);
        }
        if (json.creator != null) {
            builder.creator(json.creator);
        }
        if (json.deploymentUrl != null) {
            builder.deploymentUrl(json.deploymentUrl);
        }
        if (json.repositoryUrl != null) {
            builder.repositoryUrl(json.repositoryUrl);
        }
        return builder.build();
    }

    public static ImmutableStatus copyOf(Status instance) {
        if (instance instanceof ImmutableStatus) {
            return (ImmutableStatus)instance;
        }
        return ImmutableStatus.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Status", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private GitHubInstant createdAt;
        @Nullable
        private GitHubInstant updatedAt;
        @Nullable
        private String state;
        @Nullable
        private URI targetUrl;
        @Nullable
        private String description;
        @Nullable
        private Long id;
        @Nullable
        private URI url;
        @Nullable
        private String context;
        @Nullable
        private User creator;
        @Nullable
        private URI deploymentUrl;
        @Nullable
        private URI repositoryUrl;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Status instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(UpdateTracking instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            UpdateTracking instance;
            if (object instanceof Status) {
                Optional<URI> repositoryUrlOptional;
                URI urlValue;
                Optional<URI> targetUrlOptional;
                Long idValue;
                String stateValue;
                Optional<String> descriptionOptional;
                Optional<String> contextOptional;
                Optional<URI> deploymentUrlOptional;
                instance = (Status)object;
                Optional<User> creatorOptional = instance.creator();
                if (creatorOptional.isPresent()) {
                    this.creator(creatorOptional);
                }
                if ((deploymentUrlOptional = instance.deploymentUrl()).isPresent()) {
                    this.deploymentUrl(deploymentUrlOptional);
                }
                if ((contextOptional = instance.context()).isPresent()) {
                    this.context(contextOptional);
                }
                if ((descriptionOptional = instance.description()).isPresent()) {
                    this.description(descriptionOptional);
                }
                if ((stateValue = instance.state()) != null) {
                    this.state(stateValue);
                }
                if ((idValue = instance.id()) != null) {
                    this.id(idValue);
                }
                if ((targetUrlOptional = instance.targetUrl()).isPresent()) {
                    this.targetUrl(targetUrlOptional);
                }
                if ((urlValue = instance.url()) != null) {
                    this.url(urlValue);
                }
                if ((repositoryUrlOptional = instance.repositoryUrl()).isPresent()) {
                    this.repositoryUrl(repositoryUrlOptional);
                }
            }
            if (object instanceof UpdateTracking) {
                GitHubInstant updatedAtValue;
                instance = (UpdateTracking)object;
                GitHubInstant createdAtValue = instance.createdAt();
                if (createdAtValue != null) {
                    this.createdAt(createdAtValue);
                }
                if ((updatedAtValue = instance.updatedAt()) != null) {
                    this.updatedAt(updatedAtValue);
                }
            }
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder createdAt(@Nullable GitHubInstant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder updatedAt(@Nullable GitHubInstant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder state(@Nullable String state) {
            this.state = state;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder targetUrl(URI targetUrl) {
            this.targetUrl = Objects.requireNonNull(targetUrl, "targetUrl");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder targetUrl(Optional<? extends URI> targetUrl) {
            this.targetUrl = targetUrl.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder description(Optional<String> description) {
            this.description = description.orElse(null);
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder id(@Nullable Long id) {
            this.id = id;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder url(@Nullable URI url) {
            this.url = url;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder context(String context) {
            this.context = Objects.requireNonNull(context, "context");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder context(Optional<String> context) {
            this.context = context.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder creator(User creator) {
            this.creator = Objects.requireNonNull(creator, "creator");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder creator(Optional<? extends User> creator) {
            this.creator = creator.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder deploymentUrl(URI deploymentUrl) {
            this.deploymentUrl = Objects.requireNonNull(deploymentUrl, "deploymentUrl");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder deploymentUrl(Optional<? extends URI> deploymentUrl) {
            this.deploymentUrl = deploymentUrl.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder repositoryUrl(URI repositoryUrl) {
            this.repositoryUrl = Objects.requireNonNull(repositoryUrl, "repositoryUrl");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder repositoryUrl(Optional<? extends URI> repositoryUrl) {
            this.repositoryUrl = repositoryUrl.orElse(null);
            return this;
        }

        public ImmutableStatus build() {
            return new ImmutableStatus(this.createdAt, this.updatedAt, this.state, this.targetUrl, this.description, this.id, this.url, this.context, this.creator, this.deploymentUrl, this.repositoryUrl);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Status", generator="Immutables")
    static final class Json
    implements Status {
        @Nullable
        GitHubInstant createdAt;
        @Nullable
        GitHubInstant updatedAt;
        @Nullable
        String state;
        @Nullable
        Optional<URI> targetUrl = Optional.empty();
        @Nullable
        Optional<String> description = Optional.empty();
        @Nullable
        Long id;
        @Nullable
        URI url;
        @Nullable
        Optional<String> context = Optional.empty();
        @Nullable
        Optional<User> creator = Optional.empty();
        @Nullable
        Optional<URI> deploymentUrl = Optional.empty();
        @Nullable
        Optional<URI> repositoryUrl = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setCreatedAt(@Nullable GitHubInstant createdAt) {
            this.createdAt = createdAt;
        }

        @JsonProperty
        public void setUpdatedAt(@Nullable GitHubInstant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @JsonProperty
        public void setState(@Nullable String state) {
            this.state = state;
        }

        @JsonProperty
        public void setTargetUrl(Optional<URI> targetUrl) {
            this.targetUrl = targetUrl;
        }

        @JsonProperty
        public void setDescription(Optional<String> description) {
            this.description = description;
        }

        @JsonProperty
        public void setId(@Nullable Long id) {
            this.id = id;
        }

        @JsonProperty
        public void setUrl(@Nullable URI url) {
            this.url = url;
        }

        @JsonProperty
        public void setContext(Optional<String> context) {
            this.context = context;
        }

        @JsonProperty
        public void setCreator(Optional<User> creator) {
            this.creator = creator;
        }

        @JsonProperty
        public void setDeploymentUrl(Optional<URI> deploymentUrl) {
            this.deploymentUrl = deploymentUrl;
        }

        @JsonProperty
        public void setRepositoryUrl(Optional<URI> repositoryUrl) {
            this.repositoryUrl = repositoryUrl;
        }

        @Override
        public GitHubInstant createdAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public GitHubInstant updatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String state() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<URI> targetUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> description() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI url() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> context() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<User> creator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<URI> deploymentUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<URI> repositoryUrl() {
            throw new UnsupportedOperationException();
        }
    }
}

