/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.search.requests;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.search.requests.SearchParameters;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="SearchParameters", generator="Immutables")
@Immutable
public final class ImmutableSearchParameters
implements SearchParameters {
    @Nullable
    private final String q;
    @Nullable
    private final String sort;
    @Nullable
    private final String order;
    @Nullable
    private final Integer per_page;
    @Nullable
    private final Integer page;

    private ImmutableSearchParameters(@Nullable String q, @Nullable String sort, @Nullable String order, @Nullable Integer per_page, @Nullable Integer page) {
        this.q = q;
        this.sort = sort;
        this.order = order;
        this.per_page = per_page;
        this.page = page;
    }

    @Override
    @JsonProperty
    @Nullable
    public String q() {
        return this.q;
    }

    @Override
    @JsonProperty
    public Optional<String> sort() {
        return Optional.ofNullable(this.sort);
    }

    @Override
    @JsonProperty
    public Optional<String> order() {
        return Optional.ofNullable(this.order);
    }

    @Override
    @JsonProperty
    public Optional<Integer> per_page() {
        return Optional.ofNullable(this.per_page);
    }

    @Override
    @JsonProperty
    public Optional<Integer> page() {
        return Optional.ofNullable(this.page);
    }

    public final ImmutableSearchParameters withQ(@Nullable String value) {
        if (Objects.equals(this.q, value)) {
            return this;
        }
        return new ImmutableSearchParameters(value, this.sort, this.order, this.per_page, this.page);
    }

    public final ImmutableSearchParameters withSort(String value) {
        String newValue = Objects.requireNonNull(value, "sort");
        if (Objects.equals(this.sort, newValue)) {
            return this;
        }
        return new ImmutableSearchParameters(this.q, newValue, this.order, this.per_page, this.page);
    }

    public final ImmutableSearchParameters withSort(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.sort, value)) {
            return this;
        }
        return new ImmutableSearchParameters(this.q, value, this.order, this.per_page, this.page);
    }

    public final ImmutableSearchParameters withOrder(String value) {
        String newValue = Objects.requireNonNull(value, "order");
        if (Objects.equals(this.order, newValue)) {
            return this;
        }
        return new ImmutableSearchParameters(this.q, this.sort, newValue, this.per_page, this.page);
    }

    public final ImmutableSearchParameters withOrder(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.order, value)) {
            return this;
        }
        return new ImmutableSearchParameters(this.q, this.sort, value, this.per_page, this.page);
    }

    public final ImmutableSearchParameters withPer_page(int value) {
        Integer newValue = value;
        if (Objects.equals(this.per_page, newValue)) {
            return this;
        }
        return new ImmutableSearchParameters(this.q, this.sort, this.order, newValue, this.page);
    }

    public final ImmutableSearchParameters withPer_page(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.per_page, value)) {
            return this;
        }
        return new ImmutableSearchParameters(this.q, this.sort, this.order, value, this.page);
    }

    public final ImmutableSearchParameters withPage(int value) {
        Integer newValue = value;
        if (Objects.equals(this.page, newValue)) {
            return this;
        }
        return new ImmutableSearchParameters(this.q, this.sort, this.order, this.per_page, newValue);
    }

    public final ImmutableSearchParameters withPage(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.page, value)) {
            return this;
        }
        return new ImmutableSearchParameters(this.q, this.sort, this.order, this.per_page, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSearchParameters && this.equalTo((ImmutableSearchParameters)another);
    }

    private boolean equalTo(ImmutableSearchParameters another) {
        return Objects.equals(this.q, another.q) && Objects.equals(this.sort, another.sort) && Objects.equals(this.order, another.order) && Objects.equals(this.per_page, another.per_page) && Objects.equals(this.page, another.page);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.q);
        h += (h << 5) + Objects.hashCode(this.sort);
        h += (h << 5) + Objects.hashCode(this.order);
        h += (h << 5) + Objects.hashCode(this.per_page);
        h += (h << 5) + Objects.hashCode(this.page);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SearchParameters{");
        if (this.q != null) {
            builder.append("q=").append(this.q);
        }
        if (this.sort != null) {
            if (builder.length() > 17) {
                builder.append(", ");
            }
            builder.append("sort=").append(this.sort);
        }
        if (this.order != null) {
            if (builder.length() > 17) {
                builder.append(", ");
            }
            builder.append("order=").append(this.order);
        }
        if (this.per_page != null) {
            if (builder.length() > 17) {
                builder.append(", ");
            }
            builder.append("per_page=").append(this.per_page);
        }
        if (this.page != null) {
            if (builder.length() > 17) {
                builder.append(", ");
            }
            builder.append("page=").append(this.page);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableSearchParameters fromJson(Json json) {
        Builder builder = ImmutableSearchParameters.builder();
        if (json.q != null) {
            builder.q(json.q);
        }
        if (json.sort != null) {
            builder.sort(json.sort);
        }
        if (json.order != null) {
            builder.order(json.order);
        }
        if (json.per_page != null) {
            builder.per_page(json.per_page);
        }
        if (json.page != null) {
            builder.page(json.page);
        }
        return builder.build();
    }

    public static ImmutableSearchParameters copyOf(SearchParameters instance) {
        if (instance instanceof ImmutableSearchParameters) {
            return (ImmutableSearchParameters)instance;
        }
        return ImmutableSearchParameters.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SearchParameters", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String q;
        @Nullable
        private String sort;
        @Nullable
        private String order;
        @Nullable
        private Integer per_page;
        @Nullable
        private Integer page;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(SearchParameters instance) {
            Optional<Integer> pageOptional;
            Optional<Integer> per_pageOptional;
            Optional<String> orderOptional;
            Optional<String> sortOptional;
            Objects.requireNonNull(instance, "instance");
            String qValue = instance.q();
            if (qValue != null) {
                this.q(qValue);
            }
            if ((sortOptional = instance.sort()).isPresent()) {
                this.sort(sortOptional);
            }
            if ((orderOptional = instance.order()).isPresent()) {
                this.order(orderOptional);
            }
            if ((per_pageOptional = instance.per_page()).isPresent()) {
                this.per_page(per_pageOptional);
            }
            if ((pageOptional = instance.page()).isPresent()) {
                this.page(pageOptional);
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder q(@Nullable String q) {
            this.q = q;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sort(String sort) {
            this.sort = Objects.requireNonNull(sort, "sort");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder sort(Optional<String> sort) {
            this.sort = sort.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder order(String order) {
            this.order = Objects.requireNonNull(order, "order");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder order(Optional<String> order) {
            this.order = order.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder per_page(int per_page) {
            this.per_page = per_page;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder per_page(Optional<Integer> per_page) {
            this.per_page = per_page.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder page(int page) {
            this.page = page;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder page(Optional<Integer> page) {
            this.page = page.orElse(null);
            return this;
        }

        public ImmutableSearchParameters build() {
            return new ImmutableSearchParameters(this.q, this.sort, this.order, this.per_page, this.page);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="SearchParameters", generator="Immutables")
    static final class Json
    implements SearchParameters {
        @Nullable
        String q;
        @Nullable
        Optional<String> sort = Optional.empty();
        @Nullable
        Optional<String> order = Optional.empty();
        @Nullable
        Optional<Integer> per_page = Optional.empty();
        @Nullable
        Optional<Integer> page = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setQ(@Nullable String q) {
            this.q = q;
        }

        @JsonProperty
        public void setSort(Optional<String> sort) {
            this.sort = sort;
        }

        @JsonProperty
        public void setOrder(Optional<String> order) {
            this.order = order;
        }

        @JsonProperty
        public void setPer_page(Optional<Integer> per_page) {
            this.per_page = per_page;
        }

        @JsonProperty
        public void setPage(Optional<Integer> page) {
            this.page = page;
        }

        @Override
        public String q() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> sort() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> order() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> per_page() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> page() {
            throw new UnsupportedOperationException();
        }
    }
}

