/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import com.spotify.github.jackson.GithubApiModule;
import com.spotify.github.v3.exceptions.DeserializationException;
import java.io.IOException;
import java.util.Objects;

public class Json {
    private final ObjectMapper mapper;

    private Json(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public static Json create() {
        return Json.withMapper(DefaultMapper.INSTANCE);
    }

    public static Json withMapper(ObjectMapper mapper) {
        return new Json(mapper);
    }

    public String toJson(Object value) throws JsonProcessingException {
        return this.mapper.writeValueAsString(value);
    }

    public String toJsonUnchecked(Object value) {
        try {
            return this.toJson(value);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T fromJson(String content, Class<T> clazz) throws IOException {
        return (T)this.mapper.readValue(content, clazz);
    }

    public <T> T fromJson(String content, TypeReference<T> typeReference) throws IOException {
        return (T)this.mapper.readValue(content, typeReference);
    }

    public <T> T fromJson(String content, JavaType javaType) throws IOException {
        return (T)this.mapper.readValue(content, javaType);
    }

    public <T> T fromJson(byte[] bytes, Class<T> clazz) throws IOException {
        return (T)this.mapper.readValue(bytes, clazz);
    }

    public <T> T fromJson(byte[] bytes, TypeReference<T> typeReference) throws IOException {
        return (T)this.mapper.readValue(bytes, typeReference);
    }

    public <T> T fromJson(byte[] bytes, JavaType javaType) throws IOException {
        return (T)this.mapper.readValue(bytes, javaType);
    }

    public <T> T fromJsonUnchecked(String content, Class<T> clazz) {
        try {
            return (T)this.mapper.readValue(content, clazz);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T fromJsonUnchecked(String content, TypeReference<T> typeReference) {
        try {
            return (T)this.mapper.readValue(content, typeReference);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T fromJsonUncheckedNotNull(String content, Class<T> clazz) {
        try {
            Object t = this.mapper.readValue(content, clazz);
            if (Objects.isNull(t)) {
                throw new DeserializationException(content);
            }
            return (T)t;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T fromJsonUncheckedNotNull(String content, TypeReference<T> typeReference) {
        try {
            Object t = this.mapper.readValue(content, typeReference);
            if (Objects.isNull(t)) {
                throw new DeserializationException(content);
            }
            return (T)t;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static class DefaultMapper {
        private static final ObjectMapper INSTANCE = new ObjectMapper().registerModule((Module)new ParameterNamesModule()).registerModule((Module)new Jdk8Module()).registerModule((Module)new JavaTimeModule()).registerModule((Module)new GithubApiModule()).disable(DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).enable(SerializationFeature.WRITE_DATES_WITH_ZONE_ID).enable(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES).setSerializationInclusion(JsonInclude.Include.NON_NULL).setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);

        private DefaultMapper() {
        }
    }
}

