/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.activity.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.User;
import com.spotify.github.v3.activity.events.BaseEvent;
import com.spotify.github.v3.activity.events.CreateEvent;
import com.spotify.github.v3.activity.events.EventInstallation;
import com.spotify.github.v3.repos.Repository;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CreateEvent", generator="Immutables")
@Immutable
public final class ImmutableCreateEvent
implements CreateEvent {
    @Nullable
    private final Repository repository;
    @Nullable
    private final User sender;
    @Nullable
    private final EventInstallation eventInstallation;
    @Nullable
    private final String ref;
    @Nullable
    private final String refType;
    @Nullable
    private final String masterBranch;
    @Nullable
    private final Optional<String> description;
    @Nullable
    private final String pusherType;

    private ImmutableCreateEvent(@Nullable Repository repository, @Nullable User sender, @Nullable EventInstallation eventInstallation, @Nullable String ref, @Nullable String refType, @Nullable String masterBranch, @Nullable Optional<String> description, @Nullable String pusherType) {
        this.repository = repository;
        this.sender = sender;
        this.eventInstallation = eventInstallation;
        this.ref = ref;
        this.refType = refType;
        this.masterBranch = masterBranch;
        this.description = description;
        this.pusherType = pusherType;
    }

    @Override
    @JsonProperty
    @Nullable
    public Repository repository() {
        return this.repository;
    }

    @Override
    @JsonProperty
    @Nullable
    public User sender() {
        return this.sender;
    }

    @Override
    @JsonProperty(value="installation")
    @Nullable
    public EventInstallation eventInstallation() {
        return this.eventInstallation;
    }

    @Override
    @JsonProperty
    @Nullable
    public String ref() {
        return this.ref;
    }

    @Override
    @JsonProperty
    @Nullable
    public String refType() {
        return this.refType;
    }

    @Override
    @JsonProperty
    @Nullable
    public String masterBranch() {
        return this.masterBranch;
    }

    @Override
    @JsonProperty
    @Nullable
    public Optional<String> description() {
        return this.description;
    }

    @Override
    @JsonProperty
    @Nullable
    public String pusherType() {
        return this.pusherType;
    }

    public final ImmutableCreateEvent withRepository(@Nullable Repository value) {
        if (this.repository == value) {
            return this;
        }
        return new ImmutableCreateEvent(value, this.sender, this.eventInstallation, this.ref, this.refType, this.masterBranch, this.description, this.pusherType);
    }

    public final ImmutableCreateEvent withSender(@Nullable User value) {
        if (this.sender == value) {
            return this;
        }
        return new ImmutableCreateEvent(this.repository, value, this.eventInstallation, this.ref, this.refType, this.masterBranch, this.description, this.pusherType);
    }

    public final ImmutableCreateEvent withEventInstallation(@Nullable EventInstallation value) {
        if (this.eventInstallation == value) {
            return this;
        }
        return new ImmutableCreateEvent(this.repository, this.sender, value, this.ref, this.refType, this.masterBranch, this.description, this.pusherType);
    }

    public final ImmutableCreateEvent withRef(@Nullable String value) {
        if (Objects.equals(this.ref, value)) {
            return this;
        }
        return new ImmutableCreateEvent(this.repository, this.sender, this.eventInstallation, value, this.refType, this.masterBranch, this.description, this.pusherType);
    }

    public final ImmutableCreateEvent withRefType(@Nullable String value) {
        if (Objects.equals(this.refType, value)) {
            return this;
        }
        return new ImmutableCreateEvent(this.repository, this.sender, this.eventInstallation, this.ref, value, this.masterBranch, this.description, this.pusherType);
    }

    public final ImmutableCreateEvent withMasterBranch(@Nullable String value) {
        if (Objects.equals(this.masterBranch, value)) {
            return this;
        }
        return new ImmutableCreateEvent(this.repository, this.sender, this.eventInstallation, this.ref, this.refType, value, this.description, this.pusherType);
    }

    public final ImmutableCreateEvent withDescription(@Nullable Optional<String> value) {
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new ImmutableCreateEvent(this.repository, this.sender, this.eventInstallation, this.ref, this.refType, this.masterBranch, value, this.pusherType);
    }

    public final ImmutableCreateEvent withPusherType(@Nullable String value) {
        if (Objects.equals(this.pusherType, value)) {
            return this;
        }
        return new ImmutableCreateEvent(this.repository, this.sender, this.eventInstallation, this.ref, this.refType, this.masterBranch, this.description, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCreateEvent && this.equalTo(0, (ImmutableCreateEvent)another);
    }

    private boolean equalTo(int synthetic, ImmutableCreateEvent another) {
        return Objects.equals(this.repository, another.repository) && Objects.equals(this.sender, another.sender) && Objects.equals(this.eventInstallation, another.eventInstallation) && Objects.equals(this.ref, another.ref) && Objects.equals(this.refType, another.refType) && Objects.equals(this.masterBranch, another.masterBranch) && Objects.equals(this.description, another.description) && Objects.equals(this.pusherType, another.pusherType);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.repository);
        h += (h << 5) + Objects.hashCode(this.sender);
        h += (h << 5) + Objects.hashCode(this.eventInstallation);
        h += (h << 5) + Objects.hashCode(this.ref);
        h += (h << 5) + Objects.hashCode(this.refType);
        h += (h << 5) + Objects.hashCode(this.masterBranch);
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + Objects.hashCode(this.pusherType);
        return h;
    }

    public String toString() {
        return "CreateEvent{repository=" + this.repository + ", sender=" + this.sender + ", eventInstallation=" + this.eventInstallation + ", ref=" + this.ref + ", refType=" + this.refType + ", masterBranch=" + this.masterBranch + ", description=" + this.description + ", pusherType=" + this.pusherType + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableCreateEvent fromJson(Json json) {
        Builder builder = ImmutableCreateEvent.builder();
        if (json.repository != null) {
            builder.repository(json.repository);
        }
        if (json.sender != null) {
            builder.sender(json.sender);
        }
        if (json.eventInstallation != null) {
            builder.eventInstallation(json.eventInstallation);
        }
        if (json.ref != null) {
            builder.ref(json.ref);
        }
        if (json.refType != null) {
            builder.refType(json.refType);
        }
        if (json.masterBranch != null) {
            builder.masterBranch(json.masterBranch);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.pusherType != null) {
            builder.pusherType(json.pusherType);
        }
        return builder.build();
    }

    public static ImmutableCreateEvent copyOf(CreateEvent instance) {
        if (instance instanceof ImmutableCreateEvent) {
            return (ImmutableCreateEvent)instance;
        }
        return ImmutableCreateEvent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CreateEvent", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Repository repository;
        @Nullable
        private User sender;
        @Nullable
        private EventInstallation eventInstallation;
        @Nullable
        private String ref;
        @Nullable
        private String refType;
        @Nullable
        private String masterBranch;
        @Nullable
        private Optional<String> description;
        @Nullable
        private String pusherType;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CreateEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(BaseEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            EventInstallation eventInstallationValue;
            BaseEvent instance;
            long bits = 0L;
            if (object instanceof CreateEvent) {
                String pusherTypeValue;
                Optional<String> descriptionValue;
                String masterBranchValue;
                String refTypeValue;
                String refValue;
                instance = (CreateEvent)object;
                if ((bits & 1L) == 0L) {
                    eventInstallationValue = instance.eventInstallation();
                    if (eventInstallationValue != null) {
                        this.eventInstallation(eventInstallationValue);
                    }
                    bits |= 1L;
                }
                if ((refValue = instance.ref()) != null) {
                    this.ref(refValue);
                }
                if ((bits & 2L) == 0L) {
                    User senderValue = instance.sender();
                    if (senderValue != null) {
                        this.sender(senderValue);
                    }
                    bits |= 2L;
                }
                if ((refTypeValue = instance.refType()) != null) {
                    this.refType(refTypeValue);
                }
                if ((masterBranchValue = instance.masterBranch()) != null) {
                    this.masterBranch(masterBranchValue);
                }
                if ((descriptionValue = instance.description()) != null) {
                    this.description(descriptionValue);
                }
                if ((bits & 4L) == 0L) {
                    Repository repositoryValue = instance.repository();
                    if (repositoryValue != null) {
                        this.repository(repositoryValue);
                    }
                    bits |= 4L;
                }
                if ((pusherTypeValue = instance.pusherType()) != null) {
                    this.pusherType(pusherTypeValue);
                }
            }
            if (object instanceof BaseEvent) {
                instance = (BaseEvent)object;
                if ((bits & 4L) == 0L) {
                    Repository repositoryValue = instance.repository();
                    if (repositoryValue != null) {
                        this.repository(repositoryValue);
                    }
                    bits |= 4L;
                }
                if ((bits & 2L) == 0L) {
                    User senderValue = instance.sender();
                    if (senderValue != null) {
                        this.sender(senderValue);
                    }
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    eventInstallationValue = instance.eventInstallation();
                    if (eventInstallationValue != null) {
                        this.eventInstallation(eventInstallationValue);
                    }
                    bits |= 1L;
                }
            }
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder repository(@Nullable Repository repository) {
            this.repository = repository;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder sender(@Nullable User sender) {
            this.sender = sender;
            return this;
        }

        @JsonProperty(value="installation")
        @CanIgnoreReturnValue
        public final Builder eventInstallation(@Nullable EventInstallation eventInstallation) {
            this.eventInstallation = eventInstallation;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder ref(@Nullable String ref) {
            this.ref = ref;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder refType(@Nullable String refType) {
            this.refType = refType;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder masterBranch(@Nullable String masterBranch) {
            this.masterBranch = masterBranch;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder description(@Nullable Optional<String> description) {
            this.description = description;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder pusherType(@Nullable String pusherType) {
            this.pusherType = pusherType;
            return this;
        }

        public ImmutableCreateEvent build() {
            return new ImmutableCreateEvent(this.repository, this.sender, this.eventInstallation, this.ref, this.refType, this.masterBranch, this.description, this.pusherType);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="CreateEvent", generator="Immutables")
    static final class Json
    implements CreateEvent {
        @Nullable
        Repository repository;
        @Nullable
        User sender;
        @Nullable
        EventInstallation eventInstallation;
        @Nullable
        String ref;
        @Nullable
        String refType;
        @Nullable
        String masterBranch;
        @Nullable
        Optional<String> description;
        @Nullable
        String pusherType;

        Json() {
        }

        @JsonProperty
        public void setRepository(@Nullable Repository repository) {
            this.repository = repository;
        }

        @JsonProperty
        public void setSender(@Nullable User sender) {
            this.sender = sender;
        }

        @JsonProperty(value="installation")
        public void setEventInstallation(@Nullable EventInstallation eventInstallation) {
            this.eventInstallation = eventInstallation;
        }

        @JsonProperty
        public void setRef(@Nullable String ref) {
            this.ref = ref;
        }

        @JsonProperty
        public void setRefType(@Nullable String refType) {
            this.refType = refType;
        }

        @JsonProperty
        public void setMasterBranch(@Nullable String masterBranch) {
            this.masterBranch = masterBranch;
        }

        @JsonProperty
        public void setDescription(@Nullable Optional<String> description) {
            this.description = description;
        }

        @JsonProperty
        public void setPusherType(@Nullable String pusherType) {
            this.pusherType = pusherType;
        }

        @Override
        public Repository repository() {
            throw new UnsupportedOperationException();
        }

        @Override
        public User sender() {
            throw new UnsupportedOperationException();
        }

        @Override
        public EventInstallation eventInstallation() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String ref() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String refType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String masterBranch() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> description() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String pusherType() {
            throw new UnsupportedOperationException();
        }
    }
}

