/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.activity.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.User;
import com.spotify.github.v3.activity.events.BaseEvent;
import com.spotify.github.v3.activity.events.EventInstallation;
import com.spotify.github.v3.activity.events.ForkEvent;
import com.spotify.github.v3.repos.Repository;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ForkEvent", generator="Immutables")
@Immutable
public final class ImmutableForkEvent
implements ForkEvent {
    @Nullable
    private final Repository repository;
    @Nullable
    private final User sender;
    @Nullable
    private final EventInstallation eventInstallation;
    @Nullable
    private final Repository forkee;

    private ImmutableForkEvent(@Nullable Repository repository, @Nullable User sender, @Nullable EventInstallation eventInstallation, @Nullable Repository forkee) {
        this.repository = repository;
        this.sender = sender;
        this.eventInstallation = eventInstallation;
        this.forkee = forkee;
    }

    @Override
    @JsonProperty
    @Nullable
    public Repository repository() {
        return this.repository;
    }

    @Override
    @JsonProperty
    @Nullable
    public User sender() {
        return this.sender;
    }

    @Override
    @JsonProperty(value="installation")
    @Nullable
    public EventInstallation eventInstallation() {
        return this.eventInstallation;
    }

    @Override
    @JsonProperty
    @Nullable
    public Repository forkee() {
        return this.forkee;
    }

    public final ImmutableForkEvent withRepository(@Nullable Repository value) {
        if (this.repository == value) {
            return this;
        }
        return new ImmutableForkEvent(value, this.sender, this.eventInstallation, this.forkee);
    }

    public final ImmutableForkEvent withSender(@Nullable User value) {
        if (this.sender == value) {
            return this;
        }
        return new ImmutableForkEvent(this.repository, value, this.eventInstallation, this.forkee);
    }

    public final ImmutableForkEvent withEventInstallation(@Nullable EventInstallation value) {
        if (this.eventInstallation == value) {
            return this;
        }
        return new ImmutableForkEvent(this.repository, this.sender, value, this.forkee);
    }

    public final ImmutableForkEvent withForkee(@Nullable Repository value) {
        if (this.forkee == value) {
            return this;
        }
        return new ImmutableForkEvent(this.repository, this.sender, this.eventInstallation, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableForkEvent && this.equalTo(0, (ImmutableForkEvent)another);
    }

    private boolean equalTo(int synthetic, ImmutableForkEvent another) {
        return Objects.equals(this.repository, another.repository) && Objects.equals(this.sender, another.sender) && Objects.equals(this.eventInstallation, another.eventInstallation) && Objects.equals(this.forkee, another.forkee);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.repository);
        h += (h << 5) + Objects.hashCode(this.sender);
        h += (h << 5) + Objects.hashCode(this.eventInstallation);
        h += (h << 5) + Objects.hashCode(this.forkee);
        return h;
    }

    public String toString() {
        return "ForkEvent{repository=" + this.repository + ", sender=" + this.sender + ", eventInstallation=" + this.eventInstallation + ", forkee=" + this.forkee + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableForkEvent fromJson(Json json) {
        Builder builder = ImmutableForkEvent.builder();
        if (json.repository != null) {
            builder.repository(json.repository);
        }
        if (json.sender != null) {
            builder.sender(json.sender);
        }
        if (json.eventInstallation != null) {
            builder.eventInstallation(json.eventInstallation);
        }
        if (json.forkee != null) {
            builder.forkee(json.forkee);
        }
        return builder.build();
    }

    public static ImmutableForkEvent copyOf(ForkEvent instance) {
        if (instance instanceof ImmutableForkEvent) {
            return (ImmutableForkEvent)instance;
        }
        return ImmutableForkEvent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ForkEvent", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Repository repository;
        @Nullable
        private User sender;
        @Nullable
        private EventInstallation eventInstallation;
        @Nullable
        private Repository forkee;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ForkEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(BaseEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            User senderValue;
            Repository repositoryValue;
            EventInstallation eventInstallationValue;
            BaseEvent instance;
            long bits = 0L;
            if (object instanceof ForkEvent) {
                Repository forkeeValue;
                instance = (ForkEvent)object;
                if ((bits & 1L) == 0L) {
                    eventInstallationValue = instance.eventInstallation();
                    if (eventInstallationValue != null) {
                        this.eventInstallation(eventInstallationValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 4L) == 0L) {
                    repositoryValue = instance.repository();
                    if (repositoryValue != null) {
                        this.repository(repositoryValue);
                    }
                    bits |= 4L;
                }
                if ((bits & 2L) == 0L) {
                    senderValue = instance.sender();
                    if (senderValue != null) {
                        this.sender(senderValue);
                    }
                    bits |= 2L;
                }
                if ((forkeeValue = instance.forkee()) != null) {
                    this.forkee(forkeeValue);
                }
            }
            if (object instanceof BaseEvent) {
                instance = (BaseEvent)object;
                if ((bits & 4L) == 0L) {
                    repositoryValue = instance.repository();
                    if (repositoryValue != null) {
                        this.repository(repositoryValue);
                    }
                    bits |= 4L;
                }
                if ((bits & 2L) == 0L) {
                    senderValue = instance.sender();
                    if (senderValue != null) {
                        this.sender(senderValue);
                    }
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    eventInstallationValue = instance.eventInstallation();
                    if (eventInstallationValue != null) {
                        this.eventInstallation(eventInstallationValue);
                    }
                    bits |= 1L;
                }
            }
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder repository(@Nullable Repository repository) {
            this.repository = repository;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder sender(@Nullable User sender) {
            this.sender = sender;
            return this;
        }

        @JsonProperty(value="installation")
        @CanIgnoreReturnValue
        public final Builder eventInstallation(@Nullable EventInstallation eventInstallation) {
            this.eventInstallation = eventInstallation;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder forkee(@Nullable Repository forkee) {
            this.forkee = forkee;
            return this;
        }

        public ImmutableForkEvent build() {
            return new ImmutableForkEvent(this.repository, this.sender, this.eventInstallation, this.forkee);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ForkEvent", generator="Immutables")
    static final class Json
    implements ForkEvent {
        @Nullable
        Repository repository;
        @Nullable
        User sender;
        @Nullable
        EventInstallation eventInstallation;
        @Nullable
        Repository forkee;

        Json() {
        }

        @JsonProperty
        public void setRepository(@Nullable Repository repository) {
            this.repository = repository;
        }

        @JsonProperty
        public void setSender(@Nullable User sender) {
            this.sender = sender;
        }

        @JsonProperty(value="installation")
        public void setEventInstallation(@Nullable EventInstallation eventInstallation) {
            this.eventInstallation = eventInstallation;
        }

        @JsonProperty
        public void setForkee(@Nullable Repository forkee) {
            this.forkee = forkee;
        }

        @Override
        public Repository repository() {
            throw new UnsupportedOperationException();
        }

        @Override
        public User sender() {
            throw new UnsupportedOperationException();
        }

        @Override
        public EventInstallation eventInstallation() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Repository forkee() {
            throw new UnsupportedOperationException();
        }
    }
}

