/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.activity.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.User;
import com.spotify.github.v3.activity.events.BaseEvent;
import com.spotify.github.v3.activity.events.EventInstallation;
import com.spotify.github.v3.activity.events.PullRequestReviewEvent;
import com.spotify.github.v3.prs.PullRequestItem;
import com.spotify.github.v3.prs.Review;
import com.spotify.github.v3.repos.Repository;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="PullRequestReviewEvent", generator="Immutables")
@Immutable
public final class ImmutablePullRequestReviewEvent
implements PullRequestReviewEvent {
    @Nullable
    private final Repository repository;
    @Nullable
    private final User sender;
    @Nullable
    private final EventInstallation eventInstallation;
    @Nullable
    private final String action;
    @Nullable
    private final Review review;
    @Nullable
    private final PullRequestItem pullRequest;

    private ImmutablePullRequestReviewEvent(@Nullable Repository repository, @Nullable User sender, @Nullable EventInstallation eventInstallation, @Nullable String action, @Nullable Review review, @Nullable PullRequestItem pullRequest) {
        this.repository = repository;
        this.sender = sender;
        this.eventInstallation = eventInstallation;
        this.action = action;
        this.review = review;
        this.pullRequest = pullRequest;
    }

    @Override
    @JsonProperty
    @Nullable
    public Repository repository() {
        return this.repository;
    }

    @Override
    @JsonProperty
    @Nullable
    public User sender() {
        return this.sender;
    }

    @Override
    @JsonProperty(value="installation")
    @Nullable
    public EventInstallation eventInstallation() {
        return this.eventInstallation;
    }

    @Override
    @JsonProperty
    @Nullable
    public String action() {
        return this.action;
    }

    @Override
    @JsonProperty
    @Nullable
    public Review review() {
        return this.review;
    }

    @Override
    @JsonProperty
    @Nullable
    public PullRequestItem pullRequest() {
        return this.pullRequest;
    }

    public final ImmutablePullRequestReviewEvent withRepository(@Nullable Repository value) {
        if (this.repository == value) {
            return this;
        }
        return new ImmutablePullRequestReviewEvent(value, this.sender, this.eventInstallation, this.action, this.review, this.pullRequest);
    }

    public final ImmutablePullRequestReviewEvent withSender(@Nullable User value) {
        if (this.sender == value) {
            return this;
        }
        return new ImmutablePullRequestReviewEvent(this.repository, value, this.eventInstallation, this.action, this.review, this.pullRequest);
    }

    public final ImmutablePullRequestReviewEvent withEventInstallation(@Nullable EventInstallation value) {
        if (this.eventInstallation == value) {
            return this;
        }
        return new ImmutablePullRequestReviewEvent(this.repository, this.sender, value, this.action, this.review, this.pullRequest);
    }

    public final ImmutablePullRequestReviewEvent withAction(@Nullable String value) {
        if (Objects.equals(this.action, value)) {
            return this;
        }
        return new ImmutablePullRequestReviewEvent(this.repository, this.sender, this.eventInstallation, value, this.review, this.pullRequest);
    }

    public final ImmutablePullRequestReviewEvent withReview(@Nullable Review value) {
        if (this.review == value) {
            return this;
        }
        return new ImmutablePullRequestReviewEvent(this.repository, this.sender, this.eventInstallation, this.action, value, this.pullRequest);
    }

    public final ImmutablePullRequestReviewEvent withPullRequest(@Nullable PullRequestItem value) {
        if (this.pullRequest == value) {
            return this;
        }
        return new ImmutablePullRequestReviewEvent(this.repository, this.sender, this.eventInstallation, this.action, this.review, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePullRequestReviewEvent && this.equalTo(0, (ImmutablePullRequestReviewEvent)another);
    }

    private boolean equalTo(int synthetic, ImmutablePullRequestReviewEvent another) {
        return Objects.equals(this.repository, another.repository) && Objects.equals(this.sender, another.sender) && Objects.equals(this.eventInstallation, another.eventInstallation) && Objects.equals(this.action, another.action) && Objects.equals(this.review, another.review) && Objects.equals(this.pullRequest, another.pullRequest);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.repository);
        h += (h << 5) + Objects.hashCode(this.sender);
        h += (h << 5) + Objects.hashCode(this.eventInstallation);
        h += (h << 5) + Objects.hashCode(this.action);
        h += (h << 5) + Objects.hashCode(this.review);
        h += (h << 5) + Objects.hashCode(this.pullRequest);
        return h;
    }

    public String toString() {
        return "PullRequestReviewEvent{repository=" + this.repository + ", sender=" + this.sender + ", eventInstallation=" + this.eventInstallation + ", action=" + this.action + ", review=" + this.review + ", pullRequest=" + this.pullRequest + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePullRequestReviewEvent fromJson(Json json) {
        Builder builder = ImmutablePullRequestReviewEvent.builder();
        if (json.repository != null) {
            builder.repository(json.repository);
        }
        if (json.sender != null) {
            builder.sender(json.sender);
        }
        if (json.eventInstallation != null) {
            builder.eventInstallation(json.eventInstallation);
        }
        if (json.action != null) {
            builder.action(json.action);
        }
        if (json.review != null) {
            builder.review(json.review);
        }
        if (json.pullRequest != null) {
            builder.pullRequest(json.pullRequest);
        }
        return builder.build();
    }

    public static ImmutablePullRequestReviewEvent copyOf(PullRequestReviewEvent instance) {
        if (instance instanceof ImmutablePullRequestReviewEvent) {
            return (ImmutablePullRequestReviewEvent)instance;
        }
        return ImmutablePullRequestReviewEvent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="PullRequestReviewEvent", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Repository repository;
        @Nullable
        private User sender;
        @Nullable
        private EventInstallation eventInstallation;
        @Nullable
        private String action;
        @Nullable
        private Review review;
        @Nullable
        private PullRequestItem pullRequest;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(PullRequestReviewEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(BaseEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            BaseEvent instance;
            long bits = 0L;
            if (object instanceof PullRequestReviewEvent) {
                PullRequestItem pullRequestValue;
                Review reviewValue;
                instance = (PullRequestReviewEvent)object;
                String actionValue = instance.action();
                if (actionValue != null) {
                    this.action(actionValue);
                }
                if ((bits & 1L) == 0L) {
                    EventInstallation eventInstallationValue = instance.eventInstallation();
                    if (eventInstallationValue != null) {
                        this.eventInstallation(eventInstallationValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 4L) == 0L) {
                    Repository repositoryValue = instance.repository();
                    if (repositoryValue != null) {
                        this.repository(repositoryValue);
                    }
                    bits |= 4L;
                }
                if ((bits & 2L) == 0L) {
                    User senderValue = instance.sender();
                    if (senderValue != null) {
                        this.sender(senderValue);
                    }
                    bits |= 2L;
                }
                if ((reviewValue = instance.review()) != null) {
                    this.review(reviewValue);
                }
                if ((pullRequestValue = instance.pullRequest()) != null) {
                    this.pullRequest(pullRequestValue);
                }
            }
            if (object instanceof BaseEvent) {
                instance = (BaseEvent)object;
                if ((bits & 4L) == 0L) {
                    Repository repositoryValue = instance.repository();
                    if (repositoryValue != null) {
                        this.repository(repositoryValue);
                    }
                    bits |= 4L;
                }
                if ((bits & 2L) == 0L) {
                    User senderValue = instance.sender();
                    if (senderValue != null) {
                        this.sender(senderValue);
                    }
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    EventInstallation eventInstallationValue = instance.eventInstallation();
                    if (eventInstallationValue != null) {
                        this.eventInstallation(eventInstallationValue);
                    }
                    bits |= 1L;
                }
            }
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder repository(@Nullable Repository repository) {
            this.repository = repository;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder sender(@Nullable User sender) {
            this.sender = sender;
            return this;
        }

        @JsonProperty(value="installation")
        @CanIgnoreReturnValue
        public final Builder eventInstallation(@Nullable EventInstallation eventInstallation) {
            this.eventInstallation = eventInstallation;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder action(@Nullable String action) {
            this.action = action;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder review(@Nullable Review review) {
            this.review = review;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder pullRequest(@Nullable PullRequestItem pullRequest) {
            this.pullRequest = pullRequest;
            return this;
        }

        public ImmutablePullRequestReviewEvent build() {
            return new ImmutablePullRequestReviewEvent(this.repository, this.sender, this.eventInstallation, this.action, this.review, this.pullRequest);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="PullRequestReviewEvent", generator="Immutables")
    static final class Json
    implements PullRequestReviewEvent {
        @Nullable
        Repository repository;
        @Nullable
        User sender;
        @Nullable
        EventInstallation eventInstallation;
        @Nullable
        String action;
        @Nullable
        Review review;
        @Nullable
        PullRequestItem pullRequest;

        Json() {
        }

        @JsonProperty
        public void setRepository(@Nullable Repository repository) {
            this.repository = repository;
        }

        @JsonProperty
        public void setSender(@Nullable User sender) {
            this.sender = sender;
        }

        @JsonProperty(value="installation")
        public void setEventInstallation(@Nullable EventInstallation eventInstallation) {
            this.eventInstallation = eventInstallation;
        }

        @JsonProperty
        public void setAction(@Nullable String action) {
            this.action = action;
        }

        @JsonProperty
        public void setReview(@Nullable Review review) {
            this.review = review;
        }

        @JsonProperty
        public void setPullRequest(@Nullable PullRequestItem pullRequest) {
            this.pullRequest = pullRequest;
        }

        @Override
        public Repository repository() {
            throw new UnsupportedOperationException();
        }

        @Override
        public User sender() {
            throw new UnsupportedOperationException();
        }

        @Override
        public EventInstallation eventInstallation() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String action() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Review review() {
            throw new UnsupportedOperationException();
        }

        @Override
        public PullRequestItem pullRequest() {
            throw new UnsupportedOperationException();
        }
    }
}

