/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.activity.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.User;
import com.spotify.github.v3.activity.events.PushEvent;
import com.spotify.github.v3.git.Author;
import com.spotify.github.v3.repos.PushCommit;
import com.spotify.github.v3.repos.PushRepository;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="PushEvent", generator="Immutables")
@Immutable
public final class ImmutablePushEvent
implements PushEvent {
    @Nullable
    private final PushRepository repository;
    @Nullable
    private final User sender;
    @Nullable
    private final String ref;
    @Nullable
    private final String before;
    @Nullable
    private final String after;
    @Nullable
    private final Boolean created;
    @Nullable
    private final Boolean deleted;
    @Nullable
    private final Boolean forced;
    @Nullable
    private final String baseRef;
    @Nullable
    private final String compare;
    @Nullable
    private final List<PushCommit> commits;
    @Nullable
    private final Optional<PushCommit> headCommit;
    @Nullable
    private final Author pusher;

    private ImmutablePushEvent(@Nullable PushRepository repository, @Nullable User sender, @Nullable String ref, @Nullable String before, @Nullable String after, @Nullable Boolean created, @Nullable Boolean deleted, @Nullable Boolean forced, @Nullable String baseRef, @Nullable String compare, @Nullable List<PushCommit> commits, @Nullable Optional<PushCommit> headCommit, @Nullable Author pusher) {
        this.repository = repository;
        this.sender = sender;
        this.ref = ref;
        this.before = before;
        this.after = after;
        this.created = created;
        this.deleted = deleted;
        this.forced = forced;
        this.baseRef = baseRef;
        this.compare = compare;
        this.commits = commits;
        this.headCommit = headCommit;
        this.pusher = pusher;
    }

    @Override
    @JsonProperty
    @Nullable
    public PushRepository repository() {
        return this.repository;
    }

    @Override
    @JsonProperty
    @Nullable
    public User sender() {
        return this.sender;
    }

    @Override
    @JsonProperty
    @Nullable
    public String ref() {
        return this.ref;
    }

    @Override
    @JsonProperty
    @Nullable
    public String before() {
        return this.before;
    }

    @Override
    @JsonProperty
    @Nullable
    public String after() {
        return this.after;
    }

    @Override
    @JsonProperty
    @Nullable
    public Boolean created() {
        return this.created;
    }

    @Override
    @JsonProperty
    @Nullable
    public Boolean deleted() {
        return this.deleted;
    }

    @Override
    @JsonProperty
    @Nullable
    public Boolean forced() {
        return this.forced;
    }

    @Override
    @JsonProperty
    public Optional<String> baseRef() {
        return Optional.ofNullable(this.baseRef);
    }

    @Override
    @JsonProperty
    @Nullable
    public String compare() {
        return this.compare;
    }

    @Override
    @JsonProperty
    @Nullable
    public List<PushCommit> commits() {
        return this.commits;
    }

    @Override
    @JsonProperty
    @Nullable
    public Optional<PushCommit> headCommit() {
        return this.headCommit;
    }

    @Override
    @JsonProperty
    @Nullable
    public Author pusher() {
        return this.pusher;
    }

    public final ImmutablePushEvent withRepository(@Nullable PushRepository value) {
        if (this.repository == value) {
            return this;
        }
        return new ImmutablePushEvent(value, this.sender, this.ref, this.before, this.after, this.created, this.deleted, this.forced, this.baseRef, this.compare, this.commits, this.headCommit, this.pusher);
    }

    public final ImmutablePushEvent withSender(@Nullable User value) {
        if (this.sender == value) {
            return this;
        }
        return new ImmutablePushEvent(this.repository, value, this.ref, this.before, this.after, this.created, this.deleted, this.forced, this.baseRef, this.compare, this.commits, this.headCommit, this.pusher);
    }

    public final ImmutablePushEvent withRef(@Nullable String value) {
        if (Objects.equals(this.ref, value)) {
            return this;
        }
        return new ImmutablePushEvent(this.repository, this.sender, value, this.before, this.after, this.created, this.deleted, this.forced, this.baseRef, this.compare, this.commits, this.headCommit, this.pusher);
    }

    public final ImmutablePushEvent withBefore(@Nullable String value) {
        if (Objects.equals(this.before, value)) {
            return this;
        }
        return new ImmutablePushEvent(this.repository, this.sender, this.ref, value, this.after, this.created, this.deleted, this.forced, this.baseRef, this.compare, this.commits, this.headCommit, this.pusher);
    }

    public final ImmutablePushEvent withAfter(@Nullable String value) {
        if (Objects.equals(this.after, value)) {
            return this;
        }
        return new ImmutablePushEvent(this.repository, this.sender, this.ref, this.before, value, this.created, this.deleted, this.forced, this.baseRef, this.compare, this.commits, this.headCommit, this.pusher);
    }

    public final ImmutablePushEvent withCreated(@Nullable Boolean value) {
        if (Objects.equals(this.created, value)) {
            return this;
        }
        return new ImmutablePushEvent(this.repository, this.sender, this.ref, this.before, this.after, value, this.deleted, this.forced, this.baseRef, this.compare, this.commits, this.headCommit, this.pusher);
    }

    public final ImmutablePushEvent withDeleted(@Nullable Boolean value) {
        if (Objects.equals(this.deleted, value)) {
            return this;
        }
        return new ImmutablePushEvent(this.repository, this.sender, this.ref, this.before, this.after, this.created, value, this.forced, this.baseRef, this.compare, this.commits, this.headCommit, this.pusher);
    }

    public final ImmutablePushEvent withForced(@Nullable Boolean value) {
        if (Objects.equals(this.forced, value)) {
            return this;
        }
        return new ImmutablePushEvent(this.repository, this.sender, this.ref, this.before, this.after, this.created, this.deleted, value, this.baseRef, this.compare, this.commits, this.headCommit, this.pusher);
    }

    public final ImmutablePushEvent withBaseRef(String value) {
        String newValue = Objects.requireNonNull(value, "baseRef");
        if (Objects.equals(this.baseRef, newValue)) {
            return this;
        }
        return new ImmutablePushEvent(this.repository, this.sender, this.ref, this.before, this.after, this.created, this.deleted, this.forced, newValue, this.compare, this.commits, this.headCommit, this.pusher);
    }

    public final ImmutablePushEvent withBaseRef(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.baseRef, value)) {
            return this;
        }
        return new ImmutablePushEvent(this.repository, this.sender, this.ref, this.before, this.after, this.created, this.deleted, this.forced, value, this.compare, this.commits, this.headCommit, this.pusher);
    }

    public final ImmutablePushEvent withCompare(@Nullable String value) {
        if (Objects.equals(this.compare, value)) {
            return this;
        }
        return new ImmutablePushEvent(this.repository, this.sender, this.ref, this.before, this.after, this.created, this.deleted, this.forced, this.baseRef, value, this.commits, this.headCommit, this.pusher);
    }

    public final ImmutablePushEvent withCommits(PushCommit ... elements) {
        if (elements == null) {
            return new ImmutablePushEvent(this.repository, this.sender, this.ref, this.before, this.after, this.created, this.deleted, this.forced, this.baseRef, this.compare, null, this.headCommit, this.pusher);
        }
        List<PushCommit> newValue = Arrays.asList(elements) == null ? null : ImmutablePushEvent.createUnmodifiableList(false, ImmutablePushEvent.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutablePushEvent(this.repository, this.sender, this.ref, this.before, this.after, this.created, this.deleted, this.forced, this.baseRef, this.compare, newValue, this.headCommit, this.pusher);
    }

    public final ImmutablePushEvent withCommits(@Nullable Iterable<? extends PushCommit> elements) {
        if (this.commits == elements) {
            return this;
        }
        List<PushCommit> newValue = elements == null ? null : ImmutablePushEvent.createUnmodifiableList(false, ImmutablePushEvent.createSafeList(elements, true, false));
        return new ImmutablePushEvent(this.repository, this.sender, this.ref, this.before, this.after, this.created, this.deleted, this.forced, this.baseRef, this.compare, newValue, this.headCommit, this.pusher);
    }

    public final ImmutablePushEvent withHeadCommit(@Nullable Optional<PushCommit> value) {
        if (Objects.equals(this.headCommit, value)) {
            return this;
        }
        return new ImmutablePushEvent(this.repository, this.sender, this.ref, this.before, this.after, this.created, this.deleted, this.forced, this.baseRef, this.compare, this.commits, value, this.pusher);
    }

    public final ImmutablePushEvent withPusher(@Nullable Author value) {
        if (this.pusher == value) {
            return this;
        }
        return new ImmutablePushEvent(this.repository, this.sender, this.ref, this.before, this.after, this.created, this.deleted, this.forced, this.baseRef, this.compare, this.commits, this.headCommit, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePushEvent && this.equalTo(0, (ImmutablePushEvent)another);
    }

    private boolean equalTo(int synthetic, ImmutablePushEvent another) {
        return Objects.equals(this.repository, another.repository) && Objects.equals(this.sender, another.sender) && Objects.equals(this.ref, another.ref) && Objects.equals(this.before, another.before) && Objects.equals(this.after, another.after) && Objects.equals(this.created, another.created) && Objects.equals(this.deleted, another.deleted) && Objects.equals(this.forced, another.forced) && Objects.equals(this.baseRef, another.baseRef) && Objects.equals(this.compare, another.compare) && Objects.equals(this.commits, another.commits) && Objects.equals(this.headCommit, another.headCommit) && Objects.equals(this.pusher, another.pusher);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.repository);
        h += (h << 5) + Objects.hashCode(this.sender);
        h += (h << 5) + Objects.hashCode(this.ref);
        h += (h << 5) + Objects.hashCode(this.before);
        h += (h << 5) + Objects.hashCode(this.after);
        h += (h << 5) + Objects.hashCode(this.created);
        h += (h << 5) + Objects.hashCode(this.deleted);
        h += (h << 5) + Objects.hashCode(this.forced);
        h += (h << 5) + Objects.hashCode(this.baseRef);
        h += (h << 5) + Objects.hashCode(this.compare);
        h += (h << 5) + Objects.hashCode(this.commits);
        h += (h << 5) + Objects.hashCode(this.headCommit);
        h += (h << 5) + Objects.hashCode(this.pusher);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("PushEvent{");
        if (this.repository != null) {
            builder.append("repository=").append(this.repository);
        }
        if (this.sender != null) {
            if (builder.length() > 10) {
                builder.append(", ");
            }
            builder.append("sender=").append(this.sender);
        }
        if (this.ref != null) {
            if (builder.length() > 10) {
                builder.append(", ");
            }
            builder.append("ref=").append(this.ref);
        }
        if (this.before != null) {
            if (builder.length() > 10) {
                builder.append(", ");
            }
            builder.append("before=").append(this.before);
        }
        if (this.after != null) {
            if (builder.length() > 10) {
                builder.append(", ");
            }
            builder.append("after=").append(this.after);
        }
        if (this.created != null) {
            if (builder.length() > 10) {
                builder.append(", ");
            }
            builder.append("created=").append(this.created);
        }
        if (this.deleted != null) {
            if (builder.length() > 10) {
                builder.append(", ");
            }
            builder.append("deleted=").append(this.deleted);
        }
        if (this.forced != null) {
            if (builder.length() > 10) {
                builder.append(", ");
            }
            builder.append("forced=").append(this.forced);
        }
        if (this.baseRef != null) {
            if (builder.length() > 10) {
                builder.append(", ");
            }
            builder.append("baseRef=").append(this.baseRef);
        }
        if (this.compare != null) {
            if (builder.length() > 10) {
                builder.append(", ");
            }
            builder.append("compare=").append(this.compare);
        }
        if (this.commits != null) {
            if (builder.length() > 10) {
                builder.append(", ");
            }
            builder.append("commits=").append(this.commits);
        }
        if (this.headCommit != null) {
            if (builder.length() > 10) {
                builder.append(", ");
            }
            builder.append("headCommit=").append(this.headCommit);
        }
        if (this.pusher != null) {
            if (builder.length() > 10) {
                builder.append(", ");
            }
            builder.append("pusher=").append(this.pusher);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePushEvent fromJson(Json json) {
        Builder builder = ImmutablePushEvent.builder();
        if (json.repository != null) {
            builder.repository(json.repository);
        }
        if (json.sender != null) {
            builder.sender(json.sender);
        }
        if (json.ref != null) {
            builder.ref(json.ref);
        }
        if (json.before != null) {
            builder.before(json.before);
        }
        if (json.after != null) {
            builder.after(json.after);
        }
        if (json.created != null) {
            builder.created(json.created);
        }
        if (json.deleted != null) {
            builder.deleted(json.deleted);
        }
        if (json.forced != null) {
            builder.forced(json.forced);
        }
        if (json.baseRef != null) {
            builder.baseRef(json.baseRef);
        }
        if (json.compare != null) {
            builder.compare(json.compare);
        }
        if (json.commits != null) {
            builder.addAllCommits(json.commits);
        }
        if (json.headCommit != null) {
            builder.headCommit(json.headCommit);
        }
        if (json.pusher != null) {
            builder.pusher(json.pusher);
        }
        return builder.build();
    }

    public static ImmutablePushEvent copyOf(PushEvent instance) {
        if (instance instanceof ImmutablePushEvent) {
            return (ImmutablePushEvent)instance;
        }
        return ImmutablePushEvent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="PushEvent", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private PushRepository repository;
        @Nullable
        private User sender;
        @Nullable
        private String ref;
        @Nullable
        private String before;
        @Nullable
        private String after;
        @Nullable
        private Boolean created;
        @Nullable
        private Boolean deleted;
        @Nullable
        private Boolean forced;
        @Nullable
        private String baseRef;
        @Nullable
        private String compare;
        private List<PushCommit> commits = null;
        @Nullable
        private Optional<PushCommit> headCommit;
        @Nullable
        private Author pusher;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(PushEvent instance) {
            Author pusherValue;
            Optional<PushCommit> headCommitValue;
            List<PushCommit> commitsValue;
            String compareValue;
            Optional<String> baseRefOptional;
            Boolean forcedValue;
            Boolean deletedValue;
            Boolean createdValue;
            String afterValue;
            String beforeValue;
            String refValue;
            User senderValue;
            Objects.requireNonNull(instance, "instance");
            PushRepository repositoryValue = instance.repository();
            if (repositoryValue != null) {
                this.repository(repositoryValue);
            }
            if ((senderValue = instance.sender()) != null) {
                this.sender(senderValue);
            }
            if ((refValue = instance.ref()) != null) {
                this.ref(refValue);
            }
            if ((beforeValue = instance.before()) != null) {
                this.before(beforeValue);
            }
            if ((afterValue = instance.after()) != null) {
                this.after(afterValue);
            }
            if ((createdValue = instance.created()) != null) {
                this.created(createdValue);
            }
            if ((deletedValue = instance.deleted()) != null) {
                this.deleted(deletedValue);
            }
            if ((forcedValue = instance.forced()) != null) {
                this.forced(forcedValue);
            }
            if ((baseRefOptional = instance.baseRef()).isPresent()) {
                this.baseRef(baseRefOptional);
            }
            if ((compareValue = instance.compare()) != null) {
                this.compare(compareValue);
            }
            if ((commitsValue = instance.commits()) != null) {
                this.addAllCommits(commitsValue);
            }
            if ((headCommitValue = instance.headCommit()) != null) {
                this.headCommit(headCommitValue);
            }
            if ((pusherValue = instance.pusher()) != null) {
                this.pusher(pusherValue);
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder repository(@Nullable PushRepository repository) {
            this.repository = repository;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder sender(@Nullable User sender) {
            this.sender = sender;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder ref(@Nullable String ref) {
            this.ref = ref;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder before(@Nullable String before) {
            this.before = before;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder after(@Nullable String after) {
            this.after = after;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder created(@Nullable Boolean created) {
            this.created = created;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder deleted(@Nullable Boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder forced(@Nullable Boolean forced) {
            this.forced = forced;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder baseRef(String baseRef) {
            this.baseRef = Objects.requireNonNull(baseRef, "baseRef");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder baseRef(Optional<String> baseRef) {
            this.baseRef = baseRef.orElse(null);
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder compare(@Nullable String compare) {
            this.compare = compare;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addCommits(PushCommit element) {
            if (this.commits == null) {
                this.commits = new ArrayList<PushCommit>();
            }
            this.commits.add(Objects.requireNonNull(element, "commits element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addCommits(PushCommit ... elements) {
            if (this.commits == null) {
                this.commits = new ArrayList<PushCommit>();
            }
            for (PushCommit element : elements) {
                this.commits.add(Objects.requireNonNull(element, "commits element"));
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder commits(@Nullable Iterable<? extends PushCommit> elements) {
            if (elements == null) {
                this.commits = null;
                return this;
            }
            this.commits = new ArrayList<PushCommit>();
            return this.addAllCommits(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllCommits(Iterable<? extends PushCommit> elements) {
            Objects.requireNonNull(elements, "commits element");
            if (this.commits == null) {
                this.commits = new ArrayList<PushCommit>();
            }
            for (PushCommit pushCommit : elements) {
                this.commits.add(Objects.requireNonNull(pushCommit, "commits element"));
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder headCommit(@Nullable Optional<PushCommit> headCommit) {
            this.headCommit = headCommit;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder pusher(@Nullable Author pusher) {
            this.pusher = pusher;
            return this;
        }

        public ImmutablePushEvent build() {
            return new ImmutablePushEvent(this.repository, this.sender, this.ref, this.before, this.after, this.created, this.deleted, this.forced, this.baseRef, this.compare, this.commits == null ? null : ImmutablePushEvent.createUnmodifiableList(true, this.commits), this.headCommit, this.pusher);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="PushEvent", generator="Immutables")
    static final class Json
    implements PushEvent {
        @Nullable
        PushRepository repository;
        @Nullable
        User sender;
        @Nullable
        String ref;
        @Nullable
        String before;
        @Nullable
        String after;
        @Nullable
        Boolean created;
        @Nullable
        Boolean deleted;
        @Nullable
        Boolean forced;
        @Nullable
        Optional<String> baseRef = Optional.empty();
        @Nullable
        String compare;
        @Nullable
        List<PushCommit> commits = null;
        @Nullable
        Optional<PushCommit> headCommit;
        @Nullable
        Author pusher;

        Json() {
        }

        @JsonProperty
        public void setRepository(@Nullable PushRepository repository) {
            this.repository = repository;
        }

        @JsonProperty
        public void setSender(@Nullable User sender) {
            this.sender = sender;
        }

        @JsonProperty
        public void setRef(@Nullable String ref) {
            this.ref = ref;
        }

        @JsonProperty
        public void setBefore(@Nullable String before) {
            this.before = before;
        }

        @JsonProperty
        public void setAfter(@Nullable String after) {
            this.after = after;
        }

        @JsonProperty
        public void setCreated(@Nullable Boolean created) {
            this.created = created;
        }

        @JsonProperty
        public void setDeleted(@Nullable Boolean deleted) {
            this.deleted = deleted;
        }

        @JsonProperty
        public void setForced(@Nullable Boolean forced) {
            this.forced = forced;
        }

        @JsonProperty
        public void setBaseRef(Optional<String> baseRef) {
            this.baseRef = baseRef;
        }

        @JsonProperty
        public void setCompare(@Nullable String compare) {
            this.compare = compare;
        }

        @JsonProperty
        public void setCommits(@Nullable List<PushCommit> commits) {
            this.commits = commits;
        }

        @JsonProperty
        public void setHeadCommit(@Nullable Optional<PushCommit> headCommit) {
            this.headCommit = headCommit;
        }

        @JsonProperty
        public void setPusher(@Nullable Author pusher) {
            this.pusher = pusher;
        }

        @Override
        public PushRepository repository() {
            throw new UnsupportedOperationException();
        }

        @Override
        public User sender() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String ref() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String before() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String after() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean created() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean deleted() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean forced() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> baseRef() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String compare() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<PushCommit> commits() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<PushCommit> headCommit() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Author pusher() {
            throw new UnsupportedOperationException();
        }
    }
}

