/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.activity.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.GitHubInstant;
import com.spotify.github.UpdateTracking;
import com.spotify.github.v3.User;
import com.spotify.github.v3.activity.events.BaseEvent;
import com.spotify.github.v3.activity.events.EventInstallation;
import com.spotify.github.v3.activity.events.StatusEvent;
import com.spotify.github.v3.repos.Branch;
import com.spotify.github.v3.repos.CommitItem;
import com.spotify.github.v3.repos.Repository;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="StatusEvent", generator="Immutables")
@Immutable
public final class ImmutableStatusEvent
implements StatusEvent {
    @Nullable
    private final Repository repository;
    @Nullable
    private final User sender;
    @Nullable
    private final EventInstallation eventInstallation;
    @Nullable
    private final GitHubInstant createdAt;
    @Nullable
    private final GitHubInstant updatedAt;
    @Nullable
    private final Long id;
    @Nullable
    private final String sha;
    @Nullable
    private final String name;
    @Nullable
    private final URI targetUrl;
    @Nullable
    private final String context;
    @Nullable
    private final Optional<String> description;
    @Nullable
    private final String state;
    @Nullable
    private final CommitItem commit;
    @Nullable
    private final List<Branch> branches;

    private ImmutableStatusEvent(@Nullable Repository repository, @Nullable User sender, @Nullable EventInstallation eventInstallation, @Nullable GitHubInstant createdAt, @Nullable GitHubInstant updatedAt, @Nullable Long id, @Nullable String sha, @Nullable String name, @Nullable URI targetUrl, @Nullable String context, @Nullable Optional<String> description, @Nullable String state, @Nullable CommitItem commit, @Nullable List<Branch> branches) {
        this.repository = repository;
        this.sender = sender;
        this.eventInstallation = eventInstallation;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.id = id;
        this.sha = sha;
        this.name = name;
        this.targetUrl = targetUrl;
        this.context = context;
        this.description = description;
        this.state = state;
        this.commit = commit;
        this.branches = branches;
    }

    @Override
    @JsonProperty
    @Nullable
    public Repository repository() {
        return this.repository;
    }

    @Override
    @JsonProperty
    @Nullable
    public User sender() {
        return this.sender;
    }

    @Override
    @JsonProperty(value="installation")
    @Nullable
    public EventInstallation eventInstallation() {
        return this.eventInstallation;
    }

    @Override
    @JsonProperty
    @Nullable
    public GitHubInstant createdAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty
    @Nullable
    public GitHubInstant updatedAt() {
        return this.updatedAt;
    }

    @Override
    @JsonProperty
    @Nullable
    public Long id() {
        return this.id;
    }

    @Override
    @JsonProperty
    @Nullable
    public String sha() {
        return this.sha;
    }

    @Override
    @JsonProperty
    @Nullable
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty
    public Optional<URI> targetUrl() {
        return Optional.ofNullable(this.targetUrl);
    }

    @Override
    @JsonProperty
    @Nullable
    public String context() {
        return this.context;
    }

    @Override
    @JsonProperty
    @Nullable
    public Optional<String> description() {
        return this.description;
    }

    @Override
    @JsonProperty
    @Nullable
    public String state() {
        return this.state;
    }

    @Override
    @JsonProperty
    @Nullable
    public CommitItem commit() {
        return this.commit;
    }

    @Override
    @JsonProperty
    @Nullable
    public List<Branch> branches() {
        return this.branches;
    }

    public final ImmutableStatusEvent withRepository(@Nullable Repository value) {
        if (this.repository == value) {
            return this;
        }
        return new ImmutableStatusEvent(value, this.sender, this.eventInstallation, this.createdAt, this.updatedAt, this.id, this.sha, this.name, this.targetUrl, this.context, this.description, this.state, this.commit, this.branches);
    }

    public final ImmutableStatusEvent withSender(@Nullable User value) {
        if (this.sender == value) {
            return this;
        }
        return new ImmutableStatusEvent(this.repository, value, this.eventInstallation, this.createdAt, this.updatedAt, this.id, this.sha, this.name, this.targetUrl, this.context, this.description, this.state, this.commit, this.branches);
    }

    public final ImmutableStatusEvent withEventInstallation(@Nullable EventInstallation value) {
        if (this.eventInstallation == value) {
            return this;
        }
        return new ImmutableStatusEvent(this.repository, this.sender, value, this.createdAt, this.updatedAt, this.id, this.sha, this.name, this.targetUrl, this.context, this.description, this.state, this.commit, this.branches);
    }

    public final ImmutableStatusEvent withCreatedAt(@Nullable GitHubInstant value) {
        if (this.createdAt == value) {
            return this;
        }
        return new ImmutableStatusEvent(this.repository, this.sender, this.eventInstallation, value, this.updatedAt, this.id, this.sha, this.name, this.targetUrl, this.context, this.description, this.state, this.commit, this.branches);
    }

    public final ImmutableStatusEvent withUpdatedAt(@Nullable GitHubInstant value) {
        if (this.updatedAt == value) {
            return this;
        }
        return new ImmutableStatusEvent(this.repository, this.sender, this.eventInstallation, this.createdAt, value, this.id, this.sha, this.name, this.targetUrl, this.context, this.description, this.state, this.commit, this.branches);
    }

    public final ImmutableStatusEvent withId(@Nullable Long value) {
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return new ImmutableStatusEvent(this.repository, this.sender, this.eventInstallation, this.createdAt, this.updatedAt, value, this.sha, this.name, this.targetUrl, this.context, this.description, this.state, this.commit, this.branches);
    }

    public final ImmutableStatusEvent withSha(@Nullable String value) {
        if (Objects.equals(this.sha, value)) {
            return this;
        }
        return new ImmutableStatusEvent(this.repository, this.sender, this.eventInstallation, this.createdAt, this.updatedAt, this.id, value, this.name, this.targetUrl, this.context, this.description, this.state, this.commit, this.branches);
    }

    public final ImmutableStatusEvent withName(@Nullable String value) {
        if (Objects.equals(this.name, value)) {
            return this;
        }
        return new ImmutableStatusEvent(this.repository, this.sender, this.eventInstallation, this.createdAt, this.updatedAt, this.id, this.sha, value, this.targetUrl, this.context, this.description, this.state, this.commit, this.branches);
    }

    public final ImmutableStatusEvent withTargetUrl(URI value) {
        URI newValue = Objects.requireNonNull(value, "targetUrl");
        if (this.targetUrl == newValue) {
            return this;
        }
        return new ImmutableStatusEvent(this.repository, this.sender, this.eventInstallation, this.createdAt, this.updatedAt, this.id, this.sha, this.name, newValue, this.context, this.description, this.state, this.commit, this.branches);
    }

    public final ImmutableStatusEvent withTargetUrl(Optional<? extends URI> optional) {
        URI value = optional.orElse(null);
        if (this.targetUrl == value) {
            return this;
        }
        return new ImmutableStatusEvent(this.repository, this.sender, this.eventInstallation, this.createdAt, this.updatedAt, this.id, this.sha, this.name, value, this.context, this.description, this.state, this.commit, this.branches);
    }

    public final ImmutableStatusEvent withContext(@Nullable String value) {
        if (Objects.equals(this.context, value)) {
            return this;
        }
        return new ImmutableStatusEvent(this.repository, this.sender, this.eventInstallation, this.createdAt, this.updatedAt, this.id, this.sha, this.name, this.targetUrl, value, this.description, this.state, this.commit, this.branches);
    }

    public final ImmutableStatusEvent withDescription(@Nullable Optional<String> value) {
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new ImmutableStatusEvent(this.repository, this.sender, this.eventInstallation, this.createdAt, this.updatedAt, this.id, this.sha, this.name, this.targetUrl, this.context, value, this.state, this.commit, this.branches);
    }

    public final ImmutableStatusEvent withState(@Nullable String value) {
        if (Objects.equals(this.state, value)) {
            return this;
        }
        return new ImmutableStatusEvent(this.repository, this.sender, this.eventInstallation, this.createdAt, this.updatedAt, this.id, this.sha, this.name, this.targetUrl, this.context, this.description, value, this.commit, this.branches);
    }

    public final ImmutableStatusEvent withCommit(@Nullable CommitItem value) {
        if (this.commit == value) {
            return this;
        }
        return new ImmutableStatusEvent(this.repository, this.sender, this.eventInstallation, this.createdAt, this.updatedAt, this.id, this.sha, this.name, this.targetUrl, this.context, this.description, this.state, value, this.branches);
    }

    public final ImmutableStatusEvent withBranches(Branch ... elements) {
        if (elements == null) {
            return new ImmutableStatusEvent(this.repository, this.sender, this.eventInstallation, this.createdAt, this.updatedAt, this.id, this.sha, this.name, this.targetUrl, this.context, this.description, this.state, this.commit, null);
        }
        List<Branch> newValue = Arrays.asList(elements) == null ? null : ImmutableStatusEvent.createUnmodifiableList(false, ImmutableStatusEvent.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableStatusEvent(this.repository, this.sender, this.eventInstallation, this.createdAt, this.updatedAt, this.id, this.sha, this.name, this.targetUrl, this.context, this.description, this.state, this.commit, newValue);
    }

    public final ImmutableStatusEvent withBranches(@Nullable Iterable<? extends Branch> elements) {
        if (this.branches == elements) {
            return this;
        }
        List<Branch> newValue = elements == null ? null : ImmutableStatusEvent.createUnmodifiableList(false, ImmutableStatusEvent.createSafeList(elements, true, false));
        return new ImmutableStatusEvent(this.repository, this.sender, this.eventInstallation, this.createdAt, this.updatedAt, this.id, this.sha, this.name, this.targetUrl, this.context, this.description, this.state, this.commit, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStatusEvent && this.equalTo(0, (ImmutableStatusEvent)another);
    }

    private boolean equalTo(int synthetic, ImmutableStatusEvent another) {
        return Objects.equals(this.repository, another.repository) && Objects.equals(this.sender, another.sender) && Objects.equals(this.eventInstallation, another.eventInstallation) && Objects.equals(this.createdAt, another.createdAt) && Objects.equals(this.updatedAt, another.updatedAt) && Objects.equals(this.id, another.id) && Objects.equals(this.sha, another.sha) && Objects.equals(this.name, another.name) && Objects.equals(this.targetUrl, another.targetUrl) && Objects.equals(this.context, another.context) && Objects.equals(this.description, another.description) && Objects.equals(this.state, another.state) && Objects.equals(this.commit, another.commit) && Objects.equals(this.branches, another.branches);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.repository);
        h += (h << 5) + Objects.hashCode(this.sender);
        h += (h << 5) + Objects.hashCode(this.eventInstallation);
        h += (h << 5) + Objects.hashCode(this.createdAt);
        h += (h << 5) + Objects.hashCode(this.updatedAt);
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + Objects.hashCode(this.sha);
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + Objects.hashCode(this.targetUrl);
        h += (h << 5) + Objects.hashCode(this.context);
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + Objects.hashCode(this.state);
        h += (h << 5) + Objects.hashCode(this.commit);
        h += (h << 5) + Objects.hashCode(this.branches);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("StatusEvent{");
        if (this.repository != null) {
            builder.append("repository=").append(this.repository);
        }
        if (this.sender != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("sender=").append(this.sender);
        }
        if (this.eventInstallation != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("eventInstallation=").append(this.eventInstallation);
        }
        if (this.createdAt != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("createdAt=").append(this.createdAt);
        }
        if (this.updatedAt != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("updatedAt=").append(this.updatedAt);
        }
        if (this.id != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("id=").append(this.id);
        }
        if (this.sha != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("sha=").append(this.sha);
        }
        if (this.name != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("name=").append(this.name);
        }
        if (this.targetUrl != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("targetUrl=").append(this.targetUrl);
        }
        if (this.context != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("context=").append(this.context);
        }
        if (this.description != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("description=").append(this.description);
        }
        if (this.state != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("state=").append(this.state);
        }
        if (this.commit != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("commit=").append(this.commit);
        }
        if (this.branches != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("branches=").append(this.branches);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableStatusEvent fromJson(Json json) {
        Builder builder = ImmutableStatusEvent.builder();
        if (json.repository != null) {
            builder.repository(json.repository);
        }
        if (json.sender != null) {
            builder.sender(json.sender);
        }
        if (json.eventInstallation != null) {
            builder.eventInstallation(json.eventInstallation);
        }
        if (json.createdAt != null) {
            builder.createdAt(json.createdAt);
        }
        if (json.updatedAt != null) {
            builder.updatedAt(json.updatedAt);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.sha != null) {
            builder.sha(json.sha);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.targetUrl != null) {
            builder.targetUrl(json.targetUrl);
        }
        if (json.context != null) {
            builder.context(json.context);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.state != null) {
            builder.state(json.state);
        }
        if (json.commit != null) {
            builder.commit(json.commit);
        }
        if (json.branches != null) {
            builder.addAllBranches(json.branches);
        }
        return builder.build();
    }

    public static ImmutableStatusEvent copyOf(StatusEvent instance) {
        if (instance instanceof ImmutableStatusEvent) {
            return (ImmutableStatusEvent)instance;
        }
        return ImmutableStatusEvent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="StatusEvent", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Repository repository;
        @Nullable
        private User sender;
        @Nullable
        private EventInstallation eventInstallation;
        @Nullable
        private GitHubInstant createdAt;
        @Nullable
        private GitHubInstant updatedAt;
        @Nullable
        private Long id;
        @Nullable
        private String sha;
        @Nullable
        private String name;
        @Nullable
        private URI targetUrl;
        @Nullable
        private String context;
        @Nullable
        private Optional<String> description;
        @Nullable
        private String state;
        @Nullable
        private CommitItem commit;
        private List<Branch> branches = null;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(BaseEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(UpdateTracking instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(StatusEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            EventInstallation eventInstallationValue;
            Object instance;
            long bits = 0L;
            if (object instanceof BaseEvent) {
                instance = (BaseEvent)object;
                if ((bits & 2L) == 0L) {
                    Repository repositoryValue = instance.repository();
                    if (repositoryValue != null) {
                        this.repository(repositoryValue);
                    }
                    bits |= 2L;
                }
                if ((bits & 8L) == 0L) {
                    User senderValue = instance.sender();
                    if (senderValue != null) {
                        this.sender(senderValue);
                    }
                    bits |= 8L;
                }
                if ((bits & 1L) == 0L) {
                    eventInstallationValue = instance.eventInstallation();
                    if (eventInstallationValue != null) {
                        this.eventInstallation(eventInstallationValue);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof UpdateTracking) {
                instance = (UpdateTracking)object;
                if ((bits & 4L) == 0L) {
                    GitHubInstant createdAtValue = instance.createdAt();
                    if (createdAtValue != null) {
                        this.createdAt(createdAtValue);
                    }
                    bits |= 4L;
                }
                if ((bits & 0x10L) == 0L) {
                    GitHubInstant updatedAtValue = instance.updatedAt();
                    if (updatedAtValue != null) {
                        this.updatedAt(updatedAtValue);
                    }
                    bits |= 0x10L;
                }
            }
            if (object instanceof StatusEvent) {
                Optional<URI> targetUrlOptional;
                String stateValue;
                Long idValue;
                String contextValue;
                String nameValue;
                String shaValue;
                List<Branch> branchesValue;
                Optional<String> descriptionValue;
                CommitItem commitValue;
                instance = (StatusEvent)object;
                if ((bits & 1L) == 0L) {
                    eventInstallationValue = instance.eventInstallation();
                    if (eventInstallationValue != null) {
                        this.eventInstallation(eventInstallationValue);
                    }
                    bits |= 1L;
                }
                if ((commitValue = instance.commit()) != null) {
                    this.commit(commitValue);
                }
                if ((descriptionValue = instance.description()) != null) {
                    this.description(descriptionValue);
                }
                if ((bits & 2L) == 0L) {
                    Repository repositoryValue = instance.repository();
                    if (repositoryValue != null) {
                        this.repository(repositoryValue);
                    }
                    bits |= 2L;
                }
                if ((branchesValue = instance.branches()) != null) {
                    this.addAllBranches(branchesValue);
                }
                if ((shaValue = instance.sha()) != null) {
                    this.sha(shaValue);
                }
                if ((bits & 4L) == 0L) {
                    GitHubInstant createdAtValue = instance.createdAt();
                    if (createdAtValue != null) {
                        this.createdAt(createdAtValue);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    User senderValue = instance.sender();
                    if (senderValue != null) {
                        this.sender(senderValue);
                    }
                    bits |= 8L;
                }
                if ((nameValue = instance.name()) != null) {
                    this.name(nameValue);
                }
                if ((contextValue = instance.context()) != null) {
                    this.context(contextValue);
                }
                if ((idValue = instance.id()) != null) {
                    this.id(idValue);
                }
                if ((stateValue = instance.state()) != null) {
                    this.state(stateValue);
                }
                if ((targetUrlOptional = instance.targetUrl()).isPresent()) {
                    this.targetUrl(targetUrlOptional);
                }
                if ((bits & 0x10L) == 0L) {
                    GitHubInstant updatedAtValue = instance.updatedAt();
                    if (updatedAtValue != null) {
                        this.updatedAt(updatedAtValue);
                    }
                    bits |= 0x10L;
                }
            }
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder repository(@Nullable Repository repository) {
            this.repository = repository;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder sender(@Nullable User sender) {
            this.sender = sender;
            return this;
        }

        @JsonProperty(value="installation")
        @CanIgnoreReturnValue
        public final Builder eventInstallation(@Nullable EventInstallation eventInstallation) {
            this.eventInstallation = eventInstallation;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder createdAt(@Nullable GitHubInstant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder updatedAt(@Nullable GitHubInstant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder id(@Nullable Long id) {
            this.id = id;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder sha(@Nullable String sha) {
            this.sha = sha;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder targetUrl(URI targetUrl) {
            this.targetUrl = Objects.requireNonNull(targetUrl, "targetUrl");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder targetUrl(Optional<? extends URI> targetUrl) {
            this.targetUrl = targetUrl.orElse(null);
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder context(@Nullable String context) {
            this.context = context;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder description(@Nullable Optional<String> description) {
            this.description = description;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder state(@Nullable String state) {
            this.state = state;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder commit(@Nullable CommitItem commit) {
            this.commit = commit;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addBranches(Branch element) {
            if (this.branches == null) {
                this.branches = new ArrayList<Branch>();
            }
            this.branches.add(Objects.requireNonNull(element, "branches element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addBranches(Branch ... elements) {
            if (this.branches == null) {
                this.branches = new ArrayList<Branch>();
            }
            for (Branch element : elements) {
                this.branches.add(Objects.requireNonNull(element, "branches element"));
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder branches(@Nullable Iterable<? extends Branch> elements) {
            if (elements == null) {
                this.branches = null;
                return this;
            }
            this.branches = new ArrayList<Branch>();
            return this.addAllBranches(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllBranches(Iterable<? extends Branch> elements) {
            Objects.requireNonNull(elements, "branches element");
            if (this.branches == null) {
                this.branches = new ArrayList<Branch>();
            }
            for (Branch branch : elements) {
                this.branches.add(Objects.requireNonNull(branch, "branches element"));
            }
            return this;
        }

        public ImmutableStatusEvent build() {
            return new ImmutableStatusEvent(this.repository, this.sender, this.eventInstallation, this.createdAt, this.updatedAt, this.id, this.sha, this.name, this.targetUrl, this.context, this.description, this.state, this.commit, this.branches == null ? null : ImmutableStatusEvent.createUnmodifiableList(true, this.branches));
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="StatusEvent", generator="Immutables")
    static final class Json
    implements StatusEvent {
        @Nullable
        Repository repository;
        @Nullable
        User sender;
        @Nullable
        EventInstallation eventInstallation;
        @Nullable
        GitHubInstant createdAt;
        @Nullable
        GitHubInstant updatedAt;
        @Nullable
        Long id;
        @Nullable
        String sha;
        @Nullable
        String name;
        @Nullable
        Optional<URI> targetUrl = Optional.empty();
        @Nullable
        String context;
        @Nullable
        Optional<String> description;
        @Nullable
        String state;
        @Nullable
        CommitItem commit;
        @Nullable
        List<Branch> branches = null;

        Json() {
        }

        @JsonProperty
        public void setRepository(@Nullable Repository repository) {
            this.repository = repository;
        }

        @JsonProperty
        public void setSender(@Nullable User sender) {
            this.sender = sender;
        }

        @JsonProperty(value="installation")
        public void setEventInstallation(@Nullable EventInstallation eventInstallation) {
            this.eventInstallation = eventInstallation;
        }

        @JsonProperty
        public void setCreatedAt(@Nullable GitHubInstant createdAt) {
            this.createdAt = createdAt;
        }

        @JsonProperty
        public void setUpdatedAt(@Nullable GitHubInstant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @JsonProperty
        public void setId(@Nullable Long id) {
            this.id = id;
        }

        @JsonProperty
        public void setSha(@Nullable String sha) {
            this.sha = sha;
        }

        @JsonProperty
        public void setName(@Nullable String name) {
            this.name = name;
        }

        @JsonProperty
        public void setTargetUrl(Optional<URI> targetUrl) {
            this.targetUrl = targetUrl;
        }

        @JsonProperty
        public void setContext(@Nullable String context) {
            this.context = context;
        }

        @JsonProperty
        public void setDescription(@Nullable Optional<String> description) {
            this.description = description;
        }

        @JsonProperty
        public void setState(@Nullable String state) {
            this.state = state;
        }

        @JsonProperty
        public void setCommit(@Nullable CommitItem commit) {
            this.commit = commit;
        }

        @JsonProperty
        public void setBranches(@Nullable List<Branch> branches) {
            this.branches = branches;
        }

        @Override
        public Repository repository() {
            throw new UnsupportedOperationException();
        }

        @Override
        public User sender() {
            throw new UnsupportedOperationException();
        }

        @Override
        public EventInstallation eventInstallation() {
            throw new UnsupportedOperationException();
        }

        @Override
        public GitHubInstant createdAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public GitHubInstant updatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String sha() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<URI> targetUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String context() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> description() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String state() {
            throw new UnsupportedOperationException();
        }

        @Override
        public CommitItem commit() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Branch> branches() {
            throw new UnsupportedOperationException();
        }
    }
}

