/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.apps;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.apps.InstallationRepositoriesResponse;
import com.spotify.github.v3.repos.Repository;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="InstallationRepositoriesResponse", generator="Immutables")
@Immutable
public final class ImmutableInstallationRepositoriesResponse
implements InstallationRepositoriesResponse {
    private final int totalCount;
    private final List<Repository> repositories;

    private ImmutableInstallationRepositoriesResponse(int totalCount, List<Repository> repositories) {
        this.totalCount = totalCount;
        this.repositories = repositories;
    }

    @Override
    @JsonProperty
    public int totalCount() {
        return this.totalCount;
    }

    @Override
    @JsonProperty
    public List<Repository> repositories() {
        return this.repositories;
    }

    public final ImmutableInstallationRepositoriesResponse withTotalCount(int value) {
        if (this.totalCount == value) {
            return this;
        }
        return new ImmutableInstallationRepositoriesResponse(value, this.repositories);
    }

    public final ImmutableInstallationRepositoriesResponse withRepositories(Repository ... elements) {
        List<Repository> newValue = ImmutableInstallationRepositoriesResponse.createUnmodifiableList(false, ImmutableInstallationRepositoriesResponse.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableInstallationRepositoriesResponse(this.totalCount, newValue);
    }

    public final ImmutableInstallationRepositoriesResponse withRepositories(Iterable<? extends Repository> elements) {
        if (this.repositories == elements) {
            return this;
        }
        List<Repository> newValue = ImmutableInstallationRepositoriesResponse.createUnmodifiableList(false, ImmutableInstallationRepositoriesResponse.createSafeList(elements, true, false));
        return new ImmutableInstallationRepositoriesResponse(this.totalCount, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInstallationRepositoriesResponse && this.equalTo(0, (ImmutableInstallationRepositoriesResponse)another);
    }

    private boolean equalTo(int synthetic, ImmutableInstallationRepositoriesResponse another) {
        return this.totalCount == another.totalCount && this.repositories.equals(another.repositories);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.totalCount;
        h += (h << 5) + this.repositories.hashCode();
        return h;
    }

    public String toString() {
        return "InstallationRepositoriesResponse{totalCount=" + this.totalCount + ", repositories=" + this.repositories + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableInstallationRepositoriesResponse fromJson(Json json) {
        Builder builder = ImmutableInstallationRepositoriesResponse.builder();
        if (json.totalCountIsSet) {
            builder.totalCount(json.totalCount);
        }
        if (json.repositories != null) {
            builder.addAllRepositories(json.repositories);
        }
        return builder.build();
    }

    public static ImmutableInstallationRepositoriesResponse copyOf(InstallationRepositoriesResponse instance) {
        if (instance instanceof ImmutableInstallationRepositoriesResponse) {
            return (ImmutableInstallationRepositoriesResponse)instance;
        }
        return ImmutableInstallationRepositoriesResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="InstallationRepositoriesResponse", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TOTAL_COUNT = 1L;
        private long initBits = 1L;
        private int totalCount;
        private List<Repository> repositories = new ArrayList<Repository>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(InstallationRepositoriesResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.totalCount(instance.totalCount());
            this.addAllRepositories(instance.repositories());
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder totalCount(int totalCount) {
            this.totalCount = totalCount;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRepositories(Repository element) {
            this.repositories.add(Objects.requireNonNull(element, "repositories element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRepositories(Repository ... elements) {
            for (Repository element : elements) {
                this.repositories.add(Objects.requireNonNull(element, "repositories element"));
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder repositories(Iterable<? extends Repository> elements) {
            this.repositories.clear();
            return this.addAllRepositories(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllRepositories(Iterable<? extends Repository> elements) {
            for (Repository repository : elements) {
                this.repositories.add(Objects.requireNonNull(repository, "repositories element"));
            }
            return this;
        }

        public ImmutableInstallationRepositoriesResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInstallationRepositoriesResponse(this.totalCount, ImmutableInstallationRepositoriesResponse.createUnmodifiableList(true, this.repositories));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("totalCount");
            }
            return "Cannot build InstallationRepositoriesResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="InstallationRepositoriesResponse", generator="Immutables")
    static final class Json
    implements InstallationRepositoriesResponse {
        int totalCount;
        boolean totalCountIsSet;
        @Nullable
        List<Repository> repositories = Collections.emptyList();

        Json() {
        }

        @JsonProperty
        public void setTotalCount(int totalCount) {
            this.totalCount = totalCount;
            this.totalCountIsSet = true;
        }

        @JsonProperty
        public void setRepositories(List<Repository> repositories) {
            this.repositories = repositories;
        }

        @Override
        public int totalCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Repository> repositories() {
            throw new UnsupportedOperationException();
        }
    }
}

