/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.checks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.checks.App;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="App", generator="Immutables")
@Immutable
public final class ImmutableApp
implements App {
    private final Integer id;
    @Nullable
    private final String slug;
    private final String name;
    private final String description;
    private final String externalUrl;
    private final String htmlUrl;
    private final ZonedDateTime createdAt;
    private final ZonedDateTime updatedAt;
    private final Map<String, String> permissions;
    private final List<String> events;
    @Nullable
    private final Integer installationsCount;

    private ImmutableApp(Integer id, @Nullable String slug, String name, String description, String externalUrl, String htmlUrl, ZonedDateTime createdAt, ZonedDateTime updatedAt, Map<String, String> permissions, List<String> events, @Nullable Integer installationsCount) {
        this.id = id;
        this.slug = slug;
        this.name = name;
        this.description = description;
        this.externalUrl = externalUrl;
        this.htmlUrl = htmlUrl;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.permissions = permissions;
        this.events = events;
        this.installationsCount = installationsCount;
    }

    @Override
    @JsonProperty
    public Integer id() {
        return this.id;
    }

    @Override
    @JsonProperty
    public Optional<String> slug() {
        return Optional.ofNullable(this.slug);
    }

    @Override
    @JsonProperty
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty
    public String description() {
        return this.description;
    }

    @Override
    @JsonProperty
    public String externalUrl() {
        return this.externalUrl;
    }

    @Override
    @JsonProperty
    public String htmlUrl() {
        return this.htmlUrl;
    }

    @Override
    @JsonProperty
    public ZonedDateTime createdAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty
    public ZonedDateTime updatedAt() {
        return this.updatedAt;
    }

    @Override
    @JsonProperty
    public Map<String, String> permissions() {
        return this.permissions;
    }

    @Override
    @JsonProperty
    public List<String> events() {
        return this.events;
    }

    @Override
    @JsonProperty
    public Optional<Integer> installationsCount() {
        return Optional.ofNullable(this.installationsCount);
    }

    public final ImmutableApp withId(Integer value) {
        Integer newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableApp(newValue, this.slug, this.name, this.description, this.externalUrl, this.htmlUrl, this.createdAt, this.updatedAt, this.permissions, this.events, this.installationsCount);
    }

    public final ImmutableApp withSlug(String value) {
        String newValue = Objects.requireNonNull(value, "slug");
        if (Objects.equals(this.slug, newValue)) {
            return this;
        }
        return new ImmutableApp(this.id, newValue, this.name, this.description, this.externalUrl, this.htmlUrl, this.createdAt, this.updatedAt, this.permissions, this.events, this.installationsCount);
    }

    public final ImmutableApp withSlug(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.slug, value)) {
            return this;
        }
        return new ImmutableApp(this.id, value, this.name, this.description, this.externalUrl, this.htmlUrl, this.createdAt, this.updatedAt, this.permissions, this.events, this.installationsCount);
    }

    public final ImmutableApp withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableApp(this.id, this.slug, newValue, this.description, this.externalUrl, this.htmlUrl, this.createdAt, this.updatedAt, this.permissions, this.events, this.installationsCount);
    }

    public final ImmutableApp withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (this.description.equals(newValue)) {
            return this;
        }
        return new ImmutableApp(this.id, this.slug, this.name, newValue, this.externalUrl, this.htmlUrl, this.createdAt, this.updatedAt, this.permissions, this.events, this.installationsCount);
    }

    public final ImmutableApp withExternalUrl(String value) {
        String newValue = Objects.requireNonNull(value, "externalUrl");
        if (this.externalUrl.equals(newValue)) {
            return this;
        }
        return new ImmutableApp(this.id, this.slug, this.name, this.description, newValue, this.htmlUrl, this.createdAt, this.updatedAt, this.permissions, this.events, this.installationsCount);
    }

    public final ImmutableApp withHtmlUrl(String value) {
        String newValue = Objects.requireNonNull(value, "htmlUrl");
        if (this.htmlUrl.equals(newValue)) {
            return this;
        }
        return new ImmutableApp(this.id, this.slug, this.name, this.description, this.externalUrl, newValue, this.createdAt, this.updatedAt, this.permissions, this.events, this.installationsCount);
    }

    public final ImmutableApp withCreatedAt(ZonedDateTime value) {
        if (this.createdAt == value) {
            return this;
        }
        ZonedDateTime newValue = Objects.requireNonNull(value, "createdAt");
        return new ImmutableApp(this.id, this.slug, this.name, this.description, this.externalUrl, this.htmlUrl, newValue, this.updatedAt, this.permissions, this.events, this.installationsCount);
    }

    public final ImmutableApp withUpdatedAt(ZonedDateTime value) {
        if (this.updatedAt == value) {
            return this;
        }
        ZonedDateTime newValue = Objects.requireNonNull(value, "updatedAt");
        return new ImmutableApp(this.id, this.slug, this.name, this.description, this.externalUrl, this.htmlUrl, this.createdAt, newValue, this.permissions, this.events, this.installationsCount);
    }

    public final ImmutableApp withPermissions(Map<String, ? extends String> entries) {
        if (this.permissions == entries) {
            return this;
        }
        Map<String, String> newValue = ImmutableApp.createUnmodifiableMap(true, false, entries);
        return new ImmutableApp(this.id, this.slug, this.name, this.description, this.externalUrl, this.htmlUrl, this.createdAt, this.updatedAt, newValue, this.events, this.installationsCount);
    }

    public final ImmutableApp withEvents(String ... elements) {
        List<String> newValue = ImmutableApp.createUnmodifiableList(false, ImmutableApp.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableApp(this.id, this.slug, this.name, this.description, this.externalUrl, this.htmlUrl, this.createdAt, this.updatedAt, this.permissions, newValue, this.installationsCount);
    }

    public final ImmutableApp withEvents(Iterable<String> elements) {
        if (this.events == elements) {
            return this;
        }
        List<String> newValue = ImmutableApp.createUnmodifiableList(false, ImmutableApp.createSafeList(elements, true, false));
        return new ImmutableApp(this.id, this.slug, this.name, this.description, this.externalUrl, this.htmlUrl, this.createdAt, this.updatedAt, this.permissions, newValue, this.installationsCount);
    }

    public final ImmutableApp withInstallationsCount(int value) {
        Integer newValue = value;
        if (Objects.equals(this.installationsCount, newValue)) {
            return this;
        }
        return new ImmutableApp(this.id, this.slug, this.name, this.description, this.externalUrl, this.htmlUrl, this.createdAt, this.updatedAt, this.permissions, this.events, newValue);
    }

    public final ImmutableApp withInstallationsCount(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.installationsCount, value)) {
            return this;
        }
        return new ImmutableApp(this.id, this.slug, this.name, this.description, this.externalUrl, this.htmlUrl, this.createdAt, this.updatedAt, this.permissions, this.events, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableApp && this.equalTo(0, (ImmutableApp)another);
    }

    private boolean equalTo(int synthetic, ImmutableApp another) {
        return this.id.equals(another.id) && Objects.equals(this.slug, another.slug) && this.name.equals(another.name) && this.description.equals(another.description) && this.externalUrl.equals(another.externalUrl) && this.htmlUrl.equals(another.htmlUrl) && this.createdAt.equals(another.createdAt) && this.updatedAt.equals(another.updatedAt) && this.permissions.equals(another.permissions) && this.events.equals(another.events) && Objects.equals(this.installationsCount, another.installationsCount);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + Objects.hashCode(this.slug);
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.description.hashCode();
        h += (h << 5) + this.externalUrl.hashCode();
        h += (h << 5) + this.htmlUrl.hashCode();
        h += (h << 5) + this.createdAt.hashCode();
        h += (h << 5) + this.updatedAt.hashCode();
        h += (h << 5) + this.permissions.hashCode();
        h += (h << 5) + this.events.hashCode();
        h += (h << 5) + Objects.hashCode(this.installationsCount);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("App{");
        builder.append("id=").append(this.id);
        if (this.slug != null) {
            builder.append(", ");
            builder.append("slug=").append(this.slug);
        }
        builder.append(", ");
        builder.append("name=").append(this.name);
        builder.append(", ");
        builder.append("description=").append(this.description);
        builder.append(", ");
        builder.append("externalUrl=").append(this.externalUrl);
        builder.append(", ");
        builder.append("htmlUrl=").append(this.htmlUrl);
        builder.append(", ");
        builder.append("createdAt=").append(this.createdAt);
        builder.append(", ");
        builder.append("updatedAt=").append(this.updatedAt);
        builder.append(", ");
        builder.append("permissions=").append(this.permissions);
        builder.append(", ");
        builder.append("events=").append(this.events);
        if (this.installationsCount != null) {
            builder.append(", ");
            builder.append("installationsCount=").append(this.installationsCount);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableApp fromJson(Json json) {
        Builder builder = ImmutableApp.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.slug != null) {
            builder.slug(json.slug);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.externalUrl != null) {
            builder.externalUrl(json.externalUrl);
        }
        if (json.htmlUrl != null) {
            builder.htmlUrl(json.htmlUrl);
        }
        if (json.createdAt != null) {
            builder.createdAt(json.createdAt);
        }
        if (json.updatedAt != null) {
            builder.updatedAt(json.updatedAt);
        }
        if (json.permissions != null) {
            builder.putAllPermissions(json.permissions);
        }
        if (json.events != null) {
            builder.addAllEvents(json.events);
        }
        if (json.installationsCount != null) {
            builder.installationsCount(json.installationsCount);
        }
        return builder.build();
    }

    public static ImmutableApp copyOf(App instance) {
        if (instance instanceof ImmutableApp) {
            return (ImmutableApp)instance;
        }
        return ImmutableApp.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="App", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long INIT_BIT_DESCRIPTION = 4L;
        private static final long INIT_BIT_EXTERNAL_URL = 8L;
        private static final long INIT_BIT_HTML_URL = 16L;
        private static final long INIT_BIT_CREATED_AT = 32L;
        private static final long INIT_BIT_UPDATED_AT = 64L;
        private long initBits = 127L;
        @Nullable
        private Integer id;
        @Nullable
        private String slug;
        @Nullable
        private String name;
        @Nullable
        private String description;
        @Nullable
        private String externalUrl;
        @Nullable
        private String htmlUrl;
        @Nullable
        private ZonedDateTime createdAt;
        @Nullable
        private ZonedDateTime updatedAt;
        private Map<String, String> permissions = new LinkedHashMap<String, String>();
        private List<String> events = new ArrayList<String>();
        @Nullable
        private Integer installationsCount;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(App instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            Optional<String> slugOptional = instance.slug();
            if (slugOptional.isPresent()) {
                this.slug(slugOptional);
            }
            this.name(instance.name());
            this.description(instance.description());
            this.externalUrl(instance.externalUrl());
            this.htmlUrl(instance.htmlUrl());
            this.createdAt(instance.createdAt());
            this.updatedAt(instance.updatedAt());
            this.putAllPermissions(instance.permissions());
            this.addAllEvents(instance.events());
            Optional<Integer> installationsCountOptional = instance.installationsCount();
            if (installationsCountOptional.isPresent()) {
                this.installationsCount(installationsCountOptional);
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder id(Integer id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder slug(String slug) {
            this.slug = Objects.requireNonNull(slug, "slug");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder slug(Optional<String> slug) {
            this.slug = slug.orElse(null);
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder externalUrl(String externalUrl) {
            this.externalUrl = Objects.requireNonNull(externalUrl, "externalUrl");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder htmlUrl(String htmlUrl) {
            this.htmlUrl = Objects.requireNonNull(htmlUrl, "htmlUrl");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder createdAt(ZonedDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder updatedAt(ZonedDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putPermissions(String key, String value) {
            this.permissions.put(Objects.requireNonNull(key, "permissions key"), value == null ? Objects.requireNonNull(value, "permissions value for key: " + key) : value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putPermissions(Map.Entry<String, ? extends String> entry) {
            String v;
            String k = entry.getKey();
            this.permissions.put(Objects.requireNonNull(k, "permissions key"), (v = entry.getValue()) == null ? Objects.requireNonNull(v, "permissions value for key: " + k) : v);
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder permissions(Map<String, ? extends String> entries) {
            this.permissions.clear();
            return this.putAllPermissions(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllPermissions(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String v;
                String k = e.getKey();
                this.permissions.put(Objects.requireNonNull(k, "permissions key"), (v = e.getValue()) == null ? Objects.requireNonNull(v, "permissions value for key: " + k) : v);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addEvents(String element) {
            this.events.add(Objects.requireNonNull(element, "events element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addEvents(String ... elements) {
            for (String element : elements) {
                this.events.add(Objects.requireNonNull(element, "events element"));
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder events(Iterable<String> elements) {
            this.events.clear();
            return this.addAllEvents(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllEvents(Iterable<String> elements) {
            for (String element : elements) {
                this.events.add(Objects.requireNonNull(element, "events element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder installationsCount(int installationsCount) {
            this.installationsCount = installationsCount;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder installationsCount(Optional<Integer> installationsCount) {
            this.installationsCount = installationsCount.orElse(null);
            return this;
        }

        public ImmutableApp build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableApp(this.id, this.slug, this.name, this.description, this.externalUrl, this.htmlUrl, this.createdAt, this.updatedAt, ImmutableApp.createUnmodifiableMap(false, false, this.permissions), ImmutableApp.createUnmodifiableList(true, this.events), this.installationsCount);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("description");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("externalUrl");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("htmlUrl");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("createdAt");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("updatedAt");
            }
            return "Cannot build App, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="App", generator="Immutables")
    static final class Json
    implements App {
        @Nullable
        Integer id;
        @Nullable
        Optional<String> slug = Optional.empty();
        @Nullable
        String name;
        @Nullable
        String description;
        @Nullable
        String externalUrl;
        @Nullable
        String htmlUrl;
        @Nullable
        ZonedDateTime createdAt;
        @Nullable
        ZonedDateTime updatedAt;
        @Nullable
        Map<String, String> permissions = Collections.emptyMap();
        @Nullable
        List<String> events = Collections.emptyList();
        @Nullable
        Optional<Integer> installationsCount = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setId(Integer id) {
            this.id = id;
        }

        @JsonProperty
        public void setSlug(Optional<String> slug) {
            this.slug = slug;
        }

        @JsonProperty
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty
        public void setExternalUrl(String externalUrl) {
            this.externalUrl = externalUrl;
        }

        @JsonProperty
        public void setHtmlUrl(String htmlUrl) {
            this.htmlUrl = htmlUrl;
        }

        @JsonProperty
        public void setCreatedAt(ZonedDateTime createdAt) {
            this.createdAt = createdAt;
        }

        @JsonProperty
        public void setUpdatedAt(ZonedDateTime updatedAt) {
            this.updatedAt = updatedAt;
        }

        @JsonProperty
        public void setPermissions(Map<String, String> permissions) {
            this.permissions = permissions;
        }

        @JsonProperty
        public void setEvents(List<String> events) {
            this.events = events;
        }

        @JsonProperty
        public void setInstallationsCount(Optional<Integer> installationsCount) {
            this.installationsCount = installationsCount;
        }

        @Override
        public Integer id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> slug() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String description() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String externalUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String htmlUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ZonedDateTime createdAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ZonedDateTime updatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, String> permissions() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> events() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> installationsCount() {
            throw new UnsupportedOperationException();
        }
    }
}

