/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.checks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.checks.CheckRunAction;
import com.spotify.github.v3.checks.CheckRunBase;
import com.spotify.github.v3.checks.CheckRunConclusion;
import com.spotify.github.v3.checks.CheckRunOutput;
import com.spotify.github.v3.checks.CheckRunRequest;
import com.spotify.github.v3.checks.CheckRunStatus;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CheckRunRequest", generator="Immutables")
@Immutable
public final class ImmutableCheckRunRequest
implements CheckRunRequest {
    private final String headSha;
    private final String name;
    private final CheckRunStatus status;
    @Nullable
    private final CheckRunConclusion conclusion;
    @Nullable
    private final ZonedDateTime startedAt;
    @Nullable
    private final ZonedDateTime completedAt;
    @Nullable
    private final String externalId;
    @Nullable
    private final String detailsUrl;
    @Nullable
    private final CheckRunOutput output;
    private final List<CheckRunAction> actions;

    private ImmutableCheckRunRequest(String headSha, String name, CheckRunStatus status, @Nullable CheckRunConclusion conclusion, @Nullable ZonedDateTime startedAt, @Nullable ZonedDateTime completedAt, @Nullable String externalId, @Nullable String detailsUrl, @Nullable CheckRunOutput output, List<CheckRunAction> actions) {
        this.headSha = headSha;
        this.name = name;
        this.status = status;
        this.conclusion = conclusion;
        this.startedAt = startedAt;
        this.completedAt = completedAt;
        this.externalId = externalId;
        this.detailsUrl = detailsUrl;
        this.output = output;
        this.actions = actions;
    }

    @Override
    @JsonProperty
    public String headSha() {
        return this.headSha;
    }

    @Override
    @JsonProperty
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty
    public CheckRunStatus status() {
        return this.status;
    }

    @Override
    @JsonProperty
    public Optional<CheckRunConclusion> conclusion() {
        return Optional.ofNullable(this.conclusion);
    }

    @Override
    @JsonProperty
    public Optional<ZonedDateTime> startedAt() {
        return Optional.ofNullable(this.startedAt);
    }

    @Override
    @JsonProperty
    public Optional<ZonedDateTime> completedAt() {
        return Optional.ofNullable(this.completedAt);
    }

    @Override
    @JsonProperty
    public Optional<String> externalId() {
        return Optional.ofNullable(this.externalId);
    }

    @Override
    @JsonProperty
    public Optional<String> detailsUrl() {
        return Optional.ofNullable(this.detailsUrl);
    }

    @Override
    @JsonProperty
    public Optional<CheckRunOutput> output() {
        return Optional.ofNullable(this.output);
    }

    @Override
    @JsonProperty
    public List<CheckRunAction> actions() {
        return this.actions;
    }

    public final ImmutableCheckRunRequest withHeadSha(String value) {
        String newValue = Objects.requireNonNull(value, "headSha");
        if (this.headSha.equals(newValue)) {
            return this;
        }
        return new ImmutableCheckRunRequest(newValue, this.name, this.status, this.conclusion, this.startedAt, this.completedAt, this.externalId, this.detailsUrl, this.output, this.actions);
    }

    public final ImmutableCheckRunRequest withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableCheckRunRequest(this.headSha, newValue, this.status, this.conclusion, this.startedAt, this.completedAt, this.externalId, this.detailsUrl, this.output, this.actions);
    }

    public final ImmutableCheckRunRequest withStatus(CheckRunStatus value) {
        CheckRunStatus newValue = Objects.requireNonNull(value, "status");
        if (this.status == newValue) {
            return this;
        }
        return new ImmutableCheckRunRequest(this.headSha, this.name, newValue, this.conclusion, this.startedAt, this.completedAt, this.externalId, this.detailsUrl, this.output, this.actions);
    }

    public final ImmutableCheckRunRequest withConclusion(CheckRunConclusion value) {
        CheckRunConclusion newValue = Objects.requireNonNull(value, "conclusion");
        if (this.conclusion == newValue) {
            return this;
        }
        return new ImmutableCheckRunRequest(this.headSha, this.name, this.status, newValue, this.startedAt, this.completedAt, this.externalId, this.detailsUrl, this.output, this.actions);
    }

    public final ImmutableCheckRunRequest withConclusion(Optional<? extends CheckRunConclusion> optional) {
        CheckRunConclusion value = optional.orElse(null);
        if (this.conclusion == value) {
            return this;
        }
        return new ImmutableCheckRunRequest(this.headSha, this.name, this.status, value, this.startedAt, this.completedAt, this.externalId, this.detailsUrl, this.output, this.actions);
    }

    public final ImmutableCheckRunRequest withStartedAt(ZonedDateTime value) {
        ZonedDateTime newValue = Objects.requireNonNull(value, "startedAt");
        if (this.startedAt == newValue) {
            return this;
        }
        return new ImmutableCheckRunRequest(this.headSha, this.name, this.status, this.conclusion, newValue, this.completedAt, this.externalId, this.detailsUrl, this.output, this.actions);
    }

    public final ImmutableCheckRunRequest withStartedAt(Optional<? extends ZonedDateTime> optional) {
        ZonedDateTime value = optional.orElse(null);
        if (this.startedAt == value) {
            return this;
        }
        return new ImmutableCheckRunRequest(this.headSha, this.name, this.status, this.conclusion, value, this.completedAt, this.externalId, this.detailsUrl, this.output, this.actions);
    }

    public final ImmutableCheckRunRequest withCompletedAt(ZonedDateTime value) {
        ZonedDateTime newValue = Objects.requireNonNull(value, "completedAt");
        if (this.completedAt == newValue) {
            return this;
        }
        return new ImmutableCheckRunRequest(this.headSha, this.name, this.status, this.conclusion, this.startedAt, newValue, this.externalId, this.detailsUrl, this.output, this.actions);
    }

    public final ImmutableCheckRunRequest withCompletedAt(Optional<? extends ZonedDateTime> optional) {
        ZonedDateTime value = optional.orElse(null);
        if (this.completedAt == value) {
            return this;
        }
        return new ImmutableCheckRunRequest(this.headSha, this.name, this.status, this.conclusion, this.startedAt, value, this.externalId, this.detailsUrl, this.output, this.actions);
    }

    public final ImmutableCheckRunRequest withExternalId(String value) {
        String newValue = Objects.requireNonNull(value, "externalId");
        if (Objects.equals(this.externalId, newValue)) {
            return this;
        }
        return new ImmutableCheckRunRequest(this.headSha, this.name, this.status, this.conclusion, this.startedAt, this.completedAt, newValue, this.detailsUrl, this.output, this.actions);
    }

    public final ImmutableCheckRunRequest withExternalId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.externalId, value)) {
            return this;
        }
        return new ImmutableCheckRunRequest(this.headSha, this.name, this.status, this.conclusion, this.startedAt, this.completedAt, value, this.detailsUrl, this.output, this.actions);
    }

    public final ImmutableCheckRunRequest withDetailsUrl(String value) {
        String newValue = Objects.requireNonNull(value, "detailsUrl");
        if (Objects.equals(this.detailsUrl, newValue)) {
            return this;
        }
        return new ImmutableCheckRunRequest(this.headSha, this.name, this.status, this.conclusion, this.startedAt, this.completedAt, this.externalId, newValue, this.output, this.actions);
    }

    public final ImmutableCheckRunRequest withDetailsUrl(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.detailsUrl, value)) {
            return this;
        }
        return new ImmutableCheckRunRequest(this.headSha, this.name, this.status, this.conclusion, this.startedAt, this.completedAt, this.externalId, value, this.output, this.actions);
    }

    public final ImmutableCheckRunRequest withOutput(CheckRunOutput value) {
        CheckRunOutput newValue = Objects.requireNonNull(value, "output");
        if (this.output == newValue) {
            return this;
        }
        return new ImmutableCheckRunRequest(this.headSha, this.name, this.status, this.conclusion, this.startedAt, this.completedAt, this.externalId, this.detailsUrl, newValue, this.actions);
    }

    public final ImmutableCheckRunRequest withOutput(Optional<? extends CheckRunOutput> optional) {
        CheckRunOutput value = optional.orElse(null);
        if (this.output == value) {
            return this;
        }
        return new ImmutableCheckRunRequest(this.headSha, this.name, this.status, this.conclusion, this.startedAt, this.completedAt, this.externalId, this.detailsUrl, value, this.actions);
    }

    public final ImmutableCheckRunRequest withActions(CheckRunAction ... elements) {
        List<CheckRunAction> newValue = ImmutableCheckRunRequest.createUnmodifiableList(false, ImmutableCheckRunRequest.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableCheckRunRequest(this.headSha, this.name, this.status, this.conclusion, this.startedAt, this.completedAt, this.externalId, this.detailsUrl, this.output, newValue);
    }

    public final ImmutableCheckRunRequest withActions(Iterable<? extends CheckRunAction> elements) {
        if (this.actions == elements) {
            return this;
        }
        List<CheckRunAction> newValue = ImmutableCheckRunRequest.createUnmodifiableList(false, ImmutableCheckRunRequest.createSafeList(elements, true, false));
        return new ImmutableCheckRunRequest(this.headSha, this.name, this.status, this.conclusion, this.startedAt, this.completedAt, this.externalId, this.detailsUrl, this.output, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCheckRunRequest && this.equalTo(0, (ImmutableCheckRunRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableCheckRunRequest another) {
        return this.headSha.equals(another.headSha) && this.name.equals(another.name) && this.status.equals((Object)another.status) && Objects.equals((Object)this.conclusion, (Object)another.conclusion) && Objects.equals(this.startedAt, another.startedAt) && Objects.equals(this.completedAt, another.completedAt) && Objects.equals(this.externalId, another.externalId) && Objects.equals(this.detailsUrl, another.detailsUrl) && Objects.equals(this.output, another.output) && this.actions.equals(another.actions);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.headSha.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.status.hashCode();
        h += (h << 5) + Objects.hashCode((Object)this.conclusion);
        h += (h << 5) + Objects.hashCode(this.startedAt);
        h += (h << 5) + Objects.hashCode(this.completedAt);
        h += (h << 5) + Objects.hashCode(this.externalId);
        h += (h << 5) + Objects.hashCode(this.detailsUrl);
        h += (h << 5) + Objects.hashCode(this.output);
        h += (h << 5) + this.actions.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("CheckRunRequest{");
        builder.append("headSha=").append(this.headSha);
        builder.append(", ");
        builder.append("name=").append(this.name);
        builder.append(", ");
        builder.append("status=").append((Object)this.status);
        if (this.conclusion != null) {
            builder.append(", ");
            builder.append("conclusion=").append((Object)this.conclusion);
        }
        if (this.startedAt != null) {
            builder.append(", ");
            builder.append("startedAt=").append(this.startedAt);
        }
        if (this.completedAt != null) {
            builder.append(", ");
            builder.append("completedAt=").append(this.completedAt);
        }
        if (this.externalId != null) {
            builder.append(", ");
            builder.append("externalId=").append(this.externalId);
        }
        if (this.detailsUrl != null) {
            builder.append(", ");
            builder.append("detailsUrl=").append(this.detailsUrl);
        }
        if (this.output != null) {
            builder.append(", ");
            builder.append("output=").append(this.output);
        }
        builder.append(", ");
        builder.append("actions=").append(this.actions);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableCheckRunRequest fromJson(Json json) {
        Builder builder = ImmutableCheckRunRequest.builder();
        if (json.headSha != null) {
            builder.headSha(json.headSha);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.status != null) {
            builder.status(json.status);
        }
        if (json.conclusion != null) {
            builder.conclusion(json.conclusion);
        }
        if (json.startedAt != null) {
            builder.startedAt(json.startedAt);
        }
        if (json.completedAt != null) {
            builder.completedAt(json.completedAt);
        }
        if (json.externalId != null) {
            builder.externalId(json.externalId);
        }
        if (json.detailsUrl != null) {
            builder.detailsUrl(json.detailsUrl);
        }
        if (json.output != null) {
            builder.output(json.output);
        }
        if (json.actions != null) {
            builder.addAllActions(json.actions);
        }
        return builder.build();
    }

    public static ImmutableCheckRunRequest copyOf(CheckRunRequest instance) {
        if (instance instanceof ImmutableCheckRunRequest) {
            return (ImmutableCheckRunRequest)instance;
        }
        return ImmutableCheckRunRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="CheckRunRequest", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_HEAD_SHA = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long INIT_BIT_STATUS = 4L;
        private long initBits = 7L;
        @Nullable
        private String headSha;
        @Nullable
        private String name;
        @Nullable
        private CheckRunStatus status;
        @Nullable
        private CheckRunConclusion conclusion;
        @Nullable
        private ZonedDateTime startedAt;
        @Nullable
        private ZonedDateTime completedAt;
        @Nullable
        private String externalId;
        @Nullable
        private String detailsUrl;
        @Nullable
        private CheckRunOutput output;
        private List<CheckRunAction> actions = new ArrayList<CheckRunAction>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CheckRunRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(CheckRunBase instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Optional<CheckRunConclusion> conclusionOptional;
            CheckRunBase instance;
            long bits = 0L;
            if (object instanceof CheckRunRequest) {
                Optional<CheckRunOutput> outputOptional;
                instance = (CheckRunRequest)object;
                if ((bits & 1L) == 0L) {
                    conclusionOptional = instance.conclusion();
                    if (conclusionOptional.isPresent()) {
                        this.conclusion(conclusionOptional);
                    }
                    bits |= 1L;
                }
                if ((outputOptional = instance.output()).isPresent()) {
                    this.output(outputOptional);
                }
                if ((bits & 2L) == 0L) {
                    Optional<ZonedDateTime> completedAtOptional = instance.completedAt();
                    if (completedAtOptional.isPresent()) {
                        this.completedAt(completedAtOptional);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    Optional<String> detailsUrlOptional = instance.detailsUrl();
                    if (detailsUrlOptional.isPresent()) {
                        this.detailsUrl(detailsUrlOptional);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.name(instance.name());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    Optional<ZonedDateTime> startedAtOptional = instance.startedAt();
                    if (startedAtOptional.isPresent()) {
                        this.startedAt(startedAtOptional);
                    }
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    Optional<String> externalIdOptional = instance.externalId();
                    if (externalIdOptional.isPresent()) {
                        this.externalId(externalIdOptional);
                    }
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.headSha(instance.headSha());
                    bits |= 0x40L;
                }
                this.addAllActions(instance.actions());
                if ((bits & 0x80L) == 0L) {
                    this.status(instance.status());
                    bits |= 0x80L;
                }
            }
            if (object instanceof CheckRunBase) {
                instance = (CheckRunBase)object;
                if ((bits & 1L) == 0L) {
                    conclusionOptional = instance.conclusion();
                    if (conclusionOptional.isPresent()) {
                        this.conclusion(conclusionOptional);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    Optional<ZonedDateTime> completedAtOptional = instance.completedAt();
                    if (completedAtOptional.isPresent()) {
                        this.completedAt(completedAtOptional);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    Optional<String> detailsUrlOptional = instance.detailsUrl();
                    if (detailsUrlOptional.isPresent()) {
                        this.detailsUrl(detailsUrlOptional);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.name(instance.name());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    Optional<ZonedDateTime> startedAtOptional = instance.startedAt();
                    if (startedAtOptional.isPresent()) {
                        this.startedAt(startedAtOptional);
                    }
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    Optional<String> externalIdOptional = instance.externalId();
                    if (externalIdOptional.isPresent()) {
                        this.externalId(externalIdOptional);
                    }
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.headSha(instance.headSha());
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    this.status(instance.status());
                    bits |= 0x80L;
                }
            }
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder headSha(String headSha) {
            this.headSha = Objects.requireNonNull(headSha, "headSha");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder status(CheckRunStatus status) {
            this.status = Objects.requireNonNull(status, "status");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder conclusion(CheckRunConclusion conclusion) {
            this.conclusion = Objects.requireNonNull(conclusion, "conclusion");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder conclusion(Optional<? extends CheckRunConclusion> conclusion) {
            this.conclusion = conclusion.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder startedAt(ZonedDateTime startedAt) {
            this.startedAt = Objects.requireNonNull(startedAt, "startedAt");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder startedAt(Optional<? extends ZonedDateTime> startedAt) {
            this.startedAt = startedAt.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder completedAt(ZonedDateTime completedAt) {
            this.completedAt = Objects.requireNonNull(completedAt, "completedAt");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder completedAt(Optional<? extends ZonedDateTime> completedAt) {
            this.completedAt = completedAt.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder externalId(String externalId) {
            this.externalId = Objects.requireNonNull(externalId, "externalId");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder externalId(Optional<String> externalId) {
            this.externalId = externalId.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder detailsUrl(String detailsUrl) {
            this.detailsUrl = Objects.requireNonNull(detailsUrl, "detailsUrl");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder detailsUrl(Optional<String> detailsUrl) {
            this.detailsUrl = detailsUrl.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder output(CheckRunOutput output) {
            this.output = Objects.requireNonNull(output, "output");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder output(Optional<? extends CheckRunOutput> output) {
            this.output = output.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addActions(CheckRunAction element) {
            this.actions.add(Objects.requireNonNull(element, "actions element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addActions(CheckRunAction ... elements) {
            for (CheckRunAction element : elements) {
                this.actions.add(Objects.requireNonNull(element, "actions element"));
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder actions(Iterable<? extends CheckRunAction> elements) {
            this.actions.clear();
            return this.addAllActions(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllActions(Iterable<? extends CheckRunAction> elements) {
            for (CheckRunAction checkRunAction : elements) {
                this.actions.add(Objects.requireNonNull(checkRunAction, "actions element"));
            }
            return this;
        }

        public ImmutableCheckRunRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCheckRunRequest(this.headSha, this.name, this.status, this.conclusion, this.startedAt, this.completedAt, this.externalId, this.detailsUrl, this.output, ImmutableCheckRunRequest.createUnmodifiableList(true, this.actions));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("headSha");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("status");
            }
            return "Cannot build CheckRunRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="CheckRunRequest", generator="Immutables")
    static final class Json
    implements CheckRunRequest {
        @Nullable
        String headSha;
        @Nullable
        String name;
        @Nullable
        CheckRunStatus status;
        @Nullable
        Optional<CheckRunConclusion> conclusion = Optional.empty();
        @Nullable
        Optional<ZonedDateTime> startedAt = Optional.empty();
        @Nullable
        Optional<ZonedDateTime> completedAt = Optional.empty();
        @Nullable
        Optional<String> externalId = Optional.empty();
        @Nullable
        Optional<String> detailsUrl = Optional.empty();
        @Nullable
        Optional<CheckRunOutput> output = Optional.empty();
        @Nullable
        List<CheckRunAction> actions = Collections.emptyList();

        Json() {
        }

        @JsonProperty
        public void setHeadSha(String headSha) {
            this.headSha = headSha;
        }

        @JsonProperty
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty
        public void setStatus(CheckRunStatus status) {
            this.status = status;
        }

        @JsonProperty
        public void setConclusion(Optional<CheckRunConclusion> conclusion) {
            this.conclusion = conclusion;
        }

        @JsonProperty
        public void setStartedAt(Optional<ZonedDateTime> startedAt) {
            this.startedAt = startedAt;
        }

        @JsonProperty
        public void setCompletedAt(Optional<ZonedDateTime> completedAt) {
            this.completedAt = completedAt;
        }

        @JsonProperty
        public void setExternalId(Optional<String> externalId) {
            this.externalId = externalId;
        }

        @JsonProperty
        public void setDetailsUrl(Optional<String> detailsUrl) {
            this.detailsUrl = detailsUrl;
        }

        @JsonProperty
        public void setOutput(Optional<CheckRunOutput> output) {
            this.output = output;
        }

        @JsonProperty
        public void setActions(List<CheckRunAction> actions) {
            this.actions = actions;
        }

        @Override
        public String headSha() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public CheckRunStatus status() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<CheckRunConclusion> conclusion() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ZonedDateTime> startedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ZonedDateTime> completedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> externalId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> detailsUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<CheckRunOutput> output() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<CheckRunAction> actions() {
            throw new UnsupportedOperationException();
        }
    }
}

