/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.checks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.checks.CheckRunResponse;
import com.spotify.github.v3.checks.CheckRunResponseList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CheckRunResponseList", generator="Immutables")
@Immutable
public final class ImmutableCheckRunResponseList
implements CheckRunResponseList {
    private final int totalCount;
    private final List<CheckRunResponse> checkRuns;

    private ImmutableCheckRunResponseList(int totalCount, List<CheckRunResponse> checkRuns) {
        this.totalCount = totalCount;
        this.checkRuns = checkRuns;
    }

    @Override
    @JsonProperty
    public int totalCount() {
        return this.totalCount;
    }

    @Override
    @JsonProperty
    public List<CheckRunResponse> checkRuns() {
        return this.checkRuns;
    }

    public final ImmutableCheckRunResponseList withTotalCount(int value) {
        if (this.totalCount == value) {
            return this;
        }
        return new ImmutableCheckRunResponseList(value, this.checkRuns);
    }

    public final ImmutableCheckRunResponseList withCheckRuns(CheckRunResponse ... elements) {
        List<CheckRunResponse> newValue = ImmutableCheckRunResponseList.createUnmodifiableList(false, ImmutableCheckRunResponseList.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableCheckRunResponseList(this.totalCount, newValue);
    }

    public final ImmutableCheckRunResponseList withCheckRuns(Iterable<? extends CheckRunResponse> elements) {
        if (this.checkRuns == elements) {
            return this;
        }
        List<CheckRunResponse> newValue = ImmutableCheckRunResponseList.createUnmodifiableList(false, ImmutableCheckRunResponseList.createSafeList(elements, true, false));
        return new ImmutableCheckRunResponseList(this.totalCount, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCheckRunResponseList && this.equalTo(0, (ImmutableCheckRunResponseList)another);
    }

    private boolean equalTo(int synthetic, ImmutableCheckRunResponseList another) {
        return this.totalCount == another.totalCount && this.checkRuns.equals(another.checkRuns);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.totalCount;
        h += (h << 5) + this.checkRuns.hashCode();
        return h;
    }

    public String toString() {
        return "CheckRunResponseList{totalCount=" + this.totalCount + ", checkRuns=" + this.checkRuns + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableCheckRunResponseList fromJson(Json json) {
        Builder builder = ImmutableCheckRunResponseList.builder();
        if (json.totalCountIsSet) {
            builder.totalCount(json.totalCount);
        }
        if (json.checkRuns != null) {
            builder.addAllCheckRuns(json.checkRuns);
        }
        return builder.build();
    }

    public static ImmutableCheckRunResponseList copyOf(CheckRunResponseList instance) {
        if (instance instanceof ImmutableCheckRunResponseList) {
            return (ImmutableCheckRunResponseList)instance;
        }
        return ImmutableCheckRunResponseList.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="CheckRunResponseList", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TOTAL_COUNT = 1L;
        private long initBits = 1L;
        private int totalCount;
        private List<CheckRunResponse> checkRuns = new ArrayList<CheckRunResponse>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CheckRunResponseList instance) {
            Objects.requireNonNull(instance, "instance");
            this.totalCount(instance.totalCount());
            this.addAllCheckRuns(instance.checkRuns());
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder totalCount(int totalCount) {
            this.totalCount = totalCount;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addCheckRuns(CheckRunResponse element) {
            this.checkRuns.add(Objects.requireNonNull(element, "checkRuns element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addCheckRuns(CheckRunResponse ... elements) {
            for (CheckRunResponse element : elements) {
                this.checkRuns.add(Objects.requireNonNull(element, "checkRuns element"));
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder checkRuns(Iterable<? extends CheckRunResponse> elements) {
            this.checkRuns.clear();
            return this.addAllCheckRuns(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllCheckRuns(Iterable<? extends CheckRunResponse> elements) {
            for (CheckRunResponse checkRunResponse : elements) {
                this.checkRuns.add(Objects.requireNonNull(checkRunResponse, "checkRuns element"));
            }
            return this;
        }

        public ImmutableCheckRunResponseList build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCheckRunResponseList(this.totalCount, ImmutableCheckRunResponseList.createUnmodifiableList(true, this.checkRuns));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("totalCount");
            }
            return "Cannot build CheckRunResponseList, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="CheckRunResponseList", generator="Immutables")
    static final class Json
    implements CheckRunResponseList {
        int totalCount;
        boolean totalCountIsSet;
        @Nullable
        List<CheckRunResponse> checkRuns = Collections.emptyList();

        Json() {
        }

        @JsonProperty
        public void setTotalCount(int totalCount) {
            this.totalCount = totalCount;
            this.totalCountIsSet = true;
        }

        @JsonProperty
        public void setCheckRuns(List<CheckRunResponse> checkRuns) {
            this.checkRuns = checkRuns;
        }

        @Override
        public int totalCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<CheckRunResponse> checkRuns() {
            throw new UnsupportedOperationException();
        }
    }
}

