/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.clients;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.spotify.github.async.AsyncPage;
import com.spotify.github.v3.clients.GitHubClient;
import com.spotify.github.v3.clients.GithubPage;
import com.spotify.github.v3.clients.GithubPageIterator;
import com.spotify.github.v3.prs.MergeParameters;
import com.spotify.github.v3.prs.PullRequest;
import com.spotify.github.v3.prs.PullRequestItem;
import com.spotify.github.v3.prs.RequestReviewParameters;
import com.spotify.github.v3.prs.Review;
import com.spotify.github.v3.prs.ReviewParameters;
import com.spotify.github.v3.prs.ReviewRequests;
import com.spotify.github.v3.prs.requests.PullRequestCreate;
import com.spotify.github.v3.prs.requests.PullRequestParameters;
import com.spotify.github.v3.prs.requests.PullRequestUpdate;
import com.spotify.github.v3.repos.CommitItem;
import com.spotify.githubclient.shade.okhttp3.ResponseBody;
import java.io.Reader;
import java.lang.invoke.MethodHandles;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PullRequestClient {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String PR_TEMPLATE = "/repos/%s/%s/pulls";
    private static final String PR_NUMBER_TEMPLATE = "/repos/%s/%s/pulls/%s";
    private static final String PR_COMMITS_TEMPLATE = "/repos/%s/%s/pulls/%s/commits";
    private static final String PR_REVIEWS_TEMPLATE = "/repos/%s/%s/pulls/%s/reviews";
    private static final String PR_REVIEW_REQUESTS_TEMPLATE = "/repos/%s/%s/pulls/%s/requested_reviewers";
    private final GitHubClient github;
    private final String owner;
    private final String repo;

    PullRequestClient(GitHubClient github, String owner, String repo) {
        this.github = github;
        this.owner = owner;
        this.repo = repo;
    }

    static PullRequestClient create(GitHubClient github, String owner, String repo) {
        return new PullRequestClient(github, owner, repo);
    }

    public CompletableFuture<List<PullRequestItem>> list() {
        return this.list("");
    }

    public CompletableFuture<List<PullRequestItem>> list(PullRequestParameters parameters) {
        String serial = parameters.serialize();
        Object path = Strings.isNullOrEmpty((String)serial) ? "" : "?" + serial;
        return this.list((String)path);
    }

    public CompletableFuture<PullRequest> get(int number) {
        String path = String.format(PR_NUMBER_TEMPLATE, this.owner, this.repo, number);
        log.debug("Fetching pull request from " + path);
        return this.github.request(path, PullRequest.class);
    }

    public CompletableFuture<PullRequest> create(PullRequestCreate request) {
        String path = String.format(PR_TEMPLATE, this.owner, this.repo);
        return this.github.post(path, this.github.json().toJsonUnchecked(request), PullRequest.class);
    }

    public CompletableFuture<PullRequest> update(int number, PullRequestUpdate request) {
        String path = String.format(PR_NUMBER_TEMPLATE, this.owner, this.repo, number);
        return this.github.patch(path, this.github.json().toJsonUnchecked(request), PullRequest.class);
    }

    public CompletableFuture<List<CommitItem>> listCommits(int number) {
        String path = String.format(PR_COMMITS_TEMPLATE, this.owner, this.repo, number);
        log.debug("Fetching pull request commits from " + path);
        return this.github.request(path, GitHubClient.LIST_COMMIT_TYPE_REFERENCE);
    }

    public CompletableFuture<List<Review>> listReviews(int number) {
        String path = String.format(PR_REVIEWS_TEMPLATE, this.owner, this.repo, number);
        log.debug("Fetching pull request reviews from " + path);
        return this.github.request(path, GitHubClient.LIST_REVIEW_TYPE_REFERENCE);
    }

    public Iterator<AsyncPage<Review>> listReviews(int number, int itemsPerPage) {
        String path = String.format(PR_REVIEWS_TEMPLATE, this.owner, this.repo, number);
        log.debug("Fetching pull request reviews from " + path);
        return new GithubPageIterator<Review>(new GithubPage<Review>(this.github, path, GitHubClient.LIST_REVIEW_TYPE_REFERENCE));
    }

    public CompletableFuture<Review> createReview(int number, ReviewParameters properties) {
        String path = String.format(PR_REVIEWS_TEMPLATE, this.owner, this.repo, number);
        String jsonPayload = this.github.json().toJsonUnchecked(properties);
        log.debug("Creating review for PR: " + path);
        return this.github.post(path, jsonPayload, Review.class);
    }

    public CompletableFuture<ReviewRequests> listReviewRequests(int number) {
        String path = String.format(PR_REVIEW_REQUESTS_TEMPLATE, this.owner, this.repo, number);
        log.debug("Fetching pull request requested reviews from " + path);
        return this.github.request(path, GitHubClient.LIST_REVIEW_REQUEST_TYPE_REFERENCE);
    }

    public CompletableFuture<PullRequest> requestReview(int number, RequestReviewParameters properties) {
        String path = String.format(PR_REVIEW_REQUESTS_TEMPLATE, this.owner, this.repo, number);
        String jsonPayload = this.github.json().toJsonUnchecked(properties);
        log.debug("Requesting reviews for PR: " + path);
        return this.github.post(path, jsonPayload, PullRequest.class);
    }

    public CompletableFuture<Void> removeRequestedReview(int number, RequestReviewParameters properties) {
        String path = String.format(PR_REVIEW_REQUESTS_TEMPLATE, this.owner, this.repo, number);
        String jsonPayload = this.github.json().toJsonUnchecked(properties);
        log.debug("Removing requested reviews for PR: " + path);
        return this.github.delete(path, jsonPayload).thenAccept((Consumer)GitHubClient.IGNORE_RESPONSE_CONSUMER);
    }

    public CompletableFuture<Void> merge(int number, MergeParameters properties) {
        String path = String.format("/repos/%s/%s/pulls/%s/merge", this.owner, this.repo, number);
        String jsonPayload = this.github.json().toJsonUnchecked(properties);
        log.debug("Merging pr, running: {}", (Object)path);
        return this.github.put(path, jsonPayload).thenAccept((Consumer)GitHubClient.IGNORE_RESPONSE_CONSUMER);
    }

    public CompletableFuture<Reader> patch(int number) {
        String path = String.format(PR_NUMBER_TEMPLATE, this.owner, this.repo, number);
        ImmutableMap extraHeaders = ImmutableMap.of((Object)"Accept", (Object)"application/vnd.github.patch");
        log.debug("Fetching pull request patch from " + path);
        return this.github.request(path, (Map<String, String>)extraHeaders).thenApply(response -> {
            ResponseBody body = response.body();
            if (Objects.isNull(body)) {
                return Reader.nullReader();
            }
            return body.charStream();
        });
    }

    public CompletableFuture<Reader> diff(int number) {
        String path = String.format(PR_NUMBER_TEMPLATE, this.owner, this.repo, number);
        ImmutableMap extraHeaders = ImmutableMap.of((Object)"Accept", (Object)"application/vnd.github.diff");
        log.debug("Fetching pull diff from " + path);
        return this.github.request(path, (Map<String, String>)extraHeaders).thenApply(response -> {
            ResponseBody body = response.body();
            if (Objects.isNull(body)) {
                return Reader.nullReader();
            }
            return body.charStream();
        });
    }

    private CompletableFuture<List<PullRequestItem>> list(String parameterPath) {
        String path = String.format(PR_TEMPLATE + parameterPath, this.owner, this.repo);
        log.debug("Fetching pull requests from " + path);
        return this.github.request(path, GitHubClient.LIST_PR_TYPE_REFERENCE);
    }
}

