/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.clients;

import com.spotify.github.async.AsyncPage;
import com.spotify.github.v3.Team;
import com.spotify.github.v3.User;
import com.spotify.github.v3.clients.GitHubClient;
import com.spotify.github.v3.clients.GithubPage;
import com.spotify.github.v3.clients.GithubPageIterator;
import com.spotify.github.v3.orgs.Membership;
import com.spotify.github.v3.orgs.TeamInvitation;
import com.spotify.github.v3.orgs.requests.MembershipCreate;
import com.spotify.github.v3.orgs.requests.TeamCreate;
import com.spotify.github.v3.orgs.requests.TeamUpdate;
import java.lang.invoke.MethodHandles;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TeamClient {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String TEAM_TEMPLATE = "/orgs/%s/teams";
    private static final String TEAM_SLUG_TEMPLATE = "/orgs/%s/teams/%s";
    private static final String MEMBERS_TEMPLATE = "/orgs/%s/teams/%s/members";
    private static final String PAGED_MEMBERS_TEMPLATE = "/orgs/%s/teams/%s/members?per_page=%d";
    private static final String MEMBERSHIP_TEMPLATE = "/orgs/%s/teams/%s/memberships/%s";
    private static final String INVITATIONS_TEMPLATE = "/orgs/%s/teams/%s/invitations";
    private final GitHubClient github;
    private final String org;

    TeamClient(GitHubClient github, String org) {
        this.github = github;
        this.org = org;
    }

    static TeamClient create(GitHubClient github, String org) {
        return new TeamClient(github, org);
    }

    public CompletableFuture<Team> createTeam(TeamCreate request) {
        String path = String.format(TEAM_TEMPLATE, this.org);
        log.debug("Creating team in: " + path);
        return this.github.post(path, this.github.json().toJsonUnchecked(request), Team.class);
    }

    public CompletableFuture<Team> getTeam(String slug) {
        String path = String.format(TEAM_SLUG_TEMPLATE, this.org, slug);
        log.debug("Fetching team from " + path);
        return this.github.request(path, Team.class);
    }

    public CompletableFuture<List<Team>> listTeams() {
        String path = String.format(TEAM_TEMPLATE, this.org);
        log.debug("Fetching teams from " + path);
        return this.github.request(path, GitHubClient.LIST_TEAMS);
    }

    public CompletableFuture<Team> updateTeam(TeamUpdate request, String slug) {
        String path = String.format(TEAM_SLUG_TEMPLATE, this.org, slug);
        log.debug("Updating team in: " + path);
        return this.github.patch(path, this.github.json().toJsonUnchecked(request), Team.class);
    }

    public CompletableFuture<Void> deleteTeam(String slug) {
        String path = String.format(TEAM_SLUG_TEMPLATE, this.org, slug);
        log.debug("Deleting team from: " + path);
        return this.github.delete(path).thenAccept((Consumer)GitHubClient.IGNORE_RESPONSE_CONSUMER);
    }

    public CompletableFuture<Membership> updateMembership(MembershipCreate request, String slug, String username) {
        String path = String.format(MEMBERSHIP_TEMPLATE, this.org, slug, username);
        log.debug("Updating membership in: " + path);
        return this.github.put(path, this.github.json().toJsonUnchecked(request), Membership.class);
    }

    public CompletableFuture<Membership> getMembership(String slug, String username) {
        String path = String.format(MEMBERSHIP_TEMPLATE, this.org, slug, username);
        log.debug("Fetching membership for: " + path);
        return this.github.request(path, Membership.class);
    }

    public CompletableFuture<List<User>> listTeamMembers(String slug) {
        String path = String.format(MEMBERS_TEMPLATE, this.org, slug);
        log.debug("Fetching members for: " + path);
        return this.github.request(path, GitHubClient.LIST_TEAM_MEMBERS);
    }

    public Iterator<AsyncPage<User>> listTeamMembers(String slug, int pageSize) {
        String path = String.format(PAGED_MEMBERS_TEMPLATE, this.org, slug, pageSize);
        log.debug("Fetching members for: " + path);
        return new GithubPageIterator<User>(new GithubPage<User>(this.github, path, GitHubClient.LIST_TEAM_MEMBERS));
    }

    public CompletableFuture<Void> deleteMembership(String slug, String username) {
        String path = String.format(MEMBERSHIP_TEMPLATE, this.org, slug, username);
        log.debug("Deleting membership from: " + path);
        return this.github.delete(path).thenAccept((Consumer)GitHubClient.IGNORE_RESPONSE_CONSUMER);
    }

    public CompletableFuture<List<TeamInvitation>> listPendingTeamInvitations(String slug) {
        String path = String.format(INVITATIONS_TEMPLATE, this.org, slug);
        log.debug("Fetching pending invitations for: " + path);
        return this.github.request(path, GitHubClient.LIST_PENDING_TEAM_INVITATIONS);
    }
}

