/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.git;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.git.Reference;
import com.spotify.github.v3.git.ReferenceObject;
import java.net.URI;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Reference", generator="Immutables")
@Immutable
public final class ImmutableReference
implements Reference {
    @Nullable
    private final String ref;
    @Nullable
    private final URI url;
    @Nullable
    private final ReferenceObject object;

    private ImmutableReference(@Nullable String ref, @Nullable URI url, @Nullable ReferenceObject object) {
        this.ref = ref;
        this.url = url;
        this.object = object;
    }

    @Override
    @JsonProperty
    @Nullable
    public String ref() {
        return this.ref;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI url() {
        return this.url;
    }

    @Override
    @JsonProperty
    @Nullable
    public ReferenceObject object() {
        return this.object;
    }

    public final ImmutableReference withRef(@Nullable String value) {
        if (Objects.equals(this.ref, value)) {
            return this;
        }
        return new ImmutableReference(value, this.url, this.object);
    }

    public final ImmutableReference withUrl(@Nullable URI value) {
        if (this.url == value) {
            return this;
        }
        return new ImmutableReference(this.ref, value, this.object);
    }

    public final ImmutableReference withObject(@Nullable ReferenceObject value) {
        if (this.object == value) {
            return this;
        }
        return new ImmutableReference(this.ref, this.url, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableReference && this.equalTo(0, (ImmutableReference)another);
    }

    private boolean equalTo(int synthetic, ImmutableReference another) {
        return Objects.equals(this.ref, another.ref) && Objects.equals(this.url, another.url) && Objects.equals(this.object, another.object);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.ref);
        h += (h << 5) + Objects.hashCode(this.url);
        h += (h << 5) + Objects.hashCode(this.object);
        return h;
    }

    public String toString() {
        return "Reference{ref=" + this.ref + ", url=" + this.url + ", object=" + this.object + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableReference fromJson(Json json) {
        Builder builder = ImmutableReference.builder();
        if (json.ref != null) {
            builder.ref(json.ref);
        }
        if (json.url != null) {
            builder.url(json.url);
        }
        if (json.object != null) {
            builder.object(json.object);
        }
        return builder.build();
    }

    public static ImmutableReference copyOf(Reference instance) {
        if (instance instanceof ImmutableReference) {
            return (ImmutableReference)instance;
        }
        return ImmutableReference.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Reference", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String ref;
        @Nullable
        private URI url;
        @Nullable
        private ReferenceObject object;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Reference instance) {
            ReferenceObject objectValue;
            URI urlValue;
            Objects.requireNonNull(instance, "instance");
            String refValue = instance.ref();
            if (refValue != null) {
                this.ref(refValue);
            }
            if ((urlValue = instance.url()) != null) {
                this.url(urlValue);
            }
            if ((objectValue = instance.object()) != null) {
                this.object(objectValue);
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder ref(@Nullable String ref) {
            this.ref = ref;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder url(@Nullable URI url) {
            this.url = url;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder object(@Nullable ReferenceObject object) {
            this.object = object;
            return this;
        }

        public ImmutableReference build() {
            return new ImmutableReference(this.ref, this.url, this.object);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Reference", generator="Immutables")
    static final class Json
    implements Reference {
        @Nullable
        String ref;
        @Nullable
        URI url;
        @Nullable
        ReferenceObject object;

        Json() {
        }

        @JsonProperty
        public void setRef(@Nullable String ref) {
            this.ref = ref;
        }

        @JsonProperty
        public void setUrl(@Nullable URI url) {
            this.url = url;
        }

        @JsonProperty
        public void setObject(@Nullable ReferenceObject object) {
            this.object = object;
        }

        @Override
        public String ref() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI url() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceObject object() {
            throw new UnsupportedOperationException();
        }
    }
}

