/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.git;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.git.Author;
import com.spotify.github.v3.git.ReferenceObject;
import com.spotify.github.v3.git.ShaLink;
import com.spotify.github.v3.git.Tag;
import java.net.URI;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Tag", generator="Immutables")
@Immutable
public final class ImmutableTag
implements Tag {
    @Nullable
    private final String sha;
    @Nullable
    private final URI url;
    @Nullable
    private final String tag;
    @Nullable
    private final String message;
    @Nullable
    private final Author tagger;
    @Nullable
    private final ReferenceObject object;

    private ImmutableTag(@Nullable String sha, @Nullable URI url, @Nullable String tag, @Nullable String message, @Nullable Author tagger, @Nullable ReferenceObject object) {
        this.sha = sha;
        this.url = url;
        this.tag = tag;
        this.message = message;
        this.tagger = tagger;
        this.object = object;
    }

    @Override
    @JsonProperty
    @Nullable
    public String sha() {
        return this.sha;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI url() {
        return this.url;
    }

    @Override
    @JsonProperty
    @Nullable
    public String tag() {
        return this.tag;
    }

    @Override
    @JsonProperty
    @Nullable
    public String message() {
        return this.message;
    }

    @Override
    @JsonProperty
    @Nullable
    public Author tagger() {
        return this.tagger;
    }

    @Override
    @JsonProperty
    @Nullable
    public ReferenceObject object() {
        return this.object;
    }

    public final ImmutableTag withSha(@Nullable String value) {
        if (Objects.equals(this.sha, value)) {
            return this;
        }
        return new ImmutableTag(value, this.url, this.tag, this.message, this.tagger, this.object);
    }

    public final ImmutableTag withUrl(@Nullable URI value) {
        if (this.url == value) {
            return this;
        }
        return new ImmutableTag(this.sha, value, this.tag, this.message, this.tagger, this.object);
    }

    public final ImmutableTag withTag(@Nullable String value) {
        if (Objects.equals(this.tag, value)) {
            return this;
        }
        return new ImmutableTag(this.sha, this.url, value, this.message, this.tagger, this.object);
    }

    public final ImmutableTag withMessage(@Nullable String value) {
        if (Objects.equals(this.message, value)) {
            return this;
        }
        return new ImmutableTag(this.sha, this.url, this.tag, value, this.tagger, this.object);
    }

    public final ImmutableTag withTagger(@Nullable Author value) {
        if (this.tagger == value) {
            return this;
        }
        return new ImmutableTag(this.sha, this.url, this.tag, this.message, value, this.object);
    }

    public final ImmutableTag withObject(@Nullable ReferenceObject value) {
        if (this.object == value) {
            return this;
        }
        return new ImmutableTag(this.sha, this.url, this.tag, this.message, this.tagger, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTag && this.equalTo(0, (ImmutableTag)another);
    }

    private boolean equalTo(int synthetic, ImmutableTag another) {
        return Objects.equals(this.sha, another.sha) && Objects.equals(this.url, another.url) && Objects.equals(this.tag, another.tag) && Objects.equals(this.message, another.message) && Objects.equals(this.tagger, another.tagger) && Objects.equals(this.object, another.object);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.sha);
        h += (h << 5) + Objects.hashCode(this.url);
        h += (h << 5) + Objects.hashCode(this.tag);
        h += (h << 5) + Objects.hashCode(this.message);
        h += (h << 5) + Objects.hashCode(this.tagger);
        h += (h << 5) + Objects.hashCode(this.object);
        return h;
    }

    public String toString() {
        return "Tag{sha=" + this.sha + ", url=" + this.url + ", tag=" + this.tag + ", message=" + this.message + ", tagger=" + this.tagger + ", object=" + this.object + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableTag fromJson(Json json) {
        Builder builder = ImmutableTag.builder();
        if (json.sha != null) {
            builder.sha(json.sha);
        }
        if (json.url != null) {
            builder.url(json.url);
        }
        if (json.tag != null) {
            builder.tag(json.tag);
        }
        if (json.message != null) {
            builder.message(json.message);
        }
        if (json.tagger != null) {
            builder.tagger(json.tagger);
        }
        if (json.object != null) {
            builder.object(json.object);
        }
        return builder.build();
    }

    public static ImmutableTag copyOf(Tag instance) {
        if (instance instanceof ImmutableTag) {
            return (ImmutableTag)instance;
        }
        return ImmutableTag.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Tag", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String sha;
        @Nullable
        private URI url;
        @Nullable
        private String tag;
        @Nullable
        private String message;
        @Nullable
        private Author tagger;
        @Nullable
        private ReferenceObject object;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Tag instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(ShaLink instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ShaLink instance;
            long bits = 0L;
            if (object instanceof Tag) {
                ReferenceObject objectValue;
                String messageValue;
                String tagValue;
                instance = (Tag)object;
                Author taggerValue = instance.tagger();
                if (taggerValue != null) {
                    this.tagger(taggerValue);
                }
                if ((tagValue = instance.tag()) != null) {
                    this.tag(tagValue);
                }
                if ((messageValue = instance.message()) != null) {
                    this.message(messageValue);
                }
                if ((bits & 1L) == 0L) {
                    String shaValue = instance.sha();
                    if (shaValue != null) {
                        this.sha(shaValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    URI urlValue = instance.url();
                    if (urlValue != null) {
                        this.url(urlValue);
                    }
                    bits |= 2L;
                }
                if ((objectValue = instance.object()) != null) {
                    this.object(objectValue);
                }
            }
            if (object instanceof ShaLink) {
                instance = (ShaLink)object;
                if ((bits & 1L) == 0L) {
                    String shaValue = instance.sha();
                    if (shaValue != null) {
                        this.sha(shaValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    URI urlValue = instance.url();
                    if (urlValue != null) {
                        this.url(urlValue);
                    }
                    bits |= 2L;
                }
            }
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder sha(@Nullable String sha) {
            this.sha = sha;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder url(@Nullable URI url) {
            this.url = url;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder tag(@Nullable String tag) {
            this.tag = tag;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder message(@Nullable String message) {
            this.message = message;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder tagger(@Nullable Author tagger) {
            this.tagger = tagger;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder object(@Nullable ReferenceObject object) {
            this.object = object;
            return this;
        }

        public ImmutableTag build() {
            return new ImmutableTag(this.sha, this.url, this.tag, this.message, this.tagger, this.object);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Tag", generator="Immutables")
    static final class Json
    implements Tag {
        @Nullable
        String sha;
        @Nullable
        URI url;
        @Nullable
        String tag;
        @Nullable
        String message;
        @Nullable
        Author tagger;
        @Nullable
        ReferenceObject object;

        Json() {
        }

        @JsonProperty
        public void setSha(@Nullable String sha) {
            this.sha = sha;
        }

        @JsonProperty
        public void setUrl(@Nullable URI url) {
            this.url = url;
        }

        @JsonProperty
        public void setTag(@Nullable String tag) {
            this.tag = tag;
        }

        @JsonProperty
        public void setMessage(@Nullable String message) {
            this.message = message;
        }

        @JsonProperty
        public void setTagger(@Nullable Author tagger) {
            this.tagger = tagger;
        }

        @JsonProperty
        public void setObject(@Nullable ReferenceObject object) {
            this.object = object;
        }

        @Override
        public String sha() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI url() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String tag() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String message() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Author tagger() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceObject object() {
            throw new UnsupportedOperationException();
        }
    }
}

