/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.git;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.git.ShaLink;
import com.spotify.github.v3.git.TreeItem;
import java.net.URI;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TreeItem", generator="Immutables")
@Immutable
public final class ImmutableTreeItem
implements TreeItem {
    @Nullable
    private final String sha;
    @Nullable
    private final URI url;
    @Nullable
    private final String path;
    @Nullable
    private final String mode;
    @Nullable
    private final String type;
    @Nullable
    private final Long size;

    private ImmutableTreeItem(@Nullable String sha, @Nullable URI url, @Nullable String path, @Nullable String mode, @Nullable String type, @Nullable Long size) {
        this.sha = sha;
        this.url = url;
        this.path = path;
        this.mode = mode;
        this.type = type;
        this.size = size;
    }

    @Override
    @JsonProperty
    @Nullable
    public String sha() {
        return this.sha;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI url() {
        return this.url;
    }

    @Override
    @JsonProperty
    @Nullable
    public String path() {
        return this.path;
    }

    @Override
    @JsonProperty
    @Nullable
    public String mode() {
        return this.mode;
    }

    @Override
    @JsonProperty
    @Nullable
    public String type() {
        return this.type;
    }

    @Override
    @JsonProperty
    @Nullable
    public Long size() {
        return this.size;
    }

    public final ImmutableTreeItem withSha(@Nullable String value) {
        if (Objects.equals(this.sha, value)) {
            return this;
        }
        return new ImmutableTreeItem(value, this.url, this.path, this.mode, this.type, this.size);
    }

    public final ImmutableTreeItem withUrl(@Nullable URI value) {
        if (this.url == value) {
            return this;
        }
        return new ImmutableTreeItem(this.sha, value, this.path, this.mode, this.type, this.size);
    }

    public final ImmutableTreeItem withPath(@Nullable String value) {
        if (Objects.equals(this.path, value)) {
            return this;
        }
        return new ImmutableTreeItem(this.sha, this.url, value, this.mode, this.type, this.size);
    }

    public final ImmutableTreeItem withMode(@Nullable String value) {
        if (Objects.equals(this.mode, value)) {
            return this;
        }
        return new ImmutableTreeItem(this.sha, this.url, this.path, value, this.type, this.size);
    }

    public final ImmutableTreeItem withType(@Nullable String value) {
        if (Objects.equals(this.type, value)) {
            return this;
        }
        return new ImmutableTreeItem(this.sha, this.url, this.path, this.mode, value, this.size);
    }

    public final ImmutableTreeItem withSize(@Nullable Long value) {
        if (Objects.equals(this.size, value)) {
            return this;
        }
        return new ImmutableTreeItem(this.sha, this.url, this.path, this.mode, this.type, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTreeItem && this.equalTo(0, (ImmutableTreeItem)another);
    }

    private boolean equalTo(int synthetic, ImmutableTreeItem another) {
        return Objects.equals(this.sha, another.sha) && Objects.equals(this.url, another.url) && Objects.equals(this.path, another.path) && Objects.equals(this.mode, another.mode) && Objects.equals(this.type, another.type) && Objects.equals(this.size, another.size);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.sha);
        h += (h << 5) + Objects.hashCode(this.url);
        h += (h << 5) + Objects.hashCode(this.path);
        h += (h << 5) + Objects.hashCode(this.mode);
        h += (h << 5) + Objects.hashCode(this.type);
        h += (h << 5) + Objects.hashCode(this.size);
        return h;
    }

    public String toString() {
        return "TreeItem{sha=" + this.sha + ", url=" + this.url + ", path=" + this.path + ", mode=" + this.mode + ", type=" + this.type + ", size=" + this.size + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableTreeItem fromJson(Json json) {
        Builder builder = ImmutableTreeItem.builder();
        if (json.sha != null) {
            builder.sha(json.sha);
        }
        if (json.url != null) {
            builder.url(json.url);
        }
        if (json.path != null) {
            builder.path(json.path);
        }
        if (json.mode != null) {
            builder.mode(json.mode);
        }
        if (json.type != null) {
            builder.type(json.type);
        }
        if (json.size != null) {
            builder.size(json.size);
        }
        return builder.build();
    }

    public static ImmutableTreeItem copyOf(TreeItem instance) {
        if (instance instanceof ImmutableTreeItem) {
            return (ImmutableTreeItem)instance;
        }
        return ImmutableTreeItem.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TreeItem", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String sha;
        @Nullable
        private URI url;
        @Nullable
        private String path;
        @Nullable
        private String mode;
        @Nullable
        private String type;
        @Nullable
        private Long size;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ShaLink instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(TreeItem instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ShaLink instance;
            long bits = 0L;
            if (object instanceof ShaLink) {
                instance = (ShaLink)object;
                if ((bits & 1L) == 0L) {
                    String shaValue = instance.sha();
                    if (shaValue != null) {
                        this.sha(shaValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    URI urlValue = instance.url();
                    if (urlValue != null) {
                        this.url(urlValue);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof TreeItem) {
                String typeValue;
                Long sizeValue;
                String pathValue;
                instance = (TreeItem)object;
                String modeValue = instance.mode();
                if (modeValue != null) {
                    this.mode(modeValue);
                }
                if ((pathValue = instance.path()) != null) {
                    this.path(pathValue);
                }
                if ((sizeValue = instance.size()) != null) {
                    this.size(sizeValue);
                }
                if ((typeValue = instance.type()) != null) {
                    this.type(typeValue);
                }
                if ((bits & 1L) == 0L) {
                    String shaValue = instance.sha();
                    if (shaValue != null) {
                        this.sha(shaValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    URI urlValue = instance.url();
                    if (urlValue != null) {
                        this.url(urlValue);
                    }
                    bits |= 2L;
                }
            }
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder sha(@Nullable String sha) {
            this.sha = sha;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder url(@Nullable URI url) {
            this.url = url;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder path(@Nullable String path) {
            this.path = path;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder mode(@Nullable String mode) {
            this.mode = mode;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder type(@Nullable String type) {
            this.type = type;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder size(@Nullable Long size) {
            this.size = size;
            return this;
        }

        public ImmutableTreeItem build() {
            return new ImmutableTreeItem(this.sha, this.url, this.path, this.mode, this.type, this.size);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="TreeItem", generator="Immutables")
    static final class Json
    implements TreeItem {
        @Nullable
        String sha;
        @Nullable
        URI url;
        @Nullable
        String path;
        @Nullable
        String mode;
        @Nullable
        String type;
        @Nullable
        Long size;

        Json() {
        }

        @JsonProperty
        public void setSha(@Nullable String sha) {
            this.sha = sha;
        }

        @JsonProperty
        public void setUrl(@Nullable URI url) {
            this.url = url;
        }

        @JsonProperty
        public void setPath(@Nullable String path) {
            this.path = path;
        }

        @JsonProperty
        public void setMode(@Nullable String mode) {
            this.mode = mode;
        }

        @JsonProperty
        public void setType(@Nullable String type) {
            this.type = type;
        }

        @JsonProperty
        public void setSize(@Nullable Long size) {
            this.size = size;
        }

        @Override
        public String sha() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI url() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String path() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String mode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String type() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long size() {
            throw new UnsupportedOperationException();
        }
    }
}

