/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.hooks.requests;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.hooks.WebhookConfig;
import com.spotify.github.v3.hooks.requests.WebhookCreate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="WebhookCreate", generator="Immutables")
@Immutable
public final class ImmutableWebhookCreate
implements WebhookCreate {
    @Nullable
    private final String name;
    @Nullable
    private final Boolean active;
    @Nullable
    private final List<String> events;
    @Nullable
    private final WebhookConfig config;

    private ImmutableWebhookCreate(@Nullable String name, @Nullable Boolean active, @Nullable List<String> events, @Nullable WebhookConfig config) {
        this.name = name;
        this.active = active;
        this.events = events;
        this.config = config;
    }

    @Override
    @JsonProperty
    @Nullable
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty
    @Nullable
    public Boolean active() {
        return this.active;
    }

    @Override
    @JsonProperty
    @Nullable
    public List<String> events() {
        return this.events;
    }

    @Override
    @JsonProperty
    @Nullable
    public WebhookConfig config() {
        return this.config;
    }

    public final ImmutableWebhookCreate withName(@Nullable String value) {
        if (Objects.equals(this.name, value)) {
            return this;
        }
        return new ImmutableWebhookCreate(value, this.active, this.events, this.config);
    }

    public final ImmutableWebhookCreate withActive(@Nullable Boolean value) {
        if (Objects.equals(this.active, value)) {
            return this;
        }
        return new ImmutableWebhookCreate(this.name, value, this.events, this.config);
    }

    public final ImmutableWebhookCreate withEvents(String ... elements) {
        if (elements == null) {
            return new ImmutableWebhookCreate(this.name, this.active, null, this.config);
        }
        List<String> newValue = Arrays.asList(elements) == null ? null : ImmutableWebhookCreate.createUnmodifiableList(false, ImmutableWebhookCreate.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableWebhookCreate(this.name, this.active, newValue, this.config);
    }

    public final ImmutableWebhookCreate withEvents(@Nullable Iterable<String> elements) {
        if (this.events == elements) {
            return this;
        }
        List<String> newValue = elements == null ? null : ImmutableWebhookCreate.createUnmodifiableList(false, ImmutableWebhookCreate.createSafeList(elements, true, false));
        return new ImmutableWebhookCreate(this.name, this.active, newValue, this.config);
    }

    public final ImmutableWebhookCreate withConfig(@Nullable WebhookConfig value) {
        if (this.config == value) {
            return this;
        }
        return new ImmutableWebhookCreate(this.name, this.active, this.events, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableWebhookCreate && this.equalTo(0, (ImmutableWebhookCreate)another);
    }

    private boolean equalTo(int synthetic, ImmutableWebhookCreate another) {
        return Objects.equals(this.name, another.name) && Objects.equals(this.active, another.active) && Objects.equals(this.events, another.events) && Objects.equals(this.config, another.config);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + Objects.hashCode(this.active);
        h += (h << 5) + Objects.hashCode(this.events);
        h += (h << 5) + Objects.hashCode(this.config);
        return h;
    }

    public String toString() {
        return "WebhookCreate{name=" + this.name + ", active=" + this.active + ", events=" + this.events + ", config=" + this.config + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableWebhookCreate fromJson(Json json) {
        Builder builder = ImmutableWebhookCreate.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.active != null) {
            builder.active(json.active);
        }
        if (json.events != null) {
            builder.addAllEvents(json.events);
        }
        if (json.config != null) {
            builder.config(json.config);
        }
        return builder.build();
    }

    public static ImmutableWebhookCreate copyOf(WebhookCreate instance) {
        if (instance instanceof ImmutableWebhookCreate) {
            return (ImmutableWebhookCreate)instance;
        }
        return ImmutableWebhookCreate.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="WebhookCreate", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String name;
        @Nullable
        private Boolean active;
        private List<String> events = null;
        @Nullable
        private WebhookConfig config;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(WebhookCreate instance) {
            WebhookConfig configValue;
            List<String> eventsValue;
            Boolean activeValue;
            Objects.requireNonNull(instance, "instance");
            String nameValue = instance.name();
            if (nameValue != null) {
                this.name(nameValue);
            }
            if ((activeValue = instance.active()) != null) {
                this.active(activeValue);
            }
            if ((eventsValue = instance.events()) != null) {
                this.addAllEvents(eventsValue);
            }
            if ((configValue = instance.config()) != null) {
                this.config(configValue);
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder active(@Nullable Boolean active) {
            this.active = active;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addEvents(String element) {
            if (this.events == null) {
                this.events = new ArrayList<String>();
            }
            this.events.add(Objects.requireNonNull(element, "events element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addEvents(String ... elements) {
            if (this.events == null) {
                this.events = new ArrayList<String>();
            }
            for (String element : elements) {
                this.events.add(Objects.requireNonNull(element, "events element"));
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder events(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.events = null;
                return this;
            }
            this.events = new ArrayList<String>();
            return this.addAllEvents(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllEvents(Iterable<String> elements) {
            Objects.requireNonNull(elements, "events element");
            if (this.events == null) {
                this.events = new ArrayList<String>();
            }
            for (String element : elements) {
                this.events.add(Objects.requireNonNull(element, "events element"));
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder config(@Nullable WebhookConfig config) {
            this.config = config;
            return this;
        }

        public ImmutableWebhookCreate build() {
            return new ImmutableWebhookCreate(this.name, this.active, this.events == null ? null : ImmutableWebhookCreate.createUnmodifiableList(true, this.events), this.config);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="WebhookCreate", generator="Immutables")
    static final class Json
    implements WebhookCreate {
        @Nullable
        String name;
        @Nullable
        Boolean active;
        @Nullable
        List<String> events = null;
        @Nullable
        WebhookConfig config;

        Json() {
        }

        @JsonProperty
        public void setName(@Nullable String name) {
            this.name = name;
        }

        @JsonProperty
        public void setActive(@Nullable Boolean active) {
            this.active = active;
        }

        @JsonProperty
        public void setEvents(@Nullable List<String> events) {
            this.events = events;
        }

        @JsonProperty
        public void setConfig(@Nullable WebhookConfig config) {
            this.config = config;
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean active() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> events() {
            throw new UnsupportedOperationException();
        }

        @Override
        public WebhookConfig config() {
            throw new UnsupportedOperationException();
        }
    }
}

