/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.orgs.requests;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.orgs.requests.TeamCreate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TeamCreate", generator="Immutables")
@Immutable
public final class ImmutableTeamCreate
implements TeamCreate {
    private final String name;
    @Nullable
    private final String description;
    @Nullable
    private final String privacy;
    @Nullable
    private final String notificationSetting;
    @Nullable
    private final List<String> maintainers;
    @Nullable
    private final List<String> repoNames;
    @Nullable
    private final Integer parentTeamId;

    private ImmutableTeamCreate(String name, @Nullable String description, @Nullable String privacy, @Nullable String notificationSetting, @Nullable List<String> maintainers, @Nullable List<String> repoNames, @Nullable Integer parentTeamId) {
        this.name = name;
        this.description = description;
        this.privacy = privacy;
        this.notificationSetting = notificationSetting;
        this.maintainers = maintainers;
        this.repoNames = repoNames;
        this.parentTeamId = parentTeamId;
    }

    @Override
    @JsonProperty
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty
    public Optional<String> description() {
        return Optional.ofNullable(this.description);
    }

    @Override
    @JsonProperty
    public Optional<String> privacy() {
        return Optional.ofNullable(this.privacy);
    }

    @Override
    @JsonProperty(value="notification_setting")
    public Optional<String> notificationSetting() {
        return Optional.ofNullable(this.notificationSetting);
    }

    @Override
    @JsonProperty
    public Optional<List<String>> maintainers() {
        return Optional.ofNullable(this.maintainers);
    }

    @Override
    @JsonProperty(value="repo_names")
    public Optional<List<String>> repoNames() {
        return Optional.ofNullable(this.repoNames);
    }

    @Override
    @JsonProperty(value="parent_team_id")
    public Optional<Integer> parentTeamId() {
        return Optional.ofNullable(this.parentTeamId);
    }

    public final ImmutableTeamCreate withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableTeamCreate(newValue, this.description, this.privacy, this.notificationSetting, this.maintainers, this.repoNames, this.parentTeamId);
    }

    public final ImmutableTeamCreate withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (Objects.equals(this.description, newValue)) {
            return this;
        }
        return new ImmutableTeamCreate(this.name, newValue, this.privacy, this.notificationSetting, this.maintainers, this.repoNames, this.parentTeamId);
    }

    public final ImmutableTeamCreate withDescription(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new ImmutableTeamCreate(this.name, value, this.privacy, this.notificationSetting, this.maintainers, this.repoNames, this.parentTeamId);
    }

    public final ImmutableTeamCreate withPrivacy(String value) {
        String newValue = Objects.requireNonNull(value, "privacy");
        if (Objects.equals(this.privacy, newValue)) {
            return this;
        }
        return new ImmutableTeamCreate(this.name, this.description, newValue, this.notificationSetting, this.maintainers, this.repoNames, this.parentTeamId);
    }

    public final ImmutableTeamCreate withPrivacy(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.privacy, value)) {
            return this;
        }
        return new ImmutableTeamCreate(this.name, this.description, value, this.notificationSetting, this.maintainers, this.repoNames, this.parentTeamId);
    }

    public final ImmutableTeamCreate withNotificationSetting(String value) {
        String newValue = Objects.requireNonNull(value, "notificationSetting");
        if (Objects.equals(this.notificationSetting, newValue)) {
            return this;
        }
        return new ImmutableTeamCreate(this.name, this.description, this.privacy, newValue, this.maintainers, this.repoNames, this.parentTeamId);
    }

    public final ImmutableTeamCreate withNotificationSetting(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.notificationSetting, value)) {
            return this;
        }
        return new ImmutableTeamCreate(this.name, this.description, this.privacy, value, this.maintainers, this.repoNames, this.parentTeamId);
    }

    public final ImmutableTeamCreate withMaintainers(List<String> value) {
        List<String> newValue = Objects.requireNonNull(value, "maintainers");
        if (this.maintainers == newValue) {
            return this;
        }
        return new ImmutableTeamCreate(this.name, this.description, this.privacy, this.notificationSetting, newValue, this.repoNames, this.parentTeamId);
    }

    public final ImmutableTeamCreate withMaintainers(Optional<? extends List<String>> optional) {
        List value = optional.orElse(null);
        if (this.maintainers == value) {
            return this;
        }
        return new ImmutableTeamCreate(this.name, this.description, this.privacy, this.notificationSetting, value, this.repoNames, this.parentTeamId);
    }

    public final ImmutableTeamCreate withRepoNames(List<String> value) {
        List<String> newValue = Objects.requireNonNull(value, "repoNames");
        if (this.repoNames == newValue) {
            return this;
        }
        return new ImmutableTeamCreate(this.name, this.description, this.privacy, this.notificationSetting, this.maintainers, newValue, this.parentTeamId);
    }

    public final ImmutableTeamCreate withRepoNames(Optional<? extends List<String>> optional) {
        List value = optional.orElse(null);
        if (this.repoNames == value) {
            return this;
        }
        return new ImmutableTeamCreate(this.name, this.description, this.privacy, this.notificationSetting, this.maintainers, value, this.parentTeamId);
    }

    public final ImmutableTeamCreate withParentTeamId(int value) {
        Integer newValue = value;
        if (Objects.equals(this.parentTeamId, newValue)) {
            return this;
        }
        return new ImmutableTeamCreate(this.name, this.description, this.privacy, this.notificationSetting, this.maintainers, this.repoNames, newValue);
    }

    public final ImmutableTeamCreate withParentTeamId(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.parentTeamId, value)) {
            return this;
        }
        return new ImmutableTeamCreate(this.name, this.description, this.privacy, this.notificationSetting, this.maintainers, this.repoNames, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTeamCreate && this.equalTo(0, (ImmutableTeamCreate)another);
    }

    private boolean equalTo(int synthetic, ImmutableTeamCreate another) {
        return this.name.equals(another.name) && Objects.equals(this.description, another.description) && Objects.equals(this.privacy, another.privacy) && Objects.equals(this.notificationSetting, another.notificationSetting) && Objects.equals(this.maintainers, another.maintainers) && Objects.equals(this.repoNames, another.repoNames) && Objects.equals(this.parentTeamId, another.parentTeamId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + Objects.hashCode(this.privacy);
        h += (h << 5) + Objects.hashCode(this.notificationSetting);
        h += (h << 5) + Objects.hashCode(this.maintainers);
        h += (h << 5) + Objects.hashCode(this.repoNames);
        h += (h << 5) + Objects.hashCode(this.parentTeamId);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("TeamCreate{");
        builder.append("name=").append(this.name);
        if (this.description != null) {
            builder.append(", ");
            builder.append("description=").append(this.description);
        }
        if (this.privacy != null) {
            builder.append(", ");
            builder.append("privacy=").append(this.privacy);
        }
        if (this.notificationSetting != null) {
            builder.append(", ");
            builder.append("notificationSetting=").append(this.notificationSetting);
        }
        if (this.maintainers != null) {
            builder.append(", ");
            builder.append("maintainers=").append(this.maintainers);
        }
        if (this.repoNames != null) {
            builder.append(", ");
            builder.append("repoNames=").append(this.repoNames);
        }
        if (this.parentTeamId != null) {
            builder.append(", ");
            builder.append("parentTeamId=").append(this.parentTeamId);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableTeamCreate fromJson(Json json) {
        Builder builder = ImmutableTeamCreate.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.privacy != null) {
            builder.privacy(json.privacy);
        }
        if (json.notificationSetting != null) {
            builder.notificationSetting(json.notificationSetting);
        }
        if (json.maintainers != null) {
            builder.maintainers(json.maintainers);
        }
        if (json.repoNames != null) {
            builder.repoNames(json.repoNames);
        }
        if (json.parentTeamId != null) {
            builder.parentTeamId(json.parentTeamId);
        }
        return builder.build();
    }

    public static ImmutableTeamCreate copyOf(TeamCreate instance) {
        if (instance instanceof ImmutableTeamCreate) {
            return (ImmutableTeamCreate)instance;
        }
        return ImmutableTeamCreate.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TeamCreate", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private long initBits = 1L;
        @Nullable
        private String name;
        @Nullable
        private String description;
        @Nullable
        private String privacy;
        @Nullable
        private String notificationSetting;
        @Nullable
        private List<String> maintainers;
        @Nullable
        private List<String> repoNames;
        @Nullable
        private Integer parentTeamId;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TeamCreate instance) {
            Optional<Integer> parentTeamIdOptional;
            Optional<List<String>> repoNamesOptional;
            Optional<List<String>> maintainersOptional;
            Optional<String> notificationSettingOptional;
            Optional<String> privacyOptional;
            Objects.requireNonNull(instance, "instance");
            this.name(instance.name());
            Optional<String> descriptionOptional = instance.description();
            if (descriptionOptional.isPresent()) {
                this.description(descriptionOptional);
            }
            if ((privacyOptional = instance.privacy()).isPresent()) {
                this.privacy(privacyOptional);
            }
            if ((notificationSettingOptional = instance.notificationSetting()).isPresent()) {
                this.notificationSetting(notificationSettingOptional);
            }
            if ((maintainersOptional = instance.maintainers()).isPresent()) {
                this.maintainers(maintainersOptional);
            }
            if ((repoNamesOptional = instance.repoNames()).isPresent()) {
                this.repoNames(repoNamesOptional);
            }
            if ((parentTeamIdOptional = instance.parentTeamId()).isPresent()) {
                this.parentTeamId(parentTeamIdOptional);
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder description(Optional<String> description) {
            this.description = description.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder privacy(String privacy) {
            this.privacy = Objects.requireNonNull(privacy, "privacy");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder privacy(Optional<String> privacy) {
            this.privacy = privacy.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder notificationSetting(String notificationSetting) {
            this.notificationSetting = Objects.requireNonNull(notificationSetting, "notificationSetting");
            return this;
        }

        @JsonProperty(value="notification_setting")
        @CanIgnoreReturnValue
        public final Builder notificationSetting(Optional<String> notificationSetting) {
            this.notificationSetting = notificationSetting.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder maintainers(List<String> maintainers) {
            this.maintainers = Objects.requireNonNull(maintainers, "maintainers");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder maintainers(Optional<? extends List<String>> maintainers) {
            this.maintainers = maintainers.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder repoNames(List<String> repoNames) {
            this.repoNames = Objects.requireNonNull(repoNames, "repoNames");
            return this;
        }

        @JsonProperty(value="repo_names")
        @CanIgnoreReturnValue
        public final Builder repoNames(Optional<? extends List<String>> repoNames) {
            this.repoNames = repoNames.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder parentTeamId(int parentTeamId) {
            this.parentTeamId = parentTeamId;
            return this;
        }

        @JsonProperty(value="parent_team_id")
        @CanIgnoreReturnValue
        public final Builder parentTeamId(Optional<Integer> parentTeamId) {
            this.parentTeamId = parentTeamId.orElse(null);
            return this;
        }

        public ImmutableTeamCreate build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTeamCreate(this.name, this.description, this.privacy, this.notificationSetting, this.maintainers, this.repoNames, this.parentTeamId);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build TeamCreate, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="TeamCreate", generator="Immutables")
    static final class Json
    implements TeamCreate {
        @Nullable
        String name;
        @Nullable
        Optional<String> description = Optional.empty();
        @Nullable
        Optional<String> privacy = Optional.empty();
        @Nullable
        Optional<String> notificationSetting = Optional.empty();
        @Nullable
        Optional<List<String>> maintainers = Optional.empty();
        @Nullable
        Optional<List<String>> repoNames = Optional.empty();
        @Nullable
        Optional<Integer> parentTeamId = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty
        public void setDescription(Optional<String> description) {
            this.description = description;
        }

        @JsonProperty
        public void setPrivacy(Optional<String> privacy) {
            this.privacy = privacy;
        }

        @JsonProperty(value="notification_setting")
        public void setNotificationSetting(Optional<String> notificationSetting) {
            this.notificationSetting = notificationSetting;
        }

        @JsonProperty
        public void setMaintainers(Optional<List<String>> maintainers) {
            this.maintainers = maintainers;
        }

        @JsonProperty(value="repo_names")
        public void setRepoNames(Optional<List<String>> repoNames) {
            this.repoNames = repoNames;
        }

        @JsonProperty(value="parent_team_id")
        public void setParentTeamId(Optional<Integer> parentTeamId) {
            this.parentTeamId = parentTeamId;
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> description() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> privacy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> notificationSetting() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<List<String>> maintainers() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<List<String>> repoNames() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> parentTeamId() {
            throw new UnsupportedOperationException();
        }
    }
}

