/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.orgs.requests;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.orgs.requests.TeamUpdate;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TeamUpdate", generator="Immutables")
@Immutable
public final class ImmutableTeamUpdate
implements TeamUpdate {
    @Nullable
    private final String name;
    @Nullable
    private final String description;
    @Nullable
    private final String privacy;
    @Nullable
    private final String notificationSetting;
    @Nullable
    private final Integer parentTeamId;

    private ImmutableTeamUpdate(@Nullable String name, @Nullable String description, @Nullable String privacy, @Nullable String notificationSetting, @Nullable Integer parentTeamId) {
        this.name = name;
        this.description = description;
        this.privacy = privacy;
        this.notificationSetting = notificationSetting;
        this.parentTeamId = parentTeamId;
    }

    @Override
    @JsonProperty
    @Nullable
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty
    public Optional<String> description() {
        return Optional.ofNullable(this.description);
    }

    @Override
    @JsonProperty
    public Optional<String> privacy() {
        return Optional.ofNullable(this.privacy);
    }

    @Override
    @JsonProperty(value="notification_setting")
    public Optional<String> notificationSetting() {
        return Optional.ofNullable(this.notificationSetting);
    }

    @Override
    @JsonProperty(value="parent_team_id")
    public Optional<Integer> parentTeamId() {
        return Optional.ofNullable(this.parentTeamId);
    }

    public final ImmutableTeamUpdate withName(@Nullable String value) {
        if (Objects.equals(this.name, value)) {
            return this;
        }
        return new ImmutableTeamUpdate(value, this.description, this.privacy, this.notificationSetting, this.parentTeamId);
    }

    public final ImmutableTeamUpdate withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (Objects.equals(this.description, newValue)) {
            return this;
        }
        return new ImmutableTeamUpdate(this.name, newValue, this.privacy, this.notificationSetting, this.parentTeamId);
    }

    public final ImmutableTeamUpdate withDescription(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new ImmutableTeamUpdate(this.name, value, this.privacy, this.notificationSetting, this.parentTeamId);
    }

    public final ImmutableTeamUpdate withPrivacy(String value) {
        String newValue = Objects.requireNonNull(value, "privacy");
        if (Objects.equals(this.privacy, newValue)) {
            return this;
        }
        return new ImmutableTeamUpdate(this.name, this.description, newValue, this.notificationSetting, this.parentTeamId);
    }

    public final ImmutableTeamUpdate withPrivacy(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.privacy, value)) {
            return this;
        }
        return new ImmutableTeamUpdate(this.name, this.description, value, this.notificationSetting, this.parentTeamId);
    }

    public final ImmutableTeamUpdate withNotificationSetting(String value) {
        String newValue = Objects.requireNonNull(value, "notificationSetting");
        if (Objects.equals(this.notificationSetting, newValue)) {
            return this;
        }
        return new ImmutableTeamUpdate(this.name, this.description, this.privacy, newValue, this.parentTeamId);
    }

    public final ImmutableTeamUpdate withNotificationSetting(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.notificationSetting, value)) {
            return this;
        }
        return new ImmutableTeamUpdate(this.name, this.description, this.privacy, value, this.parentTeamId);
    }

    public final ImmutableTeamUpdate withParentTeamId(int value) {
        Integer newValue = value;
        if (Objects.equals(this.parentTeamId, newValue)) {
            return this;
        }
        return new ImmutableTeamUpdate(this.name, this.description, this.privacy, this.notificationSetting, newValue);
    }

    public final ImmutableTeamUpdate withParentTeamId(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.parentTeamId, value)) {
            return this;
        }
        return new ImmutableTeamUpdate(this.name, this.description, this.privacy, this.notificationSetting, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTeamUpdate && this.equalTo(0, (ImmutableTeamUpdate)another);
    }

    private boolean equalTo(int synthetic, ImmutableTeamUpdate another) {
        return Objects.equals(this.name, another.name) && Objects.equals(this.description, another.description) && Objects.equals(this.privacy, another.privacy) && Objects.equals(this.notificationSetting, another.notificationSetting) && Objects.equals(this.parentTeamId, another.parentTeamId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + Objects.hashCode(this.privacy);
        h += (h << 5) + Objects.hashCode(this.notificationSetting);
        h += (h << 5) + Objects.hashCode(this.parentTeamId);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("TeamUpdate{");
        if (this.name != null) {
            builder.append("name=").append(this.name);
        }
        if (this.description != null) {
            if (builder.length() > 11) {
                builder.append(", ");
            }
            builder.append("description=").append(this.description);
        }
        if (this.privacy != null) {
            if (builder.length() > 11) {
                builder.append(", ");
            }
            builder.append("privacy=").append(this.privacy);
        }
        if (this.notificationSetting != null) {
            if (builder.length() > 11) {
                builder.append(", ");
            }
            builder.append("notificationSetting=").append(this.notificationSetting);
        }
        if (this.parentTeamId != null) {
            if (builder.length() > 11) {
                builder.append(", ");
            }
            builder.append("parentTeamId=").append(this.parentTeamId);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableTeamUpdate fromJson(Json json) {
        Builder builder = ImmutableTeamUpdate.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.privacy != null) {
            builder.privacy(json.privacy);
        }
        if (json.notificationSetting != null) {
            builder.notificationSetting(json.notificationSetting);
        }
        if (json.parentTeamId != null) {
            builder.parentTeamId(json.parentTeamId);
        }
        return builder.build();
    }

    public static ImmutableTeamUpdate copyOf(TeamUpdate instance) {
        if (instance instanceof ImmutableTeamUpdate) {
            return (ImmutableTeamUpdate)instance;
        }
        return ImmutableTeamUpdate.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TeamUpdate", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String name;
        @Nullable
        private String description;
        @Nullable
        private String privacy;
        @Nullable
        private String notificationSetting;
        @Nullable
        private Integer parentTeamId;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TeamUpdate instance) {
            Optional<Integer> parentTeamIdOptional;
            Optional<String> notificationSettingOptional;
            Optional<String> privacyOptional;
            Optional<String> descriptionOptional;
            Objects.requireNonNull(instance, "instance");
            String nameValue = instance.name();
            if (nameValue != null) {
                this.name(nameValue);
            }
            if ((descriptionOptional = instance.description()).isPresent()) {
                this.description(descriptionOptional);
            }
            if ((privacyOptional = instance.privacy()).isPresent()) {
                this.privacy(privacyOptional);
            }
            if ((notificationSettingOptional = instance.notificationSetting()).isPresent()) {
                this.notificationSetting(notificationSettingOptional);
            }
            if ((parentTeamIdOptional = instance.parentTeamId()).isPresent()) {
                this.parentTeamId(parentTeamIdOptional);
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder description(Optional<String> description) {
            this.description = description.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder privacy(String privacy) {
            this.privacy = Objects.requireNonNull(privacy, "privacy");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder privacy(Optional<String> privacy) {
            this.privacy = privacy.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder notificationSetting(String notificationSetting) {
            this.notificationSetting = Objects.requireNonNull(notificationSetting, "notificationSetting");
            return this;
        }

        @JsonProperty(value="notification_setting")
        @CanIgnoreReturnValue
        public final Builder notificationSetting(Optional<String> notificationSetting) {
            this.notificationSetting = notificationSetting.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder parentTeamId(int parentTeamId) {
            this.parentTeamId = parentTeamId;
            return this;
        }

        @JsonProperty(value="parent_team_id")
        @CanIgnoreReturnValue
        public final Builder parentTeamId(Optional<Integer> parentTeamId) {
            this.parentTeamId = parentTeamId.orElse(null);
            return this;
        }

        public ImmutableTeamUpdate build() {
            return new ImmutableTeamUpdate(this.name, this.description, this.privacy, this.notificationSetting, this.parentTeamId);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="TeamUpdate", generator="Immutables")
    static final class Json
    implements TeamUpdate {
        @Nullable
        String name;
        @Nullable
        Optional<String> description = Optional.empty();
        @Nullable
        Optional<String> privacy = Optional.empty();
        @Nullable
        Optional<String> notificationSetting = Optional.empty();
        @Nullable
        Optional<Integer> parentTeamId = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setName(@Nullable String name) {
            this.name = name;
        }

        @JsonProperty
        public void setDescription(Optional<String> description) {
            this.description = description;
        }

        @JsonProperty
        public void setPrivacy(Optional<String> privacy) {
            this.privacy = privacy;
        }

        @JsonProperty(value="notification_setting")
        public void setNotificationSetting(Optional<String> notificationSetting) {
            this.notificationSetting = notificationSetting;
        }

        @JsonProperty(value="parent_team_id")
        public void setParentTeamId(Optional<Integer> parentTeamId) {
            this.parentTeamId = parentTeamId;
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> description() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> privacy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> notificationSetting() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> parentTeamId() {
            throw new UnsupportedOperationException();
        }
    }
}

