/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.prs;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.CloseTracking;
import com.spotify.github.GitHubInstant;
import com.spotify.github.UpdateTracking;
import com.spotify.github.v3.Milestone;
import com.spotify.github.v3.User;
import com.spotify.github.v3.prs.PullRequest;
import com.spotify.github.v3.prs.PullRequestItem;
import com.spotify.github.v3.prs.PullRequestLinks;
import com.spotify.github.v3.prs.PullRequestRef;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="PullRequest", generator="Immutables")
@Immutable
public final class ImmutablePullRequest
implements PullRequest {
    @Nullable
    private final GitHubInstant createdAt;
    @Nullable
    private final GitHubInstant updatedAt;
    @Nullable
    private final GitHubInstant closedAt;
    @Nullable
    private final Integer id;
    @Nullable
    private final URI url;
    @Nullable
    private final URI htmlUrl;
    @Nullable
    private final URI diffUrl;
    @Nullable
    private final URI patchUrl;
    @Nullable
    private final URI issueUrl;
    @Nullable
    private final URI commitsUrl;
    @Nullable
    private final Integer number;
    @Nullable
    private final String state;
    @Nullable
    private final String title;
    @Nullable
    private final String body;
    @Nullable
    private final User assignee;
    @Nullable
    private final List<User> assignees;
    @Nullable
    private final Milestone milestone;
    @Nullable
    private final Boolean locked;
    @Nullable
    private final GitHubInstant mergedAt;
    @Nullable
    private final PullRequestRef head;
    @Nullable
    private final PullRequestRef base;
    @Nullable
    private final User user;
    @Nullable
    private final URI statusesUrl;
    @Nullable
    private final URI reviewCommentsUrl;
    @Nullable
    private final String reviewCommentUrl;
    @Nullable
    private final URI commentsUrl;
    @Nullable
    private final PullRequestLinks links;
    @Nullable
    private final List<User> requestedReviewers;
    @Nullable
    private final List<User> requestedTeams;
    @Nullable
    private final String mergeCommitSha;
    private final String nodeId;
    @Nullable
    private final Boolean merged;
    @Nullable
    private final Boolean mergeable;
    @Nullable
    private final User mergedBy;
    @Nullable
    private final Integer comments;
    @Nullable
    private final Integer reviewComments;
    @Nullable
    private final Integer commits;
    @Nullable
    private final Integer additions;
    @Nullable
    private final Integer deletions;
    @Nullable
    private final Integer changedFiles;
    @Nullable
    private final String mergeableState;
    @Nullable
    private final Boolean draft;

    private ImmutablePullRequest(@Nullable GitHubInstant createdAt, @Nullable GitHubInstant updatedAt, @Nullable GitHubInstant closedAt, @Nullable Integer id, @Nullable URI url, @Nullable URI htmlUrl, @Nullable URI diffUrl, @Nullable URI patchUrl, @Nullable URI issueUrl, @Nullable URI commitsUrl, @Nullable Integer number, @Nullable String state, @Nullable String title, @Nullable String body, @Nullable User assignee, @Nullable List<User> assignees, @Nullable Milestone milestone, @Nullable Boolean locked, @Nullable GitHubInstant mergedAt, @Nullable PullRequestRef head, @Nullable PullRequestRef base, @Nullable User user, @Nullable URI statusesUrl, @Nullable URI reviewCommentsUrl, @Nullable String reviewCommentUrl, @Nullable URI commentsUrl, @Nullable PullRequestLinks links, @Nullable List<User> requestedReviewers, @Nullable List<User> requestedTeams, @Nullable String mergeCommitSha, String nodeId, @Nullable Boolean merged, @Nullable Boolean mergeable, @Nullable User mergedBy, @Nullable Integer comments, @Nullable Integer reviewComments, @Nullable Integer commits, @Nullable Integer additions, @Nullable Integer deletions, @Nullable Integer changedFiles, @Nullable String mergeableState, @Nullable Boolean draft) {
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.closedAt = closedAt;
        this.id = id;
        this.url = url;
        this.htmlUrl = htmlUrl;
        this.diffUrl = diffUrl;
        this.patchUrl = patchUrl;
        this.issueUrl = issueUrl;
        this.commitsUrl = commitsUrl;
        this.number = number;
        this.state = state;
        this.title = title;
        this.body = body;
        this.assignee = assignee;
        this.assignees = assignees;
        this.milestone = milestone;
        this.locked = locked;
        this.mergedAt = mergedAt;
        this.head = head;
        this.base = base;
        this.user = user;
        this.statusesUrl = statusesUrl;
        this.reviewCommentsUrl = reviewCommentsUrl;
        this.reviewCommentUrl = reviewCommentUrl;
        this.commentsUrl = commentsUrl;
        this.links = links;
        this.requestedReviewers = requestedReviewers;
        this.requestedTeams = requestedTeams;
        this.mergeCommitSha = mergeCommitSha;
        this.nodeId = nodeId;
        this.merged = merged;
        this.mergeable = mergeable;
        this.mergedBy = mergedBy;
        this.comments = comments;
        this.reviewComments = reviewComments;
        this.commits = commits;
        this.additions = additions;
        this.deletions = deletions;
        this.changedFiles = changedFiles;
        this.mergeableState = mergeableState;
        this.draft = draft;
    }

    @Override
    @JsonProperty
    @Nullable
    public GitHubInstant createdAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty
    @Nullable
    public GitHubInstant updatedAt() {
        return this.updatedAt;
    }

    @Override
    @JsonProperty
    public Optional<GitHubInstant> closedAt() {
        return Optional.ofNullable(this.closedAt);
    }

    @Override
    @JsonProperty
    @Nullable
    public Integer id() {
        return this.id;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI url() {
        return this.url;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI htmlUrl() {
        return this.htmlUrl;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI diffUrl() {
        return this.diffUrl;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI patchUrl() {
        return this.patchUrl;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI issueUrl() {
        return this.issueUrl;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI commitsUrl() {
        return this.commitsUrl;
    }

    @Override
    @JsonProperty
    @Nullable
    public Integer number() {
        return this.number;
    }

    @Override
    @JsonProperty
    @Nullable
    public String state() {
        return this.state;
    }

    @Override
    @JsonProperty
    @Nullable
    public String title() {
        return this.title;
    }

    @Override
    @JsonProperty
    public Optional<String> body() {
        return Optional.ofNullable(this.body);
    }

    @Override
    @JsonProperty
    public Optional<User> assignee() {
        return Optional.ofNullable(this.assignee);
    }

    @Override
    @JsonProperty
    public Optional<List<User>> assignees() {
        return Optional.ofNullable(this.assignees);
    }

    @Override
    @JsonProperty
    public Optional<Milestone> milestone() {
        return Optional.ofNullable(this.milestone);
    }

    @Override
    @JsonProperty
    @Nullable
    public Boolean locked() {
        return this.locked;
    }

    @Override
    @JsonProperty
    public Optional<GitHubInstant> mergedAt() {
        return Optional.ofNullable(this.mergedAt);
    }

    @Override
    @JsonProperty
    @Nullable
    public PullRequestRef head() {
        return this.head;
    }

    @Override
    @JsonProperty
    @Nullable
    public PullRequestRef base() {
        return this.base;
    }

    @Override
    @JsonProperty
    @Nullable
    public User user() {
        return this.user;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI statusesUrl() {
        return this.statusesUrl;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI reviewCommentsUrl() {
        return this.reviewCommentsUrl;
    }

    @Override
    @JsonProperty
    @Nullable
    public String reviewCommentUrl() {
        return this.reviewCommentUrl;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI commentsUrl() {
        return this.commentsUrl;
    }

    @Override
    @JsonProperty(value="_links")
    @Nullable
    public PullRequestLinks links() {
        return this.links;
    }

    @Override
    @JsonProperty(value="requested_reviewers")
    @Nullable
    public List<User> requestedReviewers() {
        return this.requestedReviewers;
    }

    @Override
    @JsonProperty(value="requested_teams")
    @Nullable
    public List<User> requestedTeams() {
        return this.requestedTeams;
    }

    @Override
    @JsonProperty
    public Optional<String> mergeCommitSha() {
        return Optional.ofNullable(this.mergeCommitSha);
    }

    @Override
    @JsonProperty
    public String nodeId() {
        return this.nodeId;
    }

    @Override
    @JsonProperty
    @Nullable
    public Boolean merged() {
        return this.merged;
    }

    @Override
    @JsonProperty
    public Optional<Boolean> mergeable() {
        return Optional.ofNullable(this.mergeable);
    }

    @Override
    @JsonProperty
    public Optional<User> mergedBy() {
        return Optional.ofNullable(this.mergedBy);
    }

    @Override
    @JsonProperty
    @Nullable
    public Integer comments() {
        return this.comments;
    }

    @Override
    @JsonProperty
    @Nullable
    public Integer reviewComments() {
        return this.reviewComments;
    }

    @Override
    @JsonProperty
    @Nullable
    public Integer commits() {
        return this.commits;
    }

    @Override
    @JsonProperty
    @Nullable
    public Integer additions() {
        return this.additions;
    }

    @Override
    @JsonProperty
    @Nullable
    public Integer deletions() {
        return this.deletions;
    }

    @Override
    @JsonProperty
    @Nullable
    public Integer changedFiles() {
        return this.changedFiles;
    }

    @Override
    @JsonProperty
    @Nullable
    public String mergeableState() {
        return this.mergeableState;
    }

    @Override
    @JsonProperty
    public Optional<Boolean> draft() {
        return Optional.ofNullable(this.draft);
    }

    public final ImmutablePullRequest withCreatedAt(@Nullable GitHubInstant value) {
        if (this.createdAt == value) {
            return this;
        }
        return new ImmutablePullRequest(value, this.updatedAt, this.closedAt, this.id, this.url, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.number, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.head, this.base, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId, this.merged, this.mergeable, this.mergedBy, this.comments, this.reviewComments, this.commits, this.additions, this.deletions, this.changedFiles, this.mergeableState, this.draft);
    }

    public final ImmutablePullRequest withUpdatedAt(@Nullable GitHubInstant value) {
        if (this.updatedAt == value) {
            return this;
        }
        return new ImmutablePullRequest(this.createdAt, value, this.closedAt, this.id, this.url, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.number, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.head, this.base, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId, this.merged, this.mergeable, this.mergedBy, this.comments, this.reviewComments, this.commits, this.additions, this.deletions, this.changedFiles, this.mergeableState, this.draft);
    }

    public final ImmutablePullRequest withClosedAt(GitHubInstant value) {
        GitHubInstant newValue = Objects.requireNonNull(value, "closedAt");
        if (this.closedAt == newValue) {
            return this;
        }
        return new ImmutablePullRequest(this.createdAt, this.updatedAt, newValue, this.id, this.url, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.number, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.head, this.base, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId, this.merged, this.mergeable, this.mergedBy, this.comments, this.reviewComments, this.commits, this.additions, this.deletions, this.changedFiles, this.mergeableState, this.draft);
    }

    public final ImmutablePullRequest withClosedAt(Optional<? extends GitHubInstant> optional) {
        GitHubInstant value = optional.orElse(null);
        if (this.closedAt == value) {
            return this;
        }
        return new ImmutablePullRequest(this.createdAt, this.updatedAt, value, this.id, this.url, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.number, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.head, this.base, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId, this.merged, this.mergeable, this.mergedBy, this.comments, this.reviewComments, this.commits, this.additions, this.deletions, this.changedFiles, this.mergeableState, this.draft);
    }

    public final ImmutablePullRequest withId(@Nullable Integer value) {
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return new ImmutablePullRequest(this.createdAt, this.updatedAt, this.closedAt, value, this.url, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.number, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.head, this.base, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId, this.merged, this.mergeable, this.mergedBy, this.comments, this.reviewComments, this.commits, this.additions, this.deletions, this.changedFiles, this.mergeableState, this.draft);
    }

    public final ImmutablePullRequest withUrl(@Nullable URI value) {
        if (this.url == value) {
            return this;
        }
        return new ImmutablePullRequest(this.createdAt, this.updatedAt, this.closedAt, this.id, value, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.number, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.head, this.base, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId, this.merged, this.mergeable, this.mergedBy, this.comments, this.reviewComments, this.commits, this.additions, this.deletions, this.changedFiles, this.mergeableState, this.draft);
    }

    public final ImmutablePullRequest withHtmlUrl(@Nullable URI value) {
        if (this.htmlUrl == value) {
            return this;
        }
        return new ImmutablePullRequest(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, value, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.number, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.head, this.base, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId, this.merged, this.mergeable, this.mergedBy, this.comments, this.reviewComments, this.commits, this.additions, this.deletions, this.changedFiles, this.mergeableState, this.draft);
    }

    public final ImmutablePullRequest withDiffUrl(@Nullable URI value) {
        if (this.diffUrl == value) {
            return this;
        }
        return new ImmutablePullRequest(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.htmlUrl, value, this.patchUrl, this.issueUrl, this.commitsUrl, this.number, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.head, this.base, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId, this.merged, this.mergeable, this.mergedBy, this.comments, this.reviewComments, this.commits, this.additions, this.deletions, this.changedFiles, this.mergeableState, this.draft);
    }

    public final ImmutablePullRequest withPatchUrl(@Nullable URI value) {
        if (this.patchUrl == value) {
            return this;
        }
        return new ImmutablePullRequest(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.htmlUrl, this.diffUrl, value, this.issueUrl, this.commitsUrl, this.number, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.head, this.base, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId, this.merged, this.mergeable, this.mergedBy, this.comments, this.reviewComments, this.commits, this.additions, this.deletions, this.changedFiles, this.mergeableState, this.draft);
    }

    public final ImmutablePullRequest withIssueUrl(@Nullable URI value) {
        if (this.issueUrl == value) {
            return this;
        }
        return new ImmutablePullRequest(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.htmlUrl, this.diffUrl, this.patchUrl, value, this.commitsUrl, this.number, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.head, this.base, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId, this.merged, this.mergeable, this.mergedBy, this.comments, this.reviewComments, this.commits, this.additions, this.deletions, this.changedFiles, this.mergeableState, this.draft);
    }

    public final ImmutablePullRequest withCommitsUrl(@Nullable URI value) {
        if (this.commitsUrl == value) {
            return this;
        }
        return new ImmutablePullRequest(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, value, this.number, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.head, this.base, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId, this.merged, this.mergeable, this.mergedBy, this.comments, this.reviewComments, this.commits, this.additions, this.deletions, this.changedFiles, this.mergeableState, this.draft);
    }

    public final ImmutablePullRequest withNumber(@Nullable Integer value) {
        if (Objects.equals(this.number, value)) {
            return this;
        }
        return new ImmutablePullRequest(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, value, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.head, this.base, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId, this.merged, this.mergeable, this.mergedBy, this.comments, this.reviewComments, this.commits, this.additions, this.deletions, this.changedFiles, this.mergeableState, this.draft);
    }

    public final ImmutablePullRequest withState(@Nullable String value) {
        if (Objects.equals(this.state, value)) {
            return this;
        }
        return new ImmutablePullRequest(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.number, value, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.head, this.base, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId, this.merged, this.mergeable, this.mergedBy, this.comments, this.reviewComments, this.commits, this.additions, this.deletions, this.changedFiles, this.mergeableState, this.draft);
    }

    public final ImmutablePullRequest withTitle(@Nullable String value) {
        if (Objects.equals(this.title, value)) {
            return this;
        }
        return new ImmutablePullRequest(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.number, this.state, value, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.head, this.base, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId, this.merged, this.mergeable, this.mergedBy, this.comments, this.reviewComments, this.commits, this.additions, this.deletions, this.changedFiles, this.mergeableState, this.draft);
    }

    public final ImmutablePullRequest withBody(String value) {
        String newValue = Objects.requireNonNull(value, "body");
        if (Objects.equals(this.body, newValue)) {
            return this;
        }
        return new ImmutablePullRequest(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.number, this.state, this.title, newValue, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.head, this.base, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId, this.merged, this.mergeable, this.mergedBy, this.comments, this.reviewComments, this.commits, this.additions, this.deletions, this.changedFiles, this.mergeableState, this.draft);
    }

    public final ImmutablePullRequest withBody(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.body, value)) {
            return this;
        }
        return new ImmutablePullRequest(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.number, this.state, this.title, value, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.head, this.base, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId, this.merged, this.mergeable, this.mergedBy, this.comments, this.reviewComments, this.commits, this.additions, this.deletions, this.changedFiles, this.mergeableState, this.draft);
    }

    public final ImmutablePullRequest withAssignee(User value) {
        User newValue = Objects.requireNonNull(value, "assignee");
        if (this.assignee == newValue) {
            return this;
        }
        return new ImmutablePullRequest(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.number, this.state, this.title, this.body, newValue, this.assignees, this.milestone, this.locked, this.mergedAt, this.head, this.base, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId, this.merged, this.mergeable, this.mergedBy, this.comments, this.reviewComments, this.commits, this.additions, this.deletions, this.changedFiles, this.mergeableState, this.draft);
    }

    public final ImmutablePullRequest withAssignee(Optional<? extends User> optional) {
        User value = optional.orElse(null);
        if (this.assignee == value) {
            return this;
        }
        return new ImmutablePullRequest(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.number, this.state, this.title, this.body, value, this.assignees, this.milestone, this.locked, this.mergedAt, this.head, this.base, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId, this.merged, this.mergeable, this.mergedBy, this.comments, this.reviewComments, this.commits, this.additions, this.deletions, this.changedFiles, this.mergeableState, this.draft);
    }

    public final ImmutablePullRequest withAssignees(List<User> value) {
        List<User> newValue = Objects.requireNonNull(value, "assignees");
        if (this.assignees == newValue) {
            return this;
        }
        return new ImmutablePullRequest(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.number, this.state, this.title, this.body, this.assignee, newValue, this.milestone, this.locked, this.mergedAt, this.head, this.base, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId, this.merged, this.mergeable, this.mergedBy, this.comments, this.reviewComments, this.commits, this.additions, this.deletions, this.changedFiles, this.mergeableState, this.draft);
    }

    public final ImmutablePullRequest withAssignees(Optional<? extends List<User>> optional) {
        List value = optional.orElse(null);
        if (this.assignees == value) {
            return this;
        }
        return new ImmutablePullRequest(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.number, this.state, this.title, this.body, this.assignee, value, this.milestone, this.locked, this.mergedAt, this.head, this.base, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId, this.merged, this.mergeable, this.mergedBy, this.comments, this.reviewComments, this.commits, this.additions, this.deletions, this.changedFiles, this.mergeableState, this.draft);
    }

    public final ImmutablePullRequest withMilestone(Milestone value) {
        Milestone newValue = Objects.requireNonNull(value, "milestone");
        if (this.milestone == newValue) {
            return this;
        }
        return new ImmutablePullRequest(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.number, this.state, this.title, this.body, this.assignee, this.assignees, newValue, this.locked, this.mergedAt, this.head, this.base, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId, this.merged, this.mergeable, this.mergedBy, this.comments, this.reviewComments, this.commits, this.additions, this.deletions, this.changedFiles, this.mergeableState, this.draft);
    }

    public final ImmutablePullRequest withMilestone(Optional<? extends Milestone> optional) {
        Milestone value = optional.orElse(null);
        if (this.milestone == value) {
            return this;
        }
        return new ImmutablePullRequest(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.number, this.state, this.title, this.body, this.assignee, this.assignees, value, this.locked, this.mergedAt, this.head, this.base, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId, this.merged, this.mergeable, this.mergedBy, this.comments, this.reviewComments, this.commits, this.additions, this.deletions, this.changedFiles, this.mergeableState, this.draft);
    }

    public final ImmutablePullRequest withLocked(@Nullable Boolean value) {
        if (Objects.equals(this.locked, value)) {
            return this;
        }
        return new ImmutablePullRequest(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.number, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, value, this.mergedAt, this.head, this.base, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId, this.merged, this.mergeable, this.mergedBy, this.comments, this.reviewComments, this.commits, this.additions, this.deletions, this.changedFiles, this.mergeableState, this.draft);
    }

    public final ImmutablePullRequest withMergedAt(GitHubInstant value) {
        GitHubInstant newValue = Objects.requireNonNull(value, "mergedAt");
        if (this.mergedAt == newValue) {
            return this;
        }
        return new ImmutablePullRequest(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.number, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, newValue, this.head, this.base, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId, this.merged, this.mergeable, this.mergedBy, this.comments, this.reviewComments, this.commits, this.additions, this.deletions, this.changedFiles, this.mergeableState, this.draft);
    }

    public final ImmutablePullRequest withMergedAt(Optional<? extends GitHubInstant> optional) {
        GitHubInstant value = optional.orElse(null);
        if (this.mergedAt == value) {
            return this;
        }
        return new ImmutablePullRequest(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.number, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, value, this.head, this.base, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId, this.merged, this.mergeable, this.mergedBy, this.comments, this.reviewComments, this.commits, this.additions, this.deletions, this.changedFiles, this.mergeableState, this.draft);
    }

    public final ImmutablePullRequest withHead(@Nullable PullRequestRef value) {
        if (this.head == value) {
            return this;
        }
        return new ImmutablePullRequest(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.number, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, value, this.base, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId, this.merged, this.mergeable, this.mergedBy, this.comments, this.reviewComments, this.commits, this.additions, this.deletions, this.changedFiles, this.mergeableState, this.draft);
    }

    public final ImmutablePullRequest withBase(@Nullable PullRequestRef value) {
        if (this.base == value) {
            return this;
        }
        return new ImmutablePullRequest(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.number, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.head, value, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId, this.merged, this.mergeable, this.mergedBy, this.comments, this.reviewComments, this.commits, this.additions, this.deletions, this.changedFiles, this.mergeableState, this.draft);
    }

    public final ImmutablePullRequest withUser(@Nullable User value) {
        if (this.user == value) {
            return this;
        }
        return new ImmutablePullRequest(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.number, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.head, this.base, value, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId, this.merged, this.mergeable, this.mergedBy, this.comments, this.reviewComments, this.commits, this.additions, this.deletions, this.changedFiles, this.mergeableState, this.draft);
    }

    public final ImmutablePullRequest withStatusesUrl(@Nullable URI value) {
        if (this.statusesUrl == value) {
            return this;
        }
        return new ImmutablePullRequest(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.number, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.head, this.base, this.user, value, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId, this.merged, this.mergeable, this.mergedBy, this.comments, this.reviewComments, this.commits, this.additions, this.deletions, this.changedFiles, this.mergeableState, this.draft);
    }

    public final ImmutablePullRequest withReviewCommentsUrl(@Nullable URI value) {
        if (this.reviewCommentsUrl == value) {
            return this;
        }
        return new ImmutablePullRequest(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.number, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.head, this.base, this.user, this.statusesUrl, value, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId, this.merged, this.mergeable, this.mergedBy, this.comments, this.reviewComments, this.commits, this.additions, this.deletions, this.changedFiles, this.mergeableState, this.draft);
    }

    public final ImmutablePullRequest withReviewCommentUrl(@Nullable String value) {
        if (Objects.equals(this.reviewCommentUrl, value)) {
            return this;
        }
        return new ImmutablePullRequest(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.number, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.head, this.base, this.user, this.statusesUrl, this.reviewCommentsUrl, value, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId, this.merged, this.mergeable, this.mergedBy, this.comments, this.reviewComments, this.commits, this.additions, this.deletions, this.changedFiles, this.mergeableState, this.draft);
    }

    public final ImmutablePullRequest withCommentsUrl(@Nullable URI value) {
        if (this.commentsUrl == value) {
            return this;
        }
        return new ImmutablePullRequest(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.number, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.head, this.base, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, value, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId, this.merged, this.mergeable, this.mergedBy, this.comments, this.reviewComments, this.commits, this.additions, this.deletions, this.changedFiles, this.mergeableState, this.draft);
    }

    public final ImmutablePullRequest withLinks(@Nullable PullRequestLinks value) {
        if (this.links == value) {
            return this;
        }
        return new ImmutablePullRequest(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.number, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.head, this.base, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, value, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId, this.merged, this.mergeable, this.mergedBy, this.comments, this.reviewComments, this.commits, this.additions, this.deletions, this.changedFiles, this.mergeableState, this.draft);
    }

    public final ImmutablePullRequest withRequestedReviewers(User ... elements) {
        if (elements == null) {
            return new ImmutablePullRequest(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.number, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.head, this.base, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, null, this.requestedTeams, this.mergeCommitSha, this.nodeId, this.merged, this.mergeable, this.mergedBy, this.comments, this.reviewComments, this.commits, this.additions, this.deletions, this.changedFiles, this.mergeableState, this.draft);
        }
        List<User> newValue = Arrays.asList(elements) == null ? null : ImmutablePullRequest.createUnmodifiableList(false, ImmutablePullRequest.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutablePullRequest(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.number, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.head, this.base, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, newValue, this.requestedTeams, this.mergeCommitSha, this.nodeId, this.merged, this.mergeable, this.mergedBy, this.comments, this.reviewComments, this.commits, this.additions, this.deletions, this.changedFiles, this.mergeableState, this.draft);
    }

    public final ImmutablePullRequest withRequestedReviewers(@Nullable Iterable<? extends User> elements) {
        if (this.requestedReviewers == elements) {
            return this;
        }
        List<User> newValue = elements == null ? null : ImmutablePullRequest.createUnmodifiableList(false, ImmutablePullRequest.createSafeList(elements, true, false));
        return new ImmutablePullRequest(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.number, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.head, this.base, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, newValue, this.requestedTeams, this.mergeCommitSha, this.nodeId, this.merged, this.mergeable, this.mergedBy, this.comments, this.reviewComments, this.commits, this.additions, this.deletions, this.changedFiles, this.mergeableState, this.draft);
    }

    public final ImmutablePullRequest withRequestedTeams(User ... elements) {
        if (elements == null) {
            return new ImmutablePullRequest(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.number, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.head, this.base, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, null, this.mergeCommitSha, this.nodeId, this.merged, this.mergeable, this.mergedBy, this.comments, this.reviewComments, this.commits, this.additions, this.deletions, this.changedFiles, this.mergeableState, this.draft);
        }
        List<User> newValue = Arrays.asList(elements) == null ? null : ImmutablePullRequest.createUnmodifiableList(false, ImmutablePullRequest.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutablePullRequest(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.number, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.head, this.base, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, newValue, this.mergeCommitSha, this.nodeId, this.merged, this.mergeable, this.mergedBy, this.comments, this.reviewComments, this.commits, this.additions, this.deletions, this.changedFiles, this.mergeableState, this.draft);
    }

    public final ImmutablePullRequest withRequestedTeams(@Nullable Iterable<? extends User> elements) {
        if (this.requestedTeams == elements) {
            return this;
        }
        List<User> newValue = elements == null ? null : ImmutablePullRequest.createUnmodifiableList(false, ImmutablePullRequest.createSafeList(elements, true, false));
        return new ImmutablePullRequest(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.number, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.head, this.base, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, newValue, this.mergeCommitSha, this.nodeId, this.merged, this.mergeable, this.mergedBy, this.comments, this.reviewComments, this.commits, this.additions, this.deletions, this.changedFiles, this.mergeableState, this.draft);
    }

    public final ImmutablePullRequest withMergeCommitSha(String value) {
        String newValue = Objects.requireNonNull(value, "mergeCommitSha");
        if (Objects.equals(this.mergeCommitSha, newValue)) {
            return this;
        }
        return new ImmutablePullRequest(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.number, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.head, this.base, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, newValue, this.nodeId, this.merged, this.mergeable, this.mergedBy, this.comments, this.reviewComments, this.commits, this.additions, this.deletions, this.changedFiles, this.mergeableState, this.draft);
    }

    public final ImmutablePullRequest withMergeCommitSha(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.mergeCommitSha, value)) {
            return this;
        }
        return new ImmutablePullRequest(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.number, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.head, this.base, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, value, this.nodeId, this.merged, this.mergeable, this.mergedBy, this.comments, this.reviewComments, this.commits, this.additions, this.deletions, this.changedFiles, this.mergeableState, this.draft);
    }

    public final ImmutablePullRequest withNodeId(String value) {
        String newValue = Objects.requireNonNull(value, "nodeId");
        if (this.nodeId.equals(newValue)) {
            return this;
        }
        return new ImmutablePullRequest(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.number, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.head, this.base, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, newValue, this.merged, this.mergeable, this.mergedBy, this.comments, this.reviewComments, this.commits, this.additions, this.deletions, this.changedFiles, this.mergeableState, this.draft);
    }

    public final ImmutablePullRequest withMerged(@Nullable Boolean value) {
        if (Objects.equals(this.merged, value)) {
            return this;
        }
        return new ImmutablePullRequest(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.number, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.head, this.base, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId, value, this.mergeable, this.mergedBy, this.comments, this.reviewComments, this.commits, this.additions, this.deletions, this.changedFiles, this.mergeableState, this.draft);
    }

    public final ImmutablePullRequest withMergeable(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.mergeable, newValue)) {
            return this;
        }
        return new ImmutablePullRequest(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.number, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.head, this.base, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId, this.merged, newValue, this.mergedBy, this.comments, this.reviewComments, this.commits, this.additions, this.deletions, this.changedFiles, this.mergeableState, this.draft);
    }

    public final ImmutablePullRequest withMergeable(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.mergeable, value)) {
            return this;
        }
        return new ImmutablePullRequest(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.number, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.head, this.base, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId, this.merged, value, this.mergedBy, this.comments, this.reviewComments, this.commits, this.additions, this.deletions, this.changedFiles, this.mergeableState, this.draft);
    }

    public final ImmutablePullRequest withMergedBy(User value) {
        User newValue = Objects.requireNonNull(value, "mergedBy");
        if (this.mergedBy == newValue) {
            return this;
        }
        return new ImmutablePullRequest(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.number, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.head, this.base, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId, this.merged, this.mergeable, newValue, this.comments, this.reviewComments, this.commits, this.additions, this.deletions, this.changedFiles, this.mergeableState, this.draft);
    }

    public final ImmutablePullRequest withMergedBy(Optional<? extends User> optional) {
        User value = optional.orElse(null);
        if (this.mergedBy == value) {
            return this;
        }
        return new ImmutablePullRequest(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.number, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.head, this.base, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId, this.merged, this.mergeable, value, this.comments, this.reviewComments, this.commits, this.additions, this.deletions, this.changedFiles, this.mergeableState, this.draft);
    }

    public final ImmutablePullRequest withComments(@Nullable Integer value) {
        if (Objects.equals(this.comments, value)) {
            return this;
        }
        return new ImmutablePullRequest(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.number, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.head, this.base, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId, this.merged, this.mergeable, this.mergedBy, value, this.reviewComments, this.commits, this.additions, this.deletions, this.changedFiles, this.mergeableState, this.draft);
    }

    public final ImmutablePullRequest withReviewComments(@Nullable Integer value) {
        if (Objects.equals(this.reviewComments, value)) {
            return this;
        }
        return new ImmutablePullRequest(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.number, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.head, this.base, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId, this.merged, this.mergeable, this.mergedBy, this.comments, value, this.commits, this.additions, this.deletions, this.changedFiles, this.mergeableState, this.draft);
    }

    public final ImmutablePullRequest withCommits(@Nullable Integer value) {
        if (Objects.equals(this.commits, value)) {
            return this;
        }
        return new ImmutablePullRequest(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.number, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.head, this.base, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId, this.merged, this.mergeable, this.mergedBy, this.comments, this.reviewComments, value, this.additions, this.deletions, this.changedFiles, this.mergeableState, this.draft);
    }

    public final ImmutablePullRequest withAdditions(@Nullable Integer value) {
        if (Objects.equals(this.additions, value)) {
            return this;
        }
        return new ImmutablePullRequest(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.number, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.head, this.base, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId, this.merged, this.mergeable, this.mergedBy, this.comments, this.reviewComments, this.commits, value, this.deletions, this.changedFiles, this.mergeableState, this.draft);
    }

    public final ImmutablePullRequest withDeletions(@Nullable Integer value) {
        if (Objects.equals(this.deletions, value)) {
            return this;
        }
        return new ImmutablePullRequest(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.number, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.head, this.base, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId, this.merged, this.mergeable, this.mergedBy, this.comments, this.reviewComments, this.commits, this.additions, value, this.changedFiles, this.mergeableState, this.draft);
    }

    public final ImmutablePullRequest withChangedFiles(@Nullable Integer value) {
        if (Objects.equals(this.changedFiles, value)) {
            return this;
        }
        return new ImmutablePullRequest(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.number, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.head, this.base, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId, this.merged, this.mergeable, this.mergedBy, this.comments, this.reviewComments, this.commits, this.additions, this.deletions, value, this.mergeableState, this.draft);
    }

    public final ImmutablePullRequest withMergeableState(@Nullable String value) {
        if (Objects.equals(this.mergeableState, value)) {
            return this;
        }
        return new ImmutablePullRequest(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.number, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.head, this.base, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId, this.merged, this.mergeable, this.mergedBy, this.comments, this.reviewComments, this.commits, this.additions, this.deletions, this.changedFiles, value, this.draft);
    }

    public final ImmutablePullRequest withDraft(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.draft, newValue)) {
            return this;
        }
        return new ImmutablePullRequest(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.number, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.head, this.base, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId, this.merged, this.mergeable, this.mergedBy, this.comments, this.reviewComments, this.commits, this.additions, this.deletions, this.changedFiles, this.mergeableState, newValue);
    }

    public final ImmutablePullRequest withDraft(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.draft, value)) {
            return this;
        }
        return new ImmutablePullRequest(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.number, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.head, this.base, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers, this.requestedTeams, this.mergeCommitSha, this.nodeId, this.merged, this.mergeable, this.mergedBy, this.comments, this.reviewComments, this.commits, this.additions, this.deletions, this.changedFiles, this.mergeableState, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePullRequest && this.equalTo(0, (ImmutablePullRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutablePullRequest another) {
        return Objects.equals(this.createdAt, another.createdAt) && Objects.equals(this.updatedAt, another.updatedAt) && Objects.equals(this.closedAt, another.closedAt) && Objects.equals(this.id, another.id) && Objects.equals(this.url, another.url) && Objects.equals(this.htmlUrl, another.htmlUrl) && Objects.equals(this.diffUrl, another.diffUrl) && Objects.equals(this.patchUrl, another.patchUrl) && Objects.equals(this.issueUrl, another.issueUrl) && Objects.equals(this.commitsUrl, another.commitsUrl) && Objects.equals(this.number, another.number) && Objects.equals(this.state, another.state) && Objects.equals(this.title, another.title) && Objects.equals(this.body, another.body) && Objects.equals(this.assignee, another.assignee) && Objects.equals(this.assignees, another.assignees) && Objects.equals(this.milestone, another.milestone) && Objects.equals(this.locked, another.locked) && Objects.equals(this.mergedAt, another.mergedAt) && Objects.equals(this.head, another.head) && Objects.equals(this.base, another.base) && Objects.equals(this.user, another.user) && Objects.equals(this.statusesUrl, another.statusesUrl) && Objects.equals(this.reviewCommentsUrl, another.reviewCommentsUrl) && Objects.equals(this.reviewCommentUrl, another.reviewCommentUrl) && Objects.equals(this.commentsUrl, another.commentsUrl) && Objects.equals(this.links, another.links) && Objects.equals(this.requestedReviewers, another.requestedReviewers) && Objects.equals(this.requestedTeams, another.requestedTeams) && Objects.equals(this.mergeCommitSha, another.mergeCommitSha) && this.nodeId.equals(another.nodeId) && Objects.equals(this.merged, another.merged) && Objects.equals(this.mergeable, another.mergeable) && Objects.equals(this.mergedBy, another.mergedBy) && Objects.equals(this.comments, another.comments) && Objects.equals(this.reviewComments, another.reviewComments) && Objects.equals(this.commits, another.commits) && Objects.equals(this.additions, another.additions) && Objects.equals(this.deletions, another.deletions) && Objects.equals(this.changedFiles, another.changedFiles) && Objects.equals(this.mergeableState, another.mergeableState) && Objects.equals(this.draft, another.draft);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.createdAt);
        h += (h << 5) + Objects.hashCode(this.updatedAt);
        h += (h << 5) + Objects.hashCode(this.closedAt);
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + Objects.hashCode(this.url);
        h += (h << 5) + Objects.hashCode(this.htmlUrl);
        h += (h << 5) + Objects.hashCode(this.diffUrl);
        h += (h << 5) + Objects.hashCode(this.patchUrl);
        h += (h << 5) + Objects.hashCode(this.issueUrl);
        h += (h << 5) + Objects.hashCode(this.commitsUrl);
        h += (h << 5) + Objects.hashCode(this.number);
        h += (h << 5) + Objects.hashCode(this.state);
        h += (h << 5) + Objects.hashCode(this.title);
        h += (h << 5) + Objects.hashCode(this.body);
        h += (h << 5) + Objects.hashCode(this.assignee);
        h += (h << 5) + Objects.hashCode(this.assignees);
        h += (h << 5) + Objects.hashCode(this.milestone);
        h += (h << 5) + Objects.hashCode(this.locked);
        h += (h << 5) + Objects.hashCode(this.mergedAt);
        h += (h << 5) + Objects.hashCode(this.head);
        h += (h << 5) + Objects.hashCode(this.base);
        h += (h << 5) + Objects.hashCode(this.user);
        h += (h << 5) + Objects.hashCode(this.statusesUrl);
        h += (h << 5) + Objects.hashCode(this.reviewCommentsUrl);
        h += (h << 5) + Objects.hashCode(this.reviewCommentUrl);
        h += (h << 5) + Objects.hashCode(this.commentsUrl);
        h += (h << 5) + Objects.hashCode(this.links);
        h += (h << 5) + Objects.hashCode(this.requestedReviewers);
        h += (h << 5) + Objects.hashCode(this.requestedTeams);
        h += (h << 5) + Objects.hashCode(this.mergeCommitSha);
        h += (h << 5) + this.nodeId.hashCode();
        h += (h << 5) + Objects.hashCode(this.merged);
        h += (h << 5) + Objects.hashCode(this.mergeable);
        h += (h << 5) + Objects.hashCode(this.mergedBy);
        h += (h << 5) + Objects.hashCode(this.comments);
        h += (h << 5) + Objects.hashCode(this.reviewComments);
        h += (h << 5) + Objects.hashCode(this.commits);
        h += (h << 5) + Objects.hashCode(this.additions);
        h += (h << 5) + Objects.hashCode(this.deletions);
        h += (h << 5) + Objects.hashCode(this.changedFiles);
        h += (h << 5) + Objects.hashCode(this.mergeableState);
        h += (h << 5) + Objects.hashCode(this.draft);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("PullRequest{");
        if (this.createdAt != null) {
            builder.append("createdAt=").append(this.createdAt);
        }
        if (this.updatedAt != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("updatedAt=").append(this.updatedAt);
        }
        if (this.closedAt != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("closedAt=").append(this.closedAt);
        }
        if (this.id != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("id=").append(this.id);
        }
        if (this.url != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("url=").append(this.url);
        }
        if (this.htmlUrl != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("htmlUrl=").append(this.htmlUrl);
        }
        if (this.diffUrl != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("diffUrl=").append(this.diffUrl);
        }
        if (this.patchUrl != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("patchUrl=").append(this.patchUrl);
        }
        if (this.issueUrl != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("issueUrl=").append(this.issueUrl);
        }
        if (this.commitsUrl != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("commitsUrl=").append(this.commitsUrl);
        }
        if (this.number != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("number=").append(this.number);
        }
        if (this.state != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("state=").append(this.state);
        }
        if (this.title != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("title=").append(this.title);
        }
        if (this.body != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("body=").append(this.body);
        }
        if (this.assignee != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("assignee=").append(this.assignee);
        }
        if (this.assignees != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("assignees=").append(this.assignees);
        }
        if (this.milestone != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("milestone=").append(this.milestone);
        }
        if (this.locked != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("locked=").append(this.locked);
        }
        if (this.mergedAt != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("mergedAt=").append(this.mergedAt);
        }
        if (this.head != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("head=").append(this.head);
        }
        if (this.base != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("base=").append(this.base);
        }
        if (this.user != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("user=").append(this.user);
        }
        if (this.statusesUrl != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("statusesUrl=").append(this.statusesUrl);
        }
        if (this.reviewCommentsUrl != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("reviewCommentsUrl=").append(this.reviewCommentsUrl);
        }
        if (this.reviewCommentUrl != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("reviewCommentUrl=").append(this.reviewCommentUrl);
        }
        if (this.commentsUrl != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("commentsUrl=").append(this.commentsUrl);
        }
        if (this.links != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("links=").append(this.links);
        }
        if (this.requestedReviewers != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("requestedReviewers=").append(this.requestedReviewers);
        }
        if (this.requestedTeams != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("requestedTeams=").append(this.requestedTeams);
        }
        if (this.mergeCommitSha != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("mergeCommitSha=").append(this.mergeCommitSha);
        }
        if (builder.length() > 12) {
            builder.append(", ");
        }
        builder.append("nodeId=").append(this.nodeId);
        if (this.merged != null) {
            builder.append(", ");
            builder.append("merged=").append(this.merged);
        }
        if (this.mergeable != null) {
            builder.append(", ");
            builder.append("mergeable=").append(this.mergeable);
        }
        if (this.mergedBy != null) {
            builder.append(", ");
            builder.append("mergedBy=").append(this.mergedBy);
        }
        if (this.comments != null) {
            builder.append(", ");
            builder.append("comments=").append(this.comments);
        }
        if (this.reviewComments != null) {
            builder.append(", ");
            builder.append("reviewComments=").append(this.reviewComments);
        }
        if (this.commits != null) {
            builder.append(", ");
            builder.append("commits=").append(this.commits);
        }
        if (this.additions != null) {
            builder.append(", ");
            builder.append("additions=").append(this.additions);
        }
        if (this.deletions != null) {
            builder.append(", ");
            builder.append("deletions=").append(this.deletions);
        }
        if (this.changedFiles != null) {
            builder.append(", ");
            builder.append("changedFiles=").append(this.changedFiles);
        }
        if (this.mergeableState != null) {
            builder.append(", ");
            builder.append("mergeableState=").append(this.mergeableState);
        }
        if (this.draft != null) {
            builder.append(", ");
            builder.append("draft=").append(this.draft);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePullRequest fromJson(Json json) {
        Builder builder = ImmutablePullRequest.builder();
        if (json.createdAt != null) {
            builder.createdAt(json.createdAt);
        }
        if (json.updatedAt != null) {
            builder.updatedAt(json.updatedAt);
        }
        if (json.closedAt != null) {
            builder.closedAt(json.closedAt);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.url != null) {
            builder.url(json.url);
        }
        if (json.htmlUrl != null) {
            builder.htmlUrl(json.htmlUrl);
        }
        if (json.diffUrl != null) {
            builder.diffUrl(json.diffUrl);
        }
        if (json.patchUrl != null) {
            builder.patchUrl(json.patchUrl);
        }
        if (json.issueUrl != null) {
            builder.issueUrl(json.issueUrl);
        }
        if (json.commitsUrl != null) {
            builder.commitsUrl(json.commitsUrl);
        }
        if (json.number != null) {
            builder.number(json.number);
        }
        if (json.state != null) {
            builder.state(json.state);
        }
        if (json.title != null) {
            builder.title(json.title);
        }
        if (json.body != null) {
            builder.body(json.body);
        }
        if (json.assignee != null) {
            builder.assignee(json.assignee);
        }
        if (json.assignees != null) {
            builder.assignees(json.assignees);
        }
        if (json.milestone != null) {
            builder.milestone(json.milestone);
        }
        if (json.locked != null) {
            builder.locked(json.locked);
        }
        if (json.mergedAt != null) {
            builder.mergedAt(json.mergedAt);
        }
        if (json.head != null) {
            builder.head(json.head);
        }
        if (json.base != null) {
            builder.base(json.base);
        }
        if (json.user != null) {
            builder.user(json.user);
        }
        if (json.statusesUrl != null) {
            builder.statusesUrl(json.statusesUrl);
        }
        if (json.reviewCommentsUrl != null) {
            builder.reviewCommentsUrl(json.reviewCommentsUrl);
        }
        if (json.reviewCommentUrl != null) {
            builder.reviewCommentUrl(json.reviewCommentUrl);
        }
        if (json.commentsUrl != null) {
            builder.commentsUrl(json.commentsUrl);
        }
        if (json.links != null) {
            builder.links(json.links);
        }
        if (json.requestedReviewers != null) {
            builder.addAllRequestedReviewers(json.requestedReviewers);
        }
        if (json.requestedTeams != null) {
            builder.addAllRequestedTeams(json.requestedTeams);
        }
        if (json.mergeCommitSha != null) {
            builder.mergeCommitSha(json.mergeCommitSha);
        }
        if (json.nodeId != null) {
            builder.nodeId(json.nodeId);
        }
        if (json.merged != null) {
            builder.merged(json.merged);
        }
        if (json.mergeable != null) {
            builder.mergeable(json.mergeable);
        }
        if (json.mergedBy != null) {
            builder.mergedBy(json.mergedBy);
        }
        if (json.comments != null) {
            builder.comments(json.comments);
        }
        if (json.reviewComments != null) {
            builder.reviewComments(json.reviewComments);
        }
        if (json.commits != null) {
            builder.commits(json.commits);
        }
        if (json.additions != null) {
            builder.additions(json.additions);
        }
        if (json.deletions != null) {
            builder.deletions(json.deletions);
        }
        if (json.changedFiles != null) {
            builder.changedFiles(json.changedFiles);
        }
        if (json.mergeableState != null) {
            builder.mergeableState(json.mergeableState);
        }
        if (json.draft != null) {
            builder.draft(json.draft);
        }
        return builder.build();
    }

    public static ImmutablePullRequest copyOf(PullRequest instance) {
        if (instance instanceof ImmutablePullRequest) {
            return (ImmutablePullRequest)instance;
        }
        return ImmutablePullRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="PullRequest", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NODE_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private GitHubInstant createdAt;
        @Nullable
        private GitHubInstant updatedAt;
        @Nullable
        private GitHubInstant closedAt;
        @Nullable
        private Integer id;
        @Nullable
        private URI url;
        @Nullable
        private URI htmlUrl;
        @Nullable
        private URI diffUrl;
        @Nullable
        private URI patchUrl;
        @Nullable
        private URI issueUrl;
        @Nullable
        private URI commitsUrl;
        @Nullable
        private Integer number;
        @Nullable
        private String state;
        @Nullable
        private String title;
        @Nullable
        private String body;
        @Nullable
        private User assignee;
        @Nullable
        private List<User> assignees;
        @Nullable
        private Milestone milestone;
        @Nullable
        private Boolean locked;
        @Nullable
        private GitHubInstant mergedAt;
        @Nullable
        private PullRequestRef head;
        @Nullable
        private PullRequestRef base;
        @Nullable
        private User user;
        @Nullable
        private URI statusesUrl;
        @Nullable
        private URI reviewCommentsUrl;
        @Nullable
        private String reviewCommentUrl;
        @Nullable
        private URI commentsUrl;
        @Nullable
        private PullRequestLinks links;
        private List<User> requestedReviewers = null;
        private List<User> requestedTeams = null;
        @Nullable
        private String mergeCommitSha;
        @Nullable
        private String nodeId;
        @Nullable
        private Boolean merged;
        @Nullable
        private Boolean mergeable;
        @Nullable
        private User mergedBy;
        @Nullable
        private Integer comments;
        @Nullable
        private Integer reviewComments;
        @Nullable
        private Integer commits;
        @Nullable
        private Integer additions;
        @Nullable
        private Integer deletions;
        @Nullable
        private Integer changedFiles;
        @Nullable
        private String mergeableState;
        @Nullable
        private Boolean draft;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(PullRequestItem instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(CloseTracking instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(UpdateTracking instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(PullRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GitHubInstant updatedAtValue;
            Optional<GitHubInstant> closedAtOptional;
            GitHubInstant createdAtValue;
            List<User> requestedReviewersValue;
            UpdateTracking instance;
            long bits = 0L;
            if (object instanceof PullRequestItem) {
                instance = (PullRequestItem)object;
                if ((bits & 1L) == 0L) {
                    requestedReviewersValue = instance.requestedReviewers();
                    if (requestedReviewersValue != null) {
                        this.addAllRequestedReviewers(requestedReviewersValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    URI diffUrlValue = instance.diffUrl();
                    if (diffUrlValue != null) {
                        this.diffUrl(diffUrlValue);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    String reviewCommentUrlValue = instance.reviewCommentUrl();
                    if (reviewCommentUrlValue != null) {
                        this.reviewCommentUrl(reviewCommentUrlValue);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    List<User> requestedTeamsValue = instance.requestedTeams();
                    if (requestedTeamsValue != null) {
                        this.addAllRequestedTeams(requestedTeamsValue);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    Optional<List<User>> assigneesOptional = instance.assignees();
                    if (assigneesOptional.isPresent()) {
                        this.assignees(assigneesOptional);
                    }
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    URI reviewCommentsUrlValue = instance.reviewCommentsUrl();
                    if (reviewCommentsUrlValue != null) {
                        this.reviewCommentsUrl(reviewCommentsUrlValue);
                    }
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    URI commitsUrlValue = instance.commitsUrl();
                    if (commitsUrlValue != null) {
                        this.commitsUrl(commitsUrlValue);
                    }
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    String titleValue = instance.title();
                    if (titleValue != null) {
                        this.title(titleValue);
                    }
                    bits |= 0x80L;
                }
                if ((bits & 0x100L) == 0L) {
                    Optional<String> bodyOptional = instance.body();
                    if (bodyOptional.isPresent()) {
                        this.body(bodyOptional);
                    }
                    bits |= 0x100L;
                }
                if ((bits & 0x200L) == 0L) {
                    PullRequestRef headValue = instance.head();
                    if (headValue != null) {
                        this.head(headValue);
                    }
                    bits |= 0x200L;
                }
                if ((bits & 0x400L) == 0L) {
                    createdAtValue = instance.createdAt();
                    if (createdAtValue != null) {
                        this.createdAt(createdAtValue);
                    }
                    bits |= 0x400L;
                }
                if ((bits & 0x800L) == 0L) {
                    Integer numberValue = instance.number();
                    if (numberValue != null) {
                        this.number(numberValue);
                    }
                    bits |= 0x800L;
                }
                if ((bits & 0x1000L) == 0L) {
                    URI patchUrlValue = instance.patchUrl();
                    if (patchUrlValue != null) {
                        this.patchUrl(patchUrlValue);
                    }
                    bits |= 0x1000L;
                }
                if ((bits & 0x2000L) == 0L) {
                    Optional<String> mergeCommitShaOptional = instance.mergeCommitSha();
                    if (mergeCommitShaOptional.isPresent()) {
                        this.mergeCommitSha(mergeCommitShaOptional);
                    }
                    bits |= 0x2000L;
                }
                if ((bits & 0x4000L) == 0L) {
                    URI statusesUrlValue = instance.statusesUrl();
                    if (statusesUrlValue != null) {
                        this.statusesUrl(statusesUrlValue);
                    }
                    bits |= 0x4000L;
                }
                if ((bits & 0x8000L) == 0L) {
                    PullRequestLinks linksValue = instance.links();
                    if (linksValue != null) {
                        this.links(linksValue);
                    }
                    bits |= 0x8000L;
                }
                if ((bits & 0x10000L) == 0L) {
                    Integer idValue = instance.id();
                    if (idValue != null) {
                        this.id(idValue);
                    }
                    bits |= 0x10000L;
                }
                if ((bits & 0x20000L) == 0L) {
                    String stateValue = instance.state();
                    if (stateValue != null) {
                        this.state(stateValue);
                    }
                    bits |= 0x20000L;
                }
                if ((bits & 0x40000L) == 0L) {
                    closedAtOptional = instance.closedAt();
                    if (closedAtOptional.isPresent()) {
                        this.closedAt(closedAtOptional);
                    }
                    bits |= 0x40000L;
                }
                if ((bits & 0x80000L) == 0L) {
                    Boolean lockedValue = instance.locked();
                    if (lockedValue != null) {
                        this.locked(lockedValue);
                    }
                    bits |= 0x80000L;
                }
                if ((bits & 0x100000L) == 0L) {
                    updatedAtValue = instance.updatedAt();
                    if (updatedAtValue != null) {
                        this.updatedAt(updatedAtValue);
                    }
                    bits |= 0x100000L;
                }
                if ((bits & 0x200000L) == 0L) {
                    Optional<GitHubInstant> mergedAtOptional = instance.mergedAt();
                    if (mergedAtOptional.isPresent()) {
                        this.mergedAt(mergedAtOptional);
                    }
                    bits |= 0x200000L;
                }
                if ((bits & 0x400000L) == 0L) {
                    URI htmlUrlValue = instance.htmlUrl();
                    if (htmlUrlValue != null) {
                        this.htmlUrl(htmlUrlValue);
                    }
                    bits |= 0x400000L;
                }
                if ((bits & 0x800000L) == 0L) {
                    URI urlValue = instance.url();
                    if (urlValue != null) {
                        this.url(urlValue);
                    }
                    bits |= 0x800000L;
                }
                if ((bits & 0x1000000L) == 0L) {
                    URI issueUrlValue = instance.issueUrl();
                    if (issueUrlValue != null) {
                        this.issueUrl(issueUrlValue);
                    }
                    bits |= 0x1000000L;
                }
                if ((bits & 0x2000000L) == 0L) {
                    Optional<Milestone> milestoneOptional = instance.milestone();
                    if (milestoneOptional.isPresent()) {
                        this.milestone(milestoneOptional);
                    }
                    bits |= 0x2000000L;
                }
                if ((bits & 0x4000000L) == 0L) {
                    URI commentsUrlValue = instance.commentsUrl();
                    if (commentsUrlValue != null) {
                        this.commentsUrl(commentsUrlValue);
                    }
                    bits |= 0x4000000L;
                }
                if ((bits & 0x8000000L) == 0L) {
                    Optional<User> assigneeOptional = instance.assignee();
                    if (assigneeOptional.isPresent()) {
                        this.assignee(assigneeOptional);
                    }
                    bits |= 0x8000000L;
                }
                if ((bits & 0x10000000L) == 0L) {
                    User userValue = instance.user();
                    if (userValue != null) {
                        this.user(userValue);
                    }
                    bits |= 0x10000000L;
                }
                if ((bits & 0x20000000L) == 0L) {
                    PullRequestRef baseValue = instance.base();
                    if (baseValue != null) {
                        this.base(baseValue);
                    }
                    bits |= 0x20000000L;
                }
            }
            if (object instanceof CloseTracking) {
                instance = (CloseTracking)object;
                if ((bits & 0x40000L) == 0L) {
                    closedAtOptional = instance.closedAt();
                    if (closedAtOptional.isPresent()) {
                        this.closedAt(closedAtOptional);
                    }
                    bits |= 0x40000L;
                }
                if ((bits & 0x400L) == 0L) {
                    createdAtValue = instance.createdAt();
                    if (createdAtValue != null) {
                        this.createdAt(createdAtValue);
                    }
                    bits |= 0x400L;
                }
                if ((bits & 0x100000L) == 0L) {
                    updatedAtValue = instance.updatedAt();
                    if (updatedAtValue != null) {
                        this.updatedAt(updatedAtValue);
                    }
                    bits |= 0x100000L;
                }
            }
            if (object instanceof UpdateTracking) {
                instance = (UpdateTracking)object;
                if ((bits & 0x400L) == 0L) {
                    createdAtValue = instance.createdAt();
                    if (createdAtValue != null) {
                        this.createdAt(createdAtValue);
                    }
                    bits |= 0x400L;
                }
                if ((bits & 0x100000L) == 0L) {
                    updatedAtValue = instance.updatedAt();
                    if (updatedAtValue != null) {
                        this.updatedAt(updatedAtValue);
                    }
                    bits |= 0x100000L;
                }
            }
            if (object instanceof PullRequest) {
                Optional<User> mergedByOptional;
                Integer commitsValue;
                Boolean mergedValue;
                Integer additionsValue;
                Integer commentsValue;
                Optional<Boolean> draftOptional;
                Integer changedFilesValue;
                Optional<Boolean> mergeableOptional;
                Integer reviewCommentsValue;
                Integer deletionsValue;
                String mergeableStateValue;
                instance = (PullRequest)object;
                if ((bits & 1L) == 0L) {
                    requestedReviewersValue = instance.requestedReviewers();
                    if (requestedReviewersValue != null) {
                        this.addAllRequestedReviewers(requestedReviewersValue);
                    }
                    bits |= 1L;
                }
                if ((mergeableStateValue = instance.mergeableState()) != null) {
                    this.mergeableState(mergeableStateValue);
                }
                if ((bits & 2L) == 0L) {
                    URI diffUrlValue = instance.diffUrl();
                    if (diffUrlValue != null) {
                        this.diffUrl(diffUrlValue);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    String reviewCommentUrlValue = instance.reviewCommentUrl();
                    if (reviewCommentUrlValue != null) {
                        this.reviewCommentUrl(reviewCommentUrlValue);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    List<User> requestedTeamsValue = instance.requestedTeams();
                    if (requestedTeamsValue != null) {
                        this.addAllRequestedTeams(requestedTeamsValue);
                    }
                    bits |= 8L;
                }
                if ((deletionsValue = instance.deletions()) != null) {
                    this.deletions(deletionsValue);
                }
                if ((bits & 0x10L) == 0L) {
                    Optional<List<User>> assigneesOptional = instance.assignees();
                    if (assigneesOptional.isPresent()) {
                        this.assignees(assigneesOptional);
                    }
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    URI reviewCommentsUrlValue = instance.reviewCommentsUrl();
                    if (reviewCommentsUrlValue != null) {
                        this.reviewCommentsUrl(reviewCommentsUrlValue);
                    }
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    URI commitsUrlValue = instance.commitsUrl();
                    if (commitsUrlValue != null) {
                        this.commitsUrl(commitsUrlValue);
                    }
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    String titleValue = instance.title();
                    if (titleValue != null) {
                        this.title(titleValue);
                    }
                    bits |= 0x80L;
                }
                if ((bits & 0x100L) == 0L) {
                    Optional<String> bodyOptional = instance.body();
                    if (bodyOptional.isPresent()) {
                        this.body(bodyOptional);
                    }
                    bits |= 0x100L;
                }
                if ((reviewCommentsValue = instance.reviewComments()) != null) {
                    this.reviewComments(reviewCommentsValue);
                }
                if ((bits & 0x200L) == 0L) {
                    PullRequestRef headValue = instance.head();
                    if (headValue != null) {
                        this.head(headValue);
                    }
                    bits |= 0x200L;
                }
                if ((bits & 0x400L) == 0L) {
                    GitHubInstant createdAtValue2 = instance.createdAt();
                    if (createdAtValue2 != null) {
                        this.createdAt(createdAtValue2);
                    }
                    bits |= 0x400L;
                }
                if ((bits & 0x800L) == 0L) {
                    Integer numberValue = instance.number();
                    if (numberValue != null) {
                        this.number(numberValue);
                    }
                    bits |= 0x800L;
                }
                if ((bits & 0x1000L) == 0L) {
                    URI patchUrlValue = instance.patchUrl();
                    if (patchUrlValue != null) {
                        this.patchUrl(patchUrlValue);
                    }
                    bits |= 0x1000L;
                }
                if ((mergeableOptional = instance.mergeable()).isPresent()) {
                    this.mergeable(mergeableOptional);
                }
                if ((changedFilesValue = instance.changedFiles()) != null) {
                    this.changedFiles(changedFilesValue);
                }
                if ((bits & 0x2000L) == 0L) {
                    Optional<String> mergeCommitShaOptional = instance.mergeCommitSha();
                    if (mergeCommitShaOptional.isPresent()) {
                        this.mergeCommitSha(mergeCommitShaOptional);
                    }
                    bits |= 0x2000L;
                }
                if ((draftOptional = instance.draft()).isPresent()) {
                    this.draft(draftOptional);
                }
                if ((bits & 0x4000L) == 0L) {
                    URI statusesUrlValue = instance.statusesUrl();
                    if (statusesUrlValue != null) {
                        this.statusesUrl(statusesUrlValue);
                    }
                    bits |= 0x4000L;
                }
                if ((bits & 0x8000L) == 0L) {
                    PullRequestLinks linksValue = instance.links();
                    if (linksValue != null) {
                        this.links(linksValue);
                    }
                    bits |= 0x8000L;
                }
                if ((bits & 0x10000L) == 0L) {
                    Integer idValue = instance.id();
                    if (idValue != null) {
                        this.id(idValue);
                    }
                    bits |= 0x10000L;
                }
                if ((bits & 0x20000L) == 0L) {
                    String stateValue = instance.state();
                    if (stateValue != null) {
                        this.state(stateValue);
                    }
                    bits |= 0x20000L;
                }
                if ((bits & 0x40000L) == 0L) {
                    Optional<GitHubInstant> closedAtOptional2 = instance.closedAt();
                    if (closedAtOptional2.isPresent()) {
                        this.closedAt(closedAtOptional2);
                    }
                    bits |= 0x40000L;
                }
                if ((bits & 0x80000L) == 0L) {
                    Boolean lockedValue = instance.locked();
                    if (lockedValue != null) {
                        this.locked(lockedValue);
                    }
                    bits |= 0x80000L;
                }
                if ((bits & 0x100000L) == 0L) {
                    GitHubInstant updatedAtValue2 = instance.updatedAt();
                    if (updatedAtValue2 != null) {
                        this.updatedAt(updatedAtValue2);
                    }
                    bits |= 0x100000L;
                }
                if ((commentsValue = instance.comments()) != null) {
                    this.comments(commentsValue);
                }
                if ((additionsValue = instance.additions()) != null) {
                    this.additions(additionsValue);
                }
                if ((bits & 0x200000L) == 0L) {
                    Optional<GitHubInstant> mergedAtOptional = instance.mergedAt();
                    if (mergedAtOptional.isPresent()) {
                        this.mergedAt(mergedAtOptional);
                    }
                    bits |= 0x200000L;
                }
                if ((bits & 0x400000L) == 0L) {
                    URI htmlUrlValue = instance.htmlUrl();
                    if (htmlUrlValue != null) {
                        this.htmlUrl(htmlUrlValue);
                    }
                    bits |= 0x400000L;
                }
                if ((mergedValue = instance.merged()) != null) {
                    this.merged(mergedValue);
                }
                if ((bits & 0x800000L) == 0L) {
                    URI urlValue = instance.url();
                    if (urlValue != null) {
                        this.url(urlValue);
                    }
                    bits |= 0x800000L;
                }
                if ((bits & 0x1000000L) == 0L) {
                    URI issueUrlValue = instance.issueUrl();
                    if (issueUrlValue != null) {
                        this.issueUrl(issueUrlValue);
                    }
                    bits |= 0x1000000L;
                }
                if ((bits & 0x2000000L) == 0L) {
                    Optional<Milestone> milestoneOptional = instance.milestone();
                    if (milestoneOptional.isPresent()) {
                        this.milestone(milestoneOptional);
                    }
                    bits |= 0x2000000L;
                }
                if ((bits & 0x4000000L) == 0L) {
                    URI commentsUrlValue = instance.commentsUrl();
                    if (commentsUrlValue != null) {
                        this.commentsUrl(commentsUrlValue);
                    }
                    bits |= 0x4000000L;
                }
                if ((commitsValue = instance.commits()) != null) {
                    this.commits(commitsValue);
                }
                if ((bits & 0x8000000L) == 0L) {
                    Optional<User> assigneeOptional = instance.assignee();
                    if (assigneeOptional.isPresent()) {
                        this.assignee(assigneeOptional);
                    }
                    bits |= 0x8000000L;
                }
                if ((mergedByOptional = instance.mergedBy()).isPresent()) {
                    this.mergedBy(mergedByOptional);
                }
                if ((bits & 0x10000000L) == 0L) {
                    User userValue = instance.user();
                    if (userValue != null) {
                        this.user(userValue);
                    }
                    bits |= 0x10000000L;
                }
                this.nodeId(instance.nodeId());
                if ((bits & 0x20000000L) == 0L) {
                    PullRequestRef baseValue = instance.base();
                    if (baseValue != null) {
                        this.base(baseValue);
                    }
                    bits |= 0x20000000L;
                }
            }
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder createdAt(@Nullable GitHubInstant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder updatedAt(@Nullable GitHubInstant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder closedAt(GitHubInstant closedAt) {
            this.closedAt = Objects.requireNonNull(closedAt, "closedAt");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder closedAt(Optional<? extends GitHubInstant> closedAt) {
            this.closedAt = closedAt.orElse(null);
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder id(@Nullable Integer id) {
            this.id = id;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder url(@Nullable URI url) {
            this.url = url;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder htmlUrl(@Nullable URI htmlUrl) {
            this.htmlUrl = htmlUrl;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder diffUrl(@Nullable URI diffUrl) {
            this.diffUrl = diffUrl;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder patchUrl(@Nullable URI patchUrl) {
            this.patchUrl = patchUrl;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder issueUrl(@Nullable URI issueUrl) {
            this.issueUrl = issueUrl;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder commitsUrl(@Nullable URI commitsUrl) {
            this.commitsUrl = commitsUrl;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder number(@Nullable Integer number) {
            this.number = number;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder state(@Nullable String state) {
            this.state = state;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder title(@Nullable String title) {
            this.title = title;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder body(String body) {
            this.body = Objects.requireNonNull(body, "body");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder body(Optional<String> body) {
            this.body = body.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder assignee(User assignee) {
            this.assignee = Objects.requireNonNull(assignee, "assignee");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder assignee(Optional<? extends User> assignee) {
            this.assignee = assignee.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder assignees(List<User> assignees) {
            this.assignees = Objects.requireNonNull(assignees, "assignees");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder assignees(Optional<? extends List<User>> assignees) {
            this.assignees = assignees.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder milestone(Milestone milestone) {
            this.milestone = Objects.requireNonNull(milestone, "milestone");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder milestone(Optional<? extends Milestone> milestone) {
            this.milestone = milestone.orElse(null);
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder locked(@Nullable Boolean locked) {
            this.locked = locked;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder mergedAt(GitHubInstant mergedAt) {
            this.mergedAt = Objects.requireNonNull(mergedAt, "mergedAt");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder mergedAt(Optional<? extends GitHubInstant> mergedAt) {
            this.mergedAt = mergedAt.orElse(null);
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder head(@Nullable PullRequestRef head) {
            this.head = head;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder base(@Nullable PullRequestRef base) {
            this.base = base;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder user(@Nullable User user) {
            this.user = user;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder statusesUrl(@Nullable URI statusesUrl) {
            this.statusesUrl = statusesUrl;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder reviewCommentsUrl(@Nullable URI reviewCommentsUrl) {
            this.reviewCommentsUrl = reviewCommentsUrl;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder reviewCommentUrl(@Nullable String reviewCommentUrl) {
            this.reviewCommentUrl = reviewCommentUrl;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder commentsUrl(@Nullable URI commentsUrl) {
            this.commentsUrl = commentsUrl;
            return this;
        }

        @JsonProperty(value="_links")
        @CanIgnoreReturnValue
        public final Builder links(@Nullable PullRequestLinks links) {
            this.links = links;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRequestedReviewers(User element) {
            if (this.requestedReviewers == null) {
                this.requestedReviewers = new ArrayList<User>();
            }
            this.requestedReviewers.add(Objects.requireNonNull(element, "requestedReviewers element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRequestedReviewers(User ... elements) {
            if (this.requestedReviewers == null) {
                this.requestedReviewers = new ArrayList<User>();
            }
            for (User element : elements) {
                this.requestedReviewers.add(Objects.requireNonNull(element, "requestedReviewers element"));
            }
            return this;
        }

        @JsonProperty(value="requested_reviewers")
        @CanIgnoreReturnValue
        public final Builder requestedReviewers(@Nullable Iterable<? extends User> elements) {
            if (elements == null) {
                this.requestedReviewers = null;
                return this;
            }
            this.requestedReviewers = new ArrayList<User>();
            return this.addAllRequestedReviewers(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllRequestedReviewers(Iterable<? extends User> elements) {
            Objects.requireNonNull(elements, "requestedReviewers element");
            if (this.requestedReviewers == null) {
                this.requestedReviewers = new ArrayList<User>();
            }
            for (User user : elements) {
                this.requestedReviewers.add(Objects.requireNonNull(user, "requestedReviewers element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRequestedTeams(User element) {
            if (this.requestedTeams == null) {
                this.requestedTeams = new ArrayList<User>();
            }
            this.requestedTeams.add(Objects.requireNonNull(element, "requestedTeams element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRequestedTeams(User ... elements) {
            if (this.requestedTeams == null) {
                this.requestedTeams = new ArrayList<User>();
            }
            for (User element : elements) {
                this.requestedTeams.add(Objects.requireNonNull(element, "requestedTeams element"));
            }
            return this;
        }

        @JsonProperty(value="requested_teams")
        @CanIgnoreReturnValue
        public final Builder requestedTeams(@Nullable Iterable<? extends User> elements) {
            if (elements == null) {
                this.requestedTeams = null;
                return this;
            }
            this.requestedTeams = new ArrayList<User>();
            return this.addAllRequestedTeams(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllRequestedTeams(Iterable<? extends User> elements) {
            Objects.requireNonNull(elements, "requestedTeams element");
            if (this.requestedTeams == null) {
                this.requestedTeams = new ArrayList<User>();
            }
            for (User user : elements) {
                this.requestedTeams.add(Objects.requireNonNull(user, "requestedTeams element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder mergeCommitSha(String mergeCommitSha) {
            this.mergeCommitSha = Objects.requireNonNull(mergeCommitSha, "mergeCommitSha");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder mergeCommitSha(Optional<String> mergeCommitSha) {
            this.mergeCommitSha = mergeCommitSha.orElse(null);
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder nodeId(String nodeId) {
            this.nodeId = Objects.requireNonNull(nodeId, "nodeId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder merged(@Nullable Boolean merged) {
            this.merged = merged;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder mergeable(boolean mergeable) {
            this.mergeable = mergeable;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder mergeable(Optional<Boolean> mergeable) {
            this.mergeable = mergeable.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder mergedBy(User mergedBy) {
            this.mergedBy = Objects.requireNonNull(mergedBy, "mergedBy");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder mergedBy(Optional<? extends User> mergedBy) {
            this.mergedBy = mergedBy.orElse(null);
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder comments(@Nullable Integer comments) {
            this.comments = comments;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder reviewComments(@Nullable Integer reviewComments) {
            this.reviewComments = reviewComments;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder commits(@Nullable Integer commits) {
            this.commits = commits;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder additions(@Nullable Integer additions) {
            this.additions = additions;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder deletions(@Nullable Integer deletions) {
            this.deletions = deletions;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder changedFiles(@Nullable Integer changedFiles) {
            this.changedFiles = changedFiles;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder mergeableState(@Nullable String mergeableState) {
            this.mergeableState = mergeableState;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder draft(boolean draft) {
            this.draft = draft;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder draft(Optional<Boolean> draft) {
            this.draft = draft.orElse(null);
            return this;
        }

        public ImmutablePullRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePullRequest(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.htmlUrl, this.diffUrl, this.patchUrl, this.issueUrl, this.commitsUrl, this.number, this.state, this.title, this.body, this.assignee, this.assignees, this.milestone, this.locked, this.mergedAt, this.head, this.base, this.user, this.statusesUrl, this.reviewCommentsUrl, this.reviewCommentUrl, this.commentsUrl, this.links, this.requestedReviewers == null ? null : ImmutablePullRequest.createUnmodifiableList(true, this.requestedReviewers), this.requestedTeams == null ? null : ImmutablePullRequest.createUnmodifiableList(true, this.requestedTeams), this.mergeCommitSha, this.nodeId, this.merged, this.mergeable, this.mergedBy, this.comments, this.reviewComments, this.commits, this.additions, this.deletions, this.changedFiles, this.mergeableState, this.draft);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("nodeId");
            }
            return "Cannot build PullRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="PullRequest", generator="Immutables")
    static final class Json
    implements PullRequest {
        @Nullable
        GitHubInstant createdAt;
        @Nullable
        GitHubInstant updatedAt;
        @Nullable
        Optional<GitHubInstant> closedAt = Optional.empty();
        @Nullable
        Integer id;
        @Nullable
        URI url;
        @Nullable
        URI htmlUrl;
        @Nullable
        URI diffUrl;
        @Nullable
        URI patchUrl;
        @Nullable
        URI issueUrl;
        @Nullable
        URI commitsUrl;
        @Nullable
        Integer number;
        @Nullable
        String state;
        @Nullable
        String title;
        @Nullable
        Optional<String> body = Optional.empty();
        @Nullable
        Optional<User> assignee = Optional.empty();
        @Nullable
        Optional<List<User>> assignees = Optional.empty();
        @Nullable
        Optional<Milestone> milestone = Optional.empty();
        @Nullable
        Boolean locked;
        @Nullable
        Optional<GitHubInstant> mergedAt = Optional.empty();
        @Nullable
        PullRequestRef head;
        @Nullable
        PullRequestRef base;
        @Nullable
        User user;
        @Nullable
        URI statusesUrl;
        @Nullable
        URI reviewCommentsUrl;
        @Nullable
        String reviewCommentUrl;
        @Nullable
        URI commentsUrl;
        @Nullable
        PullRequestLinks links;
        @Nullable
        List<User> requestedReviewers = null;
        @Nullable
        List<User> requestedTeams = null;
        @Nullable
        Optional<String> mergeCommitSha = Optional.empty();
        @Nullable
        String nodeId;
        @Nullable
        Boolean merged;
        @Nullable
        Optional<Boolean> mergeable = Optional.empty();
        @Nullable
        Optional<User> mergedBy = Optional.empty();
        @Nullable
        Integer comments;
        @Nullable
        Integer reviewComments;
        @Nullable
        Integer commits;
        @Nullable
        Integer additions;
        @Nullable
        Integer deletions;
        @Nullable
        Integer changedFiles;
        @Nullable
        String mergeableState;
        @Nullable
        Optional<Boolean> draft = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setCreatedAt(@Nullable GitHubInstant createdAt) {
            this.createdAt = createdAt;
        }

        @JsonProperty
        public void setUpdatedAt(@Nullable GitHubInstant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @JsonProperty
        public void setClosedAt(Optional<GitHubInstant> closedAt) {
            this.closedAt = closedAt;
        }

        @JsonProperty
        public void setId(@Nullable Integer id) {
            this.id = id;
        }

        @JsonProperty
        public void setUrl(@Nullable URI url) {
            this.url = url;
        }

        @JsonProperty
        public void setHtmlUrl(@Nullable URI htmlUrl) {
            this.htmlUrl = htmlUrl;
        }

        @JsonProperty
        public void setDiffUrl(@Nullable URI diffUrl) {
            this.diffUrl = diffUrl;
        }

        @JsonProperty
        public void setPatchUrl(@Nullable URI patchUrl) {
            this.patchUrl = patchUrl;
        }

        @JsonProperty
        public void setIssueUrl(@Nullable URI issueUrl) {
            this.issueUrl = issueUrl;
        }

        @JsonProperty
        public void setCommitsUrl(@Nullable URI commitsUrl) {
            this.commitsUrl = commitsUrl;
        }

        @JsonProperty
        public void setNumber(@Nullable Integer number) {
            this.number = number;
        }

        @JsonProperty
        public void setState(@Nullable String state) {
            this.state = state;
        }

        @JsonProperty
        public void setTitle(@Nullable String title) {
            this.title = title;
        }

        @JsonProperty
        public void setBody(Optional<String> body) {
            this.body = body;
        }

        @JsonProperty
        public void setAssignee(Optional<User> assignee) {
            this.assignee = assignee;
        }

        @JsonProperty
        public void setAssignees(Optional<List<User>> assignees) {
            this.assignees = assignees;
        }

        @JsonProperty
        public void setMilestone(Optional<Milestone> milestone) {
            this.milestone = milestone;
        }

        @JsonProperty
        public void setLocked(@Nullable Boolean locked) {
            this.locked = locked;
        }

        @JsonProperty
        public void setMergedAt(Optional<GitHubInstant> mergedAt) {
            this.mergedAt = mergedAt;
        }

        @JsonProperty
        public void setHead(@Nullable PullRequestRef head) {
            this.head = head;
        }

        @JsonProperty
        public void setBase(@Nullable PullRequestRef base) {
            this.base = base;
        }

        @JsonProperty
        public void setUser(@Nullable User user) {
            this.user = user;
        }

        @JsonProperty
        public void setStatusesUrl(@Nullable URI statusesUrl) {
            this.statusesUrl = statusesUrl;
        }

        @JsonProperty
        public void setReviewCommentsUrl(@Nullable URI reviewCommentsUrl) {
            this.reviewCommentsUrl = reviewCommentsUrl;
        }

        @JsonProperty
        public void setReviewCommentUrl(@Nullable String reviewCommentUrl) {
            this.reviewCommentUrl = reviewCommentUrl;
        }

        @JsonProperty
        public void setCommentsUrl(@Nullable URI commentsUrl) {
            this.commentsUrl = commentsUrl;
        }

        @JsonProperty(value="_links")
        public void setLinks(@Nullable PullRequestLinks links) {
            this.links = links;
        }

        @JsonProperty(value="requested_reviewers")
        public void setRequestedReviewers(@Nullable List<User> requestedReviewers) {
            this.requestedReviewers = requestedReviewers;
        }

        @JsonProperty(value="requested_teams")
        public void setRequestedTeams(@Nullable List<User> requestedTeams) {
            this.requestedTeams = requestedTeams;
        }

        @JsonProperty
        public void setMergeCommitSha(Optional<String> mergeCommitSha) {
            this.mergeCommitSha = mergeCommitSha;
        }

        @JsonProperty
        public void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        @JsonProperty
        public void setMerged(@Nullable Boolean merged) {
            this.merged = merged;
        }

        @JsonProperty
        public void setMergeable(Optional<Boolean> mergeable) {
            this.mergeable = mergeable;
        }

        @JsonProperty
        public void setMergedBy(Optional<User> mergedBy) {
            this.mergedBy = mergedBy;
        }

        @JsonProperty
        public void setComments(@Nullable Integer comments) {
            this.comments = comments;
        }

        @JsonProperty
        public void setReviewComments(@Nullable Integer reviewComments) {
            this.reviewComments = reviewComments;
        }

        @JsonProperty
        public void setCommits(@Nullable Integer commits) {
            this.commits = commits;
        }

        @JsonProperty
        public void setAdditions(@Nullable Integer additions) {
            this.additions = additions;
        }

        @JsonProperty
        public void setDeletions(@Nullable Integer deletions) {
            this.deletions = deletions;
        }

        @JsonProperty
        public void setChangedFiles(@Nullable Integer changedFiles) {
            this.changedFiles = changedFiles;
        }

        @JsonProperty
        public void setMergeableState(@Nullable String mergeableState) {
            this.mergeableState = mergeableState;
        }

        @JsonProperty
        public void setDraft(Optional<Boolean> draft) {
            this.draft = draft;
        }

        @Override
        public GitHubInstant createdAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public GitHubInstant updatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<GitHubInstant> closedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI url() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI htmlUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI diffUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI patchUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI issueUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI commitsUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer number() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String state() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String title() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> body() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<User> assignee() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<List<User>> assignees() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Milestone> milestone() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean locked() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<GitHubInstant> mergedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public PullRequestRef head() {
            throw new UnsupportedOperationException();
        }

        @Override
        public PullRequestRef base() {
            throw new UnsupportedOperationException();
        }

        @Override
        public User user() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI statusesUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI reviewCommentsUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String reviewCommentUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI commentsUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public PullRequestLinks links() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<User> requestedReviewers() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<User> requestedTeams() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> mergeCommitSha() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String nodeId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean merged() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> mergeable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<User> mergedBy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer comments() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer reviewComments() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer commits() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer additions() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer deletions() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer changedFiles() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String mergeableState() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> draft() {
            throw new UnsupportedOperationException();
        }
    }
}

