/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.repos;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.repos.CommitStatus;
import com.spotify.github.v3.repos.Status;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CommitStatus", generator="Immutables")
@Immutable
public final class ImmutableCommitStatus
implements CommitStatus {
    @Nullable
    private final String state;
    @Nullable
    private final List<Status> statuses;
    @Nullable
    private final String sha;

    private ImmutableCommitStatus(@Nullable String state, @Nullable List<Status> statuses, @Nullable String sha) {
        this.state = state;
        this.statuses = statuses;
        this.sha = sha;
    }

    @Override
    @JsonProperty
    @Nullable
    public String state() {
        return this.state;
    }

    @Override
    @JsonProperty
    @Nullable
    public List<Status> statuses() {
        return this.statuses;
    }

    @Override
    @JsonProperty
    @Nullable
    public String sha() {
        return this.sha;
    }

    public final ImmutableCommitStatus withState(@Nullable String value) {
        if (Objects.equals(this.state, value)) {
            return this;
        }
        return new ImmutableCommitStatus(value, this.statuses, this.sha);
    }

    public final ImmutableCommitStatus withStatuses(Status ... elements) {
        if (elements == null) {
            return new ImmutableCommitStatus(this.state, null, this.sha);
        }
        List<Status> newValue = Arrays.asList(elements) == null ? null : ImmutableCommitStatus.createUnmodifiableList(false, ImmutableCommitStatus.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableCommitStatus(this.state, newValue, this.sha);
    }

    public final ImmutableCommitStatus withStatuses(@Nullable Iterable<? extends Status> elements) {
        if (this.statuses == elements) {
            return this;
        }
        List<Status> newValue = elements == null ? null : ImmutableCommitStatus.createUnmodifiableList(false, ImmutableCommitStatus.createSafeList(elements, true, false));
        return new ImmutableCommitStatus(this.state, newValue, this.sha);
    }

    public final ImmutableCommitStatus withSha(@Nullable String value) {
        if (Objects.equals(this.sha, value)) {
            return this;
        }
        return new ImmutableCommitStatus(this.state, this.statuses, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCommitStatus && this.equalTo(0, (ImmutableCommitStatus)another);
    }

    private boolean equalTo(int synthetic, ImmutableCommitStatus another) {
        return Objects.equals(this.state, another.state) && Objects.equals(this.statuses, another.statuses) && Objects.equals(this.sha, another.sha);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.state);
        h += (h << 5) + Objects.hashCode(this.statuses);
        h += (h << 5) + Objects.hashCode(this.sha);
        return h;
    }

    public String toString() {
        return "CommitStatus{state=" + this.state + ", statuses=" + this.statuses + ", sha=" + this.sha + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableCommitStatus fromJson(Json json) {
        Builder builder = ImmutableCommitStatus.builder();
        if (json.state != null) {
            builder.state(json.state);
        }
        if (json.statuses != null) {
            builder.addAllStatuses(json.statuses);
        }
        if (json.sha != null) {
            builder.sha(json.sha);
        }
        return builder.build();
    }

    public static ImmutableCommitStatus copyOf(CommitStatus instance) {
        if (instance instanceof ImmutableCommitStatus) {
            return (ImmutableCommitStatus)instance;
        }
        return ImmutableCommitStatus.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="CommitStatus", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String state;
        private List<Status> statuses = null;
        @Nullable
        private String sha;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CommitStatus instance) {
            String shaValue;
            List<Status> statusesValue;
            Objects.requireNonNull(instance, "instance");
            String stateValue = instance.state();
            if (stateValue != null) {
                this.state(stateValue);
            }
            if ((statusesValue = instance.statuses()) != null) {
                this.addAllStatuses(statusesValue);
            }
            if ((shaValue = instance.sha()) != null) {
                this.sha(shaValue);
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder state(@Nullable String state) {
            this.state = state;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addStatuses(Status element) {
            if (this.statuses == null) {
                this.statuses = new ArrayList<Status>();
            }
            this.statuses.add(Objects.requireNonNull(element, "statuses element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addStatuses(Status ... elements) {
            if (this.statuses == null) {
                this.statuses = new ArrayList<Status>();
            }
            for (Status element : elements) {
                this.statuses.add(Objects.requireNonNull(element, "statuses element"));
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder statuses(@Nullable Iterable<? extends Status> elements) {
            if (elements == null) {
                this.statuses = null;
                return this;
            }
            this.statuses = new ArrayList<Status>();
            return this.addAllStatuses(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllStatuses(Iterable<? extends Status> elements) {
            Objects.requireNonNull(elements, "statuses element");
            if (this.statuses == null) {
                this.statuses = new ArrayList<Status>();
            }
            for (Status status : elements) {
                this.statuses.add(Objects.requireNonNull(status, "statuses element"));
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder sha(@Nullable String sha) {
            this.sha = sha;
            return this;
        }

        public ImmutableCommitStatus build() {
            return new ImmutableCommitStatus(this.state, this.statuses == null ? null : ImmutableCommitStatus.createUnmodifiableList(true, this.statuses), this.sha);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="CommitStatus", generator="Immutables")
    static final class Json
    implements CommitStatus {
        @Nullable
        String state;
        @Nullable
        List<Status> statuses = null;
        @Nullable
        String sha;

        Json() {
        }

        @JsonProperty
        public void setState(@Nullable String state) {
            this.state = state;
        }

        @JsonProperty
        public void setStatuses(@Nullable List<Status> statuses) {
            this.statuses = statuses;
        }

        @JsonProperty
        public void setSha(@Nullable String sha) {
            this.sha = sha;
        }

        @Override
        public String state() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Status> statuses() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String sha() {
            throw new UnsupportedOperationException();
        }
    }
}

