/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.repos;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.git.ShaLink;
import com.spotify.github.v3.repos.Content;
import com.spotify.github.v3.repos.FolderContent;
import java.net.URI;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Content", generator="Immutables")
@Immutable
public final class ImmutableContent
implements Content {
    @Nullable
    private final String sha;
    @Nullable
    private final URI url;
    @Nullable
    private final String type;
    @Nullable
    private final Integer size;
    @Nullable
    private final String name;
    @Nullable
    private final String path;
    @Nullable
    private final URI gitUrl;
    @Nullable
    private final URI htmlUrl;
    @Nullable
    private final URI downloadUrl;
    @Nullable
    private final String encoding;
    @Nullable
    private final String content;

    private ImmutableContent(@Nullable String sha, @Nullable URI url, @Nullable String type, @Nullable Integer size, @Nullable String name, @Nullable String path, @Nullable URI gitUrl, @Nullable URI htmlUrl, @Nullable URI downloadUrl, @Nullable String encoding, @Nullable String content) {
        this.sha = sha;
        this.url = url;
        this.type = type;
        this.size = size;
        this.name = name;
        this.path = path;
        this.gitUrl = gitUrl;
        this.htmlUrl = htmlUrl;
        this.downloadUrl = downloadUrl;
        this.encoding = encoding;
        this.content = content;
    }

    @Override
    @JsonProperty
    @Nullable
    public String sha() {
        return this.sha;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI url() {
        return this.url;
    }

    @Override
    @JsonProperty
    @Nullable
    public String type() {
        return this.type;
    }

    @Override
    @JsonProperty
    @Nullable
    public Integer size() {
        return this.size;
    }

    @Override
    @JsonProperty
    @Nullable
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty
    @Nullable
    public String path() {
        return this.path;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI gitUrl() {
        return this.gitUrl;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI htmlUrl() {
        return this.htmlUrl;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI downloadUrl() {
        return this.downloadUrl;
    }

    @Override
    @JsonProperty
    @Nullable
    public String encoding() {
        return this.encoding;
    }

    @Override
    @JsonProperty
    @Nullable
    public String content() {
        return this.content;
    }

    public final ImmutableContent withSha(@Nullable String value) {
        if (Objects.equals(this.sha, value)) {
            return this;
        }
        return new ImmutableContent(value, this.url, this.type, this.size, this.name, this.path, this.gitUrl, this.htmlUrl, this.downloadUrl, this.encoding, this.content);
    }

    public final ImmutableContent withUrl(@Nullable URI value) {
        if (this.url == value) {
            return this;
        }
        return new ImmutableContent(this.sha, value, this.type, this.size, this.name, this.path, this.gitUrl, this.htmlUrl, this.downloadUrl, this.encoding, this.content);
    }

    public final ImmutableContent withType(@Nullable String value) {
        if (Objects.equals(this.type, value)) {
            return this;
        }
        return new ImmutableContent(this.sha, this.url, value, this.size, this.name, this.path, this.gitUrl, this.htmlUrl, this.downloadUrl, this.encoding, this.content);
    }

    public final ImmutableContent withSize(@Nullable Integer value) {
        if (Objects.equals(this.size, value)) {
            return this;
        }
        return new ImmutableContent(this.sha, this.url, this.type, value, this.name, this.path, this.gitUrl, this.htmlUrl, this.downloadUrl, this.encoding, this.content);
    }

    public final ImmutableContent withName(@Nullable String value) {
        if (Objects.equals(this.name, value)) {
            return this;
        }
        return new ImmutableContent(this.sha, this.url, this.type, this.size, value, this.path, this.gitUrl, this.htmlUrl, this.downloadUrl, this.encoding, this.content);
    }

    public final ImmutableContent withPath(@Nullable String value) {
        if (Objects.equals(this.path, value)) {
            return this;
        }
        return new ImmutableContent(this.sha, this.url, this.type, this.size, this.name, value, this.gitUrl, this.htmlUrl, this.downloadUrl, this.encoding, this.content);
    }

    public final ImmutableContent withGitUrl(@Nullable URI value) {
        if (this.gitUrl == value) {
            return this;
        }
        return new ImmutableContent(this.sha, this.url, this.type, this.size, this.name, this.path, value, this.htmlUrl, this.downloadUrl, this.encoding, this.content);
    }

    public final ImmutableContent withHtmlUrl(@Nullable URI value) {
        if (this.htmlUrl == value) {
            return this;
        }
        return new ImmutableContent(this.sha, this.url, this.type, this.size, this.name, this.path, this.gitUrl, value, this.downloadUrl, this.encoding, this.content);
    }

    public final ImmutableContent withDownloadUrl(@Nullable URI value) {
        if (this.downloadUrl == value) {
            return this;
        }
        return new ImmutableContent(this.sha, this.url, this.type, this.size, this.name, this.path, this.gitUrl, this.htmlUrl, value, this.encoding, this.content);
    }

    public final ImmutableContent withEncoding(@Nullable String value) {
        if (Objects.equals(this.encoding, value)) {
            return this;
        }
        return new ImmutableContent(this.sha, this.url, this.type, this.size, this.name, this.path, this.gitUrl, this.htmlUrl, this.downloadUrl, value, this.content);
    }

    public final ImmutableContent withContent(@Nullable String value) {
        if (Objects.equals(this.content, value)) {
            return this;
        }
        return new ImmutableContent(this.sha, this.url, this.type, this.size, this.name, this.path, this.gitUrl, this.htmlUrl, this.downloadUrl, this.encoding, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableContent && this.equalTo(0, (ImmutableContent)another);
    }

    private boolean equalTo(int synthetic, ImmutableContent another) {
        return Objects.equals(this.sha, another.sha) && Objects.equals(this.url, another.url) && Objects.equals(this.type, another.type) && Objects.equals(this.size, another.size) && Objects.equals(this.name, another.name) && Objects.equals(this.path, another.path) && Objects.equals(this.gitUrl, another.gitUrl) && Objects.equals(this.htmlUrl, another.htmlUrl) && Objects.equals(this.downloadUrl, another.downloadUrl) && Objects.equals(this.encoding, another.encoding) && Objects.equals(this.content, another.content);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.sha);
        h += (h << 5) + Objects.hashCode(this.url);
        h += (h << 5) + Objects.hashCode(this.type);
        h += (h << 5) + Objects.hashCode(this.size);
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + Objects.hashCode(this.path);
        h += (h << 5) + Objects.hashCode(this.gitUrl);
        h += (h << 5) + Objects.hashCode(this.htmlUrl);
        h += (h << 5) + Objects.hashCode(this.downloadUrl);
        h += (h << 5) + Objects.hashCode(this.encoding);
        h += (h << 5) + Objects.hashCode(this.content);
        return h;
    }

    public String toString() {
        return "Content{sha=" + this.sha + ", url=" + this.url + ", type=" + this.type + ", size=" + this.size + ", name=" + this.name + ", path=" + this.path + ", gitUrl=" + this.gitUrl + ", htmlUrl=" + this.htmlUrl + ", downloadUrl=" + this.downloadUrl + ", encoding=" + this.encoding + ", content=" + this.content + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableContent fromJson(Json json) {
        Builder builder = ImmutableContent.builder();
        if (json.sha != null) {
            builder.sha(json.sha);
        }
        if (json.url != null) {
            builder.url(json.url);
        }
        if (json.type != null) {
            builder.type(json.type);
        }
        if (json.size != null) {
            builder.size(json.size);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.path != null) {
            builder.path(json.path);
        }
        if (json.gitUrl != null) {
            builder.gitUrl(json.gitUrl);
        }
        if (json.htmlUrl != null) {
            builder.htmlUrl(json.htmlUrl);
        }
        if (json.downloadUrl != null) {
            builder.downloadUrl(json.downloadUrl);
        }
        if (json.encoding != null) {
            builder.encoding(json.encoding);
        }
        if (json.content != null) {
            builder.content(json.content);
        }
        return builder.build();
    }

    public static ImmutableContent copyOf(Content instance) {
        if (instance instanceof ImmutableContent) {
            return (ImmutableContent)instance;
        }
        return ImmutableContent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Content", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String sha;
        @Nullable
        private URI url;
        @Nullable
        private String type;
        @Nullable
        private Integer size;
        @Nullable
        private String name;
        @Nullable
        private String path;
        @Nullable
        private URI gitUrl;
        @Nullable
        private URI htmlUrl;
        @Nullable
        private URI downloadUrl;
        @Nullable
        private String encoding;
        @Nullable
        private String content;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(FolderContent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(ShaLink instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Content instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            URI urlValue;
            String shaValue;
            String typeValue;
            URI downloadUrlValue;
            URI htmlUrlValue;
            String nameValue;
            Integer sizeValue;
            String pathValue;
            ShaLink instance;
            long bits = 0L;
            if (object instanceof FolderContent) {
                instance = (FolderContent)object;
                if ((bits & 1L) == 0L) {
                    pathValue = instance.path();
                    if (pathValue != null) {
                        this.path(pathValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    sizeValue = instance.size();
                    if (sizeValue != null) {
                        this.size(sizeValue);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    nameValue = instance.name();
                    if (nameValue != null) {
                        this.name(nameValue);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    htmlUrlValue = instance.htmlUrl();
                    if (htmlUrlValue != null) {
                        this.htmlUrl(htmlUrlValue);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    downloadUrlValue = instance.downloadUrl();
                    if (downloadUrlValue != null) {
                        this.downloadUrl(downloadUrlValue);
                    }
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    typeValue = instance.type();
                    if (typeValue != null) {
                        this.type(typeValue);
                    }
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    shaValue = instance.sha();
                    if (shaValue != null) {
                        this.sha(shaValue);
                    }
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    URI gitUrlValue = instance.gitUrl();
                    if (gitUrlValue != null) {
                        this.gitUrl(gitUrlValue);
                    }
                    bits |= 0x80L;
                }
                if ((bits & 0x100L) == 0L) {
                    urlValue = instance.url();
                    if (urlValue != null) {
                        this.url(urlValue);
                    }
                    bits |= 0x100L;
                }
            }
            if (object instanceof ShaLink) {
                instance = (ShaLink)object;
                if ((bits & 0x40L) == 0L) {
                    shaValue = instance.sha();
                    if (shaValue != null) {
                        this.sha(shaValue);
                    }
                    bits |= 0x40L;
                }
                if ((bits & 0x100L) == 0L) {
                    urlValue = instance.url();
                    if (urlValue != null) {
                        this.url(urlValue);
                    }
                    bits |= 0x100L;
                }
            }
            if (object instanceof Content) {
                String contentValue;
                String encodingValue;
                instance = (Content)object;
                if ((bits & 1L) == 0L) {
                    pathValue = instance.path();
                    if (pathValue != null) {
                        this.path(pathValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    sizeValue = instance.size();
                    if (sizeValue != null) {
                        this.size(sizeValue);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    nameValue = instance.name();
                    if (nameValue != null) {
                        this.name(nameValue);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    htmlUrlValue = instance.htmlUrl();
                    if (htmlUrlValue != null) {
                        this.htmlUrl(htmlUrlValue);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    downloadUrlValue = instance.downloadUrl();
                    if (downloadUrlValue != null) {
                        this.downloadUrl(downloadUrlValue);
                    }
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    typeValue = instance.type();
                    if (typeValue != null) {
                        this.type(typeValue);
                    }
                    bits |= 0x20L;
                }
                if ((encodingValue = instance.encoding()) != null) {
                    this.encoding(encodingValue);
                }
                if ((bits & 0x40L) == 0L) {
                    String shaValue2 = instance.sha();
                    if (shaValue2 != null) {
                        this.sha(shaValue2);
                    }
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    URI gitUrlValue = instance.gitUrl();
                    if (gitUrlValue != null) {
                        this.gitUrl(gitUrlValue);
                    }
                    bits |= 0x80L;
                }
                if ((bits & 0x100L) == 0L) {
                    URI urlValue2 = instance.url();
                    if (urlValue2 != null) {
                        this.url(urlValue2);
                    }
                    bits |= 0x100L;
                }
                if ((contentValue = instance.content()) != null) {
                    this.content(contentValue);
                }
            }
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder sha(@Nullable String sha) {
            this.sha = sha;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder url(@Nullable URI url) {
            this.url = url;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder type(@Nullable String type) {
            this.type = type;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder size(@Nullable Integer size) {
            this.size = size;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder path(@Nullable String path) {
            this.path = path;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder gitUrl(@Nullable URI gitUrl) {
            this.gitUrl = gitUrl;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder htmlUrl(@Nullable URI htmlUrl) {
            this.htmlUrl = htmlUrl;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder downloadUrl(@Nullable URI downloadUrl) {
            this.downloadUrl = downloadUrl;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder encoding(@Nullable String encoding) {
            this.encoding = encoding;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder content(@Nullable String content) {
            this.content = content;
            return this;
        }

        public ImmutableContent build() {
            return new ImmutableContent(this.sha, this.url, this.type, this.size, this.name, this.path, this.gitUrl, this.htmlUrl, this.downloadUrl, this.encoding, this.content);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Content", generator="Immutables")
    static final class Json
    implements Content {
        @Nullable
        String sha;
        @Nullable
        URI url;
        @Nullable
        String type;
        @Nullable
        Integer size;
        @Nullable
        String name;
        @Nullable
        String path;
        @Nullable
        URI gitUrl;
        @Nullable
        URI htmlUrl;
        @Nullable
        URI downloadUrl;
        @Nullable
        String encoding;
        @Nullable
        String content;

        Json() {
        }

        @JsonProperty
        public void setSha(@Nullable String sha) {
            this.sha = sha;
        }

        @JsonProperty
        public void setUrl(@Nullable URI url) {
            this.url = url;
        }

        @JsonProperty
        public void setType(@Nullable String type) {
            this.type = type;
        }

        @JsonProperty
        public void setSize(@Nullable Integer size) {
            this.size = size;
        }

        @JsonProperty
        public void setName(@Nullable String name) {
            this.name = name;
        }

        @JsonProperty
        public void setPath(@Nullable String path) {
            this.path = path;
        }

        @JsonProperty
        public void setGitUrl(@Nullable URI gitUrl) {
            this.gitUrl = gitUrl;
        }

        @JsonProperty
        public void setHtmlUrl(@Nullable URI htmlUrl) {
            this.htmlUrl = htmlUrl;
        }

        @JsonProperty
        public void setDownloadUrl(@Nullable URI downloadUrl) {
            this.downloadUrl = downloadUrl;
        }

        @JsonProperty
        public void setEncoding(@Nullable String encoding) {
            this.encoding = encoding;
        }

        @JsonProperty
        public void setContent(@Nullable String content) {
            this.content = content;
        }

        @Override
        public String sha() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI url() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String type() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer size() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String path() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI gitUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI htmlUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI downloadUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String encoding() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String content() {
            throw new UnsupportedOperationException();
        }
    }
}

