/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.repos;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.repos.Permissions;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Permissions", generator="Immutables")
@Immutable
public final class ImmutablePermissions
implements Permissions {
    @Nullable
    private final Boolean admin;
    @Nullable
    private final Boolean push;
    @Nullable
    private final Boolean pull;

    private ImmutablePermissions(@Nullable Boolean admin, @Nullable Boolean push, @Nullable Boolean pull) {
        this.admin = admin;
        this.push = push;
        this.pull = pull;
    }

    @Override
    @JsonProperty
    @Nullable
    public Boolean admin() {
        return this.admin;
    }

    @Override
    @JsonProperty
    @Nullable
    public Boolean push() {
        return this.push;
    }

    @Override
    @JsonProperty
    @Nullable
    public Boolean pull() {
        return this.pull;
    }

    public final ImmutablePermissions withAdmin(@Nullable Boolean value) {
        if (Objects.equals(this.admin, value)) {
            return this;
        }
        return new ImmutablePermissions(value, this.push, this.pull);
    }

    public final ImmutablePermissions withPush(@Nullable Boolean value) {
        if (Objects.equals(this.push, value)) {
            return this;
        }
        return new ImmutablePermissions(this.admin, value, this.pull);
    }

    public final ImmutablePermissions withPull(@Nullable Boolean value) {
        if (Objects.equals(this.pull, value)) {
            return this;
        }
        return new ImmutablePermissions(this.admin, this.push, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePermissions && this.equalTo(0, (ImmutablePermissions)another);
    }

    private boolean equalTo(int synthetic, ImmutablePermissions another) {
        return Objects.equals(this.admin, another.admin) && Objects.equals(this.push, another.push) && Objects.equals(this.pull, another.pull);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.admin);
        h += (h << 5) + Objects.hashCode(this.push);
        h += (h << 5) + Objects.hashCode(this.pull);
        return h;
    }

    public String toString() {
        return "Permissions{admin=" + this.admin + ", push=" + this.push + ", pull=" + this.pull + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePermissions fromJson(Json json) {
        Builder builder = ImmutablePermissions.builder();
        if (json.admin != null) {
            builder.admin(json.admin);
        }
        if (json.push != null) {
            builder.push(json.push);
        }
        if (json.pull != null) {
            builder.pull(json.pull);
        }
        return builder.build();
    }

    public static ImmutablePermissions copyOf(Permissions instance) {
        if (instance instanceof ImmutablePermissions) {
            return (ImmutablePermissions)instance;
        }
        return ImmutablePermissions.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Permissions", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Boolean admin;
        @Nullable
        private Boolean push;
        @Nullable
        private Boolean pull;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Permissions instance) {
            Boolean pullValue;
            Boolean pushValue;
            Objects.requireNonNull(instance, "instance");
            Boolean adminValue = instance.admin();
            if (adminValue != null) {
                this.admin(adminValue);
            }
            if ((pushValue = instance.push()) != null) {
                this.push(pushValue);
            }
            if ((pullValue = instance.pull()) != null) {
                this.pull(pullValue);
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder admin(@Nullable Boolean admin) {
            this.admin = admin;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder push(@Nullable Boolean push) {
            this.push = push;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder pull(@Nullable Boolean pull) {
            this.pull = pull;
            return this;
        }

        public ImmutablePermissions build() {
            return new ImmutablePermissions(this.admin, this.push, this.pull);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Permissions", generator="Immutables")
    static final class Json
    implements Permissions {
        @Nullable
        Boolean admin;
        @Nullable
        Boolean push;
        @Nullable
        Boolean pull;

        Json() {
        }

        @JsonProperty
        public void setAdmin(@Nullable Boolean admin) {
            this.admin = admin;
        }

        @JsonProperty
        public void setPush(@Nullable Boolean push) {
            this.push = push;
        }

        @JsonProperty
        public void setPull(@Nullable Boolean pull) {
            this.pull = pull;
        }

        @Override
        public Boolean admin() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean push() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean pull() {
            throw new UnsupportedOperationException();
        }
    }
}

