/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.repos;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.repos.RequiredStatusChecks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="RequiredStatusChecks", generator="Immutables")
@Immutable
public final class ImmutableRequiredStatusChecks
implements RequiredStatusChecks {
    private final String enforcementLevel;
    private final List<String> contexts;

    private ImmutableRequiredStatusChecks(Builder builder) {
        this.enforcementLevel = builder.enforcementLevel;
        this.contexts = builder.contextsIsSet() ? ImmutableRequiredStatusChecks.createUnmodifiableList(true, builder.contexts) : ImmutableRequiredStatusChecks.createUnmodifiableList(false, ImmutableRequiredStatusChecks.createSafeList(RequiredStatusChecks.super.contexts(), true, false));
    }

    private ImmutableRequiredStatusChecks(String enforcementLevel, List<String> contexts) {
        this.enforcementLevel = enforcementLevel;
        this.contexts = contexts;
    }

    @Override
    @JsonProperty(value="enforcement_level")
    public String enforcementLevel() {
        return this.enforcementLevel;
    }

    @Override
    @JsonProperty
    public List<String> contexts() {
        return this.contexts;
    }

    public final ImmutableRequiredStatusChecks withEnforcementLevel(String value) {
        String newValue = Objects.requireNonNull(value, "enforcementLevel");
        if (this.enforcementLevel.equals(newValue)) {
            return this;
        }
        return new ImmutableRequiredStatusChecks(newValue, this.contexts);
    }

    public final ImmutableRequiredStatusChecks withContexts(String ... elements) {
        List<String> newValue = ImmutableRequiredStatusChecks.createUnmodifiableList(false, ImmutableRequiredStatusChecks.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableRequiredStatusChecks(this.enforcementLevel, newValue);
    }

    public final ImmutableRequiredStatusChecks withContexts(Iterable<String> elements) {
        if (this.contexts == elements) {
            return this;
        }
        List<String> newValue = ImmutableRequiredStatusChecks.createUnmodifiableList(false, ImmutableRequiredStatusChecks.createSafeList(elements, true, false));
        return new ImmutableRequiredStatusChecks(this.enforcementLevel, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRequiredStatusChecks && this.equalTo(0, (ImmutableRequiredStatusChecks)another);
    }

    private boolean equalTo(int synthetic, ImmutableRequiredStatusChecks another) {
        return this.enforcementLevel.equals(another.enforcementLevel) && this.contexts.equals(another.contexts);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.enforcementLevel.hashCode();
        h += (h << 5) + this.contexts.hashCode();
        return h;
    }

    public String toString() {
        return "RequiredStatusChecks{enforcementLevel=" + this.enforcementLevel + ", contexts=" + this.contexts + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableRequiredStatusChecks fromJson(Json json) {
        Builder builder = ImmutableRequiredStatusChecks.builder();
        if (json.enforcementLevel != null) {
            builder.enforcementLevel(json.enforcementLevel);
        }
        if (json.contextsIsSet) {
            builder.addAllContexts(json.contexts);
        }
        return builder.build();
    }

    public static ImmutableRequiredStatusChecks copyOf(RequiredStatusChecks instance) {
        if (instance instanceof ImmutableRequiredStatusChecks) {
            return (ImmutableRequiredStatusChecks)instance;
        }
        return ImmutableRequiredStatusChecks.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="RequiredStatusChecks", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ENFORCEMENT_LEVEL = 1L;
        private static final long OPT_BIT_CONTEXTS = 1L;
        private long initBits = 1L;
        private long optBits;
        @Nullable
        private String enforcementLevel;
        private List<String> contexts = new ArrayList<String>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(RequiredStatusChecks instance) {
            Objects.requireNonNull(instance, "instance");
            this.enforcementLevel(instance.enforcementLevel());
            this.addAllContexts(instance.contexts());
            return this;
        }

        @JsonProperty(value="enforcement_level")
        @CanIgnoreReturnValue
        public final Builder enforcementLevel(String enforcementLevel) {
            this.enforcementLevel = Objects.requireNonNull(enforcementLevel, "enforcementLevel");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addContexts(String element) {
            this.contexts.add(Objects.requireNonNull(element, "contexts element"));
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addContexts(String ... elements) {
            for (String element : elements) {
                this.contexts.add(Objects.requireNonNull(element, "contexts element"));
            }
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder contexts(Iterable<String> elements) {
            this.contexts.clear();
            return this.addAllContexts(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllContexts(Iterable<String> elements) {
            for (String element : elements) {
                this.contexts.add(Objects.requireNonNull(element, "contexts element"));
            }
            this.optBits |= 1L;
            return this;
        }

        public ImmutableRequiredStatusChecks build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRequiredStatusChecks(this);
        }

        private boolean contextsIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("enforcementLevel");
            }
            return "Cannot build RequiredStatusChecks, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="RequiredStatusChecks", generator="Immutables")
    static final class Json
    implements RequiredStatusChecks {
        @Nullable
        String enforcementLevel;
        @Nullable
        List<String> contexts = Collections.emptyList();
        boolean contextsIsSet;

        Json() {
        }

        @JsonProperty(value="enforcement_level")
        public void setEnforcementLevel(String enforcementLevel) {
            this.enforcementLevel = enforcementLevel;
        }

        @JsonProperty
        public void setContexts(List<String> contexts) {
            this.contexts = contexts;
            this.contextsIsSet = null != contexts;
        }

        @Override
        public String enforcementLevel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> contexts() {
            throw new UnsupportedOperationException();
        }
    }
}

