/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.repos.requests;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.repos.requests.AuthenticatedUserRepositoriesFilter;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AuthenticatedUserRepositoriesFilter", generator="Immutables")
@Immutable
public final class ImmutableAuthenticatedUserRepositoriesFilter
implements AuthenticatedUserRepositoriesFilter {
    @Nullable
    private final String visibility;
    @Nullable
    private final String affiliation;
    @Nullable
    private final String type;
    @Nullable
    private final String sort;
    @Nullable
    private final String direction;

    private ImmutableAuthenticatedUserRepositoriesFilter(@Nullable String visibility, @Nullable String affiliation, @Nullable String type, @Nullable String sort, @Nullable String direction) {
        this.visibility = visibility;
        this.affiliation = affiliation;
        this.type = type;
        this.sort = sort;
        this.direction = direction;
    }

    @Override
    @JsonProperty
    @Nullable
    public String visibility() {
        return this.visibility;
    }

    @Override
    @JsonProperty
    @Nullable
    public String affiliation() {
        return this.affiliation;
    }

    @Override
    @JsonProperty
    @Nullable
    public String type() {
        return this.type;
    }

    @Override
    @JsonProperty
    @Nullable
    public String sort() {
        return this.sort;
    }

    @Override
    @JsonProperty
    @Nullable
    public String direction() {
        return this.direction;
    }

    public final ImmutableAuthenticatedUserRepositoriesFilter withVisibility(@Nullable String value) {
        if (Objects.equals(this.visibility, value)) {
            return this;
        }
        return new ImmutableAuthenticatedUserRepositoriesFilter(value, this.affiliation, this.type, this.sort, this.direction);
    }

    public final ImmutableAuthenticatedUserRepositoriesFilter withAffiliation(@Nullable String value) {
        if (Objects.equals(this.affiliation, value)) {
            return this;
        }
        return new ImmutableAuthenticatedUserRepositoriesFilter(this.visibility, value, this.type, this.sort, this.direction);
    }

    public final ImmutableAuthenticatedUserRepositoriesFilter withType(@Nullable String value) {
        if (Objects.equals(this.type, value)) {
            return this;
        }
        return new ImmutableAuthenticatedUserRepositoriesFilter(this.visibility, this.affiliation, value, this.sort, this.direction);
    }

    public final ImmutableAuthenticatedUserRepositoriesFilter withSort(@Nullable String value) {
        if (Objects.equals(this.sort, value)) {
            return this;
        }
        return new ImmutableAuthenticatedUserRepositoriesFilter(this.visibility, this.affiliation, this.type, value, this.direction);
    }

    public final ImmutableAuthenticatedUserRepositoriesFilter withDirection(@Nullable String value) {
        if (Objects.equals(this.direction, value)) {
            return this;
        }
        return new ImmutableAuthenticatedUserRepositoriesFilter(this.visibility, this.affiliation, this.type, this.sort, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAuthenticatedUserRepositoriesFilter && this.equalTo(0, (ImmutableAuthenticatedUserRepositoriesFilter)another);
    }

    private boolean equalTo(int synthetic, ImmutableAuthenticatedUserRepositoriesFilter another) {
        return Objects.equals(this.visibility, another.visibility) && Objects.equals(this.affiliation, another.affiliation) && Objects.equals(this.type, another.type) && Objects.equals(this.sort, another.sort) && Objects.equals(this.direction, another.direction);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.visibility);
        h += (h << 5) + Objects.hashCode(this.affiliation);
        h += (h << 5) + Objects.hashCode(this.type);
        h += (h << 5) + Objects.hashCode(this.sort);
        h += (h << 5) + Objects.hashCode(this.direction);
        return h;
    }

    public String toString() {
        return "AuthenticatedUserRepositoriesFilter{visibility=" + this.visibility + ", affiliation=" + this.affiliation + ", type=" + this.type + ", sort=" + this.sort + ", direction=" + this.direction + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAuthenticatedUserRepositoriesFilter fromJson(Json json) {
        Builder builder = ImmutableAuthenticatedUserRepositoriesFilter.builder();
        if (json.visibility != null) {
            builder.visibility(json.visibility);
        }
        if (json.affiliation != null) {
            builder.affiliation(json.affiliation);
        }
        if (json.type != null) {
            builder.type(json.type);
        }
        if (json.sort != null) {
            builder.sort(json.sort);
        }
        if (json.direction != null) {
            builder.direction(json.direction);
        }
        return builder.build();
    }

    public static ImmutableAuthenticatedUserRepositoriesFilter copyOf(AuthenticatedUserRepositoriesFilter instance) {
        if (instance instanceof ImmutableAuthenticatedUserRepositoriesFilter) {
            return (ImmutableAuthenticatedUserRepositoriesFilter)instance;
        }
        return ImmutableAuthenticatedUserRepositoriesFilter.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AuthenticatedUserRepositoriesFilter", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String visibility;
        @Nullable
        private String affiliation;
        @Nullable
        private String type;
        @Nullable
        private String sort;
        @Nullable
        private String direction;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(AuthenticatedUserRepositoriesFilter instance) {
            String directionValue;
            String sortValue;
            String typeValue;
            String affiliationValue;
            Objects.requireNonNull(instance, "instance");
            String visibilityValue = instance.visibility();
            if (visibilityValue != null) {
                this.visibility(visibilityValue);
            }
            if ((affiliationValue = instance.affiliation()) != null) {
                this.affiliation(affiliationValue);
            }
            if ((typeValue = instance.type()) != null) {
                this.type(typeValue);
            }
            if ((sortValue = instance.sort()) != null) {
                this.sort(sortValue);
            }
            if ((directionValue = instance.direction()) != null) {
                this.direction(directionValue);
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder visibility(@Nullable String visibility) {
            this.visibility = visibility;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder affiliation(@Nullable String affiliation) {
            this.affiliation = affiliation;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder type(@Nullable String type) {
            this.type = type;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder sort(@Nullable String sort) {
            this.sort = sort;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder direction(@Nullable String direction) {
            this.direction = direction;
            return this;
        }

        public ImmutableAuthenticatedUserRepositoriesFilter build() {
            return new ImmutableAuthenticatedUserRepositoriesFilter(this.visibility, this.affiliation, this.type, this.sort, this.direction);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AuthenticatedUserRepositoriesFilter", generator="Immutables")
    static final class Json
    implements AuthenticatedUserRepositoriesFilter {
        @Nullable
        String visibility;
        @Nullable
        String affiliation;
        @Nullable
        String type;
        @Nullable
        String sort;
        @Nullable
        String direction;

        Json() {
        }

        @JsonProperty
        public void setVisibility(@Nullable String visibility) {
            this.visibility = visibility;
        }

        @JsonProperty
        public void setAffiliation(@Nullable String affiliation) {
            this.affiliation = affiliation;
        }

        @JsonProperty
        public void setType(@Nullable String type) {
            this.type = type;
        }

        @JsonProperty
        public void setSort(@Nullable String sort) {
            this.sort = sort;
        }

        @JsonProperty
        public void setDirection(@Nullable String direction) {
            this.direction = direction;
        }

        @Override
        public String visibility() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String affiliation() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String type() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String sort() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String direction() {
            throw new UnsupportedOperationException();
        }
    }
}

