/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.search;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.CloseTracking;
import com.spotify.github.GitHubInstant;
import com.spotify.github.UpdateTracking;
import com.spotify.github.v3.Milestone;
import com.spotify.github.v3.User;
import com.spotify.github.v3.issues.Issue;
import com.spotify.github.v3.issues.Label;
import com.spotify.github.v3.issues.PullRequest;
import com.spotify.github.v3.search.SearchIssue;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="SearchIssue", generator="Immutables")
@Immutable
public final class ImmutableSearchIssue
implements SearchIssue {
    @Nullable
    private final GitHubInstant createdAt;
    @Nullable
    private final GitHubInstant updatedAt;
    @Nullable
    private final GitHubInstant closedAt;
    @Nullable
    private final Integer id;
    @Nullable
    private final URI url;
    @Nullable
    private final Optional<URI> eventsUrl;
    @Nullable
    private final Optional<URI> repositoryUrl;
    @Nullable
    private final String labelsUrl;
    @Nullable
    private final URI commentsUrl;
    @Nullable
    private final URI htmlUrl;
    @Nullable
    private final Integer number;
    @Nullable
    private final String state;
    @Nullable
    private final String title;
    @Nullable
    private final Optional<String> body;
    @Nullable
    private final User user;
    @Nullable
    private final List<Label> labels;
    @Nullable
    private final User assignee;
    @Nullable
    private final Milestone milestone;
    @Nullable
    private final Boolean locked;
    @Nullable
    private final Integer comments;
    @Nullable
    private final PullRequest pullRequest;
    @Nullable
    private final Float score;

    private ImmutableSearchIssue(@Nullable GitHubInstant createdAt, @Nullable GitHubInstant updatedAt, @Nullable GitHubInstant closedAt, @Nullable Integer id, @Nullable URI url, @Nullable Optional<URI> eventsUrl, @Nullable Optional<URI> repositoryUrl, @Nullable String labelsUrl, @Nullable URI commentsUrl, @Nullable URI htmlUrl, @Nullable Integer number, @Nullable String state, @Nullable String title, @Nullable Optional<String> body, @Nullable User user, @Nullable List<Label> labels, @Nullable User assignee, @Nullable Milestone milestone, @Nullable Boolean locked, @Nullable Integer comments, @Nullable PullRequest pullRequest, @Nullable Float score) {
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.closedAt = closedAt;
        this.id = id;
        this.url = url;
        this.eventsUrl = eventsUrl;
        this.repositoryUrl = repositoryUrl;
        this.labelsUrl = labelsUrl;
        this.commentsUrl = commentsUrl;
        this.htmlUrl = htmlUrl;
        this.number = number;
        this.state = state;
        this.title = title;
        this.body = body;
        this.user = user;
        this.labels = labels;
        this.assignee = assignee;
        this.milestone = milestone;
        this.locked = locked;
        this.comments = comments;
        this.pullRequest = pullRequest;
        this.score = score;
    }

    @Override
    @JsonProperty
    @Nullable
    public GitHubInstant createdAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty
    @Nullable
    public GitHubInstant updatedAt() {
        return this.updatedAt;
    }

    @Override
    @JsonProperty
    public Optional<GitHubInstant> closedAt() {
        return Optional.ofNullable(this.closedAt);
    }

    @Override
    @JsonProperty
    @Nullable
    public Integer id() {
        return this.id;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI url() {
        return this.url;
    }

    @Override
    @JsonProperty
    @Nullable
    public Optional<URI> eventsUrl() {
        return this.eventsUrl;
    }

    @Override
    @JsonProperty
    @Nullable
    public Optional<URI> repositoryUrl() {
        return this.repositoryUrl;
    }

    @Override
    @JsonProperty
    @Nullable
    public String labelsUrl() {
        return this.labelsUrl;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI commentsUrl() {
        return this.commentsUrl;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI htmlUrl() {
        return this.htmlUrl;
    }

    @Override
    @JsonProperty
    @Nullable
    public Integer number() {
        return this.number;
    }

    @Override
    @JsonProperty
    @Nullable
    public String state() {
        return this.state;
    }

    @Override
    @JsonProperty
    @Nullable
    public String title() {
        return this.title;
    }

    @Override
    @JsonProperty
    @Nullable
    public Optional<String> body() {
        return this.body;
    }

    @Override
    @JsonProperty
    @Nullable
    public User user() {
        return this.user;
    }

    @Override
    @JsonProperty
    @Nullable
    public List<Label> labels() {
        return this.labels;
    }

    @Override
    @JsonProperty
    public Optional<User> assignee() {
        return Optional.ofNullable(this.assignee);
    }

    @Override
    @JsonProperty
    public Optional<Milestone> milestone() {
        return Optional.ofNullable(this.milestone);
    }

    @Override
    @JsonProperty
    @Nullable
    public Boolean locked() {
        return this.locked;
    }

    @Override
    @JsonProperty
    @Nullable
    public Integer comments() {
        return this.comments;
    }

    @Override
    @JsonProperty
    public Optional<PullRequest> pullRequest() {
        return Optional.ofNullable(this.pullRequest);
    }

    @Override
    @JsonProperty
    @Nullable
    public Float score() {
        return this.score;
    }

    public final ImmutableSearchIssue withCreatedAt(@Nullable GitHubInstant value) {
        if (this.createdAt == value) {
            return this;
        }
        return new ImmutableSearchIssue(value, this.updatedAt, this.closedAt, this.id, this.url, this.eventsUrl, this.repositoryUrl, this.labelsUrl, this.commentsUrl, this.htmlUrl, this.number, this.state, this.title, this.body, this.user, this.labels, this.assignee, this.milestone, this.locked, this.comments, this.pullRequest, this.score);
    }

    public final ImmutableSearchIssue withUpdatedAt(@Nullable GitHubInstant value) {
        if (this.updatedAt == value) {
            return this;
        }
        return new ImmutableSearchIssue(this.createdAt, value, this.closedAt, this.id, this.url, this.eventsUrl, this.repositoryUrl, this.labelsUrl, this.commentsUrl, this.htmlUrl, this.number, this.state, this.title, this.body, this.user, this.labels, this.assignee, this.milestone, this.locked, this.comments, this.pullRequest, this.score);
    }

    public final ImmutableSearchIssue withClosedAt(GitHubInstant value) {
        GitHubInstant newValue = Objects.requireNonNull(value, "closedAt");
        if (this.closedAt == newValue) {
            return this;
        }
        return new ImmutableSearchIssue(this.createdAt, this.updatedAt, newValue, this.id, this.url, this.eventsUrl, this.repositoryUrl, this.labelsUrl, this.commentsUrl, this.htmlUrl, this.number, this.state, this.title, this.body, this.user, this.labels, this.assignee, this.milestone, this.locked, this.comments, this.pullRequest, this.score);
    }

    public final ImmutableSearchIssue withClosedAt(Optional<? extends GitHubInstant> optional) {
        GitHubInstant value = optional.orElse(null);
        if (this.closedAt == value) {
            return this;
        }
        return new ImmutableSearchIssue(this.createdAt, this.updatedAt, value, this.id, this.url, this.eventsUrl, this.repositoryUrl, this.labelsUrl, this.commentsUrl, this.htmlUrl, this.number, this.state, this.title, this.body, this.user, this.labels, this.assignee, this.milestone, this.locked, this.comments, this.pullRequest, this.score);
    }

    public final ImmutableSearchIssue withId(@Nullable Integer value) {
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return new ImmutableSearchIssue(this.createdAt, this.updatedAt, this.closedAt, value, this.url, this.eventsUrl, this.repositoryUrl, this.labelsUrl, this.commentsUrl, this.htmlUrl, this.number, this.state, this.title, this.body, this.user, this.labels, this.assignee, this.milestone, this.locked, this.comments, this.pullRequest, this.score);
    }

    public final ImmutableSearchIssue withUrl(@Nullable URI value) {
        if (this.url == value) {
            return this;
        }
        return new ImmutableSearchIssue(this.createdAt, this.updatedAt, this.closedAt, this.id, value, this.eventsUrl, this.repositoryUrl, this.labelsUrl, this.commentsUrl, this.htmlUrl, this.number, this.state, this.title, this.body, this.user, this.labels, this.assignee, this.milestone, this.locked, this.comments, this.pullRequest, this.score);
    }

    public final ImmutableSearchIssue withEventsUrl(@Nullable Optional<URI> value) {
        if (Objects.equals(this.eventsUrl, value)) {
            return this;
        }
        return new ImmutableSearchIssue(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, value, this.repositoryUrl, this.labelsUrl, this.commentsUrl, this.htmlUrl, this.number, this.state, this.title, this.body, this.user, this.labels, this.assignee, this.milestone, this.locked, this.comments, this.pullRequest, this.score);
    }

    public final ImmutableSearchIssue withRepositoryUrl(@Nullable Optional<URI> value) {
        if (Objects.equals(this.repositoryUrl, value)) {
            return this;
        }
        return new ImmutableSearchIssue(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.eventsUrl, value, this.labelsUrl, this.commentsUrl, this.htmlUrl, this.number, this.state, this.title, this.body, this.user, this.labels, this.assignee, this.milestone, this.locked, this.comments, this.pullRequest, this.score);
    }

    public final ImmutableSearchIssue withLabelsUrl(@Nullable String value) {
        if (Objects.equals(this.labelsUrl, value)) {
            return this;
        }
        return new ImmutableSearchIssue(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.eventsUrl, this.repositoryUrl, value, this.commentsUrl, this.htmlUrl, this.number, this.state, this.title, this.body, this.user, this.labels, this.assignee, this.milestone, this.locked, this.comments, this.pullRequest, this.score);
    }

    public final ImmutableSearchIssue withCommentsUrl(@Nullable URI value) {
        if (this.commentsUrl == value) {
            return this;
        }
        return new ImmutableSearchIssue(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.eventsUrl, this.repositoryUrl, this.labelsUrl, value, this.htmlUrl, this.number, this.state, this.title, this.body, this.user, this.labels, this.assignee, this.milestone, this.locked, this.comments, this.pullRequest, this.score);
    }

    public final ImmutableSearchIssue withHtmlUrl(@Nullable URI value) {
        if (this.htmlUrl == value) {
            return this;
        }
        return new ImmutableSearchIssue(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.eventsUrl, this.repositoryUrl, this.labelsUrl, this.commentsUrl, value, this.number, this.state, this.title, this.body, this.user, this.labels, this.assignee, this.milestone, this.locked, this.comments, this.pullRequest, this.score);
    }

    public final ImmutableSearchIssue withNumber(@Nullable Integer value) {
        if (Objects.equals(this.number, value)) {
            return this;
        }
        return new ImmutableSearchIssue(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.eventsUrl, this.repositoryUrl, this.labelsUrl, this.commentsUrl, this.htmlUrl, value, this.state, this.title, this.body, this.user, this.labels, this.assignee, this.milestone, this.locked, this.comments, this.pullRequest, this.score);
    }

    public final ImmutableSearchIssue withState(@Nullable String value) {
        if (Objects.equals(this.state, value)) {
            return this;
        }
        return new ImmutableSearchIssue(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.eventsUrl, this.repositoryUrl, this.labelsUrl, this.commentsUrl, this.htmlUrl, this.number, value, this.title, this.body, this.user, this.labels, this.assignee, this.milestone, this.locked, this.comments, this.pullRequest, this.score);
    }

    public final ImmutableSearchIssue withTitle(@Nullable String value) {
        if (Objects.equals(this.title, value)) {
            return this;
        }
        return new ImmutableSearchIssue(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.eventsUrl, this.repositoryUrl, this.labelsUrl, this.commentsUrl, this.htmlUrl, this.number, this.state, value, this.body, this.user, this.labels, this.assignee, this.milestone, this.locked, this.comments, this.pullRequest, this.score);
    }

    public final ImmutableSearchIssue withBody(@Nullable Optional<String> value) {
        if (Objects.equals(this.body, value)) {
            return this;
        }
        return new ImmutableSearchIssue(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.eventsUrl, this.repositoryUrl, this.labelsUrl, this.commentsUrl, this.htmlUrl, this.number, this.state, this.title, value, this.user, this.labels, this.assignee, this.milestone, this.locked, this.comments, this.pullRequest, this.score);
    }

    public final ImmutableSearchIssue withUser(@Nullable User value) {
        if (this.user == value) {
            return this;
        }
        return new ImmutableSearchIssue(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.eventsUrl, this.repositoryUrl, this.labelsUrl, this.commentsUrl, this.htmlUrl, this.number, this.state, this.title, this.body, value, this.labels, this.assignee, this.milestone, this.locked, this.comments, this.pullRequest, this.score);
    }

    public final ImmutableSearchIssue withLabels(Label ... elements) {
        if (elements == null) {
            return new ImmutableSearchIssue(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.eventsUrl, this.repositoryUrl, this.labelsUrl, this.commentsUrl, this.htmlUrl, this.number, this.state, this.title, this.body, this.user, null, this.assignee, this.milestone, this.locked, this.comments, this.pullRequest, this.score);
        }
        List<Label> newValue = Arrays.asList(elements) == null ? null : ImmutableSearchIssue.createUnmodifiableList(false, ImmutableSearchIssue.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableSearchIssue(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.eventsUrl, this.repositoryUrl, this.labelsUrl, this.commentsUrl, this.htmlUrl, this.number, this.state, this.title, this.body, this.user, newValue, this.assignee, this.milestone, this.locked, this.comments, this.pullRequest, this.score);
    }

    public final ImmutableSearchIssue withLabels(@Nullable Iterable<? extends Label> elements) {
        if (this.labels == elements) {
            return this;
        }
        List<Label> newValue = elements == null ? null : ImmutableSearchIssue.createUnmodifiableList(false, ImmutableSearchIssue.createSafeList(elements, true, false));
        return new ImmutableSearchIssue(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.eventsUrl, this.repositoryUrl, this.labelsUrl, this.commentsUrl, this.htmlUrl, this.number, this.state, this.title, this.body, this.user, newValue, this.assignee, this.milestone, this.locked, this.comments, this.pullRequest, this.score);
    }

    public final ImmutableSearchIssue withAssignee(User value) {
        User newValue = Objects.requireNonNull(value, "assignee");
        if (this.assignee == newValue) {
            return this;
        }
        return new ImmutableSearchIssue(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.eventsUrl, this.repositoryUrl, this.labelsUrl, this.commentsUrl, this.htmlUrl, this.number, this.state, this.title, this.body, this.user, this.labels, newValue, this.milestone, this.locked, this.comments, this.pullRequest, this.score);
    }

    public final ImmutableSearchIssue withAssignee(Optional<? extends User> optional) {
        User value = optional.orElse(null);
        if (this.assignee == value) {
            return this;
        }
        return new ImmutableSearchIssue(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.eventsUrl, this.repositoryUrl, this.labelsUrl, this.commentsUrl, this.htmlUrl, this.number, this.state, this.title, this.body, this.user, this.labels, value, this.milestone, this.locked, this.comments, this.pullRequest, this.score);
    }

    public final ImmutableSearchIssue withMilestone(Milestone value) {
        Milestone newValue = Objects.requireNonNull(value, "milestone");
        if (this.milestone == newValue) {
            return this;
        }
        return new ImmutableSearchIssue(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.eventsUrl, this.repositoryUrl, this.labelsUrl, this.commentsUrl, this.htmlUrl, this.number, this.state, this.title, this.body, this.user, this.labels, this.assignee, newValue, this.locked, this.comments, this.pullRequest, this.score);
    }

    public final ImmutableSearchIssue withMilestone(Optional<? extends Milestone> optional) {
        Milestone value = optional.orElse(null);
        if (this.milestone == value) {
            return this;
        }
        return new ImmutableSearchIssue(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.eventsUrl, this.repositoryUrl, this.labelsUrl, this.commentsUrl, this.htmlUrl, this.number, this.state, this.title, this.body, this.user, this.labels, this.assignee, value, this.locked, this.comments, this.pullRequest, this.score);
    }

    public final ImmutableSearchIssue withLocked(@Nullable Boolean value) {
        if (Objects.equals(this.locked, value)) {
            return this;
        }
        return new ImmutableSearchIssue(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.eventsUrl, this.repositoryUrl, this.labelsUrl, this.commentsUrl, this.htmlUrl, this.number, this.state, this.title, this.body, this.user, this.labels, this.assignee, this.milestone, value, this.comments, this.pullRequest, this.score);
    }

    public final ImmutableSearchIssue withComments(@Nullable Integer value) {
        if (Objects.equals(this.comments, value)) {
            return this;
        }
        return new ImmutableSearchIssue(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.eventsUrl, this.repositoryUrl, this.labelsUrl, this.commentsUrl, this.htmlUrl, this.number, this.state, this.title, this.body, this.user, this.labels, this.assignee, this.milestone, this.locked, value, this.pullRequest, this.score);
    }

    public final ImmutableSearchIssue withPullRequest(PullRequest value) {
        PullRequest newValue = Objects.requireNonNull(value, "pullRequest");
        if (this.pullRequest == newValue) {
            return this;
        }
        return new ImmutableSearchIssue(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.eventsUrl, this.repositoryUrl, this.labelsUrl, this.commentsUrl, this.htmlUrl, this.number, this.state, this.title, this.body, this.user, this.labels, this.assignee, this.milestone, this.locked, this.comments, newValue, this.score);
    }

    public final ImmutableSearchIssue withPullRequest(Optional<? extends PullRequest> optional) {
        PullRequest value = optional.orElse(null);
        if (this.pullRequest == value) {
            return this;
        }
        return new ImmutableSearchIssue(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.eventsUrl, this.repositoryUrl, this.labelsUrl, this.commentsUrl, this.htmlUrl, this.number, this.state, this.title, this.body, this.user, this.labels, this.assignee, this.milestone, this.locked, this.comments, value, this.score);
    }

    public final ImmutableSearchIssue withScore(@Nullable Float value) {
        if (Objects.equals(this.score, value)) {
            return this;
        }
        return new ImmutableSearchIssue(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.eventsUrl, this.repositoryUrl, this.labelsUrl, this.commentsUrl, this.htmlUrl, this.number, this.state, this.title, this.body, this.user, this.labels, this.assignee, this.milestone, this.locked, this.comments, this.pullRequest, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSearchIssue && this.equalTo(0, (ImmutableSearchIssue)another);
    }

    private boolean equalTo(int synthetic, ImmutableSearchIssue another) {
        return Objects.equals(this.createdAt, another.createdAt) && Objects.equals(this.updatedAt, another.updatedAt) && Objects.equals(this.closedAt, another.closedAt) && Objects.equals(this.id, another.id) && Objects.equals(this.url, another.url) && Objects.equals(this.eventsUrl, another.eventsUrl) && Objects.equals(this.repositoryUrl, another.repositoryUrl) && Objects.equals(this.labelsUrl, another.labelsUrl) && Objects.equals(this.commentsUrl, another.commentsUrl) && Objects.equals(this.htmlUrl, another.htmlUrl) && Objects.equals(this.number, another.number) && Objects.equals(this.state, another.state) && Objects.equals(this.title, another.title) && Objects.equals(this.body, another.body) && Objects.equals(this.user, another.user) && Objects.equals(this.labels, another.labels) && Objects.equals(this.assignee, another.assignee) && Objects.equals(this.milestone, another.milestone) && Objects.equals(this.locked, another.locked) && Objects.equals(this.comments, another.comments) && Objects.equals(this.pullRequest, another.pullRequest) && Objects.equals(this.score, another.score);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.createdAt);
        h += (h << 5) + Objects.hashCode(this.updatedAt);
        h += (h << 5) + Objects.hashCode(this.closedAt);
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + Objects.hashCode(this.url);
        h += (h << 5) + Objects.hashCode(this.eventsUrl);
        h += (h << 5) + Objects.hashCode(this.repositoryUrl);
        h += (h << 5) + Objects.hashCode(this.labelsUrl);
        h += (h << 5) + Objects.hashCode(this.commentsUrl);
        h += (h << 5) + Objects.hashCode(this.htmlUrl);
        h += (h << 5) + Objects.hashCode(this.number);
        h += (h << 5) + Objects.hashCode(this.state);
        h += (h << 5) + Objects.hashCode(this.title);
        h += (h << 5) + Objects.hashCode(this.body);
        h += (h << 5) + Objects.hashCode(this.user);
        h += (h << 5) + Objects.hashCode(this.labels);
        h += (h << 5) + Objects.hashCode(this.assignee);
        h += (h << 5) + Objects.hashCode(this.milestone);
        h += (h << 5) + Objects.hashCode(this.locked);
        h += (h << 5) + Objects.hashCode(this.comments);
        h += (h << 5) + Objects.hashCode(this.pullRequest);
        h += (h << 5) + Objects.hashCode(this.score);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SearchIssue{");
        if (this.createdAt != null) {
            builder.append("createdAt=").append(this.createdAt);
        }
        if (this.updatedAt != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("updatedAt=").append(this.updatedAt);
        }
        if (this.closedAt != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("closedAt=").append(this.closedAt);
        }
        if (this.id != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("id=").append(this.id);
        }
        if (this.url != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("url=").append(this.url);
        }
        if (this.eventsUrl != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("eventsUrl=").append(this.eventsUrl);
        }
        if (this.repositoryUrl != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("repositoryUrl=").append(this.repositoryUrl);
        }
        if (this.labelsUrl != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("labelsUrl=").append(this.labelsUrl);
        }
        if (this.commentsUrl != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("commentsUrl=").append(this.commentsUrl);
        }
        if (this.htmlUrl != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("htmlUrl=").append(this.htmlUrl);
        }
        if (this.number != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("number=").append(this.number);
        }
        if (this.state != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("state=").append(this.state);
        }
        if (this.title != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("title=").append(this.title);
        }
        if (this.body != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("body=").append(this.body);
        }
        if (this.user != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("user=").append(this.user);
        }
        if (this.labels != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("labels=").append(this.labels);
        }
        if (this.assignee != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("assignee=").append(this.assignee);
        }
        if (this.milestone != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("milestone=").append(this.milestone);
        }
        if (this.locked != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("locked=").append(this.locked);
        }
        if (this.comments != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("comments=").append(this.comments);
        }
        if (this.pullRequest != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("pullRequest=").append(this.pullRequest);
        }
        if (this.score != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("score=").append(this.score);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableSearchIssue fromJson(Json json) {
        Builder builder = ImmutableSearchIssue.builder();
        if (json.createdAt != null) {
            builder.createdAt(json.createdAt);
        }
        if (json.updatedAt != null) {
            builder.updatedAt(json.updatedAt);
        }
        if (json.closedAt != null) {
            builder.closedAt(json.closedAt);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.url != null) {
            builder.url(json.url);
        }
        if (json.eventsUrl != null) {
            builder.eventsUrl(json.eventsUrl);
        }
        if (json.repositoryUrl != null) {
            builder.repositoryUrl(json.repositoryUrl);
        }
        if (json.labelsUrl != null) {
            builder.labelsUrl(json.labelsUrl);
        }
        if (json.commentsUrl != null) {
            builder.commentsUrl(json.commentsUrl);
        }
        if (json.htmlUrl != null) {
            builder.htmlUrl(json.htmlUrl);
        }
        if (json.number != null) {
            builder.number(json.number);
        }
        if (json.state != null) {
            builder.state(json.state);
        }
        if (json.title != null) {
            builder.title(json.title);
        }
        if (json.body != null) {
            builder.body(json.body);
        }
        if (json.user != null) {
            builder.user(json.user);
        }
        if (json.labels != null) {
            builder.addAllLabels(json.labels);
        }
        if (json.assignee != null) {
            builder.assignee(json.assignee);
        }
        if (json.milestone != null) {
            builder.milestone(json.milestone);
        }
        if (json.locked != null) {
            builder.locked(json.locked);
        }
        if (json.comments != null) {
            builder.comments(json.comments);
        }
        if (json.pullRequest != null) {
            builder.pullRequest(json.pullRequest);
        }
        if (json.score != null) {
            builder.score(json.score);
        }
        return builder.build();
    }

    public static ImmutableSearchIssue copyOf(SearchIssue instance) {
        if (instance instanceof ImmutableSearchIssue) {
            return (ImmutableSearchIssue)instance;
        }
        return ImmutableSearchIssue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="SearchIssue", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private GitHubInstant createdAt;
        @Nullable
        private GitHubInstant updatedAt;
        @Nullable
        private GitHubInstant closedAt;
        @Nullable
        private Integer id;
        @Nullable
        private URI url;
        @Nullable
        private Optional<URI> eventsUrl;
        @Nullable
        private Optional<URI> repositoryUrl;
        @Nullable
        private String labelsUrl;
        @Nullable
        private URI commentsUrl;
        @Nullable
        private URI htmlUrl;
        @Nullable
        private Integer number;
        @Nullable
        private String state;
        @Nullable
        private String title;
        @Nullable
        private Optional<String> body;
        @Nullable
        private User user;
        private List<Label> labels = null;
        @Nullable
        private User assignee;
        @Nullable
        private Milestone milestone;
        @Nullable
        private Boolean locked;
        @Nullable
        private Integer comments;
        @Nullable
        private PullRequest pullRequest;
        @Nullable
        private Float score;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(SearchIssue instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(CloseTracking instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Issue instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(UpdateTracking instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GitHubInstant updatedAtValue;
            Optional<GitHubInstant> closedAtOptional;
            Integer numberValue;
            GitHubInstant createdAtValue;
            List<Label> labelsValue;
            Optional<URI> repositoryUrlValue;
            Optional<PullRequest> pullRequestOptional;
            URI urlValue;
            Optional<String> bodyValue;
            String titleValue;
            URI htmlUrlValue;
            String labelsUrlValue;
            Integer commentsValue;
            UpdateTracking instance;
            long bits = 0L;
            if (object instanceof SearchIssue) {
                Float scoreValue;
                instance = (SearchIssue)object;
                if ((bits & 1L) == 0L) {
                    commentsValue = instance.comments();
                    if (commentsValue != null) {
                        this.comments(commentsValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    labelsUrlValue = instance.labelsUrl();
                    if (labelsUrlValue != null) {
                        this.labelsUrl(labelsUrlValue);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    htmlUrlValue = instance.htmlUrl();
                    if (htmlUrlValue != null) {
                        this.htmlUrl(htmlUrlValue);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    titleValue = instance.title();
                    if (titleValue != null) {
                        this.title(titleValue);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    bodyValue = instance.body();
                    if (bodyValue != null) {
                        this.body(bodyValue);
                    }
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    urlValue = instance.url();
                    if (urlValue != null) {
                        this.url(urlValue);
                    }
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    pullRequestOptional = instance.pullRequest();
                    if (pullRequestOptional.isPresent()) {
                        this.pullRequest(pullRequestOptional);
                    }
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    repositoryUrlValue = instance.repositoryUrl();
                    if (repositoryUrlValue != null) {
                        this.repositoryUrl(repositoryUrlValue);
                    }
                    bits |= 0x80L;
                }
                if ((bits & 0x100L) == 0L) {
                    labelsValue = instance.labels();
                    if (labelsValue != null) {
                        this.addAllLabels(labelsValue);
                    }
                    bits |= 0x100L;
                }
                if ((bits & 0x200L) == 0L) {
                    createdAtValue = instance.createdAt();
                    if (createdAtValue != null) {
                        this.createdAt(createdAtValue);
                    }
                    bits |= 0x200L;
                }
                if ((bits & 0x400L) == 0L) {
                    numberValue = instance.number();
                    if (numberValue != null) {
                        this.number(numberValue);
                    }
                    bits |= 0x400L;
                }
                if ((scoreValue = instance.score()) != null) {
                    this.score(scoreValue);
                }
                if ((bits & 0x800L) == 0L) {
                    URI commentsUrlValue = instance.commentsUrl();
                    if (commentsUrlValue != null) {
                        this.commentsUrl(commentsUrlValue);
                    }
                    bits |= 0x800L;
                }
                if ((bits & 0x1000L) == 0L) {
                    Optional<Milestone> milestoneOptional = instance.milestone();
                    if (milestoneOptional.isPresent()) {
                        this.milestone(milestoneOptional);
                    }
                    bits |= 0x1000L;
                }
                if ((bits & 0x2000L) == 0L) {
                    Integer idValue = instance.id();
                    if (idValue != null) {
                        this.id(idValue);
                    }
                    bits |= 0x2000L;
                }
                if ((bits & 0x4000L) == 0L) {
                    Optional<URI> eventsUrlValue = instance.eventsUrl();
                    if (eventsUrlValue != null) {
                        this.eventsUrl(eventsUrlValue);
                    }
                    bits |= 0x4000L;
                }
                if ((bits & 0x8000L) == 0L) {
                    String stateValue = instance.state();
                    if (stateValue != null) {
                        this.state(stateValue);
                    }
                    bits |= 0x8000L;
                }
                if ((bits & 0x10000L) == 0L) {
                    Optional<User> assigneeOptional = instance.assignee();
                    if (assigneeOptional.isPresent()) {
                        this.assignee(assigneeOptional);
                    }
                    bits |= 0x10000L;
                }
                if ((bits & 0x20000L) == 0L) {
                    Optional<GitHubInstant> closedAtOptional2 = instance.closedAt();
                    if (closedAtOptional2.isPresent()) {
                        this.closedAt(closedAtOptional2);
                    }
                    bits |= 0x20000L;
                }
                if ((bits & 0x40000L) == 0L) {
                    Boolean lockedValue = instance.locked();
                    if (lockedValue != null) {
                        this.locked(lockedValue);
                    }
                    bits |= 0x40000L;
                }
                if ((bits & 0x80000L) == 0L) {
                    User userValue = instance.user();
                    if (userValue != null) {
                        this.user(userValue);
                    }
                    bits |= 0x80000L;
                }
                if ((bits & 0x100000L) == 0L) {
                    GitHubInstant updatedAtValue2 = instance.updatedAt();
                    if (updatedAtValue2 != null) {
                        this.updatedAt(updatedAtValue2);
                    }
                    bits |= 0x100000L;
                }
            }
            if (object instanceof CloseTracking) {
                instance = (CloseTracking)object;
                if ((bits & 0x20000L) == 0L) {
                    closedAtOptional = instance.closedAt();
                    if (closedAtOptional.isPresent()) {
                        this.closedAt(closedAtOptional);
                    }
                    bits |= 0x20000L;
                }
                if ((bits & 0x200L) == 0L) {
                    createdAtValue = instance.createdAt();
                    if (createdAtValue != null) {
                        this.createdAt(createdAtValue);
                    }
                    bits |= 0x200L;
                }
                if ((bits & 0x100000L) == 0L) {
                    updatedAtValue = instance.updatedAt();
                    if (updatedAtValue != null) {
                        this.updatedAt(updatedAtValue);
                    }
                    bits |= 0x100000L;
                }
            }
            if (object instanceof Issue) {
                instance = (Issue)object;
                if ((bits & 1L) == 0L) {
                    commentsValue = instance.comments();
                    if (commentsValue != null) {
                        this.comments(commentsValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    labelsUrlValue = instance.labelsUrl();
                    if (labelsUrlValue != null) {
                        this.labelsUrl(labelsUrlValue);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    htmlUrlValue = instance.htmlUrl();
                    if (htmlUrlValue != null) {
                        this.htmlUrl(htmlUrlValue);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    titleValue = instance.title();
                    if (titleValue != null) {
                        this.title(titleValue);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    bodyValue = instance.body();
                    if (bodyValue != null) {
                        this.body(bodyValue);
                    }
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    urlValue = instance.url();
                    if (urlValue != null) {
                        this.url(urlValue);
                    }
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    pullRequestOptional = instance.pullRequest();
                    if (pullRequestOptional.isPresent()) {
                        this.pullRequest(pullRequestOptional);
                    }
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    repositoryUrlValue = instance.repositoryUrl();
                    if (repositoryUrlValue != null) {
                        this.repositoryUrl(repositoryUrlValue);
                    }
                    bits |= 0x80L;
                }
                if ((bits & 0x100L) == 0L) {
                    labelsValue = instance.labels();
                    if (labelsValue != null) {
                        this.addAllLabels(labelsValue);
                    }
                    bits |= 0x100L;
                }
                if ((bits & 0x200L) == 0L) {
                    createdAtValue = instance.createdAt();
                    if (createdAtValue != null) {
                        this.createdAt(createdAtValue);
                    }
                    bits |= 0x200L;
                }
                if ((bits & 0x400L) == 0L) {
                    numberValue = instance.number();
                    if (numberValue != null) {
                        this.number(numberValue);
                    }
                    bits |= 0x400L;
                }
                if ((bits & 0x800L) == 0L) {
                    URI commentsUrlValue = instance.commentsUrl();
                    if (commentsUrlValue != null) {
                        this.commentsUrl(commentsUrlValue);
                    }
                    bits |= 0x800L;
                }
                if ((bits & 0x1000L) == 0L) {
                    Optional<Milestone> milestoneOptional = instance.milestone();
                    if (milestoneOptional.isPresent()) {
                        this.milestone(milestoneOptional);
                    }
                    bits |= 0x1000L;
                }
                if ((bits & 0x2000L) == 0L) {
                    Integer idValue = instance.id();
                    if (idValue != null) {
                        this.id(idValue);
                    }
                    bits |= 0x2000L;
                }
                if ((bits & 0x4000L) == 0L) {
                    Optional<URI> eventsUrlValue = instance.eventsUrl();
                    if (eventsUrlValue != null) {
                        this.eventsUrl(eventsUrlValue);
                    }
                    bits |= 0x4000L;
                }
                if ((bits & 0x8000L) == 0L) {
                    String stateValue = instance.state();
                    if (stateValue != null) {
                        this.state(stateValue);
                    }
                    bits |= 0x8000L;
                }
                if ((bits & 0x10000L) == 0L) {
                    Optional<User> assigneeOptional = instance.assignee();
                    if (assigneeOptional.isPresent()) {
                        this.assignee(assigneeOptional);
                    }
                    bits |= 0x10000L;
                }
                if ((bits & 0x20000L) == 0L) {
                    closedAtOptional = instance.closedAt();
                    if (closedAtOptional.isPresent()) {
                        this.closedAt(closedAtOptional);
                    }
                    bits |= 0x20000L;
                }
                if ((bits & 0x40000L) == 0L) {
                    Boolean lockedValue = instance.locked();
                    if (lockedValue != null) {
                        this.locked(lockedValue);
                    }
                    bits |= 0x40000L;
                }
                if ((bits & 0x80000L) == 0L) {
                    User userValue = instance.user();
                    if (userValue != null) {
                        this.user(userValue);
                    }
                    bits |= 0x80000L;
                }
                if ((bits & 0x100000L) == 0L) {
                    updatedAtValue = instance.updatedAt();
                    if (updatedAtValue != null) {
                        this.updatedAt(updatedAtValue);
                    }
                    bits |= 0x100000L;
                }
            }
            if (object instanceof UpdateTracking) {
                instance = (UpdateTracking)object;
                if ((bits & 0x200L) == 0L) {
                    createdAtValue = instance.createdAt();
                    if (createdAtValue != null) {
                        this.createdAt(createdAtValue);
                    }
                    bits |= 0x200L;
                }
                if ((bits & 0x100000L) == 0L) {
                    updatedAtValue = instance.updatedAt();
                    if (updatedAtValue != null) {
                        this.updatedAt(updatedAtValue);
                    }
                    bits |= 0x100000L;
                }
            }
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder createdAt(@Nullable GitHubInstant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder updatedAt(@Nullable GitHubInstant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder closedAt(GitHubInstant closedAt) {
            this.closedAt = Objects.requireNonNull(closedAt, "closedAt");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder closedAt(Optional<? extends GitHubInstant> closedAt) {
            this.closedAt = closedAt.orElse(null);
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder id(@Nullable Integer id) {
            this.id = id;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder url(@Nullable URI url) {
            this.url = url;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder eventsUrl(@Nullable Optional<URI> eventsUrl) {
            this.eventsUrl = eventsUrl;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder repositoryUrl(@Nullable Optional<URI> repositoryUrl) {
            this.repositoryUrl = repositoryUrl;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder labelsUrl(@Nullable String labelsUrl) {
            this.labelsUrl = labelsUrl;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder commentsUrl(@Nullable URI commentsUrl) {
            this.commentsUrl = commentsUrl;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder htmlUrl(@Nullable URI htmlUrl) {
            this.htmlUrl = htmlUrl;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder number(@Nullable Integer number) {
            this.number = number;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder state(@Nullable String state) {
            this.state = state;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder title(@Nullable String title) {
            this.title = title;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder body(@Nullable Optional<String> body) {
            this.body = body;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder user(@Nullable User user) {
            this.user = user;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addLabels(Label element) {
            if (this.labels == null) {
                this.labels = new ArrayList<Label>();
            }
            this.labels.add(Objects.requireNonNull(element, "labels element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addLabels(Label ... elements) {
            if (this.labels == null) {
                this.labels = new ArrayList<Label>();
            }
            for (Label element : elements) {
                this.labels.add(Objects.requireNonNull(element, "labels element"));
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder labels(@Nullable Iterable<? extends Label> elements) {
            if (elements == null) {
                this.labels = null;
                return this;
            }
            this.labels = new ArrayList<Label>();
            return this.addAllLabels(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllLabels(Iterable<? extends Label> elements) {
            Objects.requireNonNull(elements, "labels element");
            if (this.labels == null) {
                this.labels = new ArrayList<Label>();
            }
            for (Label label : elements) {
                this.labels.add(Objects.requireNonNull(label, "labels element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder assignee(User assignee) {
            this.assignee = Objects.requireNonNull(assignee, "assignee");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder assignee(Optional<? extends User> assignee) {
            this.assignee = assignee.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder milestone(Milestone milestone) {
            this.milestone = Objects.requireNonNull(milestone, "milestone");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder milestone(Optional<? extends Milestone> milestone) {
            this.milestone = milestone.orElse(null);
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder locked(@Nullable Boolean locked) {
            this.locked = locked;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder comments(@Nullable Integer comments) {
            this.comments = comments;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder pullRequest(PullRequest pullRequest) {
            this.pullRequest = Objects.requireNonNull(pullRequest, "pullRequest");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder pullRequest(Optional<? extends PullRequest> pullRequest) {
            this.pullRequest = pullRequest.orElse(null);
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder score(@Nullable Float score) {
            this.score = score;
            return this;
        }

        public ImmutableSearchIssue build() {
            return new ImmutableSearchIssue(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.eventsUrl, this.repositoryUrl, this.labelsUrl, this.commentsUrl, this.htmlUrl, this.number, this.state, this.title, this.body, this.user, this.labels == null ? null : ImmutableSearchIssue.createUnmodifiableList(true, this.labels), this.assignee, this.milestone, this.locked, this.comments, this.pullRequest, this.score);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="SearchIssue", generator="Immutables")
    static final class Json
    implements SearchIssue {
        @Nullable
        GitHubInstant createdAt;
        @Nullable
        GitHubInstant updatedAt;
        @Nullable
        Optional<GitHubInstant> closedAt = Optional.empty();
        @Nullable
        Integer id;
        @Nullable
        URI url;
        @Nullable
        Optional<URI> eventsUrl;
        @Nullable
        Optional<URI> repositoryUrl;
        @Nullable
        String labelsUrl;
        @Nullable
        URI commentsUrl;
        @Nullable
        URI htmlUrl;
        @Nullable
        Integer number;
        @Nullable
        String state;
        @Nullable
        String title;
        @Nullable
        Optional<String> body;
        @Nullable
        User user;
        @Nullable
        List<Label> labels = null;
        @Nullable
        Optional<User> assignee = Optional.empty();
        @Nullable
        Optional<Milestone> milestone = Optional.empty();
        @Nullable
        Boolean locked;
        @Nullable
        Integer comments;
        @Nullable
        Optional<PullRequest> pullRequest = Optional.empty();
        @Nullable
        Float score;

        Json() {
        }

        @JsonProperty
        public void setCreatedAt(@Nullable GitHubInstant createdAt) {
            this.createdAt = createdAt;
        }

        @JsonProperty
        public void setUpdatedAt(@Nullable GitHubInstant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @JsonProperty
        public void setClosedAt(Optional<GitHubInstant> closedAt) {
            this.closedAt = closedAt;
        }

        @JsonProperty
        public void setId(@Nullable Integer id) {
            this.id = id;
        }

        @JsonProperty
        public void setUrl(@Nullable URI url) {
            this.url = url;
        }

        @JsonProperty
        public void setEventsUrl(@Nullable Optional<URI> eventsUrl) {
            this.eventsUrl = eventsUrl;
        }

        @JsonProperty
        public void setRepositoryUrl(@Nullable Optional<URI> repositoryUrl) {
            this.repositoryUrl = repositoryUrl;
        }

        @JsonProperty
        public void setLabelsUrl(@Nullable String labelsUrl) {
            this.labelsUrl = labelsUrl;
        }

        @JsonProperty
        public void setCommentsUrl(@Nullable URI commentsUrl) {
            this.commentsUrl = commentsUrl;
        }

        @JsonProperty
        public void setHtmlUrl(@Nullable URI htmlUrl) {
            this.htmlUrl = htmlUrl;
        }

        @JsonProperty
        public void setNumber(@Nullable Integer number) {
            this.number = number;
        }

        @JsonProperty
        public void setState(@Nullable String state) {
            this.state = state;
        }

        @JsonProperty
        public void setTitle(@Nullable String title) {
            this.title = title;
        }

        @JsonProperty
        public void setBody(@Nullable Optional<String> body) {
            this.body = body;
        }

        @JsonProperty
        public void setUser(@Nullable User user) {
            this.user = user;
        }

        @JsonProperty
        public void setLabels(@Nullable List<Label> labels) {
            this.labels = labels;
        }

        @JsonProperty
        public void setAssignee(Optional<User> assignee) {
            this.assignee = assignee;
        }

        @JsonProperty
        public void setMilestone(Optional<Milestone> milestone) {
            this.milestone = milestone;
        }

        @JsonProperty
        public void setLocked(@Nullable Boolean locked) {
            this.locked = locked;
        }

        @JsonProperty
        public void setComments(@Nullable Integer comments) {
            this.comments = comments;
        }

        @JsonProperty
        public void setPullRequest(Optional<PullRequest> pullRequest) {
            this.pullRequest = pullRequest;
        }

        @JsonProperty
        public void setScore(@Nullable Float score) {
            this.score = score;
        }

        @Override
        public GitHubInstant createdAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public GitHubInstant updatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<GitHubInstant> closedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI url() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<URI> eventsUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<URI> repositoryUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String labelsUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI commentsUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI htmlUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer number() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String state() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String title() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> body() {
            throw new UnsupportedOperationException();
        }

        @Override
        public User user() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Label> labels() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<User> assignee() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Milestone> milestone() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean locked() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer comments() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<PullRequest> pullRequest() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Float score() {
            throw new UnsupportedOperationException();
        }
    }
}

