/*
 * Copyright (c) 2014 Spotify AB.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package com.spotify.helios.servicescommon;

/**
 * This class represents a Kafka record whose data is an array of bytes.
 */
public class KafkaRecord {

  private final String topic;
  private final byte[] data;

  private KafkaRecord(final String topic, final byte[] data) {
    this.topic = topic;
    this.data = data;
  }

  public String getKafkaTopic() {
    return topic;
  }

  public byte[] getKafkaData() {
    return data;
  }

  public static KafkaRecord of(final String topic, final byte[] data) {
    return new KafkaRecord(topic, data);
  }

}
