/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.agent;

import com.google.common.base.Preconditions;
import com.spotify.helios.agent.InterruptingScheduledService;
import com.spotify.helios.common.descriptors.AgentInfo;
import com.spotify.helios.servicescommon.coordination.NodeUpdaterFactory;
import com.spotify.helios.servicescommon.coordination.Paths;
import com.spotify.helios.servicescommon.coordination.ZooKeeperNodeUpdater;
import java.lang.management.RuntimeMXBean;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class AgentInfoReporter
extends InterruptingScheduledService {
    public static final int DEFAULT_INTERVAL = 1;
    public static final TimeUnit DEFAUL_TIMEUNIT = TimeUnit.MINUTES;
    private final RuntimeMXBean runtimeMXBean;
    private final ZooKeeperNodeUpdater nodeUpdater;
    private final int interval;
    private final TimeUnit timeUnit;

    AgentInfoReporter(Builder builder) {
        this.runtimeMXBean = (RuntimeMXBean)Preconditions.checkNotNull((Object)builder.runtimeMXBean);
        this.nodeUpdater = builder.nodeUpdaterFactory.create(Paths.statusHostAgentInfo(builder.host));
        this.interval = builder.interval;
        this.timeUnit = (TimeUnit)((Object)Preconditions.checkNotNull((Object)((Object)builder.timeUnit)));
    }

    @Override
    protected void runOneIteration() {
        AgentInfo agentInfo = AgentInfo.newBuilder().setName(this.runtimeMXBean.getName()).setVmName(this.runtimeMXBean.getVmName()).setVmVendor(this.runtimeMXBean.getVmVendor()).setVmVersion(this.runtimeMXBean.getVmVersion()).setSpecName(this.runtimeMXBean.getSpecName()).setSpecVendor(this.runtimeMXBean.getSpecVendor()).setSpecVersion(this.runtimeMXBean.getSpecVersion()).setInputArguments(this.runtimeMXBean.getInputArguments()).setUptime(this.runtimeMXBean.getUptime()).setStartTime(this.runtimeMXBean.getStartTime()).setVersion("0.8.9").build();
        this.nodeUpdater.update(agentInfo.toJsonBytes());
    }

    @Override
    protected ScheduledFuture<?> schedule(Runnable runnable, ScheduledExecutorService executorService) {
        return executorService.scheduleWithFixedDelay(runnable, 0L, this.interval, this.timeUnit);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private NodeUpdaterFactory nodeUpdaterFactory;
        private RuntimeMXBean runtimeMXBean;
        private String host;
        private int interval = 1;
        private TimeUnit timeUnit = DEFAUL_TIMEUNIT;

        Builder() {
        }

        public Builder setNodeUpdaterFactory(NodeUpdaterFactory nodeUpdaterFactory) {
            this.nodeUpdaterFactory = nodeUpdaterFactory;
            return this;
        }

        public Builder setRuntimeMXBean(RuntimeMXBean runtimeMXBean) {
            this.runtimeMXBean = runtimeMXBean;
            return this;
        }

        public Builder setHost(String host) {
            this.host = host;
            return this;
        }

        public Builder setInterval(int interval) {
            this.interval = interval;
            return this;
        }

        public Builder setTimeUnit(TimeUnit timeUnit) {
            this.timeUnit = timeUnit;
            return this;
        }

        public AgentInfoReporter build() {
            return new AgentInfoReporter(this);
        }
    }
}

