/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.agent;

import com.spotify.helios.agent.AgentConfig;
import com.spotify.helios.agent.AgentParser;
import com.spotify.helios.agent.AgentService;
import com.spotify.helios.common.LoggingConfig;
import com.spotify.helios.servicescommon.ServiceMain;
import com.yammer.dropwizard.config.Configuration;
import com.yammer.dropwizard.config.Environment;
import com.yammer.dropwizard.json.ObjectMapperFactory;
import com.yammer.dropwizard.validation.Validator;
import net.sourceforge.argparse4j.inf.ArgumentParserException;

public class AgentMain
extends ServiceMain {
    private final AgentConfig agentConfig;
    private AgentService service;

    public AgentMain(String ... args) throws ArgumentParserException {
        this(new AgentParser(args));
    }

    public AgentMain(AgentParser parser) {
        this(parser.getAgentConfig(), parser.getLoggingConfig());
    }

    public AgentMain(AgentConfig agentConfig, LoggingConfig loggingConfig) {
        super(loggingConfig, agentConfig.getSentryDsn());
        this.agentConfig = agentConfig;
    }

    protected void startUp() throws Exception {
        Environment environment = new Environment("helios-agent", (Configuration)this.agentConfig, new ObjectMapperFactory(), new Validator());
        this.service = new AgentService(this.agentConfig, environment);
        this.service.startAsync().awaitRunning();
    }

    protected void shutDown() throws Exception {
        if (this.service != null) {
            this.service.stopAsync().awaitTerminated();
        }
    }

    public static void main(String ... args) {
        try {
            AgentMain main = new AgentMain(args);
            main.startAsync().awaitRunning();
            main.awaitTerminated();
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }
}

