/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.agent;

import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import com.google.common.io.BaseEncoding;
import com.google.common.net.InetAddresses;
import com.spotify.helios.agent.AgentConfig;
import com.spotify.helios.servicescommon.DockerHost;
import com.spotify.helios.servicescommon.ServiceParser;
import com.yammer.dropwizard.config.HttpConfiguration;
import java.net.InetSocketAddress;
import java.nio.file.Paths;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;

public class AgentParser
extends ServiceParser {
    private final AgentConfig agentConfig;
    private Argument noHttpArg;
    private Argument httpArg;
    private Argument adminArg;
    private Argument stateDirArg;
    private Argument dockerArg;
    private Argument envArg;
    private Argument syslogRedirectToArg;
    private Argument portRangeArg;
    private Argument agentIdArg;
    private Argument dnsArg;

    public AgentParser(String ... args) throws ArgumentParserException {
        super("helios-agent", "Spotify Helios Agent", args);
        int end;
        int start;
        Namespace options = this.getNamespace();
        DockerHost dockerHost = DockerHost.from(options.getString(this.dockerArg.getDest()));
        List env = options.getList(this.envArg.getDest());
        HashMap envVars = Maps.newHashMap();
        if (env != null) {
            for (List group : env) {
                for (String s : group) {
                    String[] parts = s.split("=", 2);
                    if (parts.length != 2) {
                        throw new IllegalArgumentException("Bad environment variable: " + s);
                    }
                    envVars.put(parts[0], parts[1]);
                }
            }
        }
        InetSocketAddress httpAddress = this.parseSocketAddress(options.getString(this.httpArg.getDest()));
        String portRangeString = options.getString(this.portRangeArg.getDest());
        List parts = Splitter.on((char)':').splitToList((CharSequence)portRangeString);
        if (parts.size() != 2) {
            throw new IllegalArgumentException("Bad port range: " + portRangeString);
        }
        try {
            start = Integer.valueOf((String)parts.get(0));
            end = Integer.valueOf((String)parts.get(1));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Bad port range: " + portRangeString);
        }
        if (end <= start) {
            throw new IllegalArgumentException("Bad port range: " + portRangeString);
        }
        this.agentConfig = new AgentConfig().setName(this.getName()).setZooKeeperConnectionString(this.getZooKeeperConnectString()).setZooKeeperSessionTimeoutMillis(this.getZooKeeperSessionTimeoutMillis()).setZooKeeperConnectionTimeoutMillis(this.getZooKeeperConnectionTimeoutMillis()).setDomain(this.getDomain()).setEnvVars(envVars).setDockerHost(dockerHost).setInhibitMetrics(this.getInhibitMetrics()).setRedirectToSyslog(options.getString(this.syslogRedirectToArg.getDest())).setStateDirectory(Paths.get(options.getString(this.stateDirArg.getDest()), new String[0])).setStatsdHostPort(this.getStatsdHostPort()).setRiemannHostPort(this.getRiemannHostPort()).setPortRange(start, end).setSentryDsn(this.getSentryDsn()).setServiceRegistryAddress(this.getServiceRegistryAddress()).setServiceRegistrarPlugin(this.getServiceRegistrarPlugin());
        String explicitId = options.getString(this.agentIdArg.getDest());
        if (explicitId != null) {
            this.agentConfig.setId(explicitId);
        } else {
            byte[] idBytes = new byte[20];
            new SecureRandom().nextBytes(idBytes);
            this.agentConfig.setId(BaseEncoding.base16().encode(idBytes));
        }
        boolean noHttp = options.getBoolean(this.noHttpArg.getDest());
        if (noHttp) {
            this.agentConfig.setHttpConfiguration(null);
        } else {
            HttpConfiguration http = this.agentConfig.getHttpConfiguration();
            http.setPort(httpAddress.getPort());
            http.setBindHost(httpAddress.getHostString());
            http.setAdminPort(options.getInt(this.adminArg.getDest()).intValue());
        }
        List dns = options.getList(this.dnsArg.getDest());
        if (!dns.isEmpty()) {
            for (String d : dns) {
                if (InetAddresses.isInetAddress((String)d)) continue;
                throw new IllegalArgumentException("Invalid IP address " + d);
            }
        }
        this.agentConfig.setDns(dns);
    }

    @Override
    protected void addArgs(ArgumentParser parser) {
        this.noHttpArg = parser.addArgument(new String[]{"--no-http"}).action((ArgumentAction)Arguments.storeTrue()).setDefault((Object)false).help("disable http server");
        this.httpArg = parser.addArgument(new String[]{"--http"}).setDefault((Object)"http://0.0.0.0:5803").help("http endpoint");
        this.adminArg = parser.addArgument(new String[]{"--admin"}).type(Integer.class).setDefault((Object)5804).help("admin http port");
        this.agentIdArg = parser.addArgument(new String[]{"--id"}).help("Agent unique ID. Generated and persisted on first run if not specified.");
        this.stateDirArg = parser.addArgument(new String[]{"--state-dir"}).setDefault((Object)".").help("Directory for persisting agent state locally.");
        this.dockerArg = parser.addArgument(new String[]{"--docker"}).setDefault((Object)DockerHost.fromEnv().host()).help("docker endpoint");
        this.envArg = parser.addArgument(new String[]{"--env"}).action((ArgumentAction)Arguments.append()).setDefault(new ArrayList()).nargs("+").help("Specify environment variables that will pass down to all containers");
        this.syslogRedirectToArg = parser.addArgument(new String[]{"--syslog-redirect-to"}).help("redirect container's stdout/stderr to syslog running at host:port");
        this.portRangeArg = parser.addArgument(new String[]{"--port-range"}).setDefault((Object)"20000:32768").help("Port allocation range, start:end (end exclusive).");
        this.dnsArg = parser.addArgument(new String[]{"--dns"}).action((ArgumentAction)Arguments.append()).setDefault(new ArrayList()).help("Dns servers to use.");
    }

    public AgentConfig getAgentConfig() {
        return this.agentConfig;
    }
}

