/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.agent;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Charsets;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import com.google.common.io.Resources;
import com.google.common.util.concurrent.AbstractIdleService;
import com.google.common.util.concurrent.Service;
import com.spotify.docker.client.DockerClient;
import com.spotify.helios.agent.Agent;
import com.spotify.helios.agent.AgentConfig;
import com.spotify.helios.agent.AgentInfoReporter;
import com.spotify.helios.agent.AgentModelTaskResource;
import com.spotify.helios.agent.AgentModelTaskStatusResource;
import com.spotify.helios.agent.AgentZooKeeperRegistrar;
import com.spotify.helios.agent.DockerHealthChecker;
import com.spotify.helios.agent.EnvironmentVariableReporter;
import com.spotify.helios.agent.Execution;
import com.spotify.helios.agent.HostInfoReporter;
import com.spotify.helios.agent.MonitoredDockerClient;
import com.spotify.helios.agent.NoOpContainerDecorator;
import com.spotify.helios.agent.PollingDockerClient;
import com.spotify.helios.agent.PortAllocator;
import com.spotify.helios.agent.Reaper;
import com.spotify.helios.agent.SupervisorFactory;
import com.spotify.helios.agent.SyslogRedirectingContainerDecorator;
import com.spotify.helios.agent.ZooKeeperAgentModel;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.serviceregistration.ServiceRegistrar;
import com.spotify.helios.servicescommon.ManagedStatsdReporter;
import com.spotify.helios.servicescommon.PersistentAtomicReference;
import com.spotify.helios.servicescommon.ReactorFactory;
import com.spotify.helios.servicescommon.RiemannFacade;
import com.spotify.helios.servicescommon.RiemannHeartBeat;
import com.spotify.helios.servicescommon.RiemannSupport;
import com.spotify.helios.servicescommon.ServiceRegistrars;
import com.spotify.helios.servicescommon.ZooKeeperRegistrar;
import com.spotify.helios.servicescommon.coordination.DefaultZooKeeperClient;
import com.spotify.helios.servicescommon.coordination.Paths;
import com.spotify.helios.servicescommon.coordination.ZooKeeperClient;
import com.spotify.helios.servicescommon.coordination.ZooKeeperClientProvider;
import com.spotify.helios.servicescommon.coordination.ZooKeeperHealthChecker;
import com.spotify.helios.servicescommon.coordination.ZooKeeperModelReporter;
import com.spotify.helios.servicescommon.coordination.ZooKeeperNodeUpdaterFactory;
import com.spotify.helios.servicescommon.statistics.Metrics;
import com.spotify.helios.servicescommon.statistics.MetricsImpl;
import com.spotify.helios.servicescommon.statistics.NoopMetrics;
import com.sun.management.OperatingSystemMXBean;
import com.yammer.dropwizard.config.ConfigurationException;
import com.yammer.dropwizard.config.Environment;
import com.yammer.dropwizard.config.ServerFactory;
import com.yammer.dropwizard.lifecycle.Managed;
import com.yammer.dropwizard.lifecycle.ServerLifecycleListener;
import com.yammer.metrics.core.HealthCheck;
import com.yammer.metrics.core.MetricsRegistry;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.eclipse.jetty.server.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentService
extends AbstractIdleService {
    private static final Logger log = LoggerFactory.getLogger(AgentService.class);
    private static final TypeReference<Map<JobId, Execution>> JOBID_EXECUTIONS_MAP = new TypeReference<Map<JobId, Execution>>(){};
    private final Agent agent;
    private final Server server;
    private final ZooKeeperClient zooKeeperClient;
    private final HostInfoReporter hostInfoReporter;
    private final AgentInfoReporter agentInfoReporter;
    private final EnvironmentVariableReporter environmentVariableReporter;
    private final FileChannel stateLockFile;
    private final FileLock stateLock;
    private final ZooKeeperAgentModel model;
    private final Metrics metrics;
    private final ServiceRegistrar serviceRegistrar;
    private final Environment environment;
    private ZooKeeperRegistrar zkRegistrar;

    public AgentService(AgentConfig config, Environment environment) throws ConfigurationException, InterruptedException {
        PersistentAtomicReference<Map<JobId, Execution>> executions;
        String id;
        this.environment = environment;
        Path stateDirectory = config.getStateDirectory().toAbsolutePath().normalize();
        if (!Files.exists(stateDirectory, new LinkOption[0])) {
            try {
                Files.createDirectories(stateDirectory, new FileAttribute[0]);
            }
            catch (IOException e) {
                log.error("Failed to create state directory: {}", (Object)stateDirectory, (Object)e);
                throw Throwables.propagate((Throwable)e);
            }
        }
        Path lockPath = config.getStateDirectory().resolve("lock");
        try {
            this.stateLockFile = FileChannel.open(lockPath, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
            this.stateLock = this.stateLockFile.tryLock();
            if (this.stateLock == null) {
                throw new IllegalStateException("State lock file already locked: " + lockPath);
            }
        }
        catch (OverlappingFileLockException e) {
            throw new IllegalStateException("State lock file already locked: " + lockPath);
        }
        catch (IOException e) {
            log.error("Failed to take state lock: {}", (Object)lockPath, (Object)e);
            throw Throwables.propagate((Throwable)e);
        }
        Path idPath = config.getStateDirectory().resolve("id");
        try {
            if (Files.exists(idPath, new LinkOption[0])) {
                id = new String(Files.readAllBytes(idPath), Charsets.UTF_8);
            } else {
                id = config.getId();
                Files.write(idPath, id.getBytes(Charsets.UTF_8), new OpenOption[0]);
            }
        }
        catch (IOException e) {
            log.error("Failed to set up id file: {}", (Object)idPath, (Object)e);
            throw Throwables.propagate((Throwable)e);
        }
        MetricsRegistry metricsRegistry = com.yammer.metrics.Metrics.defaultRegistry();
        RiemannSupport riemannSupport = new RiemannSupport(metricsRegistry, config.getRiemannHostPort(), config.getName(), "helios-agent");
        RiemannFacade riemannFacade = riemannSupport.getFacade();
        if (config.isInhibitMetrics()) {
            log.info("Not starting metrics");
            this.metrics = new NoopMetrics();
        } else {
            log.info("Starting metrics");
            this.metrics = new MetricsImpl(metricsRegistry);
            environment.manage((Managed)new ManagedStatsdReporter(config.getStatsdHostPort(), "helios-agent", metricsRegistry));
            environment.manage((Managed)riemannSupport);
        }
        this.zooKeeperClient = this.setupZookeeperClient(config, id);
        DockerHealthChecker dockerHealthChecker = new DockerHealthChecker(this.metrics.getSupervisorMetrics(), TimeUnit.SECONDS, 30, riemannFacade);
        environment.manage((Managed)dockerHealthChecker);
        environment.manage((Managed)new RiemannHeartBeat(TimeUnit.MINUTES, 2, riemannFacade));
        ZooKeeperModelReporter modelReporter = new ZooKeeperModelReporter(riemannFacade, this.metrics.getZooKeeperMetrics());
        ZooKeeperClientProvider zkClientProvider = new ZooKeeperClientProvider(this.zooKeeperClient, modelReporter);
        try {
            this.model = new ZooKeeperAgentModel(zkClientProvider, config.getName(), stateDirectory);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        this.serviceRegistrar = ServiceRegistrars.createServiceRegistrar(config.getServiceRegistrarPlugin(), config.getServiceRegistryAddress(), config.getDomain());
        ZooKeeperNodeUpdaterFactory nodeUpdaterFactory = new ZooKeeperNodeUpdaterFactory(this.zooKeeperClient);
        PollingDockerClient dockerClient = new PollingDockerClient(config.getDockerHost().uri());
        DockerClient monitoredDockerClient = MonitoredDockerClient.wrap(riemannFacade, (DockerClient)dockerClient);
        this.hostInfoReporter = HostInfoReporter.newBuilder().setNodeUpdaterFactory(nodeUpdaterFactory).setOperatingSystemMXBean((OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean()).setHost(config.getName()).setDockerClient((DockerClient)dockerClient).build();
        this.agentInfoReporter = AgentInfoReporter.newBuilder().setNodeUpdaterFactory(nodeUpdaterFactory).setRuntimeMXBean(ManagementFactory.getRuntimeMXBean()).setHost(config.getName()).build();
        this.environmentVariableReporter = new EnvironmentVariableReporter(config.getName(), config.getEnvVars(), nodeUpdaterFactory);
        String namespace = "helios-" + id;
        SupervisorFactory supervisorFactory = new SupervisorFactory(this.model, monitoredDockerClient, config.getEnvVars(), this.serviceRegistrar, config.getRedirectToSyslog() != null ? new SyslogRedirectingContainerDecorator(config.getRedirectToSyslog()) : new NoOpContainerDecorator(), config.getName(), this.metrics.getSupervisorMetrics(), namespace, config.getDomain(), config.getDns());
        ReactorFactory reactorFactory = new ReactorFactory();
        PortAllocator portAllocator = new PortAllocator(config.getPortRangeStart(), config.getPortRangeEnd());
        try {
            executions = PersistentAtomicReference.create(stateDirectory.resolve("executions.json"), JOBID_EXECUTIONS_MAP, Suppliers.ofInstance(Agent.EMPTY_EXECUTIONS));
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        Reaper reaper = new Reaper((DockerClient)dockerClient, namespace);
        this.agent = new Agent(this.model, supervisorFactory, reactorFactory, executions, portAllocator, reaper);
        ZooKeeperHealthChecker zkHealthChecker = new ZooKeeperHealthChecker(this.zooKeeperClient, Paths.statusHosts(), riemannFacade, TimeUnit.MINUTES, 2L);
        environment.manage((Managed)zkHealthChecker);
        if (config.getHttpConfiguration() != null) {
            environment.addHealthCheck((HealthCheck)dockerHealthChecker);
            environment.addResource((Object)new AgentModelTaskResource(this.model));
            environment.addResource((Object)new AgentModelTaskStatusResource(this.model));
            environment.addHealthCheck((HealthCheck)zkHealthChecker);
            this.server = new ServerFactory(config.getHttpConfiguration(), environment.getName()).buildServer(environment);
        } else {
            this.server = null;
        }
    }

    private ZooKeeperClient setupZookeeperClient(AgentConfig config, String id) {
        ExponentialBackoffRetry zooKeeperRetryPolicy = new ExponentialBackoffRetry(1000, 3);
        CuratorFramework curator = CuratorFrameworkFactory.newClient((String)config.getZooKeeperConnectionString(), (int)config.getZooKeeperSessionTimeoutMillis(), (int)config.getZooKeeperConnectionTimeoutMillis(), (RetryPolicy)zooKeeperRetryPolicy);
        DefaultZooKeeperClient client = new DefaultZooKeeperClient(curator);
        this.zkRegistrar = new ZooKeeperRegistrar(client, new AgentZooKeeperRegistrar((Service)this, config.getName(), id));
        return client;
    }

    protected void startUp() throws Exception {
        this.logBanner();
        this.zooKeeperClient.start();
        this.zkRegistrar.startAsync().awaitRunning();
        this.model.startAsync().awaitRunning();
        this.agent.startAsync().awaitRunning();
        this.hostInfoReporter.startAsync();
        this.agentInfoReporter.startAsync();
        this.environmentVariableReporter.startAsync();
        this.metrics.start();
        if (this.server != null) {
            try {
                this.server.start();
                for (ServerLifecycleListener listener : this.environment.getServerListeners()) {
                    listener.serverStarted(this.server);
                }
            }
            catch (Exception e) {
                log.error("Unable to start server, shutting down", (Throwable)e);
                this.server.stop();
            }
        }
    }

    private void logBanner() {
        try {
            String banner = Resources.toString((URL)Resources.getResource((String)"agent-banner.txt"), (Charset)Charsets.UTF_8);
            log.info("\n{}", (Object)banner);
        }
        catch (IOException | IllegalArgumentException exception) {
            // empty catch block
        }
    }

    protected void shutDown() throws Exception {
        if (this.server != null) {
            this.server.stop();
            this.server.join();
        }
        this.hostInfoReporter.stopAsync().awaitTerminated();
        this.agentInfoReporter.stopAsync().awaitTerminated();
        this.environmentVariableReporter.stopAsync().awaitTerminated();
        this.agent.stopAsync().awaitTerminated();
        if (this.serviceRegistrar != null) {
            this.serviceRegistrar.close();
        }
        this.zkRegistrar.stopAsync().awaitTerminated();
        this.model.stopAsync().awaitTerminated();
        this.metrics.stop();
        this.zooKeeperClient.close();
        try {
            this.stateLock.release();
        }
        catch (IOException e) {
            log.error("Failed to release state lock", (Throwable)e);
        }
        try {
            this.stateLockFile.close();
        }
        catch (IOException e) {
            log.error("Failed to close state lock file", (Throwable)e);
        }
    }
}

