/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.agent;

import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.Service;
import com.spotify.helios.servicescommon.ZooKeeperRegistrarEventListener;
import com.spotify.helios.servicescommon.coordination.Paths;
import com.spotify.helios.servicescommon.coordination.ZooKeeperClient;
import java.io.IOException;
import org.apache.curator.framework.recipes.nodes.PersistentEphemeralNode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentZooKeeperRegistrar
implements ZooKeeperRegistrarEventListener {
    private static final Logger log = LoggerFactory.getLogger(AgentZooKeeperRegistrar.class);
    private static final byte[] EMPTY_BYTES = new byte[0];
    private final Service agentService;
    private final String name;
    private final String id;
    private PersistentEphemeralNode upNode;

    public AgentZooKeeperRegistrar(Service agentService, String name, String id) {
        this.agentService = agentService;
        this.name = name;
        this.id = id;
    }

    @Override
    public void startUp() throws Exception {
    }

    @Override
    public void shutDown() throws Exception {
        if (this.upNode != null) {
            try {
                this.upNode.close();
            }
            catch (IOException e) {
                Throwable cause = (Throwable)Optional.fromNullable((Object)e.getCause()).or((Object)e);
                log.warn("Exception on closing up node: {}", cause);
            }
        }
    }

    @Override
    public void tryToRegister(ZooKeeperClient client) throws KeeperException {
        String idPath = Paths.configHostId(this.name);
        Stat stat = client.exists(idPath);
        if (stat == null) {
            log.debug("Agent id node not present, registering agent {}: {}", (Object)this.id, (Object)this.name);
            client.ensurePath(Paths.configHost(this.name));
            client.ensurePath(Paths.configHost(this.name));
            client.ensurePath(Paths.configHostJobs(this.name));
            client.ensurePath(Paths.configHostPorts(this.name));
            client.ensurePath(Paths.statusHost(this.name));
            client.ensurePath(Paths.statusHostJobs(this.name));
            client.createAndSetData(idPath, this.id.getBytes(Charsets.UTF_8));
        } else {
            String existingId;
            byte[] bytes = client.getData(idPath);
            String string = existingId = bytes == null ? "" : new String(bytes, Charsets.UTF_8);
            if (!this.id.equals(existingId)) {
                String message = String.format("Another agent already registered as '%s' (local=%s remote=%s).", this.name, this.id, existingId);
                log.error(message);
                this.agentService.stopAsync();
                return;
            }
            log.info("Matching agent id node already present, not registering agent {}: {}", (Object)this.id, (Object)this.name);
        }
        if (this.upNode == null) {
            String upPath = Paths.statusHostUp(this.name);
            log.debug("Creating up node: {}", (Object)upPath);
            this.upNode = client.persistentEphemeralNode(upPath, PersistentEphemeralNode.Mode.EPHEMERAL, EMPTY_BYTES);
            this.upNode.start();
        }
        log.info("ZooKeeper registration complete");
    }
}

