/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.agent;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.spotify.helios.servicescommon.RiemannFacade;
import com.spotify.helios.servicescommon.statistics.MeterRates;
import com.spotify.helios.servicescommon.statistics.SupervisorMetrics;
import com.yammer.dropwizard.lifecycle.Managed;
import com.yammer.metrics.core.HealthCheck;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerHealthChecker
extends HealthCheck
implements Managed {
    private static final Logger log = LoggerFactory.getLogger(DockerHealthChecker.class);
    @VisibleForTesting
    static final double FAILURE_LOW_WATERMARK = 0.4;
    @VisibleForTesting
    static final double FAILURE_HIGH_WATERMARK = 0.8;
    private final SupervisorMetrics metrics;
    private final ScheduledExecutorService scheduler;
    private final TimeUnit timeUnit;
    private final int interval;
    private final HealthCheckRunnable runnable;
    private final RiemannFacade facade;

    public DockerHealthChecker(SupervisorMetrics metrics, TimeUnit timeUnit, int interval, RiemannFacade facade) {
        super("docker");
        this.metrics = (SupervisorMetrics)Preconditions.checkNotNull((Object)metrics);
        this.timeUnit = (TimeUnit)((Object)Preconditions.checkNotNull((Object)((Object)timeUnit)));
        this.facade = ((RiemannFacade)Preconditions.checkNotNull((Object)facade)).stack("docker-health");
        this.scheduler = Executors.newScheduledThreadPool(1);
        this.interval = interval;
        this.runnable = new HealthCheckRunnable();
    }

    private double fiveMinuteRatio(MeterRates numerator, MeterRates denominator) {
        if (denominator.getFiveMinuteRate() < 0.1) {
            return 0.0;
        }
        return numerator.getFiveMinuteRate() * 1.0 / denominator.getFiveMinuteRate();
    }

    public void stop() {
        this.scheduler.shutdownNow();
    }

    public void start() {
        this.scheduler.scheduleAtFixedRate(this.runnable, this.interval, this.interval, this.timeUnit);
    }

    protected HealthCheck.Result check() throws Exception {
        this.runnable.run();
        if (this.runnable.reason != null) {
            return HealthCheck.Result.unhealthy((String)this.runnable.reason);
        }
        return HealthCheck.Result.healthy();
    }

    private class HealthCheckRunnable
    implements Runnable {
        private String reason = null;

        private HealthCheckRunnable() {
        }

        @Override
        public void run() {
            double timeoutRatio = DockerHealthChecker.this.fiveMinuteRatio(DockerHealthChecker.this.metrics.getDockerTimeoutRates(), DockerHealthChecker.this.metrics.getSupervisorRunRates());
            double exceptionRatio = DockerHealthChecker.this.fiveMinuteRatio(DockerHealthChecker.this.metrics.getContainersThrewExceptionRates(), DockerHealthChecker.this.metrics.getSupervisorRunRates());
            log.info("timeout ratio is {}, exception ratio is {}", (Object)timeoutRatio, (Object)exceptionRatio);
            String origReason = this.reason;
            if (timeoutRatio > 0.8) {
                this.reason = "docker timeouts are too high for too long";
            }
            if (exceptionRatio > 0.8) {
                this.reason = "supervisor run exception frequency is too high";
            }
            if (timeoutRatio < 0.4 && exceptionRatio < 0.4) {
                this.reason = null;
            }
            if (origReason != null && this.reason == null) {
                DockerHealthChecker.this.facade.event().state("ok").tags(new String[]{"docker", "health"}).metric(1).send();
            } else if (this.reason != null && origReason == null) {
                DockerHealthChecker.this.facade.event().state("critical").tags(new String[]{"docker", "health"}).metric(0).send();
            }
        }
    }
}

