/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.agent;

import com.spotify.helios.agent.InterruptingScheduledService;
import com.spotify.helios.common.Json;
import com.spotify.helios.servicescommon.coordination.NodeUpdaterFactory;
import com.spotify.helios.servicescommon.coordination.Paths;
import com.spotify.helios.servicescommon.coordination.ZooKeeperNodeUpdater;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class EnvironmentVariableReporter
extends InterruptingScheduledService {
    private static final int RETRY_INTERVAL_MILLIS = 1000;
    private final Map<String, String> envVars;
    private final ZooKeeperNodeUpdater nodeUpdater;

    public EnvironmentVariableReporter(String host, Map<String, String> envVars, NodeUpdaterFactory nodeUpdaterFactory) {
        this.envVars = envVars;
        this.nodeUpdater = nodeUpdaterFactory.create(Paths.statusHostEnvVars(host));
    }

    @Override
    protected void runOneIteration() {
        boolean succesful = this.nodeUpdater.update(Json.asBytesUnchecked(this.envVars));
        if (succesful) {
            this.stopAsync();
        }
    }

    @Override
    protected ScheduledFuture<?> schedule(Runnable runnable, ScheduledExecutorService executorService) {
        return executorService.scheduleWithFixedDelay(runnable, 0L, 1000L, TimeUnit.MILLISECONDS);
    }
}

